/*
 * Decompiled with CFR 0.152.
 */
package laves.utils;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JLabel;
import laves.utils.Constants;
import lavesdk.utils.FileUtils;

public class Utils {
    private Utils() {
    }

    public static URL getHowToURL(String langID) {
        try {
            return new File(String.valueOf(Constants.PATH_HOWTO) + langID + FileUtils.FILESEPARATOR + "howto.html").toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static void makeLinkLabel(JLabel label, final String url) {
        ActionListener l = null;
        if (url != null && !url.isEmpty()) {
            l = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Utils.openWebsite(url);
                }
            };
        }
        Utils.makeLinkLabel(label, l);
    }

    public static void makeLinkLabel(final JLabel label, final ActionListener listener) {
        label.setForeground(Constants.LINK_COLOR);
        label.setCursor(Cursor.getPredefinedCursor(12));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setForeground(Constants.LINK_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setForeground(Constants.LINK_COLOR);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (listener != null) {
                    listener.actionPerformed(new ActionEvent(label, 1, "link"));
                }
            }
        });
    }

    public static boolean openWebsite(String url) throws IllegalArgumentException {
        Desktop d;
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                d.browse(new URI(url));
                return true;
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static int openFile(String file) throws IllegalArgumentException {
        if (file == null || file.isEmpty()) {
            throw new IllegalArgumentException("No valid argument!");
        }
        File f = new File(file);
        if (!f.exists()) {
            return 0;
        }
        if (Desktop.isDesktopSupported()) {
            Desktop d = Desktop.getDesktop();
            try {
                d.open(f);
                return 1;
            }
            catch (IOException e) {
                return -1;
            }
        }
        return -1;
    }
}

