/*
 * Decompiled with CFR 0.152.
 */
package laves.utils;

import java.awt.Color;
import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import lavesdk.utils.FileUtils;

public class Constants {
    public static final String LAVES = "LAVES";
    public static final String LAVES_FULL = "Logistics Algorithms Visualization and Education Software";
    public static final String LAVES_WEBSITE = "http://www.wiwi.uni-siegen.de/mis/software/laves.html";
    public static final String LAVES_CHANGELOG_WEBSITE = "http://www.wiwi.uni-siegen.de/mis/software/laves.html#changelog";
    public static final String LAVESDK_GETTINGSTARTED_WEBSITE = "http://www.wiwi.uni-siegen.de/mis/software/lavesdk.html#gettingstarted";
    public static final String PLUGINS_PAGE = "http://www.wiwi.uni-siegen.de/mis/software/laves.html#plugins";
    public static final String DEPARTEMENT_MIS_WEBSITE = "http://www.wiwi.uni-siegen.de/mis/";
    public static final String VERSION = "1.5";
    public static final int[] VERSION_RELEASE = new int[]{4, 4, 2016};
    public static final String RELEASE_DATE;
    public static final String CONTRIBUTORS = "Jan Dornseifer (jan.dornseifer@student.uni-siegen.de)\nDr. Dominik Kre\u00df (dominik.kress@uni-siegen.de)";
    public static final String PATH_APPLICATION;
    public static final String PATH_PLUGINS;
    public static final String PATH_CONFIG;
    public static final String PATH_PLUGINS_CONFIG;
    public static final String PATH_LANGUAGE;
    public static final String PATH_LICENSE;
    public static final String PATH_LOG;
    public static final String PATH_HELP;
    public static final String PATH_TEMP;
    public static final String PATH_HOWTO;
    public static final String EXT_CONFIG = ".cfg";
    public static final String FILE_MAIN_CONFIG;
    public static final String FILE_LANGUAGE;
    public static final String FILE_LICENSE;
    public static final String FILE_LOG;
    public static final String FILENAME_HOWTO = "howto.html";
    public static final String FILENAME_HELP = "user_guide.pdf";
    public static final Color COLOR_LOGO;
    public static final Color LINK_COLOR;
    public static final Color LINK_HOVER_COLOR;

    static {
        PATH_APPLICATION = Constants.getApplicationDir();
        PATH_PLUGINS = String.valueOf(PATH_APPLICATION) + "plugins" + FileUtils.FILESEPARATOR;
        PATH_CONFIG = String.valueOf(PATH_APPLICATION) + "cfg" + FileUtils.FILESEPARATOR;
        PATH_PLUGINS_CONFIG = String.valueOf(PATH_CONFIG) + "plugins" + FileUtils.FILESEPARATOR;
        PATH_LANGUAGE = String.valueOf(PATH_APPLICATION) + "lang" + FileUtils.FILESEPARATOR;
        PATH_LICENSE = String.valueOf(PATH_APPLICATION) + "license" + FileUtils.FILESEPARATOR;
        PATH_LOG = String.valueOf(PATH_APPLICATION) + "log" + FileUtils.FILESEPARATOR;
        PATH_HELP = String.valueOf(PATH_LANGUAGE) + "help" + FileUtils.FILESEPARATOR;
        PATH_TEMP = Constants.getTmpDirectory();
        PATH_HOWTO = String.valueOf(PATH_LANGUAGE) + "howto" + FileUtils.FILESEPARATOR;
        FILE_MAIN_CONFIG = String.valueOf(PATH_CONFIG) + "main" + EXT_CONFIG;
        FILE_LANGUAGE = String.valueOf(PATH_LANGUAGE) + "lang.txt";
        FILE_LICENSE = String.valueOf(PATH_LICENSE) + "license.txt";
        FILE_LOG = String.valueOf(PATH_LOG) + "log.txt";
        COLOR_LOGO = new Color(90, 133, 212);
        LINK_COLOR = new Color(75, 130, 205);
        LINK_HOVER_COLOR = new Color(95, 150, 235);
        Calendar date = Calendar.getInstance();
        date.set(VERSION_RELEASE[2], VERSION_RELEASE[1] - 1, VERSION_RELEASE[0]);
        RELEASE_DATE = DateFormat.getDateInstance().format(date.getTime());
    }

    private Constants() {
    }

    private static String getApplicationDir() {
        String dir = new File(".").getAbsolutePath();
        if (!dir.endsWith(FileUtils.FILESEPARATOR)) {
            dir = String.valueOf(dir) + FileUtils.FILESEPARATOR;
        }
        return dir;
    }

    private static String getTmpDirectory() {
        File f = new File(System.getProperty("java.io.tmpdir"));
        if (f.exists()) {
            String dir = f.getAbsolutePath();
            if (!dir.endsWith(FileUtils.FILESEPARATOR)) {
                dir = String.valueOf(dir) + FileUtils.FILESEPARATOR;
            }
            return dir;
        }
        return Constants.getApplicationDir();
    }
}

