/*
 * Decompiled with CFR 0.152.
 */
package laves.resources;

import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.ImageIcon;

public class ResourceManager {
    public final ImageIcon LOGO = this.getResourceAsIcon("logo.png");
    public final ImageIcon LOGO_SMALL = this.getResourceAsIcon("logo_small.png");
    public final Image APP_ICON = this.getResourceAsImage("app_icon.png");
    public final ImageIcon LOGO_UNISIEGEN = this.getResourceAsIcon("logo_uni_siegen.jpg");
    public final ImageIcon ICON_NEW_BIG = this.getResourceAsIcon("new_big.png");
    public final ImageIcon ICON_PLUGIN = this.getResourceAsIcon("plugin.png");
    public final ImageIcon ICON_INTERNET = this.getResourceAsIcon("internet.png");
    public final ImageIcon ICON_HELP = this.getResourceAsIcon("help.png");
    public final ImageIcon ICON_INFO = this.getResourceAsIcon("info.png");
    public final ImageIcon ICON_INFO_LARGE = this.getResourceAsIcon("info_large.png");
    public final ImageIcon ICON_VIEW = this.getResourceAsIcon("view.png");
    public final ImageIcon ICON_PLUGIN_BIG = this.getResourceAsIcon("plugin_big.png");
    private static ResourceManager instance = null;

    private ResourceManager() {
    }

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    private ImageIcon getResourceAsIcon(String name) {
        try {
            return new ImageIcon(ResourceManager.class.getResource(name));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Image getResourceAsImage(String name) {
        try {
            return Toolkit.getDefaultToolkit().getImage(ResourceManager.class.getResource(name));
        }
        catch (Exception e) {
            return null;
        }
    }
}

