/*
 * Decompiled with CFR 0.152.
 */
package laves.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import laves.PluginManagerListener;
import laves.configuration.MainConfiguration;
import laves.gui.HowToDialog;
import laves.gui.MainWindow;
import laves.gui.widgets.AlgorithmTableModel;
import laves.gui.widgets.WelcomeScreenListener;
import laves.resources.ResourceManager;
import laves.utils.Constants;
import laves.utils.Utils;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.language.LanguageFile;

public class WelcomeScreen
extends View {
    private static final long serialVersionUID = 1L;
    private final MainConfiguration config;
    private final MainWindow mainWin;
    private WelcomeScreenListener listener;
    private final PluginManagerListener pluginManListener;
    private final LastAlgorithmsTableModel lastAlgosTableModel;
    private final AlgorithmTableModel quickStartTableModel;

    public WelcomeScreen(MainWindow mw, MainConfiguration cfg) throws NullPointerException {
        super(LanguageFile.getLabel(mw.getLanguageFile(), "WELCOME_SCREEN_TITLE", mw.getLanguageID(), "Welcome"), true, mw.getLanguageFile(), mw.getLanguageID());
        if (cfg == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.config = cfg;
        this.mainWin = mw;
        this.listener = null;
        this.pluginManListener = new PluginManagerListener(){

            @Override
            public void onInstalledPluginsChanged(boolean increase) {
                if (!increase) {
                    WelcomeScreen.this.lastAlgosTableModel.reload();
                }
                WelcomeScreen.this.quickStartTableModel.reload();
            }
        };
        this.mainWin.getLoader().getPluginManager().addListener(this.pluginManListener);
        Font f = UIManager.getFont("Label.font");
        Font captionFont = f.deriveFont(1, 12.0f);
        Font linkFont = f.deriveFont(1, 14.0f);
        Color captionColor = new Color(70, 120, 200);
        SpringLayout contentLayout = new SpringLayout();
        this.content.setLayout(contentLayout);
        this.content.setBackground(Color.white);
        this.content.setBorder(BorderFactory.createEtchedBorder(1));
        JLabel lblHeadline = new JLabel(LanguageFile.getLabel(mw.getLanguageFile(), "WELCOME_MESSAGE", mw.getLanguageID(), "Welcome to LAVES!"));
        lblHeadline.setForeground(Constants.COLOR_LOGO);
        lblHeadline.setFont(f.deriveFont(1, 28.0f));
        contentLayout.putConstraint("North", (Component)lblHeadline, 10, "North", (Component)this.content);
        contentLayout.putConstraint("West", (Component)lblHeadline, 10, "West", (Component)this.content);
        this.content.add(lblHeadline);
        JLabel lblLogo = new JLabel(ResourceManager.getInstance().LOGO);
        contentLayout.putConstraint("East", (Component)lblHeadline, -20, "West", (Component)lblLogo);
        contentLayout.putConstraint("North", (Component)lblLogo, 10, "North", (Component)this.content);
        contentLayout.putConstraint("East", (Component)lblLogo, -10, "East", (Component)this.content);
        this.content.add(lblLogo);
        JLabel lblSubhead = new JLabel("<html>" + LanguageFile.getLabel(mw.getLanguageFile(), "WELCOME_SCREEN_SUBHEAD", mw.getLanguageID(), "a software to visualize, animate and educate the execution of algorithms with the goal to facilitate users the understanding of algorithms") + "</html>");
        lblSubhead.setFont(f.deriveFont(14.0f));
        lblSubhead.setVerticalAlignment(1);
        contentLayout.putConstraint("North", (Component)lblSubhead, 6, "South", (Component)lblHeadline);
        contentLayout.putConstraint("West", (Component)lblSubhead, 0, "West", (Component)lblHeadline);
        contentLayout.putConstraint("East", (Component)lblSubhead, 0, "East", (Component)lblHeadline);
        this.content.add(lblSubhead);
        JLabel lblHowTo = new JLabel(LanguageFile.getLabel(mw.getLanguageFile(), "WELCOME_SCREEN_HOWTO", mw.getLanguageID(), "HowTo"));
        lblHowTo.setFont(linkFont);
        Utils.makeLinkLabel(lblHowTo, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HowToDialog howToDlg = new HowToDialog(WelcomeScreen.this.mainWin);
                howToDlg.setVisible(true);
            }
        });
        contentLayout.putConstraint("South", (Component)lblSubhead, -30, "North", (Component)lblHowTo);
        contentLayout.putConstraint("North", (Component)lblHowTo, 30, "South", (Component)lblLogo);
        contentLayout.putConstraint("West", (Component)lblHowTo, 0, "West", (Component)lblHeadline);
        this.content.add(lblHowTo);
        JLabel lblHowToSubtitle = new JLabel(LanguageFile.getLabel(mw.getLanguageFile(), "WELCOME_SCREEN_HOWTO_SUBTITLE", mw.getLanguageID(), "find out how to work with LAVES"));
        contentLayout.putConstraint("North", (Component)lblHowToSubtitle, 6, "South", (Component)lblHowTo);
        contentLayout.putConstraint("West", (Component)lblHowToSubtitle, 0, "West", (Component)lblHeadline);
        this.content.add(lblHowToSubtitle);
        Dimension oDimTitle = lblHowTo.getPreferredSize();
        Dimension oDimSubtitle = lblHowToSubtitle.getPreferredSize();
        JLabel lblSDK = new JLabel(LanguageFile.getLabel(mw.getLanguageFile(), "WELCOME_SCREEN_SDK", mw.getLanguageID(), "Software Development Kit"));
        lblSDK.setFont(linkFont);
        Utils.makeLinkLabel(lblSDK, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Utils.openWebsite("http://www.wiwi.uni-siegen.de/mis/software/lavesdk.html#gettingstarted")) {
                    JOptionPane.showMessageDialog(WelcomeScreen.this.mainWin, LanguageFile.getLabel(WelcomeScreen.this.langFile, "MSG_ERR_OPENWEBSITE", WelcomeScreen.this.langID, "The website could not be opened!\nEnsure that you have installed a default browser."), LanguageFile.getLabel(WelcomeScreen.this.langFile, "MSG_ERR_TITLE_OPENWEBSITE", WelcomeScreen.this.langID, "Open Website"), 0);
                }
            }
        });
        contentLayout.putConstraint("North", (Component)lblSDK, 0, "North", (Component)lblHowTo);
        contentLayout.putConstraint("West", (Component)lblSDK, 30, "East", (Component)(oDimTitle.width > oDimSubtitle.width ? lblHowTo : lblHowToSubtitle));
        this.content.add(lblSDK);
        JLabel lblSDKSubtitle = new JLabel(LanguageFile.getLabel(mw.getLanguageFile(), "WELCOME_SCREEN_SDK_SUBTITLE", mw.getLanguageID(), "getting started with developing own plugins"));
        contentLayout.putConstraint("North", (Component)lblSDKSubtitle, 6, "South", (Component)lblSDK);
        contentLayout.putConstraint("West", (Component)lblSDKSubtitle, 0, "West", (Component)lblSDK);
        this.content.add(lblSDKSubtitle);
        oDimTitle = lblSDK.getPreferredSize();
        oDimSubtitle = lblSDKSubtitle.getPreferredSize();
        JLabel lblChangelog = new JLabel(LanguageFile.getLabel(mw.getLanguageFile(), "WELCOME_SCREEN_CHANGELOG", mw.getLanguageID(), "Changelog"));
        lblChangelog.setFont(linkFont);
        Utils.makeLinkLabel(lblChangelog, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Utils.openWebsite("http://www.wiwi.uni-siegen.de/mis/software/laves.html#changelog")) {
                    JOptionPane.showMessageDialog(WelcomeScreen.this.mainWin, LanguageFile.getLabel(WelcomeScreen.this.langFile, "MSG_ERR_OPENWEBSITE", WelcomeScreen.this.langID, "The website could not be opened!\nEnsure that you have installed a default browser."), LanguageFile.getLabel(WelcomeScreen.this.langFile, "MSG_ERR_TITLE_OPENWEBSITE", WelcomeScreen.this.langID, "Open Website"), 0);
                }
            }
        });
        contentLayout.putConstraint("North", (Component)lblChangelog, 0, "North", (Component)lblSDK);
        contentLayout.putConstraint("West", (Component)lblChangelog, 30, "East", (Component)(oDimTitle.width > oDimSubtitle.width ? lblSDK : lblSDKSubtitle));
        this.content.add(lblChangelog);
        JLabel lblChangelogSubtitle = new JLabel(LanguageFile.getLabel(mw.getLanguageFile(), "WELCOME_SCREEN_CHANGELOG_SUBTITLE", mw.getLanguageID(), "what's new in the latest version"));
        contentLayout.putConstraint("North", (Component)lblChangelogSubtitle, 6, "South", (Component)lblChangelog);
        contentLayout.putConstraint("West", (Component)lblChangelogSubtitle, 0, "West", (Component)lblChangelog);
        this.content.add(lblChangelogSubtitle);
        JPanel lastAlgosPanel = new JPanel(new BorderLayout());
        TitledBorder tbAlgosPanel = BorderFactory.createTitledBorder(LanguageFile.getLabel(mw.getLanguageFile(), "WELCOME_SCREEN_LASTALGOS", mw.getLanguageID(), "Recently opened algorithms"));
        tbAlgosPanel.setTitleFont(captionFont);
        tbAlgosPanel.setTitleColor(captionColor);
        lastAlgosPanel.setBorder(tbAlgosPanel);
        lastAlgosPanel.setBackground(this.content.getBackground());
        contentLayout.putConstraint("North", (Component)lastAlgosPanel, 50, "South", (Component)lblHowToSubtitle);
        contentLayout.putConstraint("West", (Component)lastAlgosPanel, 0, "West", (Component)lblHeadline);
        contentLayout.putConstraint("South", (Component)lastAlgosPanel, -10, "South", (Component)this.content);
        contentLayout.putConstraint("East", (Component)lastAlgosPanel, 400, "West", (Component)this.content);
        this.content.add(lastAlgosPanel);
        JScrollPane scrollPaneLastAlgos = new JScrollPane();
        scrollPaneLastAlgos.setBackground(this.content.getBackground());
        scrollPaneLastAlgos.getViewport().setBackground(scrollPaneLastAlgos.getBackground());
        lastAlgosPanel.add((Component)scrollPaneLastAlgos, "Center");
        this.lastAlgosTableModel = new LastAlgorithmsTableModel();
        final JTable lastAlgosTable = new JTable(this.lastAlgosTableModel);
        lastAlgosTable.setAutoCreateRowSorter(false);
        lastAlgosTable.getSelectionModel().setSelectionMode(0);
        lastAlgosTable.setBackground(this.content.getBackground());
        lastAlgosTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && lastAlgosTable.getSelectedRowCount() > 0 && WelcomeScreen.this.listener != null) {
                    WelcomeScreen.this.listener.activatePlugin(WelcomeScreen.this.lastAlgosTableModel.getRow(lastAlgosTable.convertRowIndexToModel(lastAlgosTable.getSelectedRow())));
                }
            }
        });
        scrollPaneLastAlgos.setViewportView(lastAlgosTable);
        JPanel quickStartPanel = new JPanel(new BorderLayout());
        TitledBorder tbQuickStartPanel = BorderFactory.createTitledBorder(LanguageFile.getLabel(mw.getLanguageFile(), "WELCOME_SCREEN_QUICKSTART", mw.getLanguageID(), "QuickStart"));
        tbQuickStartPanel.setTitleFont(captionFont);
        tbQuickStartPanel.setTitleColor(captionColor);
        quickStartPanel.setBorder(tbQuickStartPanel);
        quickStartPanel.setBackground(this.content.getBackground());
        contentLayout.putConstraint("North", (Component)quickStartPanel, 0, "North", (Component)lastAlgosPanel);
        contentLayout.putConstraint("West", (Component)quickStartPanel, 20, "East", (Component)lastAlgosPanel);
        contentLayout.putConstraint("South", (Component)quickStartPanel, 0, "South", (Component)lastAlgosPanel);
        contentLayout.putConstraint("East", (Component)quickStartPanel, -10, "East", (Component)this.content);
        this.content.add(quickStartPanel);
        JScrollPane scrollPaneQuickStart = new JScrollPane();
        scrollPaneQuickStart.setBackground(this.content.getBackground());
        scrollPaneQuickStart.getViewport().setBackground(scrollPaneQuickStart.getBackground());
        quickStartPanel.add(scrollPaneQuickStart);
        this.quickStartTableModel = new AlgorithmTableModel(cfg, this.mainWin.getLoader(), this.mainWin.getLanguageFile(), this.mainWin.getLanguageID());
        final JTable quickStartTable = new JTable(this.quickStartTableModel);
        this.quickStartTableModel.setTable(quickStartTable);
        quickStartTable.setAutoCreateRowSorter(true);
        quickStartTable.getSelectionModel().setSelectionMode(0);
        quickStartTable.setBackground(this.content.getBackground());
        quickStartTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && quickStartTable.getSelectedRowCount() > 0 && WelcomeScreen.this.listener != null) {
                    WelcomeScreen.this.listener.activatePlugin(WelcomeScreen.this.quickStartTableModel.getRow(quickStartTable.convertRowIndexToModel(quickStartTable.getSelectedRow())));
                }
            }
        });
        scrollPaneQuickStart.setViewportView(quickStartTable);
    }

    public void setWelcomeScreenListener(WelcomeScreenListener listener) {
        this.listener = listener;
    }

    @Override
    public void reset() {
    }

    @Override
    protected void close() {
        super.close();
        this.config.setShowWelcomeScreen(false);
    }

    @Override
    protected void beforeRemove() {
        this.mainWin.getLoader().getPluginManager().removeListener(this.pluginManListener);
    }

    private class LastAlgorithmsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<AlgorithmPlugin> rows;

        public LastAlgorithmsTableModel() {
            this.rows = WelcomeScreen.this.mainWin.getLastOpenedAlgorithms();
        }

        public void reload() {
            this.rows = WelcomeScreen.this.mainWin.getLastOpenedAlgorithms();
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return LanguageFile.getLabel(WelcomeScreen.this.mainWin.getLanguageFile(), "COLUMN_ALGONAME", WelcomeScreen.this.mainWin.getLanguageID(), "Name");
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        public AlgorithmPlugin getRow(int row) {
            return this.rows.get(row);
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.rows.get(row).getName();
        }
    }
}

