/*
 * Decompiled with CFR 0.152.
 */
package laves.gui.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JLabel lblField1;
    private final JLabel lblField2;
    private final JLabel lblField3;
    private final JLabel lblField4;

    public StatusBar() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder(0));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.3;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.lblField1 = new JLabel();
        this.lblField1.setHorizontalTextPosition(2);
        this.add((Component)this.lblField1, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JSeparator(1), gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.4;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.lblField2 = new JLabel();
        this.lblField2.setHorizontalTextPosition(2);
        this.add((Component)this.lblField2, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JSeparator(1), gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.lblField3 = new JLabel();
        this.lblField3.setHorizontalTextPosition(2);
        this.add((Component)this.lblField3, gbc);
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JSeparator(1), gbc);
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.1;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.lblField4 = new JLabel();
        this.lblField4.setHorizontalTextPosition(2);
        this.add((Component)this.lblField4, gbc);
    }

    public String getText(int field) {
        JLabel lblField = this.getField(field);
        if (lblField != null) {
            String s = lblField.getText().replaceAll("<br>", "\n");
            String s2 = s.substring("<html>".length(), s.length());
            return s2.substring(0, s2.length() - "</html>".length());
        }
        return "";
    }

    public void setText(int field, String text) throws IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        JLabel lblField = this.getField(field);
        if (text.length() > 150) {
            lblField.setToolTipText(text);
            text = String.valueOf(text.substring(0, 150)) + " ...";
        } else {
            lblField.setToolTipText(null);
        }
        if (lblField != null) {
            lblField.setText("<html>" + text.replace("\n", "<br>") + "</html>");
        }
    }

    public void setForeground(int field, Color color) {
        JLabel lblField = this.getField(field);
        if (lblField != null) {
            lblField.setForeground(color);
        }
    }

    private JLabel getField(int index) {
        switch (index) {
            case 1: {
                return this.lblField1;
            }
            case 2: {
                return this.lblField2;
            }
            case 3: {
                return this.lblField3;
            }
            case 4: {
                return this.lblField4;
            }
        }
        return null;
    }
}

