/*
 * Decompiled with CFR 0.152.
 */
package laves.gui.widgets;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class HintTextFieldUI
extends BasicTextFieldUI
implements FocusListener {
    private final String hint;
    private final Color color;

    public HintTextFieldUI(String hint) throws IllegalArgumentException {
        this(hint, Color.gray);
    }

    public HintTextFieldUI(String hint, Color color) throws IllegalArgumentException {
        if (hint == null || hint.isEmpty() || color == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.hint = hint;
        this.color = color;
    }

    @Override
    protected void paintSafely(Graphics g) {
        Insets insets;
        super.paintSafely(g);
        JTextComponent comp = this.getComponent();
        int offsetX = 2;
        if (comp.getBorder() != null && (insets = comp.getBorder().getBorderInsets(comp)) != null) {
            offsetX += insets.left;
        }
        if (comp.getText().isEmpty() && !comp.hasFocus()) {
            g.setColor(this.color);
            g.drawString(this.hint, offsetX, comp.getHeight() - (comp.getHeight() - comp.getFont().getSize()) / 2 - 1);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.getComponent() != null) {
            this.getComponent().repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.getComponent() != null) {
            this.getComponent().repaint();
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addFocusListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this);
    }
}

