/*
 * Decompiled with CFR 0.152.
 */
package laves.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import laves.Loader;
import laves.configuration.MainConfiguration;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.language.LanguageFile;

public class AlgorithmTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private final MainConfiguration cfg;
    private final Loader loader;
    private JTable table;
    private final List<String> columns;
    private final List<Integer> colIndices;
    private List<AlgorithmPlugin> rows;
    private static final int COLUMN_NAME_INDEX = 0;
    private static final int COLUMN_PROBLEMAFFILIATION_INDEX = 1;
    private static final int COLUMN_SUBJECT_INDEX = 2;
    private static final int COLUMN_TYPE_INDEX = 3;
    private static final int COLUMN_AUTHOR_INDEX = 4;
    private static final int COLUMN_AUTHORCONTACT_INDEX = 5;
    private static final int COLUMN_VERSION_INDEX = 6;
    private static final int COLUMN_SDKVERSION_INDEX = 7;

    public AlgorithmTableModel(MainConfiguration cfg, Loader loader, LanguageFile langFile, String langID) throws IllegalArgumentException {
        this(cfg, loader, langFile, langID, false);
    }

    public AlgorithmTableModel(MainConfiguration cfg, Loader loader, LanguageFile langFile, String langID, boolean showAllColumns) throws IllegalArgumentException {
        if (cfg == null || loader == null || loader.getPluginManager() == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.cfg = cfg;
        this.loader = loader;
        this.table = null;
        this.columns = new ArrayList<String>();
        this.colIndices = new ArrayList<Integer>();
        this.rows = loader.getPluginManager().getInstalledPlugins();
        this.columns.add(LanguageFile.getLabel(langFile, "COLUMN_ALGONAME", langID, "Name"));
        this.colIndices.add(0);
        if (showAllColumns || cfg.getColumnAlgoProblemAffiliationVisible()) {
            this.columns.add(LanguageFile.getLabel(langFile, "COLUMN_ALGOPROBLEMAFFILIATION", langID, "Problem Affiliation"));
            this.colIndices.add(1);
        }
        if (showAllColumns || cfg.getColumnAlgoSubjectVisible()) {
            this.columns.add(LanguageFile.getLabel(langFile, "COLUMN_ALGOSUBJECT", langID, "Subject"));
            this.colIndices.add(2);
        }
        if (showAllColumns || cfg.getColumnAlgoTypeVisible()) {
            this.columns.add(LanguageFile.getLabel(langFile, "COLUMN_ALGOTYPE", langID, "Type"));
            this.colIndices.add(3);
        }
        if (showAllColumns || cfg.getColumnAlgoAuthorVisible()) {
            this.columns.add(LanguageFile.getLabel(langFile, "COLUMN_ALGOAUTHOR", langID, "Author"));
            this.colIndices.add(4);
        }
        if (showAllColumns || cfg.getColumnAlgoAuthorContactVisible()) {
            this.columns.add(LanguageFile.getLabel(langFile, "COLUMN_ALGOAUTHORCONTACT", langID, "Author Contact Details"));
            this.colIndices.add(5);
        }
        if (showAllColumns || cfg.getColumnAlgoVersionVisible()) {
            this.columns.add(LanguageFile.getLabel(langFile, "COLUMN_ALGOVERSION", langID, "Version"));
            this.colIndices.add(6);
        }
        if (showAllColumns || cfg.getColumnAlgoSDKVersionVisible()) {
            this.columns.add(LanguageFile.getLabel(langFile, "COLUMN_ALGOSDKVERSION", langID, "Used SDK Version"));
            this.colIndices.add(7);
        }
    }

    public void setTable(JTable table) throws IllegalArgumentException {
        if (table == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.table = table;
        this.fireTableStructureChanged();
        int i = 0;
        while (i < this.colIndices.size()) {
            TableColumn column = table.getColumnModel().getColumn(i);
            if (column != null) {
                switch (this.colIndices.get(i)) {
                    case 0: {
                        column.setPreferredWidth(this.cfg.getColumnAlgoNameWidth());
                        break;
                    }
                    case 1: {
                        column.setPreferredWidth(this.cfg.getColumnAlgoProblemAffiliationWidth());
                        break;
                    }
                    case 2: {
                        column.setPreferredWidth(this.cfg.getColumnAlgoSubjectWidth());
                        break;
                    }
                    case 3: {
                        column.setPreferredWidth(this.cfg.getColumnAlgoTypeWidth());
                        break;
                    }
                    case 4: {
                        column.setPreferredWidth(this.cfg.getColumnAlgoAuthorWidth());
                        break;
                    }
                    case 5: {
                        column.setPreferredWidth(this.cfg.getColumnAlgoAuthorContactWidth());
                        break;
                    }
                    case 6: {
                        column.setPreferredWidth(this.cfg.getColumnAlgoVersionWidth());
                        break;
                    }
                    case 7: {
                        column.setPreferredWidth(this.cfg.getColumnAlgoSDKVersionWidth());
                    }
                }
            }
            ++i;
        }
    }

    public void reload() {
        this.rows = this.loader.getPluginManager().getInstalledPlugins();
        this.fireTableDataChanged();
    }

    public void storeColumnWidths() {
        if (this.table == null) {
            return;
        }
        int i = 0;
        while (i < this.colIndices.size()) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            if (column != null) {
                switch (this.colIndices.get(i)) {
                    case 0: {
                        this.cfg.setColumnAlgoNameWidth(column.getPreferredWidth());
                        break;
                    }
                    case 1: {
                        this.cfg.setColumnAlgoProblemAffiliationWidth(column.getPreferredWidth());
                        break;
                    }
                    case 2: {
                        this.cfg.setColumnAlgoSubjectWidth(column.getPreferredWidth());
                        break;
                    }
                    case 3: {
                        this.cfg.setColumnAlgoTypeWidth(column.getPreferredWidth());
                        break;
                    }
                    case 4: {
                        this.cfg.setColumnAlgoAuthorWidth(column.getPreferredWidth());
                        break;
                    }
                    case 5: {
                        this.cfg.setColumnAlgoAuthorContactWidth(column.getPreferredWidth());
                        break;
                    }
                    case 6: {
                        this.cfg.setColumnAlgoVersionWidth(column.getPreferredWidth());
                        break;
                    }
                    case 7: {
                        this.cfg.setColumnAlgoSDKVersionWidth(column.getPreferredWidth());
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public AlgorithmPlugin getRow(int row) {
        return this.rows.get(row);
    }

    @Override
    public Object getValueAt(int row, int column) {
        AlgorithmPlugin p = this.rows.get(row);
        switch (this.colIndices.get(column)) {
            case 0: {
                return p.getName();
            }
            case 1: {
                return p.getProblemAffiliation();
            }
            case 2: {
                return p.getSubject();
            }
            case 3: {
                return p.getType();
            }
            case 4: {
                return p.getAuthor();
            }
            case 5: {
                return p.getAuthorContact();
            }
            case 6: {
                return p.getVersion();
            }
            case 7: {
                return p.getUsedSDKVersion().toString();
            }
        }
        return null;
    }
}

