/*
 * Decompiled with CFR 0.152.
 */
package laves.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import laves.configuration.MainConfiguration;
import laves.gui.MainWindow;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.gui.widgets.PropertiesList;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.language.LabelEntry;
import lavesdk.language.LanguageFile;

public class PreferencesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final MainWindow mainWin;
    private final MainConfiguration config;
    private final JPanel contentPanel = new JPanel();
    private final JComboBox<String> cboLanguages;
    private final JCheckBox cbShowWelcomeScreen;
    private final JCheckBox cbShowExerciseModeInfoDlg;
    private final JCheckBox cbDisableInfoBarPermanently;
    private final JCheckBox cbAlgoProblemAffiliation;
    private final JCheckBox cbAlgoSubject;
    private final JCheckBox cbAlgoType;
    private final JCheckBox cbAlgoAuthor;
    private final JCheckBox cbAlgoAuthorContact;
    private final JCheckBox cbAlgoVersion;
    private final JCheckBox cbUsedSDKVersion;
    private final JSlider openRecentCountSlider;
    private final JComboBox<String> cboPlugins;
    private final List<Integer> cboPluginsIndices;
    private final PropertiesList propsList;
    private final CustomizationListModel propsListModel;

    public PreferencesDialog(MainWindow mw, final MainConfiguration cfg) throws IllegalArgumentException {
        if (mw == null || cfg == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.mainWin = mw;
        this.config = cfg;
        this.mainWin.setCursor(Cursor.getPredefinedCursor(3));
        Font f = UIManager.getFont("Label.font");
        Font infoFont = f.deriveFont(2);
        this.setTitle(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_TITLE", this.mainWin.getLanguageID(), "Preferences"));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setSize(this.config.getPreferencesDialogWidth(), this.config.getPreferencesDialogHeight());
        this.mainWin.adaptDialog(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        SpringLayout sl_contentPanel = new SpringLayout();
        this.contentPanel.setLayout(sl_contentPanel);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        sl_contentPanel.putConstraint("North", (Component)tabbedPane, 5, "North", (Component)this.contentPanel);
        sl_contentPanel.putConstraint("West", (Component)tabbedPane, 5, "West", (Component)this.contentPanel);
        sl_contentPanel.putConstraint("South", (Component)tabbedPane, -5, "South", (Component)this.contentPanel);
        sl_contentPanel.putConstraint("East", (Component)tabbedPane, -5, "East", (Component)this.contentPanel);
        this.contentPanel.add(tabbedPane);
        JPanel generalPanel = new JPanel();
        tabbedPane.addTab(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_MAIN", this.mainWin.getLanguageID(), "Main"), null, generalPanel, null);
        SpringLayout sl_generalPanel = new SpringLayout();
        generalPanel.setLayout(sl_generalPanel);
        JLabel lblLanguage = new JLabel(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_MAIN_LANGUAGE", this.mainWin.getLanguageID(), "Language:"));
        sl_generalPanel.putConstraint("West", (Component)lblLanguage, 10, "West", (Component)generalPanel);
        generalPanel.add(lblLanguage);
        this.cboLanguages = new JComboBox();
        this.loadLanguages();
        sl_generalPanel.putConstraint("North", this.cboLanguages, 5, "North", (Component)generalPanel);
        sl_generalPanel.putConstraint("North", (Component)lblLanguage, 3, "North", this.cboLanguages);
        sl_generalPanel.putConstraint("East", this.cboLanguages, -10, "East", (Component)generalPanel);
        generalPanel.add(this.cboLanguages);
        JLabel lblLanguageInfo = new JLabel("<html>" + LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_MAIN_LANGUAGE_INFO", this.mainWin.getLanguageID(), "The selected language refers to the user interface of the software and does not have to be supported by each installed plugin!") + "</html>");
        lblLanguageInfo.setFont(infoFont);
        sl_generalPanel.putConstraint("North", (Component)lblLanguageInfo, 6, "South", this.cboLanguages);
        sl_generalPanel.putConstraint("West", (Component)lblLanguageInfo, 0, "West", this.cboLanguages);
        sl_generalPanel.putConstraint("East", (Component)lblLanguageInfo, -10, "East", (Component)generalPanel);
        generalPanel.add(lblLanguageInfo);
        JSeparator sep1 = new JSeparator();
        sl_generalPanel.putConstraint("North", (Component)sep1, 5, "South", (Component)lblLanguageInfo);
        sl_generalPanel.putConstraint("West", (Component)sep1, 10, "West", (Component)generalPanel);
        sl_generalPanel.putConstraint("East", (Component)sep1, -10, "East", (Component)generalPanel);
        generalPanel.add(sep1);
        this.cbShowWelcomeScreen = new JCheckBox(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_MAIN_SHOWWELCOMESCREEN", this.mainWin.getLanguageID(), "Show the Welcome Screen?"));
        this.cbShowWelcomeScreen.setSelected(this.config.getShowWelcomeScreen());
        sl_generalPanel.putConstraint("North", (Component)this.cbShowWelcomeScreen, 6, "South", (Component)sep1);
        sl_generalPanel.putConstraint("West", (Component)this.cbShowWelcomeScreen, 0, "West", this.cboLanguages);
        generalPanel.add(this.cbShowWelcomeScreen);
        this.cbShowExerciseModeInfoDlg = new JCheckBox(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_MAIN_SHOWEXERCISEMODEINFODLG", this.mainWin.getLanguageID(), "Show the Exercise Mode Information Dialog?"));
        this.cbShowExerciseModeInfoDlg.setSelected(this.config.getShowExerciseModeInfoDialog());
        sl_generalPanel.putConstraint("North", (Component)this.cbShowExerciseModeInfoDlg, 6, "South", (Component)this.cbShowWelcomeScreen);
        sl_generalPanel.putConstraint("West", (Component)this.cbShowExerciseModeInfoDlg, 0, "West", this.cboLanguages);
        generalPanel.add(this.cbShowExerciseModeInfoDlg);
        this.cbDisableInfoBarPermanently = new JCheckBox(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_MAIN_DISABLEINFOBAR", this.mainWin.getLanguageID(), "Disable the information bar permanently?"));
        this.cbDisableInfoBarPermanently.setSelected(this.config.getDisableInformationBarPermanently());
        sl_generalPanel.putConstraint("North", (Component)this.cbDisableInfoBarPermanently, 6, "South", (Component)this.cbShowExerciseModeInfoDlg);
        sl_generalPanel.putConstraint("West", (Component)this.cbDisableInfoBarPermanently, 0, "West", this.cboLanguages);
        generalPanel.add(this.cbDisableInfoBarPermanently);
        JSeparator sep2 = new JSeparator();
        sl_generalPanel.putConstraint("North", (Component)sep2, 6, "South", (Component)this.cbDisableInfoBarPermanently);
        sl_generalPanel.putConstraint("West", (Component)sep2, 0, "West", (Component)sep1);
        sl_generalPanel.putConstraint("East", (Component)sep2, 0, "East", (Component)sep1);
        generalPanel.add(sep2);
        JLabel lblColumns = new JLabel(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_MAIN_COLUMNS", this.mainWin.getLanguageID(), "Which columns should be displayed in the algorithms table?"));
        sl_generalPanel.putConstraint("North", (Component)lblColumns, 6, "South", (Component)sep2);
        sl_generalPanel.putConstraint("West", (Component)lblColumns, 0, "West", (Component)lblLanguage);
        generalPanel.add(lblColumns);
        this.cbAlgoProblemAffiliation = new JCheckBox(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "COLUMN_ALGOPROBLEMAFFILIATION", this.mainWin.getLanguageID(), "Problem Affiliation"));
        this.cbAlgoProblemAffiliation.setSelected(this.config.getColumnAlgoProblemAffiliationVisible());
        sl_generalPanel.putConstraint("North", (Component)this.cbAlgoProblemAffiliation, 6, "South", (Component)lblColumns);
        sl_generalPanel.putConstraint("West", (Component)this.cbAlgoProblemAffiliation, 0, "West", this.cboLanguages);
        generalPanel.add(this.cbAlgoProblemAffiliation);
        this.cbAlgoSubject = new JCheckBox(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "COLUMN_ALGOSUBJECT", this.mainWin.getLanguageID(), "Subject"));
        this.cbAlgoSubject.setSelected(this.config.getColumnAlgoSubjectVisible());
        sl_generalPanel.putConstraint("North", (Component)this.cbAlgoSubject, 6, "South", (Component)this.cbAlgoProblemAffiliation);
        sl_generalPanel.putConstraint("West", (Component)this.cbAlgoSubject, 0, "West", this.cboLanguages);
        generalPanel.add(this.cbAlgoSubject);
        this.cbAlgoType = new JCheckBox(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "COLUMN_ALGOTYPE", this.mainWin.getLanguageID(), "Type"));
        this.cbAlgoType.setSelected(this.config.getColumnAlgoTypeVisible());
        sl_generalPanel.putConstraint("North", (Component)this.cbAlgoType, 6, "South", (Component)this.cbAlgoSubject);
        sl_generalPanel.putConstraint("West", (Component)this.cbAlgoType, 0, "West", this.cboLanguages);
        generalPanel.add(this.cbAlgoType);
        this.cbAlgoAuthor = new JCheckBox(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "COLUMN_ALGOAUTHOR", this.mainWin.getLanguageID(), "Author"));
        this.cbAlgoAuthor.setSelected(this.config.getColumnAlgoAuthorVisible());
        sl_generalPanel.putConstraint("North", (Component)this.cbAlgoAuthor, 6, "South", (Component)this.cbAlgoType);
        sl_generalPanel.putConstraint("West", (Component)this.cbAlgoAuthor, 0, "West", this.cboLanguages);
        generalPanel.add(this.cbAlgoAuthor);
        this.cbAlgoAuthorContact = new JCheckBox(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "COLUMN_ALGOAUTHORCONTACT", this.mainWin.getLanguageID(), "Author Contact Details"));
        this.cbAlgoAuthorContact.setSelected(this.config.getColumnAlgoAuthorContactVisible());
        sl_generalPanel.putConstraint("North", (Component)this.cbAlgoAuthorContact, 0, "North", (Component)this.cbAlgoProblemAffiliation);
        sl_generalPanel.putConstraint("West", (Component)this.cbAlgoAuthorContact, 250, "West", this.cboLanguages);
        generalPanel.add(this.cbAlgoAuthorContact);
        this.cbAlgoVersion = new JCheckBox(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "COLUMN_ALGOVERSION", this.mainWin.getLanguageID(), "Version"));
        this.cbAlgoVersion.setSelected(this.config.getColumnAlgoVersionVisible());
        sl_generalPanel.putConstraint("North", (Component)this.cbAlgoVersion, 0, "North", (Component)this.cbAlgoSubject);
        sl_generalPanel.putConstraint("West", (Component)this.cbAlgoVersion, 0, "West", (Component)this.cbAlgoAuthorContact);
        generalPanel.add(this.cbAlgoVersion);
        this.cbUsedSDKVersion = new JCheckBox(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "COLUMN_ALGOSDKVERSION", this.mainWin.getLanguageID(), "Used SDK Version"));
        this.cbUsedSDKVersion.setSelected(this.config.getColumnAlgoSDKVersionVisible());
        sl_generalPanel.putConstraint("North", (Component)this.cbUsedSDKVersion, 0, "North", (Component)this.cbAlgoType);
        sl_generalPanel.putConstraint("West", (Component)this.cbUsedSDKVersion, 0, "West", (Component)this.cbAlgoAuthorContact);
        generalPanel.add(this.cbUsedSDKVersion);
        JSeparator sep3 = new JSeparator();
        sl_generalPanel.putConstraint("North", (Component)sep3, 6, "South", (Component)this.cbAlgoAuthor);
        sl_generalPanel.putConstraint("West", (Component)sep3, 0, "West", (Component)sep1);
        sl_generalPanel.putConstraint("East", (Component)sep3, 0, "East", (Component)sep1);
        generalPanel.add(sep3);
        JLabel lblOpenRecentCount = new JLabel(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_MAIN_OPENRECENTCOUNT", this.mainWin.getLanguageID(), "Open Recent Count:"));
        sl_generalPanel.putConstraint("West", this.cboLanguages, 30, "East", (Component)lblOpenRecentCount);
        sl_generalPanel.putConstraint("West", (Component)lblOpenRecentCount, 0, "West", (Component)lblLanguage);
        generalPanel.add(lblOpenRecentCount);
        this.openRecentCountSlider = new JSlider();
        this.openRecentCountSlider.setMajorTickSpacing(2);
        this.openRecentCountSlider.setMaximum(10);
        this.openRecentCountSlider.setPaintLabels(true);
        this.openRecentCountSlider.setPaintTicks(true);
        this.openRecentCountSlider.setValue(this.config.getLastOpendAlgorithmsCount());
        sl_generalPanel.putConstraint("West", (Component)this.openRecentCountSlider, 0, "West", this.cboLanguages);
        sl_generalPanel.putConstraint("North", (Component)lblOpenRecentCount, 5, "North", (Component)this.openRecentCountSlider);
        sl_generalPanel.putConstraint("North", (Component)this.openRecentCountSlider, 6, "South", (Component)sep3);
        generalPanel.add(this.openRecentCountSlider);
        JLabel lblOpenRecentCountInfo = new JLabel(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_MAIN_OPENRECENTCOUNT_INFO", this.mainWin.getLanguageID(), "Specify how many algorithms should be listed in the history."));
        lblOpenRecentCountInfo.setFont(infoFont);
        sl_generalPanel.putConstraint("North", (Component)lblOpenRecentCountInfo, 6, "South", (Component)this.openRecentCountSlider);
        sl_generalPanel.putConstraint("West", (Component)lblOpenRecentCountInfo, 0, "West", (Component)this.openRecentCountSlider);
        sl_generalPanel.putConstraint("East", (Component)lblOpenRecentCountInfo, -10, "East", (Component)generalPanel);
        generalPanel.add(lblOpenRecentCountInfo);
        JPanel customizePanel = new JPanel();
        tabbedPane.addTab(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_CUSTOMIZE", this.mainWin.getLanguageID(), "Customize"), null, customizePanel, null);
        SpringLayout sl_customizePanel = new SpringLayout();
        customizePanel.setLayout(sl_customizePanel);
        JLabel lblSelectPlugin = new JLabel(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_CUSTOMIZE_SELECTPLUGIN", this.mainWin.getLanguageID(), "Select a plugin:"));
        sl_customizePanel.putConstraint("West", (Component)lblSelectPlugin, 10, "West", (Component)customizePanel);
        customizePanel.add(lblSelectPlugin);
        this.cboPlugins = new JComboBox();
        this.cboPluginsIndices = this.loadCustomizablePlugins();
        this.cboPlugins.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PreferencesDialog.this.loadPluginCustomization();
                }
            }
        });
        sl_customizePanel.putConstraint("West", this.cboPlugins, 20, "East", (Component)lblSelectPlugin);
        sl_customizePanel.putConstraint("East", this.cboPlugins, -10, "East", (Component)customizePanel);
        sl_customizePanel.putConstraint("North", (Component)lblSelectPlugin, 3, "North", this.cboPlugins);
        sl_customizePanel.putConstraint("North", this.cboPlugins, 10, "North", (Component)customizePanel);
        customizePanel.add(this.cboPlugins);
        JSeparator separator = new JSeparator();
        sl_customizePanel.putConstraint("North", (Component)separator, 6, "South", this.cboPlugins);
        sl_customizePanel.putConstraint("West", (Component)separator, 10, "West", (Component)customizePanel);
        sl_customizePanel.putConstraint("East", (Component)separator, -10, "East", (Component)customizePanel);
        customizePanel.add(separator);
        this.propsListModel = new CustomizationListModel();
        this.propsList = new PropertiesList(this.propsListModel);
        sl_customizePanel.putConstraint("North", (Component)this.propsList, 6, "South", (Component)separator);
        sl_customizePanel.putConstraint("West", (Component)this.propsList, 0, "West", (Component)lblSelectPlugin);
        sl_customizePanel.putConstraint("East", (Component)this.propsList, 0, "East", this.cboPlugins);
        customizePanel.add(this.propsList);
        JButton applyBtn = new JButton(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PREFERENCES_CUSTOMIZE_APPLY", this.mainWin.getLanguageID(), "Apply"));
        applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.doApplyCustomization();
            }
        });
        sl_customizePanel.putConstraint("South", (Component)this.propsList, -10, "North", (Component)applyBtn);
        sl_customizePanel.putConstraint("South", (Component)applyBtn, -10, "South", (Component)customizePanel);
        sl_customizePanel.putConstraint("East", (Component)applyBtn, -10, "East", (Component)customizePanel);
        customizePanel.add(applyBtn);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_BTN_OK", this.mainWin.getLanguageID(), "Ok"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.doOk();
                PreferencesDialog.this.dispose();
            }
        });
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_BTN_CANCEL", this.mainWin.getLanguageID(), "Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.dispose();
            }
        });
        buttonPane.add(cancelButton);
        this.addWindowListener(new WindowAdapter(){
            private boolean closed = false;

            @Override
            public void windowClosed(WindowEvent e) {
                this.windowClosing(e);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (this.closed) {
                    return;
                }
                cfg.setPreferencesDialogWidth(PreferencesDialog.this.getWidth());
                cfg.setPreferencesDialogHeight(PreferencesDialog.this.getHeight());
                this.closed = true;
            }
        });
        this.mainWin.setCursor(Cursor.getDefaultCursor());
    }

    private void loadLanguages() {
        List<LabelEntry> langs = this.mainWin.getLanguageFile().getAvailableLanguages();
        int currLangIndex = -1;
        int i = 0;
        while (i < langs.size()) {
            if (langs.get((int)i).langID.equals(this.mainWin.getLanguageID())) {
                currLangIndex = i;
            }
            this.cboLanguages.addItem(String.valueOf(langs.get((int)i).description) + " [" + langs.get((int)i).langID + "]");
            ++i;
        }
        this.cboLanguages.setSelectedIndex(currLangIndex);
    }

    private List<Integer> loadCustomizablePlugins() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        List<AlgorithmPlugin> plugins = this.mainWin.getLoader().getPluginManager().getInstalledPlugins();
        int i = 0;
        while (i < plugins.size()) {
            if (plugins.get(i).hasCustomization()) {
                this.cboPlugins.addItem(plugins.get(i).getName());
                indices.add(i);
            }
            ++i;
        }
        this.cboPlugins.setSelectedIndex(-1);
        return indices;
    }

    private void loadPluginCustomization() {
        int selIndex = this.cboPlugins.getSelectedIndex();
        if (selIndex < 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.propsListModel.removeAll();
        this.mainWin.getLoader().getPluginManager().getInstalledPlugins().get(this.cboPluginsIndices.get(selIndex)).loadCustomization(this.propsListModel);
        this.propsList.repaint();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void doOk() {
        List<LabelEntry> langs = this.mainWin.getLanguageFile().getAvailableLanguages();
        String newLangID = langs.get((int)this.cboLanguages.getSelectedIndex()).langID;
        boolean langChanged = !this.config.getLanguageID().equals(newLangID);
        this.doApplyCustomization();
        this.config.setLanguageID(newLangID);
        this.config.setShowWelcomeScreen(this.cbShowWelcomeScreen.isSelected());
        this.config.setShowExerciseModeInfoDialog(this.cbShowExerciseModeInfoDlg.isSelected());
        this.config.setDisableInformationBarPermanently(this.cbDisableInfoBarPermanently.isSelected());
        this.config.setColumnAlgoProblemAffiliationVisible(this.cbAlgoProblemAffiliation.isSelected());
        this.config.setColumnAlgoSubjectVisible(this.cbAlgoSubject.isSelected());
        this.config.setColumnAlgoTypeVisible(this.cbAlgoType.isSelected());
        this.config.setColumnAlgoAuthorVisible(this.cbAlgoAuthor.isSelected());
        this.config.setColumnAlgoVersionVisible(this.cbAlgoVersion.isSelected());
        this.config.setColumnAlgoSDKVersionVisible(this.cbUsedSDKVersion.isSelected());
        this.config.setLastOpenedAlgorithmsCount(this.openRecentCountSlider.getValue());
        if (langChanged) {
            JOptionPane.showMessageDialog(this, LanguageFile.getLabel(this.mainWin.getLanguageFile(), "MSG_INFO_LANGUAGECHANGED", newLangID, "Please restart LAVES to apply the changed language settings."), LanguageFile.getLabel(this.mainWin.getLanguageFile(), "MSG_INFO_TITLE_LANGUAGECHANGED", newLangID, "Language"), 1);
        }
    }

    private void doApplyCustomization() {
        int selIndex = this.cboPlugins.getSelectedIndex();
        if (selIndex < 0) {
            return;
        }
        this.mainWin.getLoader().getPluginManager().getInstalledPlugins().get(this.cboPluginsIndices.get(selIndex)).applyCustomization(this.propsListModel);
    }

    private class CustomizationListModel
    extends PropertiesListModel {
        public CustomizationListModel() {
            super(PreferencesDialog.this.mainWin.getLanguageFile(), PreferencesDialog.this.mainWin.getLanguageID());
        }

        @Override
        public boolean isHeaderVisible() {
            return true;
        }

        @Override
        public boolean hasAutoRowSorter() {
            return true;
        }
    }
}

