/*
 * Decompiled with CFR 0.152.
 */
package laves.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import laves.PluginManagerListener;
import laves.configuration.MainConfiguration;
import laves.gui.MainWindow;
import laves.gui.widgets.AlgorithmTableModel;
import laves.resources.ResourceManager;
import lavesdk.algorithm.plugin.PluginBundle;
import lavesdk.algorithm.plugin.PluginLoader;
import lavesdk.algorithm.plugin.ValidationReport;
import lavesdk.algorithm.plugin.exceptions.InvalidPluginException;
import lavesdk.language.LanguageFile;

public class PluginManagerDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final MainWindow mainWin;
    private final JPanel contentPanel = new JPanel();
    private final JTable table;
    private final AlgorithmTableModel tableModel;
    private final JButton deinstallBtn;
    private final PluginManagerListener pluginManListener;

    public PluginManagerDialog(MainWindow mw, final MainConfiguration cfg) throws IllegalArgumentException {
        if (mw == null || cfg == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.mainWin = mw;
        this.pluginManListener = new PluginManagerListener(){

            @Override
            public void onInstalledPluginsChanged(boolean increase) {
                PluginManagerDialog.this.tableModel.reload();
                PluginManagerDialog.this.deinstallBtn.setEnabled(false);
            }
        };
        mw.getLoader().getPluginManager().addListener(this.pluginManListener);
        this.setTitle(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PLUGINMANAGER_TITLE", this.mainWin.getLanguageID(), "Installed Plugins"));
        this.setModal(true);
        this.setSize(cfg.getPluginManagerDialogWidth(), cfg.getPluginManagerDialogHeight());
        this.setDefaultCloseOperation(2);
        this.mainWin.adaptDialog(this);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel descPanel = new JPanel(new BorderLayout(10, 10));
        descPanel.setBackground(Color.white);
        descPanel.add((Component)new JLabel(ResourceManager.getInstance().ICON_PLUGIN_BIG), "West");
        descPanel.add((Component)new JLabel("<html>" + LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PLUGINMANAGER_DESCRIPTION", this.mainWin.getLanguageID(), "<b>Install new plugins or deinstall existing ones.</b>") + "</html>"), "Center");
        descPanel.add((Component)new JSeparator(), "South");
        descPanel.setBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, Color.white));
        this.getContentPane().add((Component)descPanel, "North");
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(5, 5));
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "Center");
        this.tableModel = new AlgorithmTableModel(cfg, this.mainWin.getLoader(), this.mainWin.getLanguageFile(), this.mainWin.getLanguageID(), true);
        this.table = new JTable(this.tableModel);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setAutoCreateRowSorter(true);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PluginManagerDialog.this.deinstallBtn.setEnabled(true);
            }
        });
        scrollPane.setViewportView(this.table);
        JPanel panel = new JPanel();
        this.contentPanel.add((Component)panel, "East");
        panel.setLayout(new BoxLayout(panel, 1));
        JButton installBtn = new JButton(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PLUGINMANAGER_BTN_INSTALL", this.mainWin.getLanguageID(), "Install..."));
        installBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginManagerDialog.this.doInstallNew();
            }
        });
        panel.add(installBtn);
        this.deinstallBtn = new JButton(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_PLUGINMANAGER_BTN_DEINSTALL", this.mainWin.getLanguageID(), "Deinstall"));
        this.deinstallBtn.setEnabled(false);
        this.deinstallBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginManagerDialog.this.doDeinstallPlugin();
            }
        });
        panel.add(this.deinstallBtn);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton quitButton = new JButton(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_BTN_QUIT", this.mainWin.getLanguageID(), "Quit"));
        quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginManagerDialog.this.dispose();
            }
        });
        buttonPane.add(quitButton);
        this.getRootPane().setDefaultButton(quitButton);
        this.addWindowListener(new WindowAdapter(){
            private boolean closed = false;

            @Override
            public void windowClosed(WindowEvent e) {
                this.windowClosing(e);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (this.closed) {
                    return;
                }
                PluginManagerDialog.this.mainWin.getLoader().getPluginManager().removeListener(PluginManagerDialog.this.pluginManListener);
                cfg.setPluginManagerDialogWidth(PluginManagerDialog.this.getWidth());
                cfg.setPluginManagerDialogHeight(PluginManagerDialog.this.getHeight());
                this.closed = true;
            }
        });
    }

    private void doInstallNew() {
        JFileChooser fc = new JFileChooser();
        String errMsg = String.valueOf(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "MSG_ERR_INVALIDPLUGIN", this.mainWin.getLanguageID(), "The selected plugin is not valid, therefore it cannot be installed!")) + "\n";
        String errTitle = LanguageFile.getLabel(this.mainWin.getLanguageFile(), "MSG_ERR_TITLE_INVALIDPLUGIN", this.mainWin.getLanguageID(), "Invalid plugin");
        fc.setAcceptAllFileFilterUsed(false);
        fc.setMultiSelectionEnabled(false);
        fc.addChoosableFileFilter(new FileNameExtensionFilter("Plugin (*.jar)", "jar"));
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File pluginFile = fc.getSelectedFile();
            if (!pluginFile.getAbsolutePath().toLowerCase().endsWith(".jar")) {
                return;
            }
            try {
                PluginBundle bundle = PluginLoader.getInstance().loadPlugin(pluginFile);
                this.setCursor(Cursor.getPredefinedCursor(3));
                ValidationReport vr = this.mainWin.getLoader().getPluginManager().install(bundle);
                this.setCursor(Cursor.getDefaultCursor());
                if (!vr.ok) {
                    JOptionPane.showMessageDialog(this, String.valueOf(errMsg) + vr.message, errTitle, 0);
                }
            }
            catch (InvalidPluginException e) {
                JOptionPane.showMessageDialog(this, String.valueOf(errMsg) + e.getMessage(), errTitle, 0);
            }
        }
    }

    private void doDeinstallPlugin() {
        if (this.table.getSelectedRow() < 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean result = this.mainWin.getLoader().getPluginManager().deinstall(this.tableModel.getRow(this.table.convertRowIndexToModel(this.table.getSelectedRow())));
        this.setCursor(Cursor.getDefaultCursor());
        if (!result) {
            JOptionPane.showMessageDialog(this, LanguageFile.getLabel(this.mainWin.getLanguageFile(), "MSG_ERR_DEINSTALLPLUGIN", this.mainWin.getLanguageID(), "The plugin could not be deinstalled!"), LanguageFile.getLabel(this.mainWin.getLanguageFile(), "MSG_ERR_TITLE_DEINSTALLPLUGIN", this.mainWin.getLanguageID(), "Deinstall plugin"), 0);
        }
    }
}

