/*
 * Decompiled with CFR 0.152.
 */
package laves.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import laves.configuration.MainConfiguration;
import laves.gui.MainWindow;
import laves.gui.widgets.AlgorithmTableModel;
import laves.gui.widgets.HintTextFieldUI;
import laves.resources.ResourceManager;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.gui.widgets.PropertiesList;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.language.LanguageFile;

public class NewDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final MainWindow mainWin;
    private AlgorithmPlugin selectedPlugin;
    private AlgorithmPlugin currSelectedPlugin;
    private PropertiesListModel creatorPreferences;
    private PropertiesListModel currCreatorPreferences;
    private final JPanel contentPanel = new JPanel();
    private final PropertiesList prefList;
    private final AlgorithmTableModel algoTableModel;
    private final JTable algoTable;
    private final TableRowSorter<AlgorithmTableModel> algoTableSorter;
    private final JPanel infoPanel;
    private final JPanel prefsGroup;
    private final JLabel lblAlgoName;
    private final JLabel lblAlgoDesc;
    private final JLabel lblAlgoProbAffil;
    private final JLabel lblAlgoSubject;
    private final JLabel lblAlgoType;
    private final JLabel lblAlgoAssumptions;
    private final String algoNameLabel;
    private final String algoDescLabel;
    private final String algoProbAffilLabel;
    private final String algoSubjectLabel;
    private final String algoTypeLabel;
    private final String algoAssumptionsLabel;

    public NewDialog(MainWindow mw, final MainConfiguration cfg) throws IllegalArgumentException {
        if (mw == null || cfg == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        Font f = UIManager.getFont("Label.font");
        Font boldFont = f.deriveFont(1);
        this.mainWin = mw;
        this.selectedPlugin = null;
        this.currSelectedPlugin = null;
        this.creatorPreferences = null;
        this.currCreatorPreferences = null;
        this.algoNameLabel = LanguageFile.getLabel(this.mainWin.getLanguageFile(), "COLUMN_ALGONAME", this.mainWin.getLanguageID(), "Name");
        this.algoDescLabel = LanguageFile.getLabel(this.mainWin.getLanguageFile(), "COLUMN_ALGODESC", this.mainWin.getLanguageID(), "Description");
        this.algoProbAffilLabel = LanguageFile.getLabel(this.mainWin.getLanguageFile(), "COLUMN_ALGOPROBLEMAFFILIATION", this.mainWin.getLanguageID(), "Problem Affiliation");
        this.algoSubjectLabel = LanguageFile.getLabel(this.mainWin.getLanguageFile(), "COLUMN_ALGOSUBJECT", this.mainWin.getLanguageID(), "Subject");
        this.algoTypeLabel = LanguageFile.getLabel(this.mainWin.getLanguageFile(), "COLUMN_ALGOTYPE", this.mainWin.getLanguageID(), "Type");
        this.algoAssumptionsLabel = LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_NEW_ALGOASSUMPTIONS", this.mainWin.getLanguageID(), "Assumption(s)");
        this.setTitle(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_NEW_TITLE", this.mainWin.getLanguageID(), "New algorithm"));
        this.setSize(cfg.getNewDialogWidth(), cfg.getNewDialogHeight());
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.mainWin.adaptDialog(this);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel descPanel = new JPanel(new BorderLayout(10, 10));
        descPanel.setBackground(Color.white);
        descPanel.add((Component)new JLabel(ResourceManager.getInstance().ICON_NEW_BIG), "West");
        descPanel.add((Component)new JLabel("<html>" + LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_NEW_DESCRIPTION", this.mainWin.getLanguageID(), "<b>Select an algorithm from the list below.</b><br>Use the preferences to individualize the selected algorithm.") + "</html>"), "Center");
        descPanel.add((Component)new JSeparator(), "South");
        descPanel.setBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, Color.white));
        this.getContentPane().add((Component)descPanel, "North");
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        SpringLayout sl_contentPanel = new SpringLayout();
        this.contentPanel.setLayout(sl_contentPanel);
        ViewGroup gblSplitPane = new ViewGroup(0);
        sl_contentPanel.putConstraint("North", (Component)gblSplitPane, 2, "North", (Component)this.contentPanel);
        sl_contentPanel.putConstraint("West", (Component)gblSplitPane, 2, "West", (Component)this.contentPanel);
        sl_contentPanel.putConstraint("South", (Component)gblSplitPane, -2, "South", (Component)this.contentPanel);
        sl_contentPanel.putConstraint("East", (Component)gblSplitPane, -2, "East", (Component)this.contentPanel);
        this.contentPanel.add(gblSplitPane);
        JPanel algoTablePanel = new JPanel(new BorderLayout(2, 2));
        gblSplitPane.add(algoTablePanel);
        final JTextField searchField = new JTextField();
        searchField.setUI(new HintTextFieldUI(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_NEW_SEARCH", this.mainWin.getLanguageID(), "Search")));
        searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewDialog.this.filterAlgoTable(searchField);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewDialog.this.filterAlgoTable(searchField);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewDialog.this.filterAlgoTable(searchField);
            }
        });
        algoTablePanel.add((Component)searchField, "North");
        this.algoTableModel = new AlgorithmTableModel(cfg, this.mainWin.getLoader(), this.mainWin.getLanguageFile(), this.mainWin.getLanguageID());
        this.algoTableSorter = new TableRowSorter<AlgorithmTableModel>(this.algoTableModel);
        this.algoTable = new JTable(this.algoTableModel);
        this.algoTableModel.setTable(this.algoTable);
        this.algoTable.setRowSorter(this.algoTableSorter);
        this.algoTable.setRowHeight(20);
        this.algoTable.getTableHeader().setReorderingAllowed(false);
        this.algoTable.getSelectionModel().setSelectionMode(0);
        this.algoTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (NewDialog.this.algoTable.getSelectedRowCount() < 1) {
                    return;
                }
                NewDialog.this.selectionChanged(NewDialog.this.algoTableModel.getRow(NewDialog.this.algoTable.convertRowIndexToModel(NewDialog.this.algoTable.getSelectedRow())));
            }
        });
        this.algoTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && NewDialog.this.algoTable.getSelectedRowCount() > 0) {
                    NewDialog.this.selectionChanged(NewDialog.this.algoTableModel.getRow(NewDialog.this.algoTable.convertRowIndexToModel(NewDialog.this.algoTable.getSelectedRow())));
                    NewDialog.this.doOk();
                }
            }
        });
        algoTablePanel.add((Component)new JScrollPane(this.algoTable), "Center");
        JLabel lblNOIA = new JLabel(String.valueOf(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_NEW_NUMBEROFINSTALLEDALGOS", this.mainWin.getLanguageID(), "Number of installed algorithms:")) + " " + this.algoTableModel.getRowCount());
        algoTablePanel.add((Component)lblNOIA, "South");
        ViewGroup rightSplitPane = new ViewGroup(1);
        gblSplitPane.add(rightSplitPane);
        JPanel infoGroup = new JPanel(new BorderLayout());
        infoGroup.setBorder(BorderFactory.createTitledBorder(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_NEW_INFORMATIONAREA_TITLE", this.mainWin.getLanguageID(), "Information")));
        this.infoPanel = new JPanel(new GridBagLayout());
        infoGroup.add((Component)this.infoPanel, "Center");
        rightSplitPane.add(infoGroup);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 0.6;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 0, 2);
        JLabel lbl = new JLabel(this.algoNameLabel);
        lbl.setFont(boldFont);
        this.infoPanel.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 0.4;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 0, 2);
        lbl = new JLabel(this.algoTypeLabel);
        lbl.setFont(boldFont);
        this.infoPanel.add((Component)lbl, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 0.6;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.lblAlgoName = new JLabel();
        this.infoPanel.add((Component)this.lblAlgoName, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 0.4;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.lblAlgoType = new JLabel();
        this.infoPanel.add((Component)this.lblAlgoType, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 0, 2);
        lbl = new JLabel(this.algoDescLabel);
        lbl.setFont(boldFont);
        this.infoPanel.add((Component)lbl, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.lblAlgoDesc = new JLabel();
        this.infoPanel.add((Component)this.lblAlgoDesc, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 0.6;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 0, 2);
        lbl = new JLabel(this.algoProbAffilLabel);
        lbl.setFont(boldFont);
        this.infoPanel.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 0.4;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 0, 2);
        lbl = new JLabel(this.algoSubjectLabel);
        lbl.setFont(boldFont);
        this.infoPanel.add((Component)lbl, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 0.6;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.lblAlgoProbAffil = new JLabel();
        this.infoPanel.add((Component)this.lblAlgoProbAffil, gbc);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 0.4;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.lblAlgoSubject = new JLabel();
        this.infoPanel.add((Component)this.lblAlgoSubject, gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 0, 2);
        lbl = new JLabel(this.algoAssumptionsLabel);
        lbl.setFont(boldFont);
        this.infoPanel.add((Component)lbl, gbc);
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.lblAlgoAssumptions = new JLabel();
        this.infoPanel.add((Component)this.lblAlgoAssumptions, gbc);
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.infoPanel.add((Component)new JLabel(), gbc);
        this.prefsGroup = new JPanel(new BorderLayout());
        this.prefsGroup.setBorder(BorderFactory.createTitledBorder(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_NEW_CREATORPREFSAREA_TITLE", this.mainWin.getLanguageID(), "Preferences")));
        this.prefList = new PropertiesList();
        this.prefsGroup.add((Component)this.prefList, "Center");
        this.prefsGroup.setVisible(false);
        rightSplitPane.add(this.prefsGroup);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_BTN_OK", this.mainWin.getLanguageID(), "Ok"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewDialog.this.doOk();
            }
        });
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(LanguageFile.getLabel(this.mainWin.getLanguageFile(), "DLG_BTN_CANCEL", this.mainWin.getLanguageID(), "Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewDialog.this.doCancel();
            }
        });
        buttonPane.add(cancelButton);
        this.addWindowListener(new WindowAdapter(){
            private boolean closed = false;
            private boolean opened = false;

            @Override
            public void windowClosed(WindowEvent e) {
                this.windowClosing(e);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (this.closed) {
                    return;
                }
                cfg.setNewDialogWidth(NewDialog.this.getWidth());
                cfg.setNewDialogHeight(NewDialog.this.getHeight());
                NewDialog.this.algoTableModel.storeColumnWidths();
                this.closed = true;
            }

            @Override
            public void windowOpened(WindowEvent e) {
                if (this.opened) {
                    return;
                }
                NewDialog.this.requestFocusInWindow();
                this.opened = true;
            }
        });
        gblSplitPane.setWeights(new float[]{0.6f, 0.4f});
        rightSplitPane.setWeights(new float[]{0.65f, 0.35f});
    }

    public AlgorithmPlugin getSelectedPlugin() {
        return this.selectedPlugin;
    }

    public PropertiesListModel getCreatorPreferences() {
        return this.creatorPreferences;
    }

    private void doOk() {
        this.selectedPlugin = this.currSelectedPlugin;
        this.creatorPreferences = this.currCreatorPreferences;
        this.dispose();
    }

    private void doCancel() {
        this.selectedPlugin = null;
        this.creatorPreferences = null;
        this.dispose();
    }

    private void selectionChanged(AlgorithmPlugin plugin) {
        if (plugin == null) {
            this.lblAlgoName.setText("");
            this.lblAlgoType.setText("");
            this.lblAlgoDesc.setText("");
            this.lblAlgoProbAffil.setText("");
            this.lblAlgoSubject.setText("");
            this.lblAlgoAssumptions.setText("");
            this.prefsGroup.setVisible(false);
            return;
        }
        if (plugin.hasCreatorPreferences()) {
            this.currCreatorPreferences = new PropertiesListModel(this.mainWin.getLanguageFile(), this.mainWin.getLanguageID());
            plugin.loadCreatorPreferences(this.currCreatorPreferences);
            this.prefList.setModel(this.currCreatorPreferences);
            this.prefsGroup.setVisible(true);
        } else {
            this.currCreatorPreferences = null;
            this.prefsGroup.setVisible(false);
        }
        this.lblAlgoName.setText(plugin.getName());
        this.lblAlgoType.setText(plugin.getType());
        this.lblAlgoDesc.setText("<html>" + plugin.getDescription() + "</html>");
        this.lblAlgoProbAffil.setText(plugin.getProblemAffiliation());
        this.lblAlgoSubject.setText(plugin.getSubject());
        this.lblAlgoAssumptions.setText("<html>" + plugin.getAssumptions() + "</html>");
        this.currSelectedPlugin = plugin;
    }

    private void filterAlgoTable(JTextField searchField) {
        int[] columns = new int[this.algoTableModel.getColumnCount()];
        RowFilter filter = null;
        int i = 0;
        while (i < columns.length) {
            columns[i] = i;
            ++i;
        }
        try {
            filter = RowFilter.regexFilter("(?i)" + searchField.getText(), columns);
        }
        catch (PatternSyntaxException e) {
            filter = null;
        }
        if (filter != null) {
            this.algoTableSorter.setRowFilter(filter);
        }
    }
}

