/*
 * Decompiled with CFR 0.152.
 */
package laves.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import laves.Loader;
import laves.PluginManagerListener;
import laves.configuration.MainConfiguration;
import laves.gui.AboutDialog;
import laves.gui.ChangeExecSpeedDialog;
import laves.gui.ExerciseModeInfoDialog;
import laves.gui.HowToDialog;
import laves.gui.NewDialog;
import laves.gui.PluginManagerDialog;
import laves.gui.PreferencesDialog;
import laves.gui.widgets.StatusBar;
import laves.gui.widgets.WelcomeScreen;
import laves.gui.widgets.WelcomeScreenListener;
import laves.resources.ResourceManager;
import laves.utils.Constants;
import laves.utils.Utils;
import lavesdk.algorithm.AlgorithmExerciseProvider;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.RTEListener;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.enums.AlgorithmStartOption;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginBundle;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.ExercisesListView;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.configuration.Configuration;
import lavesdk.gui.widgets.InformationBar;
import lavesdk.gui.widgets.Option;
import lavesdk.gui.widgets.OptionComboButton;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.language.LanguageFile;
import lavesdk.logging.enums.LogType;
import lavesdk.resources.Resources;
import lavesdk.utils.FileUtils;
import lavesdk.utils.MathUtils;

public class MainWindow
extends JFrame
implements PluginHost {
    private static final long serialVersionUID = 1L;
    private final Loader loader;
    private final MainConfiguration config;
    private final LanguageFile langFile;
    private final String langID;
    private final Map<Integer, Float> execSpeedFactors;
    private final int normalExecSpeedKey;
    private boolean initialized;
    private AlgorithmPlugin activePlugin;
    private List<AlgorithmPlugin> lastOpenedPlugins;
    private final int lastOpenedPluginsCount;
    private final EventController eventController;
    private final JToolBar toolBar;
    private final JPanel contentPanel;
    private final InformationBar infoBar;
    private final ExercisesListView exercisesList;
    private final ViewGroup splitPane;
    private final ViewContainer viewContainer;
    private final StatusBar statusBar;
    private final JButton newBtn;
    private final JButton saveAsBtn;
    private final JButton openBtn;
    private final JToggleButton exerciseModeBtn;
    private final OptionComboButton startBtn;
    private final JButton pauseBtn;
    private final JButton stopBtn;
    private final JButton prevStepBtn;
    private final JButton nextStepBtn;
    private final JToggleButton skipBreakpointsBtn;
    private final JToggleButton pauseBeforeStopBtn;
    private final JSlider execSpeedSlider;
    private final JButton slowerBtn;
    private final JButton fasterBtn;
    private final JButton resetExecSpeedBtn;
    private final JLabel execSpeedLbl;
    private final JFileChooser fileChooser;
    private JMenu menuFunctions;
    private static final String ACTION_NEW = "onNew";
    private static final String ACTION_SAVEAS = "onSaveAs";
    private static final String ACTION_OPEN = "onOpen";
    private static final String ACTION_CHANGERTEMODE = "onChangeRTEMode";
    private static final String ACTION_OPT_START = "onStart";
    private static final String ACTION_OPT_STARTTOFINISH = "onStartToFinish";
    private static final String ACTION_OPT_PLAYANDPAUSE = "onPlayAndPause";
    private static final String ACTION_PAUSE = "onPause";
    private static final String ACTION_STOP = "onStop";
    private static final String ACTION_PREVSTEP = "onPrevStep";
    private static final String ACTION_NEXTSTEP = "onNextStep";
    private static final String ACTION_PAUSEBEFORESTOP = "onPauseBeforeStop";
    private static final String ACTION_SKIPBREAKPOINTS = "onSkipBreakpoints";
    private static final String ACTION_SLOWER = "onSlower";
    private static final String ACTION_FASTER = "onFaster";
    private static final String ACTION_RESETEXECSPEED = "onResetExecSpeed";
    private static final String ACTION_EXIT = "onExit";
    private static final String ACTION_INSTALLNEWPLUGINS = "onInstallNewPlugins";
    private static final String ACTION_OPENPLUGINSPAGE = "onOpenPlugins";
    private static final String ACTION_PREFERENCES = "onPreferences";
    private static final String ACTION_HELP = "onHelp";
    private static final String ACTION_HOWTO = "onHowTo";
    private static final String ACTION_OPENWEBSITE = "onOpenWebsite";
    private static final String ACTION_ABOUT = "onAbout";
    private static final String DYNACTION = "dynOn";
    private static final String DYNACTION_PARAMSEP = "#";
    private static final String DYNACTION_OPENRECENT = "dynOnOpenLastAlgo#";
    private static final String DYNACTION_SHOWFUNC = "dynOnShowFunc#";
    private static final int EXECSPEED_SLIDER_WIDTH = 100;

    public MainWindow(Loader loader) throws IllegalArgumentException {
        if (loader == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.initialized = false;
        this.loader = loader;
        this.config = new MainConfiguration(loader.getMainConfiguration(), loader.getLanguageFile().getAvailableLanguages());
        this.langFile = loader.getLanguageFile();
        this.langID = this.config.getLanguageID();
        this.execSpeedFactors = new HashMap<Integer, Float>();
        this.normalExecSpeedKey = this.createExecSpeedFactors();
        this.activePlugin = null;
        this.lastOpenedPluginsCount = this.config.getLastOpendAlgorithmsCount();
        this.menuFunctions = null;
        this.setTitle("LAVES - Logistics Algorithms Visualization and Education Software");
        this.setIconImage(ResourceManager.getInstance().APP_ICON);
        this.setDefaultCloseOperation(3);
        this.setSize(this.config.getWindowWidth(), this.config.getWindowHeight());
        if (this.config.getWindowMaximized()) {
            this.setExtendedState(6);
        }
        this.setLocation(this.config.getWindowPosX(), this.config.getWindowPosY());
        this.setLayout(new BorderLayout());
        this.eventController = new EventController();
        this.contentPanel = new JPanel(new BorderLayout());
        this.infoBar = new InformationBar(this, this.langFile, this.langID);
        this.infoBar.setVisible(false);
        this.exercisesList = new ExercisesListView(this.langFile, this.langID);
        this.exercisesList.setVisible(false);
        this.viewContainer = new ViewContainer(0);
        this.splitPane = new ViewGroup(0, 4);
        this.splitPane.add(this.exercisesList);
        this.splitPane.add(this.viewContainer);
        this.splitPane.setWeights(new float[]{0.25f, 0.75f});
        this.splitPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.statusBar = new StatusBar();
        this.fileChooser = new JFileChooser();
        this.contentPanel.add((Component)this.infoBar, "North");
        this.contentPanel.add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.statusBar.setText(1, LanguageFile.getLabel(this.langFile, "WELCOME_MESSAGE", this.langID, "Welcome to LAVES!"));
        this.newBtn = new JButton(Resources.getInstance().NEW_ICON);
        this.newBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "FILE_NEW", this.langID, "New..."));
        this.newBtn.setActionCommand(ACTION_NEW);
        this.newBtn.addActionListener(this.eventController);
        this.toolBar.add(this.newBtn);
        this.toolBar.addSeparator();
        this.saveAsBtn = new JButton(Resources.getInstance().SAVE_ICON);
        this.saveAsBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "FILE_SAVE_AS", this.langID, "Save as..."));
        this.saveAsBtn.setActionCommand(ACTION_SAVEAS);
        this.saveAsBtn.addActionListener(this.eventController);
        this.toolBar.add(this.saveAsBtn);
        this.openBtn = new JButton(Resources.getInstance().OPEN_ICON);
        this.openBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "FILE_OPEN", this.langID, "Open..."));
        this.openBtn.setActionCommand(ACTION_OPEN);
        this.openBtn.addActionListener(this.eventController);
        this.toolBar.add(this.openBtn);
        this.toolBar.addSeparator();
        this.exerciseModeBtn = new JToggleButton(Resources.getInstance().EXERCISE_MODE_ICON);
        this.exerciseModeBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_EXERCISE_MODE", this.langID, "Exercise Mode"));
        this.exerciseModeBtn.setActionCommand(ACTION_CHANGERTEMODE);
        this.exerciseModeBtn.addActionListener(this.eventController);
        this.toolBar.add(this.exerciseModeBtn);
        this.toolBar.addSeparator();
        Option optStart = new Option(Resources.getInstance().START_ICON, LanguageFile.getLabel(this.langFile, "RTE_START", this.langID, "Start/Resume"));
        optStart.setActionCommand(ACTION_OPT_START);
        optStart.addActionListener(this.eventController);
        Option optStart2Finish = new Option(Resources.getInstance().START_FINISH_ICON, LanguageFile.getLabel(this.langFile, "RTE_START_TO_FINISH", this.langID, "Start/Resume to Finish"));
        optStart2Finish.setActionCommand(ACTION_OPT_STARTTOFINISH);
        optStart2Finish.addActionListener(this.eventController);
        Option optPlayAndPause = new Option(Resources.getInstance().PLAY_PAUSE_ICON, LanguageFile.getLabel(this.langFile, "RTE_PLAY_AND_PAUSE", this.langID, "Play And Pause"));
        optPlayAndPause.setActionCommand(ACTION_OPT_PLAYANDPAUSE);
        optPlayAndPause.addActionListener(this.eventController);
        this.startBtn = new OptionComboButton(new Option[]{optStart, optStart2Finish, optPlayAndPause});
        this.toolBar.add(this.startBtn);
        this.pauseBtn = new JButton(Resources.getInstance().PAUSE_ICON);
        this.pauseBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_PAUSE", this.langID, "Pause"));
        this.pauseBtn.setActionCommand(ACTION_PAUSE);
        this.pauseBtn.addActionListener(this.eventController);
        this.toolBar.add(this.pauseBtn);
        this.stopBtn = new JButton(Resources.getInstance().STOP_ICON);
        this.stopBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_STOP", this.langID, "Stop"));
        this.stopBtn.setActionCommand(ACTION_STOP);
        this.stopBtn.addActionListener(this.eventController);
        this.toolBar.add(this.stopBtn);
        this.toolBar.addSeparator();
        this.prevStepBtn = new JButton(Resources.getInstance().PREVSTEP_ICON);
        this.prevStepBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_PREV_STEP", this.langID, "Previous Step"));
        this.prevStepBtn.setActionCommand(ACTION_PREVSTEP);
        this.prevStepBtn.addActionListener(this.eventController);
        this.toolBar.add(this.prevStepBtn);
        this.nextStepBtn = new JButton(Resources.getInstance().NEXTSTEP_ICON);
        this.nextStepBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_NEXT_STEP", this.langID, "Next Step"));
        this.nextStepBtn.setActionCommand(ACTION_NEXTSTEP);
        this.nextStepBtn.addActionListener(this.eventController);
        this.toolBar.add(this.nextStepBtn);
        this.toolBar.addSeparator();
        this.pauseBeforeStopBtn = new JToggleButton(Resources.getInstance().PAUSE_BEFORE_STOP_ICON);
        this.pauseBeforeStopBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_PAUSE_BEFORE_STOP", this.langID, "Pause Before Stop"));
        this.pauseBeforeStopBtn.setActionCommand(ACTION_PAUSEBEFORESTOP);
        this.pauseBeforeStopBtn.addActionListener(this.eventController);
        this.pauseBeforeStopBtn.setSelected(this.config.getToolBarOptPauseBeforeStopSelected());
        this.toolBar.add(this.pauseBeforeStopBtn);
        this.skipBreakpointsBtn = new JToggleButton(Resources.getInstance().SKIP_BREAKPOINTS_ICON);
        this.skipBreakpointsBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_SKIP_BREAKPOINTS", this.langID, "Skip All Breakpoints"));
        this.skipBreakpointsBtn.setActionCommand(ACTION_SKIPBREAKPOINTS);
        this.skipBreakpointsBtn.addActionListener(this.eventController);
        this.skipBreakpointsBtn.setSelected(this.config.getToolBarOptSkipBreakpointsSelected());
        this.toolBar.add(this.skipBreakpointsBtn);
        this.toolBar.addSeparator();
        this.slowerBtn = new JButton(Resources.getInstance().SLOWER_ICON);
        this.slowerBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_SLOWER", this.langID, "Slower"));
        this.slowerBtn.setActionCommand(ACTION_SLOWER);
        this.slowerBtn.addActionListener(this.eventController);
        this.toolBar.add(this.slowerBtn);
        this.execSpeedSlider = new JSlider(1, this.execSpeedFactors.size(), this.normalExecSpeedKey);
        this.execSpeedSlider.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_CHANGE", this.langID, "Change Execution Speed"));
        Dimension sliderDim = new Dimension(100, this.execSpeedSlider.getPreferredSize().height);
        this.execSpeedSlider.setPreferredSize(sliderDim);
        this.execSpeedSlider.setMaximumSize(sliderDim);
        this.execSpeedSlider.setMinimumSize(sliderDim);
        this.execSpeedSlider.addChangeListener(this.eventController);
        this.toolBar.add(this.execSpeedSlider);
        this.fasterBtn = new JButton(Resources.getInstance().FASTER_ICON);
        this.fasterBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_FASTER", this.langID, "Faster"));
        this.fasterBtn.setActionCommand(ACTION_FASTER);
        this.fasterBtn.addActionListener(this.eventController);
        this.toolBar.add(this.fasterBtn);
        this.execSpeedLbl = new JLabel();
        this.updateExecSpeed();
        this.toolBar.add(this.execSpeedLbl);
        this.resetExecSpeedBtn = new JButton(Resources.getInstance().RESET_EXECSPEED_ICON);
        this.resetExecSpeedBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_RESET", this.langID, "Reset Execution Speed"));
        this.resetExecSpeedBtn.setActionCommand(ACTION_RESETEXECSPEED);
        this.resetExecSpeedBtn.addActionListener(this.eventController);
        this.toolBar.add(this.resetExecSpeedBtn);
        this.toolBar.addSeparator();
        this.toolBar.add(Box.createHorizontalStrut(30));
        this.setJMenuBar(this.createMenuBar());
        this.updateRTECtrlButtonStates();
        this.updateNonRTECtrlButtonStates();
        this.addWindowListener(this.eventController);
        this.initialized = true;
    }

    @Override
    public void adaptDialog(JDialog dlg) {
        dlg.setLocationRelativeTo(this);
        dlg.setIconImage(this.getIconImage());
    }

    @Override
    public boolean checkPermission(PluginHost host) {
        return host == this;
    }

    @Override
    public AlgorithmExerciseProvider getDefaultExerciseProvider() {
        return this.exercisesList;
    }

    @Override
    public LanguageFile getLanguageFile() {
        return this.langFile;
    }

    @Override
    public String getLanguageID() {
        return this.langID;
    }

    @Override
    public boolean isActivePlugin(AlgorithmPlugin plugin) {
        return plugin == this.activePlugin;
    }

    @Override
    public void rteModeChanged() {
        if (this.isValidActiveRTE()) {
            this.exerciseModeBtn.setSelected(this.activePlugin.getRuntimeEnvironment().isExerciseModeEnabled());
            if (this.exerciseModeBtn.isSelected() && this.config.getShowExerciseModeInfoDialog()) {
                new ExerciseModeInfoDialog(this, this.config, this.activePlugin, true).setVisible(true);
            }
        } else {
            this.exerciseModeBtn.setSelected(false);
        }
        this.updateRTECtrlButtonStates();
    }

    @Override
    public void showMessage(AlgorithmPlugin plugin, String msg, String title, MessageIcon icon) {
        if (!this.isActivePlugin(plugin)) {
            return;
        }
        JOptionPane.showMessageDialog(this, msg, title, icon.toMessageType());
    }

    @Override
    public void writeLogMessage(AlgorithmPlugin plugin, String msg, LogType type) {
        this.writeLogMessage(plugin, msg, null, type);
    }

    @Override
    public void writeLogMessage(AlgorithmPlugin plugin, String msg, Exception e, LogType type) {
        this.loader.logMessage(plugin, msg, e, type);
        final String oldText = this.statusBar.getText(1);
        this.statusBar.setText(1, msg);
        if (type == LogType.ERROR) {
            this.statusBar.setForeground(1, Color.red);
        } else if (type == LogType.WARNING) {
            this.statusBar.setForeground(1, Color.yellow);
        }
        Timer t = new Timer(15000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.statusBar.setText(1, oldText);
                MainWindow.this.statusBar.setForeground(1, Color.black);
            }
        });
        t.start();
    }

    @Override
    public int getPluginCount() {
        return this.loader.getPluginManager().getInstalledPlugins().size();
    }

    @Override
    public String getPluginAssumptions(int index) throws IndexOutOfBoundsException {
        return this.loader.getPluginManager().getInstalledPlugins().get(index).getAssumptions();
    }

    @Override
    public String getPluginAuthor(int index) throws IndexOutOfBoundsException {
        return this.loader.getPluginManager().getInstalledPlugins().get(index).getAuthor();
    }

    @Override
    public String getPluginAuthorContact(int index) throws IndexOutOfBoundsException {
        return this.loader.getPluginManager().getInstalledPlugins().get(index).getAuthorContact();
    }

    @Override
    public String getPluginDescription(int index) throws IndexOutOfBoundsException {
        return this.loader.getPluginManager().getInstalledPlugins().get(index).getDescription();
    }

    @Override
    public String getPluginInstructions(int index) throws IndexOutOfBoundsException {
        return this.loader.getPluginManager().getInstalledPlugins().get(index).getInstructions();
    }

    @Override
    public String getPluginName(int index) throws IndexOutOfBoundsException {
        return this.loader.getPluginManager().getInstalledPlugins().get(index).getName();
    }

    @Override
    public String getPluginProblemAffiliation(int index) throws IndexOutOfBoundsException {
        return this.loader.getPluginManager().getInstalledPlugins().get(index).getProblemAffiliation();
    }

    @Override
    public String getPluginSubject(int index) throws IndexOutOfBoundsException {
        return this.loader.getPluginManager().getInstalledPlugins().get(index).getSubject();
    }

    @Override
    public AlgorithmText getPluginText(int index) throws IndexOutOfBoundsException {
        return this.loader.getPluginManager().getInstalledPlugins().get(index).getText();
    }

    @Override
    public String getPluginType(int index) throws IndexOutOfBoundsException {
        return this.loader.getPluginManager().getInstalledPlugins().get(index).getType();
    }

    @Override
    public String getPluginVersion(int index) throws IndexOutOfBoundsException {
        return this.loader.getPluginManager().getInstalledPlugins().get(index).getVersion();
    }

    public Loader getLoader() {
        return this.loader;
    }

    public List<AlgorithmPlugin> getLastOpenedAlgorithms() {
        return Collections.unmodifiableList(this.lastOpenedPlugins);
    }

    @Override
    protected void addImpl(Component component, Object constraints, int index) {
        if (!this.initialized) {
            super.addImpl(component, constraints, index);
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar bar = new JMenuBar();
        JMenu menuFile = new JMenu(LanguageFile.getLabel(this.langFile, "MENU_FILE", this.langID, "File"));
        bar.add(menuFile);
        final JMenuItem itemNew = new JMenuItem(LanguageFile.getLabel(this.langFile, "FILE_NEW", this.langID, "New..."));
        itemNew.setActionCommand(ACTION_NEW);
        itemNew.addActionListener(this.eventController);
        itemNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        itemNew.setIcon(Resources.getInstance().NEW_ICON);
        final JMenu subMenuOpenRecent = new JMenu(LanguageFile.getLabel(this.langFile, "MENU_FILE_OPENRECENT", this.langID, "Open Recent"));
        subMenuOpenRecent.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                int i = 0;
                while (i < MainWindow.this.lastOpenedPlugins.size()) {
                    JMenuItem subItem = new JMenuItem(((AlgorithmPlugin)MainWindow.this.lastOpenedPlugins.get(i)).getName());
                    subItem.setActionCommand(MainWindow.DYNACTION_OPENRECENT + i);
                    subItem.addActionListener(MainWindow.this.eventController);
                    subItem.setEnabled(MainWindow.this.newBtn.isEnabled());
                    subMenuOpenRecent.add(subItem);
                    ++i;
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                subMenuOpenRecent.removeAll();
            }

            @Override
            public void menuCanceled(MenuEvent e) {
                subMenuOpenRecent.removeAll();
            }
        });
        final JMenuItem itemOpen = new JMenuItem(LanguageFile.getLabel(this.langFile, "FILE_OPEN", this.langID, "Open..."));
        itemOpen.setActionCommand(ACTION_OPEN);
        itemOpen.addActionListener(this.eventController);
        itemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        itemOpen.setIcon(Resources.getInstance().OPEN_ICON);
        final JMenuItem itemSaveAs = new JMenuItem(LanguageFile.getLabel(this.langFile, "FILE_SAVE_AS", this.langID, "Save as..."));
        itemSaveAs.setActionCommand(ACTION_SAVEAS);
        itemSaveAs.addActionListener(this.eventController);
        itemSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        itemSaveAs.setIcon(Resources.getInstance().SAVE_ICON);
        JMenuItem itemExit = new JMenuItem(LanguageFile.getLabel(this.langFile, "MENU_FILE_EXIT", this.langID, "Exit"));
        itemExit.setActionCommand(ACTION_EXIT);
        itemExit.addActionListener(this.eventController);
        menuFile.add(itemNew);
        menuFile.add(subMenuOpenRecent);
        menuFile.addSeparator();
        menuFile.add(itemOpen);
        menuFile.add(itemSaveAs);
        menuFile.addSeparator();
        menuFile.add(itemExit);
        menuFile.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                itemNew.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_NEW));
                subMenuOpenRecent.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_NEW));
                itemOpen.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_OPEN));
                itemSaveAs.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_SAVEAS));
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenu menuAlgo = new JMenu(LanguageFile.getLabel(this.langFile, "MENU_ALGORITHM", this.langID, "Algorithm"));
        bar.add(menuAlgo);
        final JCheckBoxMenuItem cbiExerciseMode = new JCheckBoxMenuItem(LanguageFile.getLabel(this.langFile, "RTE_EXERCISE_MODE", this.langID, "Exercise Mode"));
        cbiExerciseMode.setActionCommand(ACTION_CHANGERTEMODE);
        cbiExerciseMode.addActionListener(this.eventController);
        cbiExerciseMode.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        cbiExerciseMode.setIcon(Resources.getInstance().EXERCISE_MODE_ICON);
        final JMenuItem itemStart = new JMenuItem(LanguageFile.getLabel(this.langFile, "RTE_START", this.langID, "Start/Resume"));
        itemStart.setActionCommand(ACTION_OPT_START);
        itemStart.addActionListener(this.eventController);
        itemStart.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        itemStart.setIcon(Resources.getInstance().START_ICON);
        final JMenuItem itemStart2Finish = new JMenuItem(LanguageFile.getLabel(this.langFile, "RTE_START_TO_FINISH", this.langID, "Start/Resume to Finish"));
        itemStart2Finish.setActionCommand(ACTION_OPT_STARTTOFINISH);
        itemStart2Finish.addActionListener(this.eventController);
        itemStart2Finish.setIcon(Resources.getInstance().START_FINISH_ICON);
        final JMenuItem itemPlayAndPause = new JMenuItem(LanguageFile.getLabel(this.langFile, "RTE_PLAY_AND_PAUSE", this.langID, "Play And Pause"));
        itemPlayAndPause.setActionCommand(ACTION_OPT_PLAYANDPAUSE);
        itemPlayAndPause.addActionListener(this.eventController);
        itemPlayAndPause.setIcon(Resources.getInstance().PLAY_PAUSE_ICON);
        final JMenuItem itemPause = new JMenuItem(LanguageFile.getLabel(this.langFile, "RTE_PAUSE", this.langID, "Pause"));
        itemPause.setActionCommand(ACTION_PAUSE);
        itemPause.addActionListener(this.eventController);
        itemPause.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        itemPause.setIcon(Resources.getInstance().PAUSE_ICON);
        final JMenuItem itemStop = new JMenuItem(LanguageFile.getLabel(this.langFile, "RTE_STOP", this.langID, "Stop"));
        itemStop.setActionCommand(ACTION_STOP);
        itemStop.addActionListener(this.eventController);
        itemStop.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        itemStop.setIcon(Resources.getInstance().STOP_ICON);
        final JMenuItem itemPrevStep = new JMenuItem(LanguageFile.getLabel(this.langFile, "RTE_PREV_STEP", this.langID, "Previous Step"));
        itemPrevStep.setActionCommand(ACTION_PREVSTEP);
        itemPrevStep.addActionListener(this.eventController);
        itemPrevStep.setAccelerator(KeyStroke.getKeyStroke(37, 8));
        itemPrevStep.setIcon(Resources.getInstance().PREVSTEP_ICON);
        final JMenuItem itemNextStep = new JMenuItem(LanguageFile.getLabel(this.langFile, "RTE_NEXT_STEP", this.langID, "Next Step"));
        itemNextStep.setActionCommand(ACTION_NEXTSTEP);
        itemNextStep.addActionListener(this.eventController);
        itemNextStep.setAccelerator(KeyStroke.getKeyStroke(39, 8));
        itemNextStep.setIcon(Resources.getInstance().NEXTSTEP_ICON);
        final JCheckBoxMenuItem cbiPauseBeforeStop = new JCheckBoxMenuItem(LanguageFile.getLabel(this.langFile, "RTE_PAUSE_BEFORE_STOP", this.langID, "Pause Before Stop"));
        cbiPauseBeforeStop.setActionCommand(ACTION_PAUSEBEFORESTOP);
        cbiPauseBeforeStop.addActionListener(this.eventController);
        cbiPauseBeforeStop.setIcon(Resources.getInstance().PAUSE_BEFORE_STOP_ICON);
        final JCheckBoxMenuItem cbiSkipBreakpoints = new JCheckBoxMenuItem(LanguageFile.getLabel(this.langFile, "RTE_SKIP_BREAKPOINTS", this.langID, "Skip All Breakpoints"));
        cbiSkipBreakpoints.setActionCommand(ACTION_SKIPBREAKPOINTS);
        cbiSkipBreakpoints.addActionListener(this.eventController);
        cbiSkipBreakpoints.setIcon(Resources.getInstance().SKIP_BREAKPOINTS_ICON);
        final JMenuItem itemSlower = new JMenuItem(LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_SLOWER", this.langID, "Slower"));
        itemSlower.setActionCommand(ACTION_SLOWER);
        itemSlower.addActionListener(this.eventController);
        itemSlower.setAccelerator(KeyStroke.getKeyStroke(76, 8));
        itemSlower.setIcon(Resources.getInstance().SLOWER_ICON);
        final JMenuItem itemFaster = new JMenuItem(LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_FASTER", this.langID, "Faster"));
        itemFaster.setActionCommand(ACTION_FASTER);
        itemFaster.addActionListener(this.eventController);
        itemFaster.setAccelerator(KeyStroke.getKeyStroke(70, 8));
        itemFaster.setIcon(Resources.getInstance().FASTER_ICON);
        String changeExecSpeedLabel = LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_CHANGE", this.langID, "Change Execution Speed");
        if (!changeExecSpeedLabel.endsWith("...")) {
            changeExecSpeedLabel = String.valueOf(changeExecSpeedLabel) + "...";
        }
        final JMenuItem itemChangeExecSpeed = new JMenuItem(changeExecSpeedLabel);
        itemChangeExecSpeed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] factors = new String[MainWindow.this.execSpeedFactors.size()];
                int i = 1;
                while (i <= factors.length) {
                    factors[i - 1] = MainWindow.this.getExecSpeedFactorAsText(((Float)MainWindow.this.execSpeedFactors.get(i)).floatValue());
                    ++i;
                }
                ChangeExecSpeedDialog dlg = new ChangeExecSpeedDialog(factors, MainWindow.this.execSpeedSlider.getValue(), MainWindow.this, MainWindow.this.langFile, MainWindow.this.langID);
                dlg.setVisible(true);
                if (!dlg.isCanceled()) {
                    MainWindow.this.execSpeedSlider.setValue(dlg.getChosenFactor());
                }
            }
        });
        menuAlgo.add(cbiExerciseMode);
        menuAlgo.addSeparator();
        menuAlgo.add(itemStart);
        menuAlgo.add(itemStart2Finish);
        menuAlgo.add(itemPlayAndPause);
        menuAlgo.addSeparator();
        menuAlgo.add(itemPause);
        menuAlgo.add(itemStop);
        menuAlgo.addSeparator();
        menuAlgo.add(itemPrevStep);
        menuAlgo.add(itemNextStep);
        menuAlgo.addSeparator();
        menuAlgo.add(cbiPauseBeforeStop);
        menuAlgo.add(cbiSkipBreakpoints);
        menuAlgo.addSeparator();
        menuAlgo.add(itemSlower);
        menuAlgo.add(itemFaster);
        menuAlgo.add(itemChangeExecSpeed);
        menuAlgo.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                AlgorithmRTE rte = MainWindow.this.isValidActiveRTE() ? MainWindow.this.activePlugin.getRuntimeEnvironment() : null;
                cbiExerciseMode.setSelected(rte != null ? rte.isExerciseModeEnabled() : false);
                cbiPauseBeforeStop.setSelected(rte != null ? rte.getPauseBeforeStop() : false);
                cbiSkipBreakpoints.setSelected(rte != null ? rte.getSkipBreakpoints() : false);
                cbiExerciseMode.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_CHANGERTEMODE));
                itemStart.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_OPT_START));
                itemStart2Finish.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_OPT_STARTTOFINISH));
                itemPlayAndPause.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_OPT_PLAYANDPAUSE));
                itemPause.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_PAUSE));
                itemStop.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_STOP));
                itemPrevStep.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_PREVSTEP));
                itemNextStep.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_NEXTSTEP));
                cbiPauseBeforeStop.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_PAUSEBEFORESTOP));
                cbiSkipBreakpoints.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_SKIPBREAKPOINTS));
                itemSlower.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_SLOWER));
                itemFaster.setEnabled(MainWindow.this.isActionEnabled(MainWindow.ACTION_FASTER));
                itemChangeExecSpeed.setEnabled(MainWindow.this.execSpeedSlider.isEnabled());
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        final JMenu menuView = new JMenu(LanguageFile.getLabel(this.langFile, "MENU_VIEW", this.langID, "View"));
        bar.add(menuView);
        menuView.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                if (MainWindow.this.activePlugin == null) {
                    return;
                }
                List<View> views = MainWindow.this.viewContainer.queryAllViews();
                int i = 0;
                while (i < views.size()) {
                    final View view = views.get(i);
                    if (view.isClosable()) {
                        JCheckBoxMenuItem cbiItem = new JCheckBoxMenuItem(view.getTitle());
                        cbiItem.setSelected(view.isVisible());
                        cbiItem.setIcon(ResourceManager.getInstance().ICON_VIEW);
                        cbiItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                view.setVisible(!view.isVisible());
                            }
                        });
                        menuView.add(cbiItem);
                    }
                    ++i;
                }
                if (views.size() > 0) {
                    menuView.addSeparator();
                }
                JCheckBoxMenuItem itemInfoBar = new JCheckBoxMenuItem(LanguageFile.getLabel(MainWindow.this.langFile, "MENU_VIEW_INFOBAR", MainWindow.this.langID, "Information Bar"));
                itemInfoBar.setSelected(MainWindow.this.infoBar.isVisible());
                itemInfoBar.setEnabled(MainWindow.this.infoBar.isActivatable());
                itemInfoBar.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MainWindow.this.infoBar.setVisible(!MainWindow.this.infoBar.isVisible());
                    }
                });
                menuView.add(itemInfoBar);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                menuView.removeAll();
            }

            @Override
            public void menuCanceled(MenuEvent e) {
                menuView.removeAll();
            }
        });
        JMenu menuTools = new JMenu(LanguageFile.getLabel(this.langFile, "MENU_TOOLS", this.langID, "Tools"));
        bar.add(menuTools);
        JMenuItem itemInstallNewPlugins = new JMenuItem(LanguageFile.getLabel(this.langFile, "MENU_TOOLS_INSTALLNEWPLUGINS", this.langID, "Install New Plugins..."));
        itemInstallNewPlugins.setActionCommand(ACTION_INSTALLNEWPLUGINS);
        itemInstallNewPlugins.addActionListener(this.eventController);
        itemInstallNewPlugins.setIcon(ResourceManager.getInstance().ICON_PLUGIN);
        menuTools.add(itemInstallNewPlugins);
        JMenuItem itemPlugins = new JMenuItem(LanguageFile.getLabel(this.langFile, "MENU_TOOLS_OPENPLUGINS", this.langID, "Open Plugins Page"));
        itemPlugins.setActionCommand(ACTION_OPENPLUGINSPAGE);
        itemPlugins.addActionListener(this.eventController);
        menuTools.add(itemPlugins);
        menuTools.addSeparator();
        JMenuItem itemPreferences = new JMenuItem(LanguageFile.getLabel(this.langFile, "MENU_TOOLS_PREFERENCES", this.langID, "Preferences"));
        itemPreferences.setActionCommand(ACTION_PREFERENCES);
        itemPreferences.addActionListener(this.eventController);
        itemPreferences.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        menuTools.add(itemPreferences);
        JMenu menuHelp = new JMenu(LanguageFile.getLabel(this.langFile, "MENU_HELP", this.langID, "Help"));
        bar.add(menuHelp);
        JMenuItem itemHelp = new JMenuItem(LanguageFile.getLabel(this.langFile, "MENU_HELP_HELP", this.langID, "LAVES Help"));
        itemHelp.setActionCommand(ACTION_HELP);
        itemHelp.addActionListener(this.eventController);
        itemHelp.setIcon(ResourceManager.getInstance().ICON_HELP);
        itemHelp.setAccelerator(KeyStroke.getKeyStroke(112, 2));
        menuHelp.add(itemHelp);
        JMenuItem itemHowTo = new JMenuItem(LanguageFile.getLabel(this.langFile, "MENU_HELP_HOWTO", this.langID, "HowTo"));
        itemHowTo.setActionCommand(ACTION_HOWTO);
        itemHowTo.addActionListener(this.eventController);
        menuHelp.add(itemHowTo);
        final JMenuItem itemInstructions = new JMenuItem(LanguageFile.getLabel(this.langFile, "MENU_HELP_INSTRUCTIONS", this.langID, "Instructions"));
        itemInstructions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(MainWindow.this, new JLabel("<html>" + MainWindow.this.activePlugin.getInstructions() + "</html>"), LanguageFile.getLabel(MainWindow.this.langFile, "MENU_HELP_INSTRUCTIONS", MainWindow.this.langID, "Instructions"), 1);
            }
        });
        menuHelp.add(itemInstructions);
        menuHelp.addSeparator();
        JMenuItem itemWebsite = new JMenuItem(LanguageFile.getLabel(this.langFile, "MENU_HELP_WEBSITE", this.langID, "LAVES Website"));
        itemWebsite.setActionCommand(ACTION_OPENWEBSITE);
        itemWebsite.addActionListener(this.eventController);
        itemWebsite.setIcon(ResourceManager.getInstance().ICON_INTERNET);
        menuHelp.add(itemWebsite);
        menuHelp.addSeparator();
        JMenuItem itemAbout = new JMenuItem(LanguageFile.getLabel(this.langFile, "MENU_HELP_ABOUT", this.langID, "About"));
        itemAbout.setActionCommand(ACTION_ABOUT);
        itemAbout.addActionListener(this.eventController);
        itemAbout.setIcon(ResourceManager.getInstance().ICON_INFO);
        menuHelp.add(itemAbout);
        menuHelp.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                itemInstructions.setEnabled(MainWindow.this.activePlugin != null && MainWindow.this.activePlugin.getInstructions() != null && !MainWindow.this.activePlugin.getInstructions().isEmpty());
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return bar;
    }

    private boolean isActionEnabled(String action) {
        switch (action) {
            case "onNew": {
                return this.newBtn.isEnabled();
            }
            case "onOpen": {
                return this.openBtn.isEnabled();
            }
            case "onSaveAs": {
                return this.saveAsBtn.isEnabled();
            }
            case "onChangeRTEMode": {
                return this.exerciseModeBtn.isEnabled();
            }
            case "onStart": 
            case "onStartToFinish": 
            case "onPlayAndPause": {
                return this.startBtn.isEnabled();
            }
            case "onPause": {
                return this.pauseBtn.isEnabled();
            }
            case "onStop": {
                return this.stopBtn.isEnabled();
            }
            case "onPrevStep": {
                return this.prevStepBtn.isEnabled();
            }
            case "onNextStep": {
                return this.nextStepBtn.isEnabled();
            }
            case "onPauseBeforeStop": {
                return this.pauseBeforeStopBtn.isEnabled();
            }
            case "onSkipBreakpoints": {
                return this.skipBreakpointsBtn.isEnabled();
            }
            case "onSlower": {
                return this.slowerBtn.isEnabled();
            }
            case "onFaster": {
                return this.fasterBtn.isEnabled();
            }
        }
        return true;
    }

    private void saveConfigurationData() {
        boolean isMaximized;
        boolean bl = isMaximized = (this.getExtendedState() & 6) != 0;
        if (!isMaximized) {
            this.config.setWindowWidth(this.getWidth());
            this.config.setWindowHeight(this.getHeight());
            this.config.setWindowPosX(this.getX());
            this.config.setWindowPosY(this.getY());
        }
        this.config.setWindowMaximized(isMaximized);
        this.config.setLastOpenedAlgorithms(this.lastOpenedPlugins, this.loader.getPluginManager());
        this.config.setToolBarOptPauseBeforeStopSelected(this.pauseBeforeStopBtn.isSelected());
        this.config.setToolBarOptSkipBreakpointsSelected(this.skipBreakpointsBtn.isSelected());
        try {
            Configuration.save(Constants.FILE_MAIN_CONFIG, this.config.getConfiguration());
        }
        catch (IOException | IllegalArgumentException e) {
            this.loader.logMessage("Main configuration could not be saved!", LogType.ERROR);
        }
        for (PluginBundle bundle : this.loader.getPluginManager().getPluginBundles()) {
            try {
                Configuration cfg = bundle.getPlugin().getConfiguration();
                if (cfg == null) continue;
                Configuration.save(String.valueOf(Constants.PATH_PLUGINS_CONFIG) + bundle.getSimpleName() + ".cfg", cfg);
            }
            catch (IOException | IllegalArgumentException e) {
                this.loader.logMessage(bundle.getPlugin(), "Configuration of plugin " + bundle.getName() + " could not be saved!", e, LogType.ERROR);
            }
        }
    }

    private void activatePlugin(AlgorithmPlugin plugin, PropertiesListModel creatorProperties) {
        if (plugin == null) {
            return;
        }
        this.closeActivePlugin();
        this.activePlugin = plugin;
        AlgorithmRTE rte = this.activePlugin.getRuntimeEnvironment();
        if (rte != null) {
            rte.addListener(this.eventController);
            rte.setPauseBeforeTerminate(this.pauseBeforeStopBtn.isSelected());
            rte.setSkipBreakpoints(this.skipBreakpointsBtn.isSelected());
        }
        this.menuFunctions = new JMenu(LanguageFile.getLabel(this.langFile, "MENU_FUNCTIONS", this.langID, "Functions"));
        this.menuFunctions.setEnabled(false);
        this.getJMenuBar().add((Component)this.menuFunctions, 2);
        if (this.activePlugin.getToolBarExtensions() != null) {
            int i = 0;
            while (i < this.activePlugin.getToolBarExtensions().length) {
                ToolBarExtension ext = this.activePlugin.getToolBarExtensions()[i];
                if (ext != null) {
                    ext.apply(this.toolBar);
                    if (ext.getShowInMenu()) {
                        JMenuItem itemFunc = new JMenuItem(ext.getMenuOptionText());
                        itemFunc.setActionCommand(DYNACTION_SHOWFUNC + i);
                        itemFunc.addActionListener(this.eventController);
                        itemFunc.setIcon(ext.getMenuOptionIcon());
                        this.menuFunctions.add(itemFunc);
                        this.menuFunctions.setEnabled(true);
                    }
                }
                ++i;
            }
            this.toolBar.repaint();
        }
        if (this.lastOpenedPlugins.contains(this.activePlugin)) {
            this.lastOpenedPlugins.remove(this.activePlugin);
        } else if (this.lastOpenedPlugins.size() == this.lastOpenedPluginsCount) {
            this.lastOpenedPlugins.remove(this.lastOpenedPluginsCount - 1);
        }
        this.lastOpenedPlugins.add(0, this.activePlugin);
        this.exercisesList.reset();
        this.exercisesList.setVisible(rte != null && rte.isExerciseModeEnabled());
        this.rteModeChanged();
        this.activePlugin.onCreate(this.viewContainer, creatorProperties);
        this.viewContainer.revalidate();
        this.infoBar.update(this.activePlugin);
        if (this.config.getDisableInformationBarPermanently()) {
            this.infoBar.setVisible(false);
        }
        this.statusBar.setText(2, this.activePlugin.getDescription());
        this.statusBar.setText(3, this.activePlugin.getName());
        this.statusBar.setText(4, this.activePlugin.getProblemAffiliation());
        this.updateRTECtrlButtonStates();
        this.updateNonRTECtrlButtonStates();
    }

    private void closeActivePlugin() {
        if (this.activePlugin != null) {
            this.activePlugin.onClose();
            if (this.activePlugin.getRuntimeEnvironment() != null) {
                this.activePlugin.getRuntimeEnvironment().stop();
                this.activePlugin.getRuntimeEnvironment().removeListener(this.eventController);
            }
            if (this.activePlugin.getToolBarExtensions() != null) {
                ToolBarExtension[] toolBarExtensionArray = this.activePlugin.getToolBarExtensions();
                int n = toolBarExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolBarExtension ext = toolBarExtensionArray[n2];
                    if (ext != null) {
                        ext.remove(this.toolBar);
                    }
                    ++n2;
                }
                this.toolBar.repaint();
            }
        }
        if (this.menuFunctions != null) {
            this.getJMenuBar().remove(this.menuFunctions);
            this.menuFunctions = null;
        }
        this.activePlugin = null;
        this.statusBar.setText(2, "");
        this.statusBar.setText(3, "");
        this.statusBar.setText(4, "");
        this.viewContainer.removeAll();
        this.viewContainer.setLayout(null);
        this.viewContainer.revalidate();
        this.viewContainer.repaint();
        this.updateRTECtrlButtonStates();
    }

    private void loadWelcomeScreen() {
        if (!this.config.getShowWelcomeScreen()) {
            return;
        }
        WelcomeScreen ws = new WelcomeScreen(this, this.config);
        ws.setWelcomeScreenListener(new WelcomeScreenListener(){

            @Override
            public void activatePlugin(AlgorithmPlugin plugin) {
                MainWindow.this.activatePlugin(plugin, null);
            }
        });
        this.viewContainer.setLayout(new BorderLayout());
        this.viewContainer.add((Component)ws, "Center");
        this.viewContainer.revalidate();
    }

    private void validatePlugins() {
        List<AlgorithmPlugin> installedPlugins = this.loader.getPluginManager().getInstalledPlugins();
        if (this.activePlugin != null && !installedPlugins.contains(this.activePlugin)) {
            this.closeActivePlugin();
        }
        int i = this.lastOpenedPlugins.size() - 1;
        while (i >= 0) {
            if (!installedPlugins.contains(this.lastOpenedPlugins.get(i))) {
                this.lastOpenedPlugins.remove(i);
            }
            --i;
        }
    }

    private void onOpenApplication() {
        this.lastOpenedPlugins = this.config.getLastOpenedAlgorithms(this.loader.getPluginManager());
        this.loadWelcomeScreen();
        this.loader.getPluginManager().addListener(new PluginManagerListener(){

            @Override
            public void onInstalledPluginsChanged(boolean increase) {
                if (!increase) {
                    MainWindow.this.validatePlugins();
                }
            }
        });
        if (this.loader.hasErrors()) {
            this.writeLogMessage(null, LanguageFile.getLabel(this.langFile, "MSG_OPENEDWITHERRORS", this.langID, "Opened with errors (see log/log.txt for further information)!"), LogType.ERROR);
        }
    }

    private void onTerminateApplication() {
        this.onStop();
        this.closeActivePlugin();
        this.saveConfigurationData();
    }

    private void onNew() {
        NewDialog dlg = new NewDialog(this, this.config);
        dlg.setVisible(true);
        if (dlg.getSelectedPlugin() != null) {
            this.activatePlugin(dlg.getSelectedPlugin(), dlg.getCreatorPreferences());
        }
    }

    private void onSaveAs() {
        if (this.activePlugin == null || this.activePlugin.getSaveFileFilters() == null) {
            return;
        }
        this.resetFileChooser();
        FileNameExtensionFilter[] fileNameExtensionFilterArray = this.activePlugin.getSaveFileFilters();
        int n = fileNameExtensionFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileNameExtensionFilter fnef = fileNameExtensionFilterArray[n2];
            if (fnef != null) {
                this.fileChooser.addChoosableFileFilter(fnef);
            }
            ++n2;
        }
        int result = this.fileChooser.showSaveDialog(this);
        if (result == 0) {
            FileNameExtensionFilter fnef = (FileNameExtensionFilter)this.fileChooser.getFileFilter();
            File file = FileUtils.validateFile(this.fileChooser.getSelectedFile(), fnef.getExtensions()[0]);
            String msg = LanguageFile.getLabel(this.langFile, "MSG_WARN_SAVEEXISTINGFILE", this.langID, "The file \"&name&\" already exists.\nDo you want to overwrite it?");
            msg = msg.replace("&name&", file.getAbsolutePath());
            if (file.exists() && JOptionPane.showConfirmDialog(this, msg, LanguageFile.getLabel(this.langFile, "MSG_WARN_TITLE_SAVEEXISTINGFILE", this.langID, "Save as"), 0, 2) == 1) {
                return;
            }
            this.activePlugin.save(FileUtils.validateFile(this.fileChooser.getSelectedFile(), fnef.getExtensions()[0]));
        }
    }

    private void onOpen() {
        if (this.activePlugin == null || this.activePlugin.getOpenFileFilters() == null) {
            return;
        }
        this.resetFileChooser();
        FileNameExtensionFilter[] fileNameExtensionFilterArray = this.activePlugin.getOpenFileFilters();
        int n = fileNameExtensionFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileNameExtensionFilter fnef = fileNameExtensionFilterArray[n2];
            if (fnef != null) {
                this.fileChooser.addChoosableFileFilter(fnef);
            }
            ++n2;
        }
        int result = this.fileChooser.showOpenDialog(this);
        if (result == 0) {
            FileNameExtensionFilter fnef = (FileNameExtensionFilter)this.fileChooser.getFileFilter();
            this.activePlugin.open(FileUtils.validateFile(this.fileChooser.getSelectedFile(), fnef.getExtensions()[0]));
        }
    }

    private void onChangeMode() {
        if (this.isValidActiveRTE()) {
            if (this.activePlugin.getRuntimeEnvironment().isStarted()) {
                this.exerciseModeBtn.setSelected(this.activePlugin.getRuntimeEnvironment().isExerciseModeEnabled());
                JOptionPane.showMessageDialog(this, LanguageFile.getLabel(this.langFile, "MSG_INFO_EXERCISEMODE", this.langID, "The exercise mode can only be activated/deactivated when the algorithm is stopped!"), LanguageFile.getLabel(this.langFile, "MSG_INFO_TITLE_EXERCISEMODE", this.langID, "Exercise Mode"), 1);
                return;
            }
            this.activePlugin.getRuntimeEnvironment().setExerciseModeEnabled(!this.activePlugin.getRuntimeEnvironment().isExerciseModeEnabled());
        }
    }

    private void onStart(AlgorithmStartOption option) {
        if (this.isValidActiveRTE()) {
            this.activePlugin.getRuntimeEnvironment().start(option);
        }
    }

    private void onPause() {
        if (this.isValidActiveRTE()) {
            this.activePlugin.getRuntimeEnvironment().pause();
        }
    }

    private void onStop() {
        if (this.isValidActiveRTE()) {
            this.activePlugin.getRuntimeEnvironment().stop();
        }
    }

    private void onPreviousStep() {
        if (this.isValidActiveRTE()) {
            this.activePlugin.getRuntimeEnvironment().prevStep();
        }
    }

    private void onNextStep() {
        if (this.isValidActiveRTE()) {
            this.activePlugin.getRuntimeEnvironment().nextStep();
        }
    }

    private void onPauseBeforeStop() {
        AlgorithmRTE rte;
        AlgorithmRTE algorithmRTE = rte = this.isValidActiveRTE() ? this.activePlugin.getRuntimeEnvironment() : null;
        if (rte != null) {
            rte.setPauseBeforeTerminate(!rte.getPauseBeforeStop());
            this.pauseBeforeStopBtn.setSelected(rte.getPauseBeforeStop());
        } else {
            this.pauseBeforeStopBtn.setSelected(false);
        }
    }

    private void onSkipBreakpoints() {
        AlgorithmRTE rte;
        AlgorithmRTE algorithmRTE = rte = this.isValidActiveRTE() ? this.activePlugin.getRuntimeEnvironment() : null;
        if (rte != null) {
            rte.setSkipBreakpoints(!rte.getSkipBreakpoints());
            this.skipBreakpointsBtn.setSelected(rte.getSkipBreakpoints());
        } else {
            this.skipBreakpointsBtn.setSelected(false);
        }
    }

    private void onInstallNewPlugins() {
        PluginManagerDialog plugManDlg = new PluginManagerDialog(this, this.config);
        plugManDlg.setVisible(true);
    }

    private void onOpenPluginsPage() {
        if (!Utils.openWebsite("http://www.wiwi.uni-siegen.de/mis/software/laves.html#plugins")) {
            JOptionPane.showMessageDialog(this, LanguageFile.getLabel(this.langFile, "MSG_ERR_OPENWEBSITE", this.langID, "The website could not be opened!\nEnsure that you have installed a default browser."), LanguageFile.getLabel(this.langFile, "MSG_ERR_TITLE_OPENWEBSITE", this.langID, "Open Website"), 0);
        }
    }

    private void onPreferences() {
        PreferencesDialog prefDlg = new PreferencesDialog(this, this.config);
        prefDlg.setVisible(true);
    }

    private void onHelp() {
        String helpFile = String.valueOf(Constants.PATH_HELP) + this.langID + FileUtils.FILESEPARATOR + "user_guide.pdf";
        int res = Utils.openFile(helpFile);
        switch (res) {
            case -1: {
                JOptionPane.showMessageDialog(this, LanguageFile.getLabel(this.langFile, "MSG_INFO_CANNOTOPENHELPFILE", this.langID, "The user guide cannot be opened!\nEnsure that you have installed a suitable PDF-Reader."), LanguageFile.getLabel(this.langFile, "MSG_INFO_TITLE_CANNOTOPENHELPFILE", this.langID, "User guide"), 1);
                break;
            }
            case 0: {
                JOptionPane.showMessageDialog(this, LanguageFile.getLabel(this.langFile, "MSG_INFO_NOHELPFILE", this.langID, "Their is no user guide available for the selected language!"), LanguageFile.getLabel(this.langFile, "MSG_INFO_TITLE_NOHELPFILE", this.langID, "No user guide available"), 1);
            }
        }
    }

    private void onHowTo() {
        HowToDialog howToDlg = new HowToDialog(this);
        howToDlg.setVisible(true);
    }

    private void onOpenWebsite() {
        if (!Utils.openWebsite("http://www.wiwi.uni-siegen.de/mis/software/laves.html")) {
            JOptionPane.showMessageDialog(this, LanguageFile.getLabel(this.langFile, "MSG_ERR_OPENWEBSITE", this.langID, "The website could not be opened!\nEnsure that you have installed a default browser."), LanguageFile.getLabel(this.langFile, "MSG_ERR_TITLE_OPENWEBSITE", this.langID, "Open Website"), 0);
        }
    }

    private void onAbout() {
        AboutDialog aboutDlg = new AboutDialog(this);
        aboutDlg.setVisible(true);
    }

    private void resetFileChooser() {
        FileFilter[] filters;
        FileFilter[] fileFilterArray = filters = this.fileChooser.getChoosableFileFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            FileFilter f = fileFilterArray[n2];
            this.fileChooser.removeChoosableFileFilter(f);
            ++n2;
        }
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setAcceptAllFileFilterUsed(false);
    }

    private boolean isValidActiveRTE() {
        return this.activePlugin != null && this.activePlugin.getRuntimeEnvironment() != null;
    }

    private void updateRTECtrlButtonStates() {
        AlgorithmRTE rte = this.activePlugin != null ? this.activePlugin.getRuntimeEnvironment() : null;
        boolean rteState = rte != null;
        this.exerciseModeBtn.setEnabled(rteState && this.activePlugin.hasExerciseMode());
        this.startBtn.setEnabled(rteState && !rte.isRunning());
        this.pauseBtn.setEnabled(rteState && rte.isRunning() && !rte.isExerciseModeEnabled());
        this.stopBtn.setEnabled(rteState && rte.isStarted());
        this.nextStepBtn.setEnabled(rteState && rte.isStarted() && !rte.isExerciseModeEnabled());
        this.prevStepBtn.setEnabled(rteState && rte.isStarted() && !rte.isExerciseModeEnabled());
        this.pauseBeforeStopBtn.setEnabled(rteState);
        this.skipBreakpointsBtn.setEnabled(rteState);
        this.slowerBtn.setEnabled(rteState);
        this.execSpeedSlider.setEnabled(rteState);
        this.fasterBtn.setEnabled(rteState);
        this.resetExecSpeedBtn.setEnabled(rteState);
    }

    private void updateNonRTECtrlButtonStates() {
        boolean validActivePlugin = this.activePlugin != null;
        boolean rteIsStarted = validActivePlugin && this.activePlugin.getRuntimeEnvironment() != null ? this.activePlugin.getRuntimeEnvironment().isStarted() : false;
        this.newBtn.setEnabled(!rteIsStarted);
        this.saveAsBtn.setEnabled(!rteIsStarted && validActivePlugin && this.activePlugin.getSaveFileFilters() != null);
        this.openBtn.setEnabled(!rteIsStarted && validActivePlugin && this.activePlugin.getOpenFileFilters() != null);
        if (this.activePlugin != null && this.activePlugin.getToolBarExtensions() != null) {
            ToolBarExtension[] toolBarExtensionArray = this.activePlugin.getToolBarExtensions();
            int n = toolBarExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolBarExtension tbe = toolBarExtensionArray[n2];
                if (tbe != null) {
                    tbe.setEnabled(!rteIsStarted);
                }
                ++n2;
            }
        }
    }

    private void updateExecSpeed() {
        float execSpeedFactor = this.execSpeedFactors.get(this.execSpeedSlider.getValue()).floatValue();
        if (this.isValidActiveRTE()) {
            this.activePlugin.getRuntimeEnvironment().setExecSpeedFactor(execSpeedFactor);
        }
        String execSpeedDesc = LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_NORMAL", this.langID, "Normal");
        if (execSpeedFactor < 1.0f) {
            execSpeedDesc = MathUtils.formatFloat(1.0f / execSpeedFactor) + "x " + LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_SLOWER", this.langID, "Slower");
        } else if (execSpeedFactor > 1.0f) {
            execSpeedDesc = MathUtils.formatFloat(execSpeedFactor) + "x " + LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_FASTER", this.langID, "Faster");
        }
        this.execSpeedLbl.setText(this.getExecSpeedFactorAsText(execSpeedFactor));
        this.execSpeedLbl.setToolTipText(String.valueOf(LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED", this.langID, "Execution Speed")) + ": " + execSpeedDesc);
        this.execSpeedLbl.repaint();
    }

    private int createExecSpeedFactors() {
        this.execSpeedFactors.put(1, Float.valueOf(0.1f));
        this.execSpeedFactors.put(2, Float.valueOf(0.125f));
        this.execSpeedFactors.put(3, Float.valueOf(0.25f));
        this.execSpeedFactors.put(4, Float.valueOf(0.5f));
        this.execSpeedFactors.put(5, Float.valueOf(0.75f));
        int normalFactorKey = 6;
        this.execSpeedFactors.put(6, Float.valueOf(1.0f));
        this.execSpeedFactors.put(7, Float.valueOf(2.0f));
        this.execSpeedFactors.put(8, Float.valueOf(4.0f));
        this.execSpeedFactors.put(9, Float.valueOf(8.0f));
        this.execSpeedFactors.put(10, Float.valueOf(16.0f));
        return normalFactorKey;
    }

    private String getExecSpeedFactorAsText(float factor) {
        int intFactor = (int)factor;
        String result = (float)intFactor == factor ? "" + intFactor : "" + factor;
        return String.valueOf(result) + "x";
    }

    private String getDynamicActionParameter(String dynAction) {
        int paramSep = dynAction.lastIndexOf(DYNACTION_PARAMSEP);
        if (paramSep >= 0) {
            return dynAction.substring(paramSep + 1, dynAction.length());
        }
        return "";
    }

    private class EventController
    implements WindowListener,
    ActionListener,
    ChangeListener,
    RTEListener {
        private boolean closed = false;
        private boolean opened = false;

        private EventController() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.windowClosing(e);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (this.closed) {
                return;
            }
            MainWindow.this.onTerminateApplication();
            this.closed = true;
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            if (this.opened) {
                return;
            }
            MainWindow.this.onOpenApplication();
            this.opened = true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            if (action.startsWith(MainWindow.DYNACTION)) {
                String paramVal = MainWindow.this.getDynamicActionParameter(action);
                if (action.startsWith(MainWindow.DYNACTION_OPENRECENT)) {
                    try {
                        Integer index = new Integer(paramVal);
                        MainWindow.this.activatePlugin((AlgorithmPlugin)MainWindow.this.lastOpenedPlugins.get(index), null);
                    }
                    catch (NumberFormatException index) {}
                } else if (action.startsWith(MainWindow.DYNACTION_SHOWFUNC)) {
                    try {
                        Integer index = new Integer(paramVal);
                        MainWindow.this.activePlugin.getToolBarExtensions()[index].showMenuOption();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return;
            }
            if (!MainWindow.this.isActionEnabled(action)) {
                return;
            }
            switch (action) {
                case "onNew": {
                    MainWindow.this.onNew();
                    break;
                }
                case "onSaveAs": {
                    MainWindow.this.onSaveAs();
                    break;
                }
                case "onOpen": {
                    MainWindow.this.onOpen();
                    break;
                }
                case "onChangeRTEMode": {
                    MainWindow.this.onChangeMode();
                    break;
                }
                case "onStart": {
                    MainWindow.this.onStart(AlgorithmStartOption.NORMAL);
                    break;
                }
                case "onStartToFinish": {
                    MainWindow.this.onStart(AlgorithmStartOption.START_TO_FINISH);
                    break;
                }
                case "onPlayAndPause": {
                    MainWindow.this.onStart(AlgorithmStartOption.PLAY_AND_PAUSE);
                    break;
                }
                case "onPause": {
                    MainWindow.this.onPause();
                    break;
                }
                case "onStop": {
                    MainWindow.this.onStop();
                    break;
                }
                case "onPrevStep": {
                    MainWindow.this.onPreviousStep();
                    break;
                }
                case "onNextStep": {
                    MainWindow.this.onNextStep();
                    break;
                }
                case "onPauseBeforeStop": {
                    MainWindow.this.onPauseBeforeStop();
                    break;
                }
                case "onSkipBreakpoints": {
                    MainWindow.this.onSkipBreakpoints();
                    break;
                }
                case "onSlower": {
                    MainWindow.this.execSpeedSlider.setValue(MainWindow.this.execSpeedSlider.getValue() - 1);
                    break;
                }
                case "onFaster": {
                    MainWindow.this.execSpeedSlider.setValue(MainWindow.this.execSpeedSlider.getValue() + 1);
                    break;
                }
                case "onResetExecSpeed": {
                    MainWindow.this.execSpeedSlider.setValue(MainWindow.this.normalExecSpeedKey);
                    break;
                }
                case "onExit": {
                    MainWindow.this.dispose();
                    break;
                }
                case "onInstallNewPlugins": {
                    MainWindow.this.onInstallNewPlugins();
                    break;
                }
                case "onOpenPlugins": {
                    MainWindow.this.onOpenPluginsPage();
                    break;
                }
                case "onPreferences": {
                    MainWindow.this.onPreferences();
                    break;
                }
                case "onHelp": {
                    MainWindow.this.onHelp();
                    break;
                }
                case "onHowTo": {
                    MainWindow.this.onHowTo();
                    break;
                }
                case "onOpenWebsite": {
                    MainWindow.this.onOpenWebsite();
                    break;
                }
                case "onAbout": {
                    MainWindow.this.onAbout();
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            MainWindow.this.updateExecSpeed();
        }

        @Override
        public void beforeStart(RTEvent e) {
        }

        @Override
        public void beforeResume(RTEvent e) {
        }

        @Override
        public void beforePause(RTEvent e) {
        }

        @Override
        public void onStop() {
            MainWindow.this.updateRTECtrlButtonStates();
            MainWindow.this.updateNonRTECtrlButtonStates();
        }

        @Override
        public void onRunning() {
            MainWindow.this.updateRTECtrlButtonStates();
            MainWindow.this.updateNonRTECtrlButtonStates();
        }

        @Override
        public void onPause() {
            MainWindow.this.updateRTECtrlButtonStates();
        }
    }
}

