/*
 * Decompiled with CFR 0.152.
 */
package laves.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import laves.Loader;
import laves.gui.MainWindow;
import laves.resources.ResourceManager;
import laves.utils.ProgressListener;
import lavesdk.logging.enums.LogType;

public class LoadingScreen
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final Loader loader;
    private MainWindow mainWin;
    private final JLabel lblInfo;
    private final JProgressBar progressBar;

    public LoadingScreen(Loader loader) throws IllegalArgumentException {
        if (loader == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.loader = loader;
        this.mainWin = null;
        this.setSize(400, 250);
        this.setLocationRelativeTo(null);
        this.setUndecorated(true);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        Container pane = this.getContentPane();
        JPanel content = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        pane.setLayout(new BorderLayout());
        content.setBackground(Color.white);
        content.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.lblInfo = new JLabel("Loading...");
        this.progressBar = new JProgressBar();
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        content.add((Component)new JLabel(ResourceManager.getInstance().LOGO), gbc);
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        content.add((Component)this.lblInfo, gbc);
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        content.add((Component)this.progressBar, gbc);
        pane.add((Component)content, "Center");
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                LoadingScreen.this.load();
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    public MainWindow doLoad() {
        this.setVisible(true);
        return this.mainWin;
    }

    private void load() {
        SwingWorker<MainWindow, String> loadingTask = new SwingWorker<MainWindow, String>(){
            private int lastCurrent = 0;
            private static final String TOTAL = "TOTAL#";
            private static final String CURRENT = "CURR#";

            @Override
            protected MainWindow doInBackground() throws Exception {
                try {
                    LoadingScreen.this.loader.loadData(new ProgressListener(){

                        @Override
                        public void totalProgress(int total) {
                            this.publish(new String[]{2.TOTAL + (total + 2)});
                        }

                        @Override
                        public void currentProgress(int current, String desc) {
                            lastCurrent = current;
                            this.publish(new String[]{2.CURRENT + current, desc});
                        }
                    });
                    this.publish("Loading GUI ...");
                    LoadingScreen.this.mainWin = new MainWindow(LoadingScreen.this.loader);
                    ++this.lastCurrent;
                    this.publish(CURRENT + this.lastCurrent);
                    this.publish("Initializing plugins (wait a minute please) ...");
                    LoadingScreen.this.loader.initializePlugins(LoadingScreen.this.mainWin);
                    ++this.lastCurrent;
                    this.publish(CURRENT + this.lastCurrent);
                }
                catch (Exception e) {
                    LoadingScreen.this.loader.logMessage(null, "Loading the application has failed!", e, LogType.ERROR);
                }
                return LoadingScreen.this.mainWin;
            }

            @Override
            protected void done() {
                LoadingScreen.this.dispose();
            }

            @Override
            protected void process(List<String> chunks) {
                for (String chunk : chunks) {
                    if (chunk.startsWith(TOTAL)) {
                        LoadingScreen.this.progressBar.setMaximum(new Integer(chunk.substring(TOTAL.length(), chunk.length())));
                        continue;
                    }
                    if (chunk.startsWith(CURRENT)) {
                        LoadingScreen.this.progressBar.setValue(new Integer(chunk.substring(CURRENT.length(), chunk.length())));
                        continue;
                    }
                    LoadingScreen.this.lblInfo.setText(chunk);
                }
            }
        };
        loadingTask.execute();
    }
}

