/*
 * Decompiled with CFR 0.152.
 */
package laves.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import laves.gui.MainWindow;
import laves.utils.Utils;
import lavesdk.language.LanguageFile;

public class HowToDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();

    public HowToDialog(MainWindow mw) throws IllegalArgumentException {
        if (mw == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        URL howToURL = Utils.getHowToURL(mw.getLanguageID());
        this.setTitle(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_HOWTO_TITLE", mw.getLanguageID(), "HowTo"));
        this.setSize(600, 600);
        this.setDefaultCloseOperation(2);
        mw.adaptDialog(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        try {
            JEditorPane editorPane = howToURL != null ? new JEditorPane(howToURL) : new JEditorPane("No HowTo file available!");
            editorPane.setContentType("text/html");
            editorPane.setEditable(false);
            this.contentPanel.add((Component)new JScrollPane(editorPane), "Center");
        }
        catch (IOException e) {
            this.contentPanel.add((Component)new JLabel("<html>HowTo file could not be loaded!<br>" + e.getMessage() + "</html>"), "Center");
        }
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton quitButton = new JButton(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_BTN_QUIT", mw.getLanguageID(), "Quit"));
        quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HowToDialog.this.dispose();
            }
        });
        buttonPane.add(quitButton);
        this.getRootPane().setDefaultButton(quitButton);
    }
}

