/*
 * Decompiled with CFR 0.152.
 */
package laves.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import laves.configuration.MainConfiguration;
import laves.gui.MainWindow;
import laves.resources.ResourceManager;
import laves.utils.Utils;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.language.LanguageFile;

public class ExerciseModeInfoDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private final JCheckBox cbDoNotShowAgain;

    public ExerciseModeInfoDialog(final MainWindow mw, final MainConfiguration cfg, final AlgorithmPlugin activePlugin, boolean modal) throws IllegalArgumentException {
        if (mw == null || cfg == null || activePlugin == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.setTitle(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_EXERCISEMODEINFO_TITLE", mw.getLanguageID(), "Information about the Exercise Mode"));
        this.setType(Window.Type.UTILITY);
        this.setModal(modal);
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 20));
        JPanel textPanel = new JPanel(new BorderLayout(10, 5));
        JLabel lblInfoText = new JLabel("<html>" + LanguageFile.getLabel(mw.getLanguageFile(), "DLG_EXERCISEMODEINFO_TEXT", mw.getLanguageID(), "The exercise mode let you practice the algorithm in an interactive way.<br>Start the algorithm and answer the exercises, you will be asked during the execution. You have an arbitrary<br>number of attempts to solve an exercise. If you are not able to process an exercise, you can cancel the task<br>and view the sample solution in the visualization.<br><br>If an exercise can be solved directly in a view of the algorithm the corresponding view is highlighted with a border.<br>Enter your solution and afterwards press the \"solve\"-button of the exercise.") + "</html>");
        textPanel.add((Component)lblInfoText, "Center");
        JLabel lblInfoIcon = new JLabel(ResourceManager.getInstance().ICON_INFO_LARGE);
        lblInfoIcon.setVerticalAlignment(1);
        textPanel.add((Component)lblInfoIcon, "West");
        JPanel seeAlsoPanel = null;
        if (activePlugin.getInstructions() != null && !activePlugin.getInstructions().isEmpty()) {
            seeAlsoPanel = new JPanel(new FlowLayout(3));
            seeAlsoPanel.add((Component)new JSeparator(), "North");
            JLabel lblSeeAlso = new JLabel(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_EXERCISEMODEINFO_SEEALSO", mw.getLanguageID(), "See also here:"));
            seeAlsoPanel.add((Component)lblSeeAlso, "West");
            JLabel lblInstructionsLink = new JLabel(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_EXERCISEMODEINFO_INSTRUCTIONSLINK", mw.getLanguageID(), "Instructions of the algorithm"));
            seeAlsoPanel.add((Component)lblInstructionsLink, "Center");
            Utils.makeLinkLabel(lblInstructionsLink, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(mw, new JLabel("<html>" + activePlugin.getInstructions() + "</html>"), LanguageFile.getLabel(mw.getLanguageFile(), "MENU_HELP_INSTRUCTIONS", mw.getLanguageID(), "Instructions"), 1);
                }
            });
        }
        if (seeAlsoPanel != null) {
            textPanel.add(seeAlsoPanel, "South");
        }
        this.contentPanel.add((Component)textPanel, "Center");
        this.cbDoNotShowAgain = new JCheckBox(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_CB_DONOTSHOWAGAIN", mw.getLanguageID(), "Do not show this dialog again"));
        this.contentPanel.add((Component)this.cbDoNotShowAgain, "South");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton btnQuit = new JButton(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_BTN_QUIT", mw.getLanguageID(), "Quit"));
        btnQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExerciseModeInfoDialog.this.dispose();
            }
        });
        buttonPane.add(btnQuit);
        this.getRootPane().setDefaultButton(btnQuit);
        this.pack();
        mw.adaptDialog(this);
        this.addWindowListener(new WindowAdapter(){
            boolean closed = false;

            @Override
            public void windowClosing(WindowEvent e) {
                this.windowClosed(e);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (this.closed) {
                    return;
                }
                cfg.setShowExerciseModeInfoDialog(!ExerciseModeInfoDialog.this.cbDoNotShowAgain.isSelected());
                this.closed = true;
            }
        });
    }
}

