/*
 * Decompiled with CFR 0.152.
 */
package laves.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import laves.gui.MainWindow;
import laves.resources.ResourceManager;
import laves.utils.Constants;
import laves.utils.Utils;
import lavesdk.LAVESDKV;
import lavesdk.language.LanguageFile;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();

    public AboutDialog(MainWindow mw) throws IllegalArgumentException {
        if (mw == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        Font f = UIManager.getFont("Label.font");
        Font boldFont = f.deriveFont(1);
        this.setTitle(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_ABOUT_TITLE", mw.getLanguageID(), "About"));
        this.setModal(true);
        this.setSize(520, 400);
        this.setDefaultCloseOperation(2);
        mw.adaptDialog(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        SpringLayout sl_contentPanel = new SpringLayout();
        this.contentPanel.setLayout(sl_contentPanel);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        sl_contentPanel.putConstraint("North", (Component)tabbedPane, 5, "North", (Component)this.contentPanel);
        sl_contentPanel.putConstraint("West", (Component)tabbedPane, 5, "West", (Component)this.contentPanel);
        sl_contentPanel.putConstraint("South", (Component)tabbedPane, -5, "South", (Component)this.contentPanel);
        sl_contentPanel.putConstraint("East", (Component)tabbedPane, -5, "East", (Component)this.contentPanel);
        this.contentPanel.add(tabbedPane);
        JPanel aboutPanel = new JPanel();
        tabbedPane.addTab(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_ABOUT_INFO", mw.getLanguageID(), "Information"), null, aboutPanel, null);
        SpringLayout sl_aboutPanel = new SpringLayout();
        aboutPanel.setLayout(sl_aboutPanel);
        JLabel lblLogo = new JLabel(ResourceManager.getInstance().LOGO_SMALL);
        sl_aboutPanel.putConstraint("North", (Component)lblLogo, 10, "North", (Component)aboutPanel);
        sl_aboutPanel.putConstraint("East", (Component)lblLogo, -10, "East", (Component)aboutPanel);
        aboutPanel.add(lblLogo);
        JLabel lblUniLogo = new JLabel(ResourceManager.getInstance().LOGO_UNISIEGEN);
        lblUniLogo.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black), BorderFactory.createMatteBorder(4, 4, 4, 4, Color.white)));
        sl_aboutPanel.putConstraint("North", (Component)lblUniLogo, 6, "South", (Component)lblLogo);
        sl_aboutPanel.putConstraint("East", (Component)lblUniLogo, 0, "East", (Component)lblLogo);
        aboutPanel.add(lblUniLogo);
        JLabel lblHeadline = new JLabel("LAVES");
        lblHeadline.setForeground(Constants.COLOR_LOGO);
        lblHeadline.setFont(f.deriveFont(1, 16.0f));
        sl_aboutPanel.putConstraint("North", (Component)lblHeadline, 10, "North", (Component)aboutPanel);
        sl_aboutPanel.putConstraint("West", (Component)lblHeadline, 10, "West", (Component)aboutPanel);
        aboutPanel.add(lblHeadline);
        JLabel lblSubhead = new JLabel("Logistics Algorithms Visualization and Education Software");
        sl_aboutPanel.putConstraint("North", (Component)lblSubhead, 6, "South", (Component)lblHeadline);
        sl_aboutPanel.putConstraint("West", (Component)lblSubhead, 0, "West", (Component)lblHeadline);
        sl_aboutPanel.putConstraint("East", (Component)lblSubhead, -6, "West", (Component)lblLogo);
        aboutPanel.add(lblSubhead);
        JLabel lblVersionTitle = new JLabel(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_ABOUT_INFO_VERSION", mw.getLanguageID(), "Version:"));
        lblVersionTitle.setFont(boldFont);
        sl_aboutPanel.putConstraint("North", (Component)lblVersionTitle, 30, "South", (Component)lblSubhead);
        sl_aboutPanel.putConstraint("West", (Component)lblVersionTitle, 0, "West", (Component)lblHeadline);
        aboutPanel.add(lblVersionTitle);
        JLabel lblLAVESDKVersionTitle = new JLabel(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_ABOUT_INFO_SDKVERSION", mw.getLanguageID(), "SDK Version:"));
        lblLAVESDKVersionTitle.setFont(boldFont);
        sl_aboutPanel.putConstraint("North", (Component)lblLAVESDKVersionTitle, 6, "South", (Component)lblVersionTitle);
        sl_aboutPanel.putConstraint("West", (Component)lblLAVESDKVersionTitle, 0, "West", (Component)lblHeadline);
        aboutPanel.add(lblLAVESDKVersionTitle);
        JLabel lblLAVESDKVersion = new JLabel(String.valueOf(LAVESDKV.CURRENT.toString()) + " (" + LanguageFile.getLabel(mw.getLanguageFile(), "DLG_ABOUT_INFO_SDKVERSION_MIN", mw.getLanguageID(), "min.") + " " + LAVESDKV.MINIMUM.toString() + ")");
        sl_aboutPanel.putConstraint("West", (Component)lblLAVESDKVersion, 6, "East", (Component)lblLAVESDKVersionTitle);
        sl_aboutPanel.putConstraint("South", (Component)lblLAVESDKVersion, 0, "South", (Component)lblLAVESDKVersionTitle);
        aboutPanel.add(lblLAVESDKVersion);
        JLabel lblVersion = new JLabel("1.5 (" + Constants.RELEASE_DATE + ")");
        sl_aboutPanel.putConstraint("North", (Component)lblVersion, 0, "North", (Component)lblVersionTitle);
        sl_aboutPanel.putConstraint("West", (Component)lblVersion, 0, "West", (Component)lblLAVESDKVersion);
        aboutPanel.add(lblVersion);
        JLabel lblProductInfo = new JLabel("<html>" + LanguageFile.getLabel(mw.getLanguageFile(), "DLG_ABOUT_INFO_PRODUCTINFO", mw.getLanguageID(), "This product includes the JLaTeXMath library and uses the Fugue Icons Set by Yusuke Kamiyamane.") + "</html>");
        sl_aboutPanel.putConstraint("North", (Component)lblProductInfo, 30, "South", (Component)lblLAVESDKVersionTitle);
        sl_aboutPanel.putConstraint("West", (Component)lblProductInfo, 0, "West", (Component)lblHeadline);
        sl_aboutPanel.putConstraint("East", (Component)lblProductInfo, -6, "West", (Component)lblLogo);
        aboutPanel.add(lblProductInfo);
        JLabel lblDevInfo = new JLabel("<html>" + LanguageFile.getLabel(mw.getLanguageFile(), "DLG_ABOUT_INFO_DEVINFO", mw.getLanguageID(), "This software is developed at the Departement of Management Information Science, University of Siegen.") + "</html>");
        sl_aboutPanel.putConstraint("North", (Component)lblDevInfo, 6, "South", (Component)lblUniLogo);
        sl_aboutPanel.putConstraint("West", (Component)lblDevInfo, 0, "West", (Component)lblHeadline);
        sl_aboutPanel.putConstraint("East", (Component)lblDevInfo, 0, "East", (Component)lblUniLogo);
        aboutPanel.add(lblDevInfo);
        JLabel lblDepartmentWebsite = new JLabel("http://www.wiwi.uni-siegen.de/mis/");
        Utils.makeLinkLabel(lblDepartmentWebsite, "http://www.wiwi.uni-siegen.de/mis/");
        sl_aboutPanel.putConstraint("North", (Component)lblDepartmentWebsite, 3, "South", (Component)lblDevInfo);
        sl_aboutPanel.putConstraint("West", (Component)lblDepartmentWebsite, 0, "West", (Component)lblHeadline);
        aboutPanel.add(lblDepartmentWebsite);
        JPanel contributorsPanel = new JPanel(new BorderLayout());
        tabbedPane.addTab(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_ABOUT_CONTRIBUTORS", mw.getLanguageID(), "Contributors"), null, contributorsPanel, null);
        contributorsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JTextArea contributors = new JTextArea("Jan Dornseifer (jan.dornseifer@student.uni-siegen.de)\nDr. Dominik Kre\u00df (dominik.kress@uni-siegen.de)");
        contributors.setFont(f);
        contributors.setEditable(false);
        contributorsPanel.add((Component)new JScrollPane(contributors), "Center");
        JPanel licensePanel = new JPanel(new BorderLayout());
        tabbedPane.addTab(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_ABOUT_LICENSE", mw.getLanguageID(), "License"), null, licensePanel, null);
        licensePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JTextArea license = new JTextArea(this.getLicenseText());
        license.setFont(f);
        license.setEditable(false);
        licensePanel.add((Component)new JScrollPane(license), "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton quitButton = new JButton(LanguageFile.getLabel(mw.getLanguageFile(), "DLG_BTN_QUIT", mw.getLanguageID(), "Quit"));
        quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        buttonPane.add(quitButton);
        this.getRootPane().setDefaultButton(quitButton);
        this.setMinimumSize(new Dimension(400, 350));
    }

    private String getLicenseText() {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(Constants.FILE_LICENSE));
            StringBuilder s = new StringBuilder();
            while ((line = br.readLine()) != null) {
                s.append(line);
                s.append('\n');
            }
            String string = s.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            return "License not found!";
        }
        catch (IOException e) {
            return "License file could not be read!";
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    br = null;
                }
            }
        }
    }
}

