/*
 * Decompiled with CFR 0.152.
 */
package laves.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import laves.PluginManager;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginBundle;
import lavesdk.configuration.Configuration;
import lavesdk.language.LabelEntry;

public class MainConfiguration {
    private final Configuration config;
    private final String defLangID;

    public MainConfiguration(Configuration config) throws IllegalArgumentException {
        this(config, null);
    }

    public MainConfiguration(Configuration config, List<LabelEntry> availableLangs) throws IllegalArgumentException {
        if (config == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.config = config;
        if (availableLangs != null) {
            String defLangTmp = Locale.getDefault().getLanguage().toLowerCase();
            boolean exists = false;
            for (LabelEntry e : availableLangs) {
                if (!e.langID.equals(defLangTmp)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                defLangTmp = "en";
            }
            this.defLangID = defLangTmp;
        } else {
            this.defLangID = "en";
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public int getWindowWidth() {
        return this.config.getInt("windowWidth", 800);
    }

    public void setWindowWidth(int width) {
        this.config.addInt("windowWidth", width);
    }

    public int getWindowHeight() {
        return this.config.getInt("windowHeight", 600);
    }

    public void setWindowHeight(int height) {
        this.config.addInt("windowHeight", height);
    }

    public int getWindowPosX() {
        return this.config.getInt("windowPosX", 100);
    }

    public void setWindowPosX(int x) {
        this.config.addInt("windowPosX", x);
    }

    public int getWindowPosY() {
        return this.config.getInt("windowPosY", 100);
    }

    public void setWindowPosY(int y) {
        this.config.addInt("windowPosY", y);
    }

    public boolean getWindowMaximized() {
        return this.config.getBoolean("windowMaximized", false);
    }

    public void setWindowMaximized(boolean maximized) {
        this.config.addBoolean("windowMaximized", maximized);
    }

    public String getLanguageID() {
        return this.config.getString("langID", this.defLangID);
    }

    public void setLanguageID(String langID) {
        this.config.addString("langID", langID);
    }

    public int getNewDialogWidth() {
        return this.config.getInt("newDlgWidth", 650);
    }

    public void setNewDialogWidth(int width) {
        this.config.addInt("newDlgWidth", width);
    }

    public int getNewDialogHeight() {
        return this.config.getInt("newDialogHeight", 550);
    }

    public void setNewDialogHeight(int height) {
        this.config.addInt("newDialogHeight", height);
    }

    public int getPluginManagerDialogWidth() {
        return this.config.getInt("plugManDlgWidth", 600);
    }

    public void setPluginManagerDialogWidth(int width) {
        this.config.addInt("plugManDlgWidth", width);
    }

    public int getPluginManagerDialogHeight() {
        return this.config.getInt("plugManDlgHeight", 450);
    }

    public void setPluginManagerDialogHeight(int height) {
        this.config.addInt("plugManDlgHeight", height);
    }

    public int getPreferencesDialogWidth() {
        return this.config.getInt("prefsDlgWidth", 650);
    }

    public void setPreferencesDialogWidth(int width) {
        this.config.addInt("prefsDlgWidth", width);
    }

    public int getPreferencesDialogHeight() {
        return this.config.getInt("prefsDlgHeight", 550);
    }

    public void setPreferencesDialogHeight(int height) {
        this.config.addInt("prefsDlgHeight", height);
    }

    public int getColumnAlgoNameWidth() {
        return this.config.getInt("columnAlgoNameWidth", 0);
    }

    public void setColumnAlgoNameWidth(int width) {
        this.config.addInt("columnAlgoNameWidth", width);
    }

    public boolean getColumnAlgoProblemAffiliationVisible() {
        return this.config.getBoolean("columnAlgoProbAffilVisible", true);
    }

    public void setColumnAlgoProblemAffiliationVisible(boolean visible) {
        this.config.addBoolean("columnAlgoProbAffilVisible", visible);
    }

    public int getColumnAlgoProblemAffiliationWidth() {
        return this.config.getInt("columnAlgoProbAffilWidth", 0);
    }

    public void setColumnAlgoProblemAffiliationWidth(int width) {
        this.config.addInt("columnAlgoProbAffilWidth", width);
    }

    public boolean getColumnAlgoSubjectVisible() {
        return this.config.getBoolean("columnAlgoSubjectVisible", false);
    }

    public void setColumnAlgoSubjectVisible(boolean visible) {
        this.config.addBoolean("columnAlgoSubjectVisible", visible);
    }

    public int getColumnAlgoSubjectWidth() {
        return this.config.getInt("columnAlgoSubjectWidth", 0);
    }

    public void setColumnAlgoSubjectWidth(int width) {
        this.config.addInt("columnAlgoSubjectWidth", width);
    }

    public boolean getColumnAlgoTypeVisible() {
        return this.config.getBoolean("columnAlgoTypeVisible", false);
    }

    public void setColumnAlgoTypeVisible(boolean visible) {
        this.config.addBoolean("columnAlgoTypeVisible", visible);
    }

    public int getColumnAlgoTypeWidth() {
        return this.config.getInt("columnAlgoTypeWidth", 0);
    }

    public void setColumnAlgoTypeWidth(int width) {
        this.config.addInt("columnAlgoTypeWidth", width);
    }

    public boolean getColumnAlgoAuthorVisible() {
        return this.config.getBoolean("columnAlgoAuthorVisible", false);
    }

    public void setColumnAlgoAuthorVisible(boolean visible) {
        this.config.addBoolean("columnAlgoAuthorVisible", visible);
    }

    public int getColumnAlgoAuthorWidth() {
        return this.config.getInt("columnAlgoAuthorWidth", 0);
    }

    public void setColumnAlgoAuthorWidth(int width) {
        this.config.addInt("columnAlgoAuthorWidth", width);
    }

    public boolean getColumnAlgoAuthorContactVisible() {
        return this.config.getBoolean("columnAlgoAuthorContactVisible", false);
    }

    public void setColumnAlgoAuthorContactVisible(boolean visible) {
        this.config.addBoolean("columnAlgoAuthorContactVisible", visible);
    }

    public int getColumnAlgoAuthorContactWidth() {
        return this.config.getInt("columnAlgoAuthorContactWidth", 0);
    }

    public void setColumnAlgoAuthorContactWidth(int width) {
        this.config.addInt("columnAlgoAuthorContactWidth", width);
    }

    public boolean getColumnAlgoVersionVisible() {
        return this.config.getBoolean("columnAlgoVersionVisible", true);
    }

    public void setColumnAlgoVersionVisible(boolean visible) {
        this.config.addBoolean("columnAlgoVersionVisible", visible);
    }

    public int getColumnAlgoVersionWidth() {
        return this.config.getInt("columnAlgoVersionWidth", 0);
    }

    public void setColumnAlgoVersionWidth(int width) {
        this.config.addInt("columnAlgoVersionWidth", width);
    }

    public boolean getColumnAlgoSDKVersionVisible() {
        return this.config.getBoolean("columnAlgoSDKVersionVisible", false);
    }

    public void setColumnAlgoSDKVersionVisible(boolean visible) {
        this.config.addBoolean("columnAlgoSDKVersionVisible", visible);
    }

    public int getColumnAlgoSDKVersionWidth() {
        return this.config.getInt("columnAlgoSDKVersionWidth", 0);
    }

    public void setColumnAlgoSDKVersionWidth(int width) {
        this.config.addInt("columnAlgoSDKVersionWidth", width);
    }

    public boolean getShowWelcomeScreen() {
        return this.config.getBoolean("showWelcomeScreen", true);
    }

    public void setShowWelcomeScreen(boolean show) {
        this.config.addBoolean("showWelcomeScreen", show);
    }

    public boolean getDisableInformationBarPermanently() {
        return this.config.getBoolean("disableInfoBarPermanently", false);
    }

    public void setDisableInformationBarPermanently(boolean disable) {
        this.config.addBoolean("disableInfoBarPermanently", disable);
    }

    public List<AlgorithmPlugin> getLastOpenedAlgorithms(PluginManager manager) throws IllegalArgumentException {
        if (manager == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        List list = this.config.getList("lastOpenedAlgorithms", new ArrayList(0));
        ArrayList<AlgorithmPlugin> res = new ArrayList<AlgorithmPlugin>(list.size());
        int i = 0;
        while (i < list.size()) {
            for (PluginBundle bundle : manager.getPluginBundles()) {
                if (!bundle.getSimpleName().equals(list.get(i)) || !manager.isBundleInstalled(bundle)) continue;
                res.add(bundle.getPlugin());
                break;
            }
            ++i;
        }
        return res;
    }

    public void setLastOpenedAlgorithms(List<AlgorithmPlugin> algorithms, PluginManager manager) throws IllegalArgumentException {
        if (algorithms == null || manager == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        ArrayList<String> res = new ArrayList<String>(algorithms.size());
        int i = 0;
        while (i < algorithms.size()) {
            PluginBundle bundle = manager.findBundle(algorithms.get(i));
            if (bundle != null) {
                res.add(bundle.getSimpleName());
            }
            ++i;
        }
        this.config.addList("lastOpenedAlgorithms", res);
    }

    public int getLastOpendAlgorithmsCount() {
        return this.config.getInt("lastOpenedAlgorithmsCount", 3);
    }

    public void setLastOpenedAlgorithmsCount(int count) {
        this.config.addInt("lastOpenedAlgorithmsCount", count);
    }

    public boolean getShowExerciseModeInfoDialog() {
        return this.config.getBoolean("showExerciseModeInfoDialog", true);
    }

    public void setShowExerciseModeInfoDialog(boolean show) {
        this.config.addBoolean("showExerciseModeInfoDialog", show);
    }

    public boolean getToolBarOptPauseBeforeStopSelected() {
        return this.config.getBoolean("toolBarOptPauseBeforeStopSelected", false);
    }

    public void setToolBarOptPauseBeforeStopSelected(boolean selected) {
        this.config.addBoolean("toolBarOptPauseBeforeStopSelected", selected);
    }

    public boolean getToolBarOptSkipBreakpointsSelected() {
        return this.config.getBoolean("toolBarOptSkipBreakpointsSelected", false);
    }

    public void setToolBarOptSkipBreakpointsSelected(boolean selected) {
        this.config.addBoolean("toolBarOptSkipBreakpointsSelected", selected);
    }
}

