/*
 * Decompiled with CFR 0.152.
 */
package laves;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import laves.Loader;
import laves.PluginManagerListener;
import laves.utils.Constants;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginBundle;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ValidationReport;
import lavesdk.algorithm.plugin.Validator;
import lavesdk.configuration.Configuration;
import lavesdk.logging.enums.LogType;

public class PluginManager {
    private final Loader loader;
    private final PluginHost host;
    private final List<PluginBundle> pluginBundles;
    private final Map<String, Configuration> pluginConfigs;
    private List<AlgorithmPlugin> installedPlugins;
    private final List<PluginManagerListener> listeners;

    public PluginManager(Loader loader, PluginHost host, List<PluginBundle> bundles, Map<String, Configuration> bundleConfigs) throws IllegalArgumentException {
        if (loader == null || host == null || bundles == null || bundleConfigs == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.loader = loader;
        this.host = host;
        this.pluginBundles = bundles;
        this.pluginConfigs = bundleConfigs;
        this.installedPlugins = null;
        this.listeners = new ArrayList<PluginManagerListener>(3);
    }

    public boolean initialize() {
        if (this.installedPlugins != null) {
            return false;
        }
        ArrayList<AlgorithmPlugin> plugins = new ArrayList<AlgorithmPlugin>();
        boolean result = true;
        for (PluginBundle bundle : this.pluginBundles) {
            if (!LAVESDKV.checkCompatibility(bundle.getPlugin())) {
                this.loader.logMessage(bundle.getPlugin(), "plugin is not compatible with the current SDK version!", null, LogType.ERROR);
                continue;
            }
            try {
                bundle.getPlugin().initialize(this.host, bundle.getResourceLoader(), this.pluginConfigs.get(bundle.getSimpleName()));
                AlgorithmRTE rte = bundle.getPlugin().getRuntimeEnvironment();
                if (rte != null) {
                    rte.registerHost(this.host);
                }
                plugins.add(bundle.getPlugin());
            }
            catch (Exception e) {
                this.loader.logMessage(bundle.getPlugin(), "plugin could not be initialized!", e, LogType.ERROR);
                result = false;
            }
        }
        this.installedPlugins = Collections.unmodifiableList(plugins);
        return result;
    }

    public void addListener(PluginManagerListener listener) {
        if (listener == null || this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(PluginManagerListener listener) {
        this.listeners.remove(listener);
    }

    public final List<PluginBundle> getPluginBundles() {
        return this.pluginBundles;
    }

    public final Configuration getPluginConfiguration(PluginBundle bundle) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return this.pluginConfigs != null ? this.pluginConfigs.get(bundle.getSimpleName()) : null;
    }

    public final List<AlgorithmPlugin> getInstalledPlugins() {
        return this.installedPlugins;
    }

    /*
     * Unable to fully structure code
     */
    public final ValidationReport install(PluginBundle bundle) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        i = 1;
        cancelIndex = 1000;
        pluginFileName = bundle.getName();
        if (!LAVESDKV.checkCompatibility(bundle.getPlugin())) {
            return new ValidationReport(false, "Plugin is not compatible with the installed SDK version!", 1, 0);
        }
        vr = Validator.validate(bundle.getPlugin(), true);
        if (vr.ok) ** GOTO lbl12
        return vr;
lbl-1000:
        // 1 sources

        {
            pluginFileName = String.valueOf(bundle.getSimpleName()) + "_" + i++ + ".jar";
lbl12:
            // 2 sources

            ** while (new File((String)(String.valueOf((Object)Constants.PATH_PLUGINS) + pluginFileName)).exists() && i < cancelIndex)
        }
lbl13:
        // 1 sources

        if (i >= cancelIndex) {
            return new ValidationReport(false, "Plugin could not be installed in the plugin folder!", 1, 0);
        }
        try {
            Files.copy(Paths.get(bundle.getFile().getAbsolutePath(), new String[0]), Paths.get(String.valueOf(Constants.PATH_PLUGINS) + pluginFileName, new String[0]), new CopyOption[0]);
            try {
                bundle.getPlugin().initialize(this.host, bundle.getResourceLoader(), null);
            }
            catch (Exception e) {
                return new ValidationReport(false, "Plugin could not be initialized! " + e.getMessage(), 1, 0);
            }
            this.pluginBundles.add(bundle);
            modifiablePluginsList = new ArrayList<AlgorithmPlugin>(this.installedPlugins);
            modifiablePluginsList.add(bundle.getPlugin());
            this.installedPlugins = Collections.unmodifiableList(modifiablePluginsList);
            this.fireInstalledPluginsChanged(true);
        }
        catch (IOException e) {
            return new ValidationReport(false, e.getMessage(), 1, 0);
        }
        return new ValidationReport(true, "", 0, 0);
    }

    public final boolean deinstall(AlgorithmPlugin plugin) throws IllegalArgumentException {
        if (plugin == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        PluginBundle bundle = this.findBundle(plugin);
        if (bundle == null) {
            return false;
        }
        ArrayList<AlgorithmPlugin> modifiablePluginsList = new ArrayList<AlgorithmPlugin>(this.installedPlugins);
        if (modifiablePluginsList.remove(bundle.getPlugin())) {
            File cfgFile = new File(String.valueOf(Constants.PATH_PLUGINS_CONFIG) + bundle.getSimpleName() + ".cfg");
            File pluginFile = new File(bundle.getPath());
            if (!cfgFile.delete() || !pluginFile.delete()) {
                this.loader.addDeinstallationEntry(bundle);
            }
            this.pluginBundles.remove(bundle);
            this.pluginConfigs.remove(bundle.getSimpleName());
            this.installedPlugins = Collections.unmodifiableList(modifiablePluginsList);
            this.fireInstalledPluginsChanged(false);
            return true;
        }
        return false;
    }

    public final PluginBundle findBundle(AlgorithmPlugin plugin) throws IllegalArgumentException {
        if (plugin == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        for (PluginBundle bundle : this.pluginBundles) {
            if (bundle.getPlugin() != plugin) continue;
            return bundle;
        }
        return null;
    }

    public final boolean isBundleInstalled(PluginBundle bundle) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return this.installedPlugins.contains(bundle.getPlugin());
    }

    private void fireInstalledPluginsChanged(boolean increase) {
        for (PluginManagerListener l : this.listeners) {
            l.onInstalledPluginsChanged(increase);
        }
    }
}

