/*
 * Decompiled with CFR 0.152.
 */
package laves;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import laves.PluginManager;
import laves.utils.Constants;
import laves.utils.ProgressListener;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginBundle;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.PluginLoader;
import lavesdk.configuration.Configuration;
import lavesdk.language.LanguageFile;
import lavesdk.logging.LogFile;
import lavesdk.logging.enums.LogType;
import lavesdk.utils.FileUtils;

public class Loader {
    private boolean dataLoaded = false;
    private Configuration mainConfig = null;
    private List<PluginBundle> pluginBundles = null;
    private Map<String, Configuration> pluginConfigs = null;
    private LanguageFile langFile = null;
    private PluginManager pluginManager = null;
    private final LogFile logFile;
    private boolean hasErrors = false;
    private static final String DEINSTALL_PLUGINS_FILENAME = "deinstall_plugins.txt";

    public Loader() {
        LogFile lf;
        try {
            lf = new LogFile(Constants.FILE_LOG);
        }
        catch (IOException e) {
            lf = null;
        }
        this.logFile = lf;
    }

    public void loadData(final ProgressListener listener) {
        this.deinstallPluginFiles();
        this.pluginBundles = PluginLoader.getInstance().loadPlugins(Constants.PATH_PLUGINS, new lavesdk.utils.ProgressListener(){
            private int totalPlugins = 0;

            @Override
            public void totalProgress(int total) {
                this.totalPlugins = total;
                listener.totalProgress(this.totalPlugins + 3);
            }

            @Override
            public void currentProgress(int current) {
                listener.currentProgress(current, "Loading Plugin " + current + "/" + this.totalPlugins + " ...");
            }
        });
        int current = this.pluginBundles.size() + 1;
        listener.currentProgress(current++, "Loading main configuration ...");
        this.mainConfig = Configuration.load(Constants.FILE_MAIN_CONFIG);
        listener.currentProgress(current++, "Loading plugin configurations ...");
        this.pluginConfigs = new HashMap<String, Configuration>();
        for (PluginBundle bundle : this.pluginBundles) {
            this.pluginConfigs.put(bundle.getSimpleName(), Configuration.load(String.valueOf(Constants.PATH_PLUGINS_CONFIG) + bundle.getSimpleName() + ".cfg"));
        }
        listener.currentProgress(current++, "Loading languages ...");
        try {
            this.langFile = new LanguageFile(Constants.FILE_LANGUAGE);
        }
        catch (IOException e) {
            this.langFile = null;
            this.logMessage("Loader: Loading languages failed!", LogType.ERROR);
            this.hasErrors = true;
        }
        this.dataLoaded = true;
    }

    public boolean isDataLoaded() {
        return this.dataLoaded;
    }

    public void initializePlugins(PluginHost host) throws IllegalArgumentException {
        if (!this.dataLoaded || this.pluginManager != null) {
            return;
        }
        this.pluginManager = new PluginManager(this, host, this.pluginBundles, this.pluginConfigs);
        if (!this.pluginManager.initialize()) {
            this.hasErrors = true;
        }
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public final Configuration getMainConfiguration() {
        return this.mainConfig;
    }

    public final LanguageFile getLanguageFile() {
        return this.langFile;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void logMessage(String msg, LogType type) {
        this.logMessage(null, msg, null, type);
    }

    public void logMessage(AlgorithmPlugin plugin, String msg, Exception e, LogType type) {
        if (this.logFile != null) {
            this.logFile.writeToLog(plugin, msg, e, type);
        }
    }

    void addDeinstallationEntry(PluginBundle bundle) {
        block12: {
            OutputStreamWriter fw = null;
            try {
                try {
                    File f = FileUtils.createFilePath(String.valueOf(Constants.PATH_TEMP) + DEINSTALL_PLUGINS_FILENAME);
                    fw = new FileWriter(f, true);
                    fw.write(String.valueOf(bundle.getFile().getAbsolutePath()) + "\n");
                    fw.flush();
                }
                catch (IOException iOException) {
                    if (fw == null) break block12;
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        fw = null;
                    }
                }
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        fw = null;
                    }
                }
            }
        }
    }

    private void deinstallPluginFiles() {
        File f;
        block16: {
            f = new File(String.valueOf(Constants.PATH_TEMP) + DEINSTALL_PLUGINS_FILENAME);
            BufferedReader br = null;
            if (!f.exists()) {
                return;
            }
            try {
                try {
                    String entry;
                    br = new BufferedReader(new FileReader(f));
                    while ((entry = br.readLine()) != null) {
                        File delFile;
                        if (entry.isEmpty() || !(delFile = new File(entry)).exists()) continue;
                        delFile.delete();
                    }
                }
                catch (IOException iOException) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            br = null;
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        br = null;
                    }
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    br = null;
                }
            }
        }
        f.delete();
    }
}

