/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Random;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.CircleLayoutToolBarExtension;
import lavesdk.algorithm.plugin.extensions.MatrixToGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.RandomGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.AlgorithmTextView;
import lavesdk.algorithm.plugin.views.DefaultGraphView;
import lavesdk.algorithm.plugin.views.ExecutionTableView;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.LegendView;
import lavesdk.algorithm.plugin.views.MatrixView;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.configuration.Configuration;
import lavesdk.gui.dialogs.SolveExerciseDialog;
import lavesdk.gui.dialogs.SolveExercisePane;
import lavesdk.gui.dialogs.enums.AllowedGraphType;
import lavesdk.gui.widgets.BooleanProperty;
import lavesdk.gui.widgets.BooleanPropertyGroup;
import lavesdk.gui.widgets.ColorProperty;
import lavesdk.gui.widgets.ExecutionTableBorder;
import lavesdk.gui.widgets.ExecutionTableColumn;
import lavesdk.gui.widgets.ExecutionTableGroup;
import lavesdk.gui.widgets.ExecutionTableItem;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.gui.widgets.Mask;
import lavesdk.gui.widgets.MatrixEditor;
import lavesdk.gui.widgets.MatrixElementFormat;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.NumericTextField;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;
import lavesdk.gui.widgets.Symbol;
import lavesdk.language.LanguageFile;
import lavesdk.math.Matrix;
import lavesdk.math.NumericMatrix;
import lavesdk.math.ObjectMatrix;
import lavesdk.math.Set;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.SimpleGraph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.Walk;
import lavesdk.math.graph.enums.Type;
import lavesdk.serialization.Serializer;
import lavesdk.utils.GraphUtils;
import lavesdk.utils.MathUtils;

public class TripelAlgorithmPlugin
implements AlgorithmPlugin {
    private PluginHost host;
    private Configuration config;
    private LanguageFile langFile;
    private String langID;
    private FileNameExtensionFilter vgfFileFilter;
    private FileNameExtensionFilter pngFileFilter;
    private AlgorithmText algoText;
    private DefaultGraphView graphView;
    private AlgorithmTextView algoTextView;
    private ExecutionTableView assistantTableView;
    private LegendView legendView;
    private MatrixView<Float> matrixViewD;
    private MatrixView<String> matrixViewP;
    private TripelRTE rte;
    private MatrixToGraphToolBarExtension<Vertex, Edge> matrixToGraph;
    private RandomGraphToolBarExtension<Vertex, Edge> randomGraph;
    private CircleLayoutToolBarExtension<Vertex, Edge> circleLayoutExt;
    private String creatorPrefsDirected;
    private String creatorPrefsUndirected;
    private boolean creatorPrefsDirectedValue;
    private ViewGroup ab;
    private ViewGroup ce;
    private ViewGroup df;
    private ViewGroup cedf;
    private ViewGroup abcdef;
    private Color colorSourceVertex;
    private Color colorTransitVertex;
    private Color colorTargetVertex;
    private Color colorHighlightedVertices;
    private Color colorHighlightedEdge;
    private Color colorSmallerDist;
    private Color colorModified;
    private int lineWidthSourceVertex;
    private int lineWidthTransitVertex;
    private int lineWidthTargetVertex;
    private static final String CFGKEY_CREATORPROP_DIRECTED = "creatorPropDirected";
    private static final String CFGKEY_COLOR_SOURCEVERTEX = "colorSourceVertex";
    private static final String CFGKEY_COLOR_TRANSITVERTEX = "colorTransitVertex";
    private static final String CFGKEY_COLOR_TARGETVERTEX = "colorTargetVertex";
    private static final String CFGKEY_COLOR_HIGHLIGHTEDVERTICES = "colorHighlightedVertices";
    private static final String CFGKEY_COLOR_HIGHLIGHTEDEDGE = "colorHighlightedEdge";
    private static final String CFGKEY_COLOR_SMALLERDIST = "colorSmallerDist";
    private static final String CFGKEY_COLOR_MODIFIED = "colorModified";
    private static final String CFGKEY_LINEWIDTH_SOURCEVERTEX = "lineWidthSourceVertex";
    private static final String CFGKEY_LINEWIDTH_TRANSITVERTEX = "lineWidthTransitVertex";
    private static final String CFGKEY_LINEWIDTH_TARGETVERTEX = "lineWidthTargetVertex";
    private static final String COLUMN_CHANGE_TICK = "t";

    public void initialize(PluginHost host, ResourceLoader resLoader, Configuration config) {
        try {
            this.langFile = new LanguageFile(resLoader.getResourceAsStream("main/resources/langTripel.txt"));
            this.langFile.include(host.getLanguageFile());
        }
        catch (IOException e) {
            this.langFile = null;
        }
        this.langID = host.getLanguageID();
        this.host = host;
        this.config = config != null ? config : new Configuration();
        this.vgfFileFilter = new FileNameExtensionFilter("Visual Graph File (*.vgf)", "vgf");
        this.pngFileFilter = new FileNameExtensionFilter("Portable Network Graphic (*.png)", "png");
        this.graphView = new DefaultGraphView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_GRAPH_TITLE", (String)this.langID, (String)"Graph"), (Graph)new SimpleGraph(false), null, true, this.langFile, this.langID);
        this.assistantTableView = new ExecutionTableView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ASSISTANTTABLE_TITLE", (String)this.langID, (String)"Assistant Table"), true, this.langFile, this.langID);
        this.matrixViewD = new MatrixView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_MATRIXD_TITLE", (String)this.langID, (String)"Matrix D (distance matrix)"), (MatrixElementFormat)new MatrixEditor.FloatElementFormat(), true, this.langFile, this.langID);
        this.matrixViewP = new MatrixView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_MATRIXP_TITLE", (String)this.langID, (String)"Matrix P (predecessor matrix)"), (MatrixElementFormat)new MatrixEditor.StringElementFormat(), true, this.langFile, this.langID);
        this.algoText = this.loadAlgorithmText();
        this.algoTextView = new AlgorithmTextView(host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ALGOTEXT_TITLE", (String)this.langID, (String)"Algorithm"), this.algoText, true, this.langFile, this.langID);
        this.legendView = new LegendView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LEGEND_TITLE", (String)this.langID, (String)"Legend"), true, this.langFile, this.langID);
        this.rte = new TripelRTE();
        this.matrixToGraph = new MatrixToGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.BOTH, this.langFile, this.langID, true);
        this.randomGraph = new RandomGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.BOTH, this.langFile, this.langID, false);
        this.circleLayoutExt = new CircleLayoutToolBarExtension((GraphView)this.graphView, this.langFile, this.langID, false);
        this.creatorPrefsDirected = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_DIRECTED", (String)this.langID, (String)"directed");
        this.creatorPrefsUndirected = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_UNDIRECTED", (String)this.langID, (String)"undirected");
        this.algoTextView.setAutoRepaint(true);
        this.assistantTableView.setAutoRepaint(true);
        this.matrixViewD.setAutoRepaint(true);
        this.matrixViewP.setAutoRepaint(true);
        this.assistantTableView.setAutoResizeColumns(false);
        this.matrixViewD.addMask(new Mask((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Icon)Symbol.getPredefinedSymbol((Symbol.PredefinedSymbol)Symbol.PredefinedSymbol.INFINITY)));
        this.creatorPrefsDirectedValue = this.config.getBoolean(CFGKEY_CREATORPROP_DIRECTED, false);
        this.colorSourceVertex = this.config.getColor(CFGKEY_COLOR_SOURCEVERTEX, new Color(180, 210, 230));
        this.colorTransitVertex = this.config.getColor(CFGKEY_COLOR_TRANSITVERTEX, new Color(110, 190, 110));
        this.colorTargetVertex = this.config.getColor(CFGKEY_COLOR_TARGETVERTEX, new Color(255, 220, 80));
        this.colorHighlightedVertices = this.config.getColor(CFGKEY_COLOR_HIGHLIGHTEDVERTICES, new Color(200, 145, 145));
        this.colorHighlightedEdge = this.config.getColor(CFGKEY_COLOR_HIGHLIGHTEDEDGE, new Color(200, 145, 145));
        this.colorSmallerDist = this.config.getColor(CFGKEY_COLOR_SMALLERDIST, new Color(120, 210, 80));
        this.colorModified = this.config.getColor(CFGKEY_COLOR_MODIFIED, new Color(255, 180, 130));
        this.lineWidthSourceVertex = this.config.getInt(CFGKEY_LINEWIDTH_SOURCEVERTEX, 2);
        this.lineWidthTransitVertex = this.config.getInt(CFGKEY_LINEWIDTH_TRANSITVERTEX, 2);
        this.lineWidthTargetVertex = this.config.getInt(CFGKEY_LINEWIDTH_TARGETVERTEX, 2);
        this.graphView.loadConfiguration(config, "graphView");
        this.algoTextView.loadConfiguration(config, "algoTextView");
        this.assistantTableView.loadConfiguration(config, "assistantTableView");
        this.matrixViewD.loadConfiguration(config, "matrixViewD");
        this.matrixViewP.loadConfiguration(config, "matrixViewP");
        this.legendView.loadConfiguration(config, "legendView");
        this.createLegend();
    }

    public String getName() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_NAME", (String)this.langID, (String)"Floyd-Warshall algorithm (Tripel algorithm)");
    }

    public String getDescription() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_DESC", (String)this.langID, (String)"Finds the shortest paths between all pairs of vertices in a graph.");
    }

    public String getType() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_TYPE", (String)this.langID, (String)"Exact algorithm");
    }

    public String getAuthor() {
        return "Jan Dornseifer";
    }

    public String getAuthorContact() {
        return "jan.dornseifer@student.uni-siegen.de";
    }

    public String getAssumptions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_ASSUMPTIONS", (String)this.langID, (String)"A simple, weighted graph G = (V, E) without circles of negative length.");
    }

    public String getProblemAffiliation() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_PROBLEMAFFILIATION", (String)this.langID, (String)"Shortest path problem");
    }

    public String getSubject() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_SUBJECT", (String)this.langID, (String)"Logistics");
    }

    public String getInstructions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_INSTRUCTIONS", (String)this.langID, (String)"<b>Creating problem entities</b>:<br>Create your own graph and make sure that the graph complies with the assumptions of the algorithm. You can use<br>the toolbar extension to create a graph by use of an adjacency matrix.<br><br><b>Exercise Mode</b>:<br>Activate the exercise mode to practice the algorithm in an interactive way. After you have started the algorithm<br>exercises are presented that you have to solve.<br>If an exercise can be solved directly in a view of the algorithm the corresponding view is highlighted with a border, there you can<br>enter your solution and afterwards you have to press the button to solve the exercise. Otherwise (if an exercise is not related to a specific<br>view) you can directly press the button to solve the exercise which opens a dialog where you can enter your solution of the exercise.");
    }

    public String getVersion() {
        return "1.4";
    }

    public LAVESDKV getUsedSDKVersion() {
        return new LAVESDKV(1, 4);
    }

    public AlgorithmRTE getRuntimeEnvironment() {
        return this.rte;
    }

    public AlgorithmText getText() {
        return this.algoText.getBaseCopy();
    }

    public boolean hasExerciseMode() {
        return true;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean hasCreatorPreferences() {
        return true;
    }

    public void loadCreatorPreferences(PropertiesListModel plm) {
        BooleanPropertyGroup group = new BooleanPropertyGroup(plm);
        plm.add((Property)new BooleanProperty(this.creatorPrefsDirected, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_DIRECTED_DESC", (String)this.langID, (String)"Apply algorithm to a directed graph"), this.creatorPrefsDirectedValue, group));
        plm.add((Property)new BooleanProperty(this.creatorPrefsUndirected, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_UNDIRECTED_DESC", (String)this.langID, (String)"Apply algorithm to an undirected graph"), !this.creatorPrefsDirectedValue, group));
    }

    public void onCreate(ViewContainer container, PropertiesListModel creatorProperties) {
        this.creatorPrefsDirectedValue = creatorProperties != null ? creatorProperties.getBooleanProperty(this.creatorPrefsDirected).getValue() : false;
        this.config.addBoolean(CFGKEY_CREATORPROP_DIRECTED, this.creatorPrefsDirectedValue);
        this.graphView.setGraph((Graph)new SimpleGraph(this.creatorPrefsDirectedValue));
        this.graphView.repaint();
        this.matrixToGraph.setAllowedGraphType(this.creatorPrefsDirectedValue ? AllowedGraphType.DIRECTED_ONLY : AllowedGraphType.UNDIRECTED_ONLY);
        this.randomGraph.setAllowedGraphType(this.creatorPrefsDirectedValue ? AllowedGraphType.DIRECTED_ONLY : AllowedGraphType.UNDIRECTED_ONLY);
        this.ab = new ViewGroup(1);
        this.ce = new ViewGroup(0);
        this.df = new ViewGroup(0);
        this.cedf = new ViewGroup(1);
        this.abcdef = new ViewGroup(0);
        this.ab.add((Component)this.algoTextView);
        this.ab.add((Component)this.legendView);
        this.ab.restoreWeights((Serializer)this.config, "weights_ab", new float[]{0.6f, 0.4f});
        this.ce.add((Component)this.graphView);
        this.ce.add((Component)this.assistantTableView);
        this.ce.restoreWeights((Serializer)this.config, "weights_ce", new float[]{0.7f, 0.3f});
        this.df.add(this.matrixViewD);
        this.df.add(this.matrixViewP);
        this.df.restoreWeights((Serializer)this.config, "weights_df", new float[]{0.5f, 0.5f});
        this.df.setWeights(new float[]{0.5f, 0.5f});
        this.cedf.add((Component)this.ce);
        this.cedf.add((Component)this.df);
        this.cedf.restoreWeights((Serializer)this.config, "weights_cedf", new float[]{0.7f, 0.3f});
        this.abcdef.add((Component)this.ab);
        this.abcdef.add((Component)this.cedf);
        this.abcdef.restoreWeights((Serializer)this.config, "weights_abcdef", new float[]{0.4f, 0.6f});
        container.setLayout((LayoutManager)new BorderLayout());
        container.add((Component)this.abcdef, (Object)"Center");
    }

    public void onClose() {
        this.graphView.saveConfiguration(this.config, "graphView");
        this.algoTextView.saveConfiguration(this.config, "algoTextView");
        this.assistantTableView.saveConfiguration(this.config, "assistantTableView");
        this.matrixViewD.saveConfiguration(this.config, "matrixViewD");
        this.matrixViewP.saveConfiguration(this.config, "matrixViewP");
        this.legendView.saveConfiguration(this.config, "legendView");
        if (this.ab != null) {
            this.ab.storeWeights((Serializer)this.config, "weights_ab");
        }
        if (this.ce != null) {
            this.ce.storeWeights((Serializer)this.config, "weights_ce");
        }
        if (this.df != null) {
            this.df.storeWeights((Serializer)this.config, "weights_df");
        }
        if (this.cedf != null) {
            this.cedf.storeWeights((Serializer)this.config, "weights_cedf");
        }
        if (this.abcdef != null) {
            this.abcdef.storeWeights((Serializer)this.config, "weights_abcdef");
        }
        this.graphView.reset();
        this.assistantTableView.reset();
        this.matrixViewD.reset();
        this.matrixViewP.reset();
    }

    public boolean hasCustomization() {
        return true;
    }

    public void loadCustomization(PropertiesListModel plm) {
        plm.add((Property)new ColorProperty("algoTextHighlightForeground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTFOREGROUND", (String)this.langID, (String)"Foreground color of the current step in the algorithm"), this.algoTextView.getHighlightForeground()));
        plm.add((Property)new ColorProperty("algoTextHighlightBackground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTBACKGROUND", (String)this.langID, (String)"Background color of the current step in the algorithm"), this.algoTextView.getHighlightBackground()));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_TRANSITVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_TRANSITVERTEX", (String)this.langID, (String)"Background color of the transit vertex"), this.colorTransitVertex));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SOURCEVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_SOURCEVERTEX", (String)this.langID, (String)"Background color of the source vertex"), this.colorSourceVertex));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_TARGETVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_TARGETVERTEX", (String)this.langID, (String)"Background color of the target vertex"), this.colorTargetVertex));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_HIGHLIGHTEDVERTICES, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_HIGHLIGHTEDVERTICES", (String)this.langID, (String)"Background color of the vertices that are currently investigated"), this.colorHighlightedVertices));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_HIGHLIGHTEDEDGE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_HIGHLIGHTEDEDGE", (String)this.langID, (String)"Color of the edge that is currently investigated"), this.colorHighlightedEdge));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SMALLERDIST, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_SMALLERDIST", (String)this.langID, (String)"Background color of an assistant table cell that indicates a smaller distance"), this.colorSmallerDist));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MODIFIED, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MODIFICATIONS", (String)this.langID, (String)"Color of modifications to objects"), this.colorModified));
        NumericProperty lwTransitVertex = new NumericProperty(CFGKEY_LINEWIDTH_TRANSITVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_TRANSITVERTEX", (String)this.langID, (String)"Line width of the transit vertex"), (Number)this.lineWidthTransitVertex, true);
        lwTransitVertex.setMinimum(1);
        lwTransitVertex.setMaximum(5);
        plm.add((Property)lwTransitVertex);
        NumericProperty lwSourceVertex = new NumericProperty(CFGKEY_LINEWIDTH_SOURCEVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_SOURCEVERTEX", (String)this.langID, (String)"Line width of the source vertex"), (Number)this.lineWidthSourceVertex, true);
        lwSourceVertex.setMinimum(1);
        lwSourceVertex.setMaximum(5);
        plm.add((Property)lwSourceVertex);
        NumericProperty lwTargetVertex = new NumericProperty(CFGKEY_LINEWIDTH_TARGETVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_TARGETVERTEX", (String)this.langID, (String)"Line width of the target vertex"), (Number)this.lineWidthTargetVertex, true);
        lwTargetVertex.setMinimum(1);
        lwTargetVertex.setMaximum(5);
        plm.add((Property)lwTargetVertex);
    }

    public void applyCustomization(PropertiesListModel plm) {
        this.algoTextView.setHighlightForeground(plm.getColorProperty("algoTextHighlightForeground").getValue());
        this.algoTextView.setHighlightBackground(plm.getColorProperty("algoTextHighlightBackground").getValue());
        this.colorTransitVertex = this.config.addColor(CFGKEY_COLOR_TRANSITVERTEX, plm.getColorProperty(CFGKEY_COLOR_TRANSITVERTEX).getValue());
        this.colorSourceVertex = this.config.addColor(CFGKEY_COLOR_SOURCEVERTEX, plm.getColorProperty(CFGKEY_COLOR_SOURCEVERTEX).getValue());
        this.colorTargetVertex = this.config.addColor(CFGKEY_COLOR_TARGETVERTEX, plm.getColorProperty(CFGKEY_COLOR_TARGETVERTEX).getValue());
        this.colorHighlightedVertices = this.config.addColor(CFGKEY_COLOR_HIGHLIGHTEDVERTICES, plm.getColorProperty(CFGKEY_COLOR_HIGHLIGHTEDVERTICES).getValue());
        this.colorHighlightedEdge = this.config.addColor(CFGKEY_COLOR_HIGHLIGHTEDEDGE, plm.getColorProperty(CFGKEY_COLOR_HIGHLIGHTEDEDGE).getValue());
        this.colorSmallerDist = this.config.addColor(CFGKEY_COLOR_SMALLERDIST, plm.getColorProperty(CFGKEY_COLOR_SMALLERDIST).getValue());
        this.colorModified = this.config.addColor(CFGKEY_COLOR_MODIFIED, plm.getColorProperty(CFGKEY_COLOR_MODIFIED).getValue());
        this.lineWidthTransitVertex = this.config.addInt(CFGKEY_LINEWIDTH_TRANSITVERTEX, plm.getNumericProperty(CFGKEY_LINEWIDTH_TRANSITVERTEX).getValue().intValue());
        this.lineWidthSourceVertex = this.config.addInt(CFGKEY_LINEWIDTH_SOURCEVERTEX, plm.getNumericProperty(CFGKEY_LINEWIDTH_SOURCEVERTEX).getValue().intValue());
        this.lineWidthTargetVertex = this.config.addInt(CFGKEY_LINEWIDTH_TARGETVERTEX, plm.getNumericProperty(CFGKEY_LINEWIDTH_TARGETVERTEX).getValue().intValue());
        this.createLegend();
    }

    public ToolBarExtension[] getToolBarExtensions() {
        return new ToolBarExtension[]{this.matrixToGraph, this.randomGraph, this.circleLayoutExt};
    }

    public void save(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.save(file);
            } else if (this.pngFileFilter.accept(file)) {
                this.graphView.saveAsPNG(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE", (String)this.langID, (String)"File could not be saved!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE_TITLE", (String)this.langID, (String)"Save File"), MessageIcon.ERROR);
        }
    }

    public void open(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.load(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE", (String)this.langID, (String)"File could not be opened!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE_TITLE", (String)this.langID, (String)"Open File"), MessageIcon.ERROR);
        }
    }

    public FileNameExtensionFilter[] getSaveFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter, this.pngFileFilter};
    }

    public FileNameExtensionFilter[] getOpenFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter};
    }

    public void beforeStart(RTEvent e) {
        if (!this.isValidGraph()) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NOTVALID", (String)this.langID, (String)"The created graph is not valid!\nThe Floyd-Warshall algorithm can only be applied to directed graphs that have no circles of negative length and\nto undirected graphs that have no negative weights."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NOTVALID_TITLE", (String)this.langID, (String)"Graph not valid"), MessageIcon.INFO);
            e.doit = false;
        }
        if (e.doit) {
            this.graphView.deselectAll();
            this.graphView.setEditable(false);
            HashMap<Integer, String> labels = new HashMap<Integer, String>();
            int i = 0;
            while (i < this.graphView.getVisualVertexCount()) {
                GraphView.VisualVertex vv = this.graphView.getVisualVertex(i);
                labels.put(vv.getVertex().getIndex(), vv.getVertex().getCaption());
                ++i;
            }
            this.matrixViewD.setRowLabels(labels);
            this.matrixViewD.setColumnLabels(labels);
            this.matrixViewP.setRowLabels(labels);
            this.matrixViewP.setColumnLabels(labels);
            this.assistantTableView.reset();
            ExecutionTableColumn column = new ExecutionTableColumn("v<sub>s</sub>");
            column.setWidth(30);
            this.assistantTableView.add(column);
            column = new ExecutionTableColumn("v<sub>t</sub>");
            column.setWidth(30);
            this.assistantTableView.add(column);
            column = new ExecutionTableColumn("v<sub>z</sub>");
            column.setWidth(30);
            this.assistantTableView.add(column);
            column = new ExecutionTableColumn("d(v<sub>s</sub>,v<sub>t</sub>) + d(v<sub>t</sub>,v<sub>z</sub>) &lt; d(v<sub>s</sub>,v<sub>z</sub>)");
            column.setWidth(175);
            this.assistantTableView.add(column);
            column = new ExecutionTableColumn(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ASSISTANTTABLE_COLUMNCHANGE", (String)this.langID, (String)"Change?"));
            column.addMask(new Mask((Object)COLUMN_CHANGE_TICK, (Icon)Symbol.createLaTeXSymbol((String)"\\checkmark", (float)12.0f)));
            this.assistantTableView.add(column);
            column = new ExecutionTableColumn(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ASSISTANTTABLE_COLUMNCHANGEDIST", (String)this.langID, (String)"Change in <i>D</i>"));
            column.setWidth(75);
            this.assistantTableView.add(column);
            column = new ExecutionTableColumn(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ASSISTANTTABLE_COLUMNCHANGEPRED", (String)this.langID, (String)"Change in <i>P</i>"));
            column.setWidth(75);
            this.assistantTableView.add(column);
            ExecutionTableBorder border = new ExecutionTableBorder(2, Color.black);
            this.assistantTableView.addColumnGroup(new ExecutionTableGroup(border, 2, 1, false));
            this.assistantTableView.addColumnGroup(new ExecutionTableGroup(border, 4, 1, false));
            int vertexGroupSize = (this.graphView.getVisualVertexCount() - 1) * (this.graphView.getVisualVertexCount() - 2);
            if (vertexGroupSize > 0) {
                this.assistantTableView.addItemGroup(new ExecutionTableGroup(border, 0, vertexGroupSize, true));
            }
            if (this.rte.isExerciseModeEnabled()) {
                Random rnd = new Random();
                Set vertices = this.graphView.getGraph().getVertexSet();
                final Vertex rndSourceVertex = (Vertex)vertices.get(rnd.nextInt(vertices.size()));
                vertices.remove((Object)rndSourceVertex);
                final Vertex rndTargetVertex = (Vertex)vertices.get(rnd.nextInt(vertices.size()));
                String finalExerciseText = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"FINAL_EXERCISE", (String)this.langID, (String)"What is the shortest path from vertex &v_i& to vertex &v_j& and how long is this path?");
                finalExerciseText = finalExerciseText.replaceAll("&v_i&", rndSourceVertex.getCaption());
                finalExerciseText = finalExerciseText.replaceAll("&v_j&", rndTargetVertex.getCaption());
                this.algoText.setFinalExercise((AlgorithmExercise)new AlgorithmExercise<Object>(finalExerciseText, 3.0f){

                    protected Object[] requestSolution() {
                        SolveExerciseDialog.SolutionEntry entryPath = new SolveExerciseDialog.SolutionEntry(LanguageFile.getLabel((LanguageFile)TripelAlgorithmPlugin.this.langFile, (String)"FINAL_EXERCISE_PATH", (String)TripelAlgorithmPlugin.this.langID, (String)"Path ="), (Component)new JTextField());
                        SolveExerciseDialog.SolutionEntry entryLength = new SolveExerciseDialog.SolutionEntry(LanguageFile.getLabel((LanguageFile)TripelAlgorithmPlugin.this.langFile, (String)"FINAL_EXERCISE_LENGTH", (String)TripelAlgorithmPlugin.this.langID, (String)"Length ="), (Component)new NumericTextField());
                        if (!SolveExercisePane.showDialog((PluginHost)TripelAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryPath, entryLength}, (LanguageFile)TripelAlgorithmPlugin.this.langFile, (String)TripelAlgorithmPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)TripelAlgorithmPlugin.this.langFile, (String)"EXERCISE_HINT_SETINPUT", (String)TripelAlgorithmPlugin.this.langID, (String)"Use a comma as the delimiter!"))) {
                            return null;
                        }
                        Walk w = GraphUtils.toWalk((String)((JTextField)entryPath.getComponent()).getText(), (Graph)TripelAlgorithmPlugin.this.graphView.getGraph());
                        Number length = null;
                        try {
                            length = NumberFormat.getInstance().parse(((NumericTextField)entryLength.getComponent()).getText());
                        }
                        catch (ParseException e) {
                            length = null;
                        }
                        return new Object[]{w, length};
                    }

                    protected boolean examine(Object[] results, AlgorithmState state) {
                        Walk w = (Walk)results[0];
                        Number length = (Number)results[1];
                        Matrix D = state.getMatrix("D");
                        Matrix P = state.getMatrix("P");
                        if (w == null || length == null) {
                            return false;
                        }
                        if (length.floatValue() != ((Float)D.get(rndSourceVertex.getIndex(), rndTargetVertex.getIndex())).floatValue()) {
                            return false;
                        }
                        Graph graph = TripelAlgorithmPlugin.this.graphView.getGraph();
                        Walk idealWalk = new Walk(graph);
                        Vertex v = rndTargetVertex;
                        do {
                            idealWalk.add(0, v);
                        } while ((v = graph.getVertexByCaption((String)P.get(rndSourceVertex.getIndex(), v.getIndex()))) != rndSourceVertex);
                        idealWalk.add(0, rndSourceVertex);
                        return w.equals(idealWalk);
                    }
                });
            }
        }
    }

    public void beforeResume(RTEvent e) {
    }

    public void beforePause(RTEvent e) {
    }

    public void onStop() {
        this.graphView.setEditable(true);
        this.algoText.setFinalExercise(null);
    }

    public void onRunning() {
    }

    public void onPause() {
    }

    private AlgorithmText loadAlgorithmText() {
        int TAB_SIZE = 4;
        AlgorithmText text = new AlgorithmText();
        AlgorithmParagraph initParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_INITIALIZATION", (String)this.langID, (String)"1. Initialization:"), 1);
        AlgorithmParagraph itParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_ITERATION", (String)this.langID, (String)"2. Iteration:"), 2);
        AlgorithmStep step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP1_INITDANDP1", (String)this.langID, (String)"For all _latex{$v_i \\in V$}: set\n_latex{$d(v_i,v_i) := 0$}, _latex{$p(v_i,v_i) := v_i$}.\n"), 1);
        step.setExercise(new AlgorithmExercise<Matrix<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_SETP1", (String)this.langID, (String)"Initialize the distance matrix <i>D</i> and the predecessor matrix <i>P</i>."), 2.0f, new View[]{this.matrixViewD, this.matrixViewP}){

            protected void beforeRequestSolution(AlgorithmState state) {
                int vertexCount = TripelAlgorithmPlugin.this.graphView.getVisualVertexCount();
                TripelAlgorithmPlugin.this.matrixViewD.setMatrix((Matrix)new NumericMatrix(vertexCount, vertexCount));
                TripelAlgorithmPlugin.this.matrixViewD.setEditable(true);
                TripelAlgorithmPlugin.this.matrixViewP.setMatrix((Matrix)new ObjectMatrix(vertexCount, vertexCount));
                TripelAlgorithmPlugin.this.matrixViewP.setEditable(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                TripelAlgorithmPlugin.this.matrixViewD.setEditable(false);
                TripelAlgorithmPlugin.this.matrixViewP.setEditable(false);
            }

            protected Matrix<?>[] requestSolution() {
                return new Matrix[]{TripelAlgorithmPlugin.this.matrixViewD.getMatrix(), TripelAlgorithmPlugin.this.matrixViewP.getMatrix()};
            }

            protected boolean examine(Matrix<?>[] results, AlgorithmState state) {
                return this.doAutoExamine(state, new String[]{"D", "P"}, results);
            }
        });
        step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP2_INITDANDP2", (String)this.langID, (String)"For all _latex{$v_i,v_j \\in V$}, _latex{$i \\neq j$}: set _latex{$p(v_i,v_j) = \\begin{cases} v_i, \\; if \\; (v_i,v_j) \\in E \\\\ 0, \\; else \\end{cases}$}\n_latex{$d(v_i,v_j) = \\begin{cases} c(v_i,v_j), \\; if \\; (v_i,v_j) \\in E \\\\ \\inf, \\; else \\end{cases}$}.\n\n"), 2);
        step.setExercise(new AlgorithmExercise<Matrix<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP2", (String)this.langID, (String)"What are <i>D</i> and <i>P</i> after this step (<i>use \"-\" as infinity</i>)?"), 5.0f, new View[]{this.matrixViewD, this.matrixViewP}){

            protected void beforeRequestSolution(AlgorithmState state) {
                Matrix m = state.getMatrix("D");
                Matrix p = state.getMatrix("P");
                TripelAlgorithmPlugin.this.matrixViewD.setMatrix(m);
                TripelAlgorithmPlugin.this.matrixViewD.setEditable(true);
                TripelAlgorithmPlugin.this.matrixViewP.setMatrix(p);
                TripelAlgorithmPlugin.this.matrixViewP.setEditable(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                TripelAlgorithmPlugin.this.matrixViewD.setEditable(false);
                TripelAlgorithmPlugin.this.matrixViewP.setEditable(false);
            }

            protected Matrix<?>[] requestSolution() {
                return new Matrix[]{TripelAlgorithmPlugin.this.matrixViewD.getMatrix(), TripelAlgorithmPlugin.this.matrixViewP.getMatrix()};
            }

            protected boolean examine(Matrix<?>[] results, AlgorithmState state) {
                return this.doAutoExamine(state, new String[]{"D", "P"}, results);
            }
        });
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP3_FORALLTRANSITVERTICES", (String)this.langID, (String)"For all vertices _latex{$v_t \\in V$} (transit vertices)"), 3);
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP4_FORALLSOURCEVERTICES", (String)this.langID, (String)"For all vertices _latex{$v_s \\in V$}, _latex{$v_s \\neq v_t$} (source vertices)"), 4, 4);
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5_FORALLTARGETVERTICES", (String)this.langID, (String)"For all vertices _latex{$v_z \\in V$}, _latex{$v_z \neq v_z$}, _latex{$v_z \neq v_t$} (target vertices)"), 5, 8);
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP6_UPDATEDANDP", (String)this.langID, (String)"If _latex{$d(v_s,v_t) + d(v_t,v_z) < d(v_s,v_z)$}\n"), 6, 12);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Boolean>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP6", (String)this.langID, (String)"Is d(v<sub>s</sub>,v<sub>t</sub>) + d(v<sub>t</sub>,v<sub>z</sub>) < d(v<sub>s</sub>,v<sub>z</sub>)?"), 1.0f){
            private final String labelYes;
            private final String labelNo;
            {
                this.labelYes = LanguageFile.getLabel((LanguageFile)TripelAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP6_YES", (String)TripelAlgorithmPlugin.this.langID, (String)"Yes");
                this.labelNo = LanguageFile.getLabel((LanguageFile)TripelAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP6_NO", (String)TripelAlgorithmPlugin.this.langID, (String)"No");
            }

            protected Boolean[] requestSolution() {
                ButtonGroup group = new ButtonGroup();
                JRadioButton rdobtn1 = new JRadioButton(this.labelYes);
                JRadioButton rdobtn2 = new JRadioButton(this.labelNo);
                group.add(rdobtn1);
                group.add(rdobtn2);
                SolveExerciseDialog.SolutionEntry entryYes = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn1);
                SolveExerciseDialog.SolutionEntry entryNo = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn2);
                if (!SolveExercisePane.showDialog((PluginHost)TripelAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryYes, entryNo}, (LanguageFile)TripelAlgorithmPlugin.this.langFile, (String)TripelAlgorithmPlugin.this.langID)) {
                    return null;
                }
                return new Boolean[]{!rdobtn1.isSelected() && !rdobtn2.isSelected() ? null : Boolean.valueOf(rdobtn1.isSelected())};
            }

            protected String getResultAsString(Boolean result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return result == Boolean.TRUE ? this.labelYes : this.labelNo;
            }

            protected boolean examine(Boolean[] results, AlgorithmState state) {
                Graph graph = TripelAlgorithmPlugin.this.graphView.getGraph();
                int v_transit = state.getInt("v_transit");
                int v_source = state.getInt("v_source");
                int v_target = state.getInt("v_target");
                Matrix D = state.getMatrix("D");
                Vertex transit = graph.getVertexByID(v_transit);
                Vertex source = graph.getVertexByID(v_source);
                Vertex target = graph.getVertexByID(v_target);
                return results[0] != null && results[0] == ((Float)D.get(source.getIndex(), transit.getIndex())).floatValue() + ((Float)D.get(transit.getIndex(), target.getIndex())).floatValue() < ((Float)D.get(source.getIndex(), target.getIndex())).floatValue();
            }
        });
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP7_UPDATEDANDP", (String)this.langID, (String)"then set _latex{$d(v_s,v_z) = d(v_s,v_t) + d(v_t,v_z)$} and _latex{$p(v_s,v_z) = p(v_t,v_z)$}."), 7, 12);
        step.setExercise(new AlgorithmExercise<Matrix<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP7", (String)this.langID, (String)"What are <i>D</i> and <i>P</i> after this step?"), 1.0f, new View[]{this.matrixViewD, this.matrixViewP}){

            protected void beforeRequestSolution(AlgorithmState state) {
                Matrix m = state.getMatrix("D");
                Matrix p = state.getMatrix("P");
                TripelAlgorithmPlugin.this.matrixViewD.setMatrix(m);
                TripelAlgorithmPlugin.this.matrixViewD.setEditable(true);
                TripelAlgorithmPlugin.this.matrixViewP.setMatrix(p);
                TripelAlgorithmPlugin.this.matrixViewP.setEditable(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                TripelAlgorithmPlugin.this.matrixViewD.setEditable(false);
                TripelAlgorithmPlugin.this.matrixViewP.setEditable(false);
            }

            protected Matrix<?>[] requestSolution() {
                return new Matrix[]{TripelAlgorithmPlugin.this.matrixViewD.getMatrix(), TripelAlgorithmPlugin.this.matrixViewP.getMatrix()};
            }

            protected boolean examine(Matrix<?>[] results, AlgorithmState state) {
                return this.doAutoExamine(state, new String[]{"D", "P"}, results);
            }
        });
        return text;
    }

    private void createLegend() {
        this.legendView.removeAll();
        this.legendView.add(new LegendItem("item1", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_TRANSITVERTEX", (String)this.langID, (String)"Current transit vertex v<sub>t</sub>"), LegendItem.createCircleIcon((Color)this.colorTransitVertex, (Color)Color.black, (int)this.lineWidthTransitVertex)));
        this.legendView.add(new LegendItem("item2", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_SOURCEVERTEX", (String)this.langID, (String)"Current source vertex v<sub>s</sub>"), LegendItem.createCircleIcon((Color)this.colorSourceVertex, (Color)Color.black, (int)this.lineWidthSourceVertex)));
        this.legendView.add(new LegendItem("item3", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_TARGETVERTEX", (String)this.langID, (String)"Current target vertex v<sub>z</sub>"), LegendItem.createCircleIcon((Color)this.colorTargetVertex, (Color)Color.black, (int)this.lineWidthTargetVertex)));
        this.legendView.add(new LegendItem("item4", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_HIGHLIGHTEDV_I", (String)this.langID, (String)"Vertex v<sub>i</sub> that is currently under investigation"), LegendItem.createCircleIcon((Color)this.colorHighlightedVertices, (Color)Color.black, (int)2)));
        this.legendView.add(new LegendItem("item5", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_HIGHLIGHTEDV_J", (String)this.langID, (String)"Vertex v<sub>j</sub> that is currently under investigation"), LegendItem.createCircleIcon((Color)this.colorHighlightedVertices, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item6", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_HIGHLIGHTEDEDGE", (String)this.langID, (String)"Edge (v<sub>i</sub>, v<sub>j</sub>) that is currently under investigation"), LegendItem.createLineIcon((Color)this.colorHighlightedEdge, (int)2)));
        this.legendView.add(new LegendItem("item7", this.assistantTableView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_ASSISTANTTABLE_SMALLERDIST", (String)this.langID, (String)"Their is a shorter path taking the transit vertex"), LegendItem.createRectangleIcon((Color)this.colorSmallerDist, (Color)this.colorSmallerDist, (int)0)));
        this.legendView.add(new LegendItem("item8", this.assistantTableView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_ASSISTANTTABLE_CHANGE", (String)this.langID, (String)"Change in D or P"), LegendItem.createRectangleIcon((Color)Color.white, (Color)this.colorModified, (int)2)));
        this.legendView.add(new LegendItem("item9", this.matrixViewD.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_MATRIXD_MODIFICATION", (String)this.langID, (String)"Modification of matrix D"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
        this.legendView.add(new LegendItem("item10", this.matrixViewP.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_MATRIXP_MODIFICATION", (String)this.langID, (String)"Modification of matrix P"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
    }

    private boolean isValidGraph() {
        Graph graph = this.graphView.getGraph();
        if (graph.getType() == Type.DIRECTED) {
            NumericMatrix d = new NumericMatrix(graph.getOrder(), graph.getOrder());
            ObjectMatrix p = new ObjectMatrix(graph.getOrder(), graph.getOrder());
            GraphUtils.findShortestPaths((Graph)graph, (Matrix)d, (Matrix)p, (boolean)true);
            int i = 0;
            while (i < graph.getOrder()) {
                if (p.get(i, i) != graph.getVertex(i)) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < graph.getSize()) {
                if (graph.getEdge(i).getWeight() < 0.0f) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private class TripelRTE
    extends AlgorithmRTE {
        private Set<Integer> transits;
        private Set<Integer> sources;
        private Set<Integer> targets;
        private Matrix<Float> D;
        private Matrix<String> P;
        private int v_transit;
        private int v_source;
        private int v_target;
        private static final String P_UNDEFINED = "0";

        public TripelRTE() {
            super((AlgorithmPlugin)TripelAlgorithmPlugin.this, TripelAlgorithmPlugin.this.algoText);
        }

        protected int executeStep(int stepID, AlgorithmStateAttachment asa) throws Exception {
            Graph graph = TripelAlgorithmPlugin.this.graphView.getGraph();
            Set V = graph.getVertexByIDSet();
            int nextStep = -1;
            switch (stepID) {
                case 1: {
                    this.transits = V.clone();
                    this.D = new NumericMatrix(V.size(), V.size());
                    this.P = new ObjectMatrix(V.size(), V.size());
                    for (Integer i : V) {
                        Vertex v_i = graph.getVertexByID(i.intValue());
                        this.D.set(v_i.getIndex(), v_i.getIndex(), (Object)Float.valueOf(0.0f));
                        this.P.set(v_i.getIndex(), v_i.getIndex(), (Object)v_i.getCaption());
                    }
                    this.sleep(250L);
                    TripelAlgorithmPlugin.this.matrixViewD.setMatrix(this.D);
                    this.sleep(500L);
                    TripelAlgorithmPlugin.this.matrixViewP.setMatrix(this.P);
                    this.sleep(1000L);
                    nextStep = 2;
                    break;
                }
                case 2: {
                    for (Integer i : V) {
                        for (Integer j : V) {
                            Float elemD;
                            String elemP;
                            if (i.intValue() == j.intValue()) continue;
                            Vertex v_i = graph.getVertexByID(i.intValue());
                            GraphView.VisualVertex vv_i = TripelAlgorithmPlugin.this.graphView.getVisualVertex(v_i);
                            Vertex v_j = graph.getVertexByID(j.intValue());
                            GraphView.VisualVertex vv_j = TripelAlgorithmPlugin.this.graphView.getVisualVertex(v_j);
                            Edge e = graph.getEdge(i.intValue(), j.intValue());
                            GraphView.VisualEdge ve = e != null ? TripelAlgorithmPlugin.this.graphView.getVisualEdge(e) : null;
                            this.sleep(250L);
                            vv_i.setBackground(TripelAlgorithmPlugin.this.colorHighlightedVertices);
                            vv_i.setEdgeWidth(2);
                            vv_j.setBackground(TripelAlgorithmPlugin.this.colorHighlightedVertices);
                            TripelAlgorithmPlugin.this.graphView.repaint();
                            this.sleep(250L);
                            if (e != null) {
                                ve.setColor(TripelAlgorithmPlugin.this.colorHighlightedEdge);
                                ve.setLineWidth(2);
                                TripelAlgorithmPlugin.this.graphView.repaint();
                                this.sleep(250L);
                                elemP = v_i.getCaption();
                                elemD = Float.valueOf(e.getWeight());
                            } else {
                                elemP = P_UNDEFINED;
                                elemD = Float.valueOf(Float.POSITIVE_INFINITY);
                            }
                            this.P.set(v_i.getIndex(), v_j.getIndex(), (Object)elemP);
                            this.D.set(v_i.getIndex(), v_j.getIndex(), (Object)elemD);
                            this.sleep(250L);
                            TripelAlgorithmPlugin.this.matrixViewP.setElementBackground(v_i.getIndex(), v_j.getIndex(), TripelAlgorithmPlugin.this.colorModified);
                            TripelAlgorithmPlugin.this.matrixViewP.setMatrix(this.P);
                            this.sleep(250L);
                            TripelAlgorithmPlugin.this.matrixViewD.setElementBackground(v_i.getIndex(), v_j.getIndex(), TripelAlgorithmPlugin.this.colorModified);
                            TripelAlgorithmPlugin.this.matrixViewD.setMatrix(this.D);
                            this.sleep(250L);
                            vv_i.setBackground(GraphView.DEF_VERTEXBACKGROUND);
                            vv_i.setEdgeWidth(1);
                            vv_j.setBackground(GraphView.DEF_VERTEXBACKGROUND);
                            TripelAlgorithmPlugin.this.graphView.repaint();
                            if (ve != null) {
                                ve.setColor(GraphView.DEF_EDGECOLOR);
                                ve.setLineWidth(1);
                                TripelAlgorithmPlugin.this.graphView.repaint();
                            }
                            TripelAlgorithmPlugin.this.matrixViewP.setElementBackground(v_i.getIndex(), v_j.getIndex(), Color.white);
                            TripelAlgorithmPlugin.this.matrixViewD.setElementBackground(v_i.getIndex(), v_j.getIndex(), Color.white);
                        }
                    }
                    nextStep = 3;
                    break;
                }
                case 3: {
                    this.v_transit = 0;
                    this.v_source = 0;
                    this.v_target = 0;
                    this.sources = V.clone();
                    this.v_transit = this.forEachGetNext(this.transits, new int[0]);
                    if (this.v_transit < 1) {
                        nextStep = -1;
                        break;
                    }
                    this.sleep(250L);
                    this.visualizeVertices();
                    this.sleep(500L);
                    nextStep = 4;
                    break;
                }
                case 4: {
                    this.v_source = 0;
                    this.v_target = 0;
                    this.targets = V.clone();
                    this.v_source = this.forEachGetNext(this.sources, this.v_transit);
                    if (this.v_source < 1) {
                        nextStep = 3;
                        break;
                    }
                    this.sleep(250L);
                    this.visualizeVertices();
                    this.sleep(500L);
                    nextStep = 5;
                    break;
                }
                case 5: {
                    this.v_target = 0;
                    this.v_target = this.forEachGetNext(this.targets, this.v_transit, this.v_source);
                    if (this.v_target < 1) {
                        nextStep = 4;
                        break;
                    }
                    this.sleep(250L);
                    this.visualizeVertices();
                    this.sleep(250L);
                    Vertex transit = graph.getVertexByID(this.v_transit);
                    Vertex source = graph.getVertexByID(this.v_source);
                    Vertex target = graph.getVertexByID(this.v_target);
                    TripelAlgorithmPlugin.this.assistantTableView.add(new ExecutionTableItem((Object[])new String[]{source.getCaption(), transit.getCaption(), target.getCaption()}));
                    this.sleep(250L);
                    nextStep = 6;
                    break;
                }
                case 6: {
                    ExecutionTableItem item = TripelAlgorithmPlugin.this.assistantTableView.getLastItem();
                    Vertex transit = graph.getVertexByID(this.v_transit);
                    Vertex source = graph.getVertexByID(this.v_source);
                    Vertex target = graph.getVertexByID(this.v_target);
                    float distST = ((Float)this.D.get(source.getIndex(), transit.getIndex())).floatValue();
                    float distTZ = ((Float)this.D.get(transit.getIndex(), target.getIndex())).floatValue();
                    float distSZ = ((Float)this.D.get(source.getIndex(), target.getIndex())).floatValue();
                    float dist = distST + distTZ;
                    item.setCellObject(3, (Object)(String.valueOf(MathUtils.formatFloat((float)distST)) + " + " + MathUtils.formatFloat((float)distTZ) + " < " + MathUtils.formatFloat((float)distSZ)));
                    this.sleep(500L);
                    if (dist < distSZ) {
                        item.setCellBackground(3, TripelAlgorithmPlugin.this.colorSmallerDist);
                        this.sleep(1000L);
                        item.setCellBackground(3, Color.white);
                        nextStep = 7;
                        break;
                    }
                    item.setCellObject(4, (Object)"-");
                    item.setCellObject(5, (Object)"-");
                    item.setCellObject(6, (Object)"-");
                    this.sleep(500L);
                    nextStep = 5;
                    break;
                }
                case 7: {
                    ExecutionTableItem item = TripelAlgorithmPlugin.this.assistantTableView.getLastItem();
                    Vertex transit = graph.getVertexByID(this.v_transit);
                    Vertex source = graph.getVertexByID(this.v_source);
                    Vertex target = graph.getVertexByID(this.v_target);
                    float dist = ((Float)this.D.get(source.getIndex(), transit.getIndex())).floatValue() + ((Float)this.D.get(transit.getIndex(), target.getIndex())).floatValue();
                    String pred = (String)this.P.get(transit.getIndex(), target.getIndex());
                    item.setCellObject(4, (Object)TripelAlgorithmPlugin.COLUMN_CHANGE_TICK);
                    this.sleep(500L);
                    item.setCellBorder(5, TripelAlgorithmPlugin.this.colorModified, 2);
                    this.sleep(250L);
                    item.setCellObject(5, (Object)("d(" + source.getCaption() + "," + target.getCaption() + ")=" + MathUtils.formatFloat((float)dist)));
                    this.sleep(250L);
                    item.setCellBorder(5, null);
                    this.sleep(250L);
                    item.setCellBorder(6, TripelAlgorithmPlugin.this.colorModified, 2);
                    this.sleep(250L);
                    item.setCellObject(6, (Object)("p(" + source.getCaption() + "," + target.getCaption() + ")=" + pred));
                    this.sleep(250L);
                    item.setCellBorder(6, null);
                    this.sleep(500L);
                    this.D.set(source.getIndex(), target.getIndex(), (Object)Float.valueOf(dist));
                    this.P.set(source.getIndex(), target.getIndex(), (Object)pred);
                    TripelAlgorithmPlugin.this.matrixViewD.setElementBackground(source.getIndex(), target.getIndex(), TripelAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    TripelAlgorithmPlugin.this.matrixViewD.setMatrix(this.D);
                    this.sleep(250L);
                    TripelAlgorithmPlugin.this.matrixViewD.setElementBackground(source.getIndex(), target.getIndex(), Color.white);
                    TripelAlgorithmPlugin.this.matrixViewP.setElementBackground(source.getIndex(), target.getIndex(), TripelAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    TripelAlgorithmPlugin.this.matrixViewP.setMatrix(this.P);
                    this.sleep(250L);
                    TripelAlgorithmPlugin.this.matrixViewP.setElementBackground(source.getIndex(), target.getIndex(), Color.white);
                    this.sleep(500L);
                    nextStep = 5;
                }
            }
            return nextStep;
        }

        protected void storeState(AlgorithmState state) {
            state.addSet("transits", this.transits);
            state.addSet("sources", this.sources);
            state.addSet("targets", this.targets);
            state.addMatrix("D", this.D);
            state.addMatrix("P", this.P);
            state.addInt("v_transit", this.v_transit);
            state.addInt("v_source", this.v_source);
            state.addInt("v_target", this.v_target);
        }

        protected void restoreState(AlgorithmState state) {
            this.transits = state.getSet("transits");
            this.sources = state.getSet("sources");
            this.targets = state.getSet("targets");
            this.D = state.getMatrix("D");
            this.P = state.getMatrix("P");
            this.v_transit = state.getInt("v_transit");
            this.v_source = state.getInt("v_source");
            this.v_target = state.getInt("v_target");
        }

        protected void createInitialState(AlgorithmState state) {
            this.transits = state.addSet("transits", new Set());
            this.sources = state.addSet("sources", new Set());
            this.targets = state.addSet("targets", new Set());
            this.D = state.addMatrix("D", (Matrix)new NumericMatrix(1, 1));
            this.P = state.addMatrix("P", (Matrix)new ObjectMatrix(1, 1));
            this.v_transit = state.addInt("v_transit", 0);
            this.v_source = state.addInt("v_source", 0);
            this.v_target = state.addInt("v_target", 0);
        }

        protected void rollBackStep(int stepID, int nextStepID) {
            if (stepID == 1 || stepID == 2 || stepID == 7) {
                TripelAlgorithmPlugin.this.matrixViewD.setMatrix(this.D);
                TripelAlgorithmPlugin.this.matrixViewP.setMatrix(this.P);
            } else if (stepID == 5 && nextStepID == 6) {
                TripelAlgorithmPlugin.this.assistantTableView.remove(TripelAlgorithmPlugin.this.assistantTableView.getLastItem());
            } else if (stepID == 6 || stepID == 7) {
                int start;
                ExecutionTableItem item = TripelAlgorithmPlugin.this.assistantTableView.getLastItem();
                int i = start = stepID == 6 ? 3 : 4;
                while (i <= 6) {
                    item.setCellObject(i, null);
                    ++i;
                }
            }
            this.visualizeVertices();
        }

        protected void adoptState(int stepID, AlgorithmState state) {
        }

        protected View[] getViews() {
            return new View[]{TripelAlgorithmPlugin.this.graphView, TripelAlgorithmPlugin.this.matrixViewD, TripelAlgorithmPlugin.this.matrixViewP, TripelAlgorithmPlugin.this.assistantTableView};
        }

        private void visualizeVertices() {
            TripelAlgorithmPlugin.this.graphView.resetVisualAppearance();
            GraphView.VisualVertex vv = TripelAlgorithmPlugin.this.graphView.getVisualVertexByID(this.v_transit);
            if (vv != null) {
                vv.setBackground(TripelAlgorithmPlugin.this.colorTransitVertex);
                vv.setEdgeWidth(TripelAlgorithmPlugin.this.lineWidthTransitVertex);
            }
            if ((vv = TripelAlgorithmPlugin.this.graphView.getVisualVertexByID(this.v_source)) != null) {
                vv.setBackground(TripelAlgorithmPlugin.this.colorSourceVertex);
                vv.setEdgeWidth(TripelAlgorithmPlugin.this.lineWidthSourceVertex);
            }
            if ((vv = TripelAlgorithmPlugin.this.graphView.getVisualVertexByID(this.v_target)) != null) {
                vv.setBackground(TripelAlgorithmPlugin.this.colorTargetVertex);
                vv.setEdgeWidth(TripelAlgorithmPlugin.this.lineWidthTargetVertex);
            }
            TripelAlgorithmPlugin.this.graphView.repaint();
        }

        private int forEachGetNext(Set<Integer> set, int ... without) {
            int next = 0;
            if (without != null) {
                int[] nArray = without;
                int n = without.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    set.remove((Object)i);
                    ++n2;
                }
            }
            if (set.size() > 0) {
                next = (Integer)set.get(0);
                set.remove((Object)next);
            }
            return next;
        }
    }
}

