/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.CircleLayoutToolBarExtension;
import lavesdk.algorithm.plugin.extensions.MatrixToGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.RandomGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.AlgorithmTextView;
import lavesdk.algorithm.plugin.views.DefaultGraphView;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.LegendView;
import lavesdk.algorithm.plugin.views.TextAreaView;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.configuration.Configuration;
import lavesdk.gui.dialogs.SolveExerciseDialog;
import lavesdk.gui.dialogs.SolveExercisePane;
import lavesdk.gui.dialogs.enums.AllowedGraphType;
import lavesdk.gui.widgets.BooleanProperty;
import lavesdk.gui.widgets.BooleanPropertyGroup;
import lavesdk.gui.widgets.ColorProperty;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.MultiGraph;
import lavesdk.math.graph.Trail;
import lavesdk.math.graph.TrailByID;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.Walk;
import lavesdk.serialization.Serializer;
import lavesdk.utils.GraphUtils;

public class EulerianCycleAlgorithmPlugin
implements AlgorithmPlugin {
    private PluginHost host;
    private Configuration config;
    private LanguageFile langFile;
    private String langID;
    private FileNameExtensionFilter vgfFileFilter;
    private FileNameExtensionFilter pngFileFilter;
    private AlgorithmText algoText;
    private DefaultGraphView graphView;
    private AlgorithmTextView algoTextView;
    private TextAreaView cycleWView;
    private TextAreaView cycleW_ApoView;
    private LegendView legendView;
    private EulerianCycleRTE rte;
    private MatrixToGraphToolBarExtension<Vertex, Edge> matrixToGraph;
    private RandomGraphToolBarExtension<Vertex, Edge> randomGraph;
    private CircleLayoutToolBarExtension<Vertex, Edge> circleLayoutExt;
    private String creatorPrefsDirected;
    private String creatorPrefsUndirected;
    private boolean creatorPrefsDirectedValue;
    private ViewGroup ab;
    private ViewGroup de;
    private ViewGroup cde;
    private ViewGroup abcde;
    private Color colorModified;
    private Color colorV1;
    private Color colorV_k;
    private Color colorW;
    private Color colorW_Apostrophe;
    private int lineWidthV1;
    private int lineWidthV_k;
    private int lineWidthW;
    private int lineWidthW_Apostrophe;
    private static final String CFGKEY_CREATORPROP_DIRECTED = "creatorPropDirected";
    private static final String CFGKEY_COLOR_MODIFIED = "colorModified";
    private static final String CFGKEY_COLOR_V1 = "colorV1";
    private static final String CFGKEY_COLOR_V_k = "colorV_k";
    private static final String CFGKEY_COLOR_W = "colorW";
    private static final String CFGKEY_COLOR_W_APOSTROPHE = "colorW'";
    private static final String CFGKEY_LINEWIDTH_V1 = "lineWidthV1";
    private static final String CFGKEY_LINEWIDTH_V_k = "lineWidthV_k";
    private static final String CFGKEY_LINEWIDTH_W = "lineWidthW";
    private static final String CFGKEY_LINEWIDTH_W_APOSTROPHE = "lineWidthW'";

    public void initialize(PluginHost host, ResourceLoader resLoader, Configuration config) {
        try {
            this.langFile = new LanguageFile(resLoader.getResourceAsStream("main/resources/langEulerianCycle.txt"));
            this.langFile.include(host.getLanguageFile());
        }
        catch (IOException e) {
            this.langFile = null;
        }
        this.langID = host.getLanguageID();
        this.host = host;
        this.config = config != null ? config : new Configuration();
        this.vgfFileFilter = new FileNameExtensionFilter("Visual Graph File (*.vgf)", "vgf");
        this.pngFileFilter = new FileNameExtensionFilter("Portable Network Graphic (*.png)", "png");
        this.graphView = new DefaultGraphView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_GRAPH_TITLE", (String)this.langID, (String)"Graph"), (Graph)new MultiGraph(false), null, true, this.langFile, this.langID);
        this.cycleWView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_CYCLE_W_TITLE", (String)this.langID, (String)"Cycle W'"), true, this.langFile, this.langID);
        this.cycleW_ApoView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_CYCLE_W_APOSTROPHE_TITLE", (String)this.langID, (String)"Cycle W'"), true, this.langFile, this.langID);
        this.algoText = this.loadAlgorithmText();
        this.algoTextView = new AlgorithmTextView(host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ALGOTEXT_TITLE", (String)this.langID, (String)"Algorithm"), this.algoText, true, this.langFile, this.langID);
        this.legendView = new LegendView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LEGEND_TITLE", (String)this.langID, (String)"Legend"), true, this.langFile, this.langID);
        this.rte = new EulerianCycleRTE();
        this.matrixToGraph = new MatrixToGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.BOTH, this.langFile, this.langID, true);
        this.randomGraph = new RandomGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.BOTH, this.langFile, this.langID, false);
        this.circleLayoutExt = new CircleLayoutToolBarExtension((GraphView)this.graphView, this.langFile, this.langID, true);
        this.creatorPrefsDirected = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_DIRECTED", (String)this.langID, (String)"directed");
        this.creatorPrefsUndirected = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_UNDIRECTED", (String)this.langID, (String)"undirected");
        this.algoTextView.setAutoRepaint(true);
        this.cycleWView.setAutoRepaint(true);
        this.cycleW_ApoView.setAutoRepaint(true);
        this.creatorPrefsDirectedValue = this.config.getBoolean(CFGKEY_CREATORPROP_DIRECTED, false);
        this.colorModified = this.config.getColor(CFGKEY_COLOR_MODIFIED, new Color(255, 180, 130));
        this.colorV1 = this.config.getColor(CFGKEY_COLOR_V1, new Color(85, 150, 190));
        this.colorV_k = this.config.getColor(CFGKEY_COLOR_V_k, new Color(255, 220, 80));
        this.colorW = this.config.getColor(CFGKEY_COLOR_W, new Color(25, 90, 140));
        this.colorW_Apostrophe = this.config.getColor(CFGKEY_COLOR_W_APOSTROPHE, new Color(255, 220, 80));
        this.lineWidthV1 = this.config.getInt(CFGKEY_LINEWIDTH_V1, 2);
        this.lineWidthV_k = this.config.getInt(CFGKEY_LINEWIDTH_V_k, 1);
        this.lineWidthW = this.config.getInt(CFGKEY_LINEWIDTH_W, 3);
        this.lineWidthW_Apostrophe = this.config.getInt(CFGKEY_LINEWIDTH_W_APOSTROPHE, 2);
        this.graphView.loadConfiguration(config, "graphView");
        this.algoTextView.loadConfiguration(config, "algoTextView");
        this.cycleWView.loadConfiguration(config, "cycleView");
        this.cycleW_ApoView.loadConfiguration(config, "cycleW_ApoView");
        this.legendView.loadConfiguration(config, "legendView");
        this.createLegend();
    }

    public String getName() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_NAME", (String)this.langID, (String)"Eulerian cycle algorithm");
    }

    public String getDescription() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_DESC", (String)this.langID, (String)"Finds an Eulerian cycle in an Eulerian graph.");
    }

    public String getType() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_TYPE", (String)this.langID, (String)"Exact algorithm");
    }

    public String getAuthor() {
        return "Jan Dornseifer";
    }

    public String getAuthorContact() {
        return "jan.dornseifer@student.uni-siegen.de";
    }

    public String getAssumptions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_ASSUMPTIONS", (String)this.langID, (String)"A connected Eulerian graph <i>G = (V, E)</i>.");
    }

    public String getProblemAffiliation() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_PROBLEMAFFILIATION", (String)this.langID, (String)"Chinese postman problem");
    }

    public String getSubject() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_SUBJECT", (String)this.langID, (String)"Logistics");
    }

    public String getInstructions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_INSTRUCTIONS", (String)this.langID, (String)"<b>Creating problem entities</b>:<br>Create your own graph and make sure that the graph complies with the assumptions of the algorithm. You can use<br>the toolbar extension to create a graph by use of an adjacency matrix.<br><br><b>Exercise Mode</b>:<br>Activate the exercise mode to practice the algorithm in an interactive way. After you have started the algorithm<br>exercises are presented that you have to solve.<br>If an exercise can be solved directly in a view of the algorithm the corresponding view is highlighted with a border, there you can<br>enter your solution and afterwards you have to press the button to solve the exercise. Otherwise (if an exercise is not related to a specific<br>view) you can directly press the button to solve the exercise which opens a dialog where you can enter your solution of the exercise.");
    }

    public String getVersion() {
        return "1.4";
    }

    public LAVESDKV getUsedSDKVersion() {
        return new LAVESDKV(1, 4);
    }

    public AlgorithmRTE getRuntimeEnvironment() {
        return this.rte;
    }

    public AlgorithmText getText() {
        return this.algoText.getBaseCopy();
    }

    public boolean hasExerciseMode() {
        return true;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean hasCreatorPreferences() {
        return true;
    }

    public void loadCreatorPreferences(PropertiesListModel plm) {
        BooleanPropertyGroup group = new BooleanPropertyGroup(plm);
        plm.add((Property)new BooleanProperty(this.creatorPrefsDirected, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_DIRECTED_DESC", (String)this.langID, (String)"Apply algorithm to a directed graph"), this.creatorPrefsDirectedValue, group));
        plm.add((Property)new BooleanProperty(this.creatorPrefsUndirected, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_UNDIRECTED_DESC", (String)this.langID, (String)"Apply algorithm to an undirected graph"), !this.creatorPrefsDirectedValue, group));
    }

    public void onCreate(ViewContainer container, PropertiesListModel creatorProperties) {
        this.creatorPrefsDirectedValue = creatorProperties != null ? creatorProperties.getBooleanProperty(this.creatorPrefsDirected).getValue() : false;
        this.config.addBoolean(CFGKEY_CREATORPROP_DIRECTED, this.creatorPrefsDirectedValue);
        this.graphView.setGraph((Graph)new MultiGraph(this.creatorPrefsDirectedValue));
        this.graphView.repaint();
        this.matrixToGraph.setAllowedGraphType(this.creatorPrefsDirectedValue ? AllowedGraphType.DIRECTED_ONLY : AllowedGraphType.UNDIRECTED_ONLY);
        this.randomGraph.setAllowedGraphType(this.creatorPrefsDirectedValue ? AllowedGraphType.DIRECTED_ONLY : AllowedGraphType.UNDIRECTED_ONLY);
        this.ab = new ViewGroup(1);
        this.de = new ViewGroup(0);
        this.cde = new ViewGroup(1);
        this.abcde = new ViewGroup(0);
        this.ab.add((Component)this.algoTextView);
        this.ab.add((Component)this.legendView);
        this.ab.restoreWeights((Serializer)this.config, "weights_ab", new float[]{0.6f, 0.4f});
        this.de.add((Component)this.cycleWView);
        this.de.add((Component)this.cycleW_ApoView);
        this.de.restoreWeights((Serializer)this.config, "weights_de", new float[]{0.6f, 0.4f});
        this.cde.add((Component)this.graphView);
        this.cde.add((Component)this.de);
        this.cde.restoreWeights((Serializer)this.config, "weights_cde", new float[]{0.7f, 0.3f});
        this.abcde.add((Component)this.ab);
        this.abcde.add((Component)this.cde);
        this.abcde.restoreWeights((Serializer)this.config, "weights_abcde", new float[]{0.4f, 0.6f});
        container.setLayout((LayoutManager)new BorderLayout());
        container.add((Component)this.abcde, (Object)"Center");
    }

    public void onClose() {
        this.graphView.saveConfiguration(this.config, "graphView");
        this.algoTextView.saveConfiguration(this.config, "algoTextView");
        this.cycleWView.saveConfiguration(this.config, "cycleView");
        this.cycleW_ApoView.saveConfiguration(this.config, "cycleW_ApoView");
        this.legendView.saveConfiguration(this.config, "legendView");
        if (this.ab != null) {
            this.ab.storeWeights((Serializer)this.config, "weights_ab");
        }
        if (this.de != null) {
            this.de.storeWeights((Serializer)this.config, "weights_de");
        }
        if (this.cde != null) {
            this.cde.storeWeights((Serializer)this.config, "weights_cde");
        }
        if (this.abcde != null) {
            this.abcde.storeWeights((Serializer)this.config, "weights_abcde");
        }
        this.graphView.reset();
        this.cycleWView.reset();
        this.cycleW_ApoView.reset();
    }

    public boolean hasCustomization() {
        return true;
    }

    public void loadCustomization(PropertiesListModel plm) {
        plm.add((Property)new ColorProperty("algoTextHighlightForeground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTFOREGROUND", (String)this.langID, (String)"Foreground color of the current step in the algorithm"), this.algoTextView.getHighlightForeground()));
        plm.add((Property)new ColorProperty("algoTextHighlightBackground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTBACKGROUND", (String)this.langID, (String)"Background color of the current step in the algorithm"), this.algoTextView.getHighlightBackground()));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_V1, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_V1", (String)this.langID, (String)"Background color of the vertex v<sub>1</sub>"), this.colorV1));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_V_k, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_V_k", (String)this.langID, (String)"Background color of the vertex v<sub>k</sub>"), this.colorV_k));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_W, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_W", (String)this.langID, (String)"Color of the cycle W"), this.colorW));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_W_APOSTROPHE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_W_APOSTROPHE", (String)this.langID, (String)"Color of the cycle W'"), this.colorW_Apostrophe));
        NumericProperty lwV1 = new NumericProperty(CFGKEY_LINEWIDTH_V1, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_V1", (String)this.langID, (String)"Line width of the vertex v<sub>1</sub>"), (Number)this.lineWidthV1, true);
        lwV1.setMinimum(1);
        lwV1.setMaximum(5);
        plm.add((Property)lwV1);
        NumericProperty lwV_k = new NumericProperty(CFGKEY_LINEWIDTH_V_k, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_V_k", (String)this.langID, (String)"Line width of the vertex v<sub>k</sub>"), (Number)this.lineWidthV_k, true);
        lwV_k.setMinimum(1);
        lwV_k.setMaximum(5);
        plm.add((Property)lwV_k);
        NumericProperty lwW = new NumericProperty(CFGKEY_LINEWIDTH_W, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_W", (String)this.langID, (String)"Line width of the cycle W"), (Number)this.lineWidthW, true);
        lwW.setMinimum(1);
        lwW.setMaximum(5);
        plm.add((Property)lwW);
        NumericProperty lwW_Apostrophe = new NumericProperty(CFGKEY_LINEWIDTH_W_APOSTROPHE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_W_APOSTROPHE", (String)this.langID, (String)"Line width of the cycle W'"), (Number)this.lineWidthW_Apostrophe, true);
        lwW_Apostrophe.setMinimum(1);
        lwW_Apostrophe.setMaximum(5);
        plm.add((Property)lwW_Apostrophe);
    }

    public void applyCustomization(PropertiesListModel plm) {
        this.algoTextView.setHighlightForeground(plm.getColorProperty("algoTextHighlightForeground").getValue());
        this.algoTextView.setHighlightBackground(plm.getColorProperty("algoTextHighlightBackground").getValue());
        this.colorV1 = this.config.addColor(CFGKEY_COLOR_V1, plm.getColorProperty(CFGKEY_COLOR_V1).getValue());
        this.colorV_k = this.config.addColor(CFGKEY_COLOR_V_k, plm.getColorProperty(CFGKEY_COLOR_V_k).getValue());
        this.colorW = this.config.addColor(CFGKEY_COLOR_W, plm.getColorProperty(CFGKEY_COLOR_W).getValue());
        this.colorW_Apostrophe = this.config.addColor(CFGKEY_COLOR_W_APOSTROPHE, plm.getColorProperty(CFGKEY_COLOR_W_APOSTROPHE).getValue());
        this.lineWidthV1 = this.config.addInt(CFGKEY_LINEWIDTH_V1, plm.getNumericProperty(CFGKEY_LINEWIDTH_V1).getValue().intValue());
        this.lineWidthV_k = this.config.addInt(CFGKEY_LINEWIDTH_V_k, plm.getNumericProperty(CFGKEY_LINEWIDTH_V_k).getValue().intValue());
        this.lineWidthW = this.config.addInt(CFGKEY_LINEWIDTH_W, plm.getNumericProperty(CFGKEY_LINEWIDTH_W).getValue().intValue());
        this.lineWidthW_Apostrophe = this.config.addInt(CFGKEY_LINEWIDTH_W_APOSTROPHE, plm.getNumericProperty(CFGKEY_LINEWIDTH_W_APOSTROPHE).getValue().intValue());
        this.createLegend();
    }

    public ToolBarExtension[] getToolBarExtensions() {
        return new ToolBarExtension[]{this.matrixToGraph, this.randomGraph, this.circleLayoutExt};
    }

    public void save(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.save(file);
            } else if (this.pngFileFilter.accept(file)) {
                this.graphView.saveAsPNG(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE", (String)this.langID, (String)"File could not be saved!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE_TITLE", (String)this.langID, (String)"Save File"), MessageIcon.ERROR);
        }
    }

    public void open(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.load(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE", (String)this.langID, (String)"File could not be opened!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE_TITLE", (String)this.langID, (String)"Open File"), MessageIcon.ERROR);
        }
    }

    public FileNameExtensionFilter[] getSaveFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter, this.pngFileFilter};
    }

    public FileNameExtensionFilter[] getOpenFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter};
    }

    public void beforeStart(RTEvent e) {
        if (!GraphUtils.isEulerian((Graph)this.graphView.getGraph())) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NOTEULERIAN", (String)this.langID, (String)"The created graph is not eulerian!%nThe algorithm can only be applied to Eulerian graphs."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NOTEULERIAN_TITLE", (String)this.langID, (String)"No Eulerian graph"), MessageIcon.INFO);
            e.doit = false;
        }
        if (e.doit) {
            this.graphView.setEditable(false);
            this.graphView.deselectAll();
            this.cycleWView.reset();
            this.cycleW_ApoView.reset();
        }
    }

    public void beforeResume(RTEvent e) {
    }

    public void beforePause(RTEvent e) {
    }

    public void onStop() {
        this.graphView.setEditable(true);
    }

    public void onRunning() {
    }

    public void onPause() {
    }

    private AlgorithmText loadAlgorithmText() {
        AlgorithmText text = new AlgorithmText();
        AlgorithmParagraph initParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_INITIALIZATION", (String)this.langID, (String)"1. Initialization:"), 1);
        AlgorithmParagraph stopParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_STOPCRITERION", (String)this.langID, (String)"2. Stop criterion:"), 2);
        AlgorithmParagraph addParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_ADDITIONALCYCLE", (String)this.langID, (String)"3. Additional cycle:"), 3);
        AlgorithmParagraph enlargeParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_ENLARGMENT", (String)this.langID, (String)"4. Enlargment:"), 4);
        AlgorithmStep step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP1_INIT", (String)this.langID, (String)"Choose a _latex{$v_1 \\in V$}.\n"), 1);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Integer>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP1", (String)this.langID, (String)"Select a vertex <i>v<sub>1</sub></i>."), 1.0f, (View)this.graphView){

            protected void beforeRequestSolution(AlgorithmState state) {
                EulerianCycleAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.VERTICES_ONLY);
                EulerianCycleAlgorithmPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                EulerianCycleAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.BOTH);
                EulerianCycleAlgorithmPlugin.this.graphView.setShowCursorToolAlways(false);
                EulerianCycleAlgorithmPlugin.this.graphView.deselectAll();
            }

            protected Integer[] requestSolution() {
                if (EulerianCycleAlgorithmPlugin.this.graphView.getSelectedVertexCount() != 1) {
                    return null;
                }
                return new Integer[]{EulerianCycleAlgorithmPlugin.this.graphView.getSelectedVertex(0).getVertex().getID()};
            }

            protected String getResultAsString(Integer result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return EulerianCycleAlgorithmPlugin.this.graphView.getVisualVertexByID(result.intValue()).getVertex().getCaption();
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, Integer[] solutions) {
                state.addInt("v1", solutions[0].intValue());
            }

            protected boolean examine(Integer[] results, AlgorithmState state) {
                return true;
            }
        });
        step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP2_INIT", (String)this.langID, (String)"Find a cycle _latex{$W$} ensuing from _latex{$v_1$}.\n\n"), 2);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<String>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP2", (String)this.langID, (String)"Specify a cycle <i>W</i>."), 1.0f){

            protected String[] requestSolution() {
                SolveExerciseDialog.SolutionEntry entry = new SolveExerciseDialog.SolutionEntry("W=", (Component)new JTextField());
                if (!SolveExercisePane.showDialog((PluginHost)EulerianCycleAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entry}, (LanguageFile)EulerianCycleAlgorithmPlugin.this.langFile, (String)EulerianCycleAlgorithmPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)EulerianCycleAlgorithmPlugin.this.langFile, (String)"EXERCISE_HINT_CYCLEINPUT", (String)EulerianCycleAlgorithmPlugin.this.langID, (String)"Use a comma as the delimiter!<br>Enter the cycle in the following form: v<sub>i</sub>, v<sub>j</sub>, v<sub>k</sub>, ..., v<sub>i</sub>."))) {
                    return null;
                }
                return new String[]{((JTextField)entry.getComponent()).getText()};
            }

            protected String getResultAsString(String result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                if (result.startsWith("(") && result.endsWith(")")) {
                    return "W=" + result;
                }
                return "W=(" + result + ")";
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, String[] solutions) {
                state.addTrail("W", GraphUtils.toTrail((String)solutions[0], (Graph)EulerianCycleAlgorithmPlugin.this.graphView.getGraph(), null).cast());
            }

            protected boolean examine(String[] results, AlgorithmState state) {
                Trail t = GraphUtils.toTrail((String)results[0], (Graph)EulerianCycleAlgorithmPlugin.this.graphView.getGraph(), null);
                return t != null && t.isClosed();
            }
        });
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP3_STOP", (String)this.langID, (String)"If _latex{$W$} contains all edges of _latex{$G$} then stop.\n"), 3);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Boolean>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP3", (String)this.langID, (String)"Will the algorithm stop?"), 1.0f){
            private final String labelYes;
            private final String labelNo;
            {
                this.labelYes = LanguageFile.getLabel((LanguageFile)EulerianCycleAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP3_YES", (String)EulerianCycleAlgorithmPlugin.this.langID, (String)"Yes");
                this.labelNo = LanguageFile.getLabel((LanguageFile)EulerianCycleAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP3_NO", (String)EulerianCycleAlgorithmPlugin.this.langID, (String)"No");
            }

            protected Boolean[] requestSolution() {
                ButtonGroup group = new ButtonGroup();
                JRadioButton rdobtn1 = new JRadioButton(this.labelYes);
                JRadioButton rdobtn2 = new JRadioButton(this.labelNo);
                group.add(rdobtn1);
                group.add(rdobtn2);
                SolveExerciseDialog.SolutionEntry entryYes = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn1);
                SolveExerciseDialog.SolutionEntry entryNo = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn2);
                if (!SolveExercisePane.showDialog((PluginHost)EulerianCycleAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryYes, entryNo}, (LanguageFile)EulerianCycleAlgorithmPlugin.this.langFile, (String)EulerianCycleAlgorithmPlugin.this.langID)) {
                    return null;
                }
                return new Boolean[]{!rdobtn1.isSelected() && !rdobtn2.isSelected() ? null : Boolean.valueOf(rdobtn1.isSelected())};
            }

            protected String getResultAsString(Boolean result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return result == Boolean.TRUE ? this.labelYes : this.labelNo;
            }

            protected boolean examine(Boolean[] results, AlgorithmState state) {
                Graph graph = EulerianCycleAlgorithmPlugin.this.graphView.getGraph();
                TrailByID t = state.getTrail("W", graph);
                return t != null && results[0] != null && t.length() == graph.getSize() == results[0];
            }
        });
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP4_STOP", (String)this.langID, (String)"Otherwise find a vertex _latex{$v_k$} that is endpoint of at least two edges, one of them is contained in _latex{$W$} and one of them not.\n\n"), 4);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Integer>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP4", (String)this.langID, (String)"Find a vertex <i>v<sub>k</sub></i> (<i>select the vertex in the graph</i>)."), 1.0f, (View)this.graphView){

            protected void beforeRequestSolution(AlgorithmState state) {
                EulerianCycleAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.VERTICES_ONLY);
                EulerianCycleAlgorithmPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                EulerianCycleAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.BOTH);
                EulerianCycleAlgorithmPlugin.this.graphView.setShowCursorToolAlways(false);
                EulerianCycleAlgorithmPlugin.this.graphView.deselectAll();
            }

            protected Integer[] requestSolution() {
                if (EulerianCycleAlgorithmPlugin.this.graphView.getSelectedVertexCount() != 1) {
                    return null;
                }
                return new Integer[]{EulerianCycleAlgorithmPlugin.this.graphView.getSelectedVertex(0).getVertex().getID()};
            }

            protected String getResultAsString(Integer result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return EulerianCycleAlgorithmPlugin.this.graphView.getVisualVertexByID(result.intValue()).getVertex().getCaption();
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, Integer[] solutions) {
                state.addInt("v_k", solutions[0].intValue());
            }

            protected boolean examine(Integer[] results, AlgorithmState state) {
                Graph graph = EulerianCycleAlgorithmPlugin.this.graphView.getGraph();
                TrailByID t = state.getTrail("W", graph);
                Vertex v_k = graph.getVertexByID(results[0].intValue());
                boolean contained = false;
                boolean notContained = false;
                int i = 0;
                while (i < v_k.getOutgoingEdgeCount()) {
                    boolean contains = t.contains(v_k.getOutgoingEdge(i));
                    contained = contained || contains;
                    notContained = notContained || !contains;
                    ++i;
                }
                return contained && notContained;
            }
        });
        step = new AlgorithmStep(addParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5_ADDITIONALCYCLE", (String)this.langID, (String)"Find a cycle _latex{$W'$} ensuing from _latex{$v_1$} that does not contain any edge of _latex{$W$}.\n\n"), 5);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<String>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP5", (String)this.langID, (String)"Specify a cycle <i>W'</i>."), 1.0f){
            private Trail<Vertex> W_Apo;
            {
                this.W_Apo = null;
            }

            protected String[] requestSolution() {
                SolveExerciseDialog.SolutionEntry entry = new SolveExerciseDialog.SolutionEntry("W'=", (Component)new JTextField());
                if (!SolveExercisePane.showDialog((PluginHost)EulerianCycleAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entry}, (LanguageFile)EulerianCycleAlgorithmPlugin.this.langFile, (String)EulerianCycleAlgorithmPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)EulerianCycleAlgorithmPlugin.this.langFile, (String)"EXERCISE_HINT_CYCLEINPUT", (String)EulerianCycleAlgorithmPlugin.this.langID, (String)"Use a comma as the delimiter!<br>Enter the cycle in the following form: v<sub>i</sub>, v<sub>j</sub>, v<sub>k</sub>, ..., v<sub>i</sub>."))) {
                    return null;
                }
                return new String[]{((JTextField)entry.getComponent()).getText()};
            }

            protected String getResultAsString(String result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                if (result.startsWith("(") && result.endsWith(")")) {
                    return "W'=" + result;
                }
                return "W'=(" + result + ")";
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, String[] solutions) {
                state.addTrail("W_Apo", this.W_Apo.cast());
                this.W_Apo = null;
            }

            protected boolean examine(String[] results, AlgorithmState state) {
                Graph graph = EulerianCycleAlgorithmPlugin.this.graphView.getGraph();
                int v_k = state.getInt("v_k");
                TrailByID w = state.getTrail("W", graph);
                this.W_Apo = GraphUtils.toTrail((String)results[0], (Graph)EulerianCycleAlgorithmPlugin.this.graphView.getGraph(), (Trail)w.cast());
                if (this.W_Apo == null || this.W_Apo.length() < 1) {
                    return false;
                }
                if (this.W_Apo.get(0).getID() != v_k || !this.W_Apo.isClosed()) {
                    return false;
                }
                int i = 0;
                while (i < this.W_Apo.length()) {
                    if (w.contains(this.W_Apo.getEdge(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        });
        step = new AlgorithmStep(enlargeParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP6_ENLARGMENT", (String)this.langID, (String)"Enlarge the cycle _latex{$W$} by inserting the cycle _latex{$W'$} at the position of _latex{$v_k$}.\n"), 6);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<String>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP6", (String)this.langID, (String)"What is <i>W</i> after this step?"), 1.0f){

            protected String[] requestSolution() {
                SolveExerciseDialog.SolutionEntry entry = new SolveExerciseDialog.SolutionEntry("W=", (Component)new JTextField());
                if (!SolveExercisePane.showDialog((PluginHost)EulerianCycleAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entry}, (LanguageFile)EulerianCycleAlgorithmPlugin.this.langFile, (String)EulerianCycleAlgorithmPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)EulerianCycleAlgorithmPlugin.this.langFile, (String)"EXERCISE_HINT_CYCLEINPUT", (String)EulerianCycleAlgorithmPlugin.this.langID, (String)"Use a comma as the delimiter!<br>Enter the cycle in the following form: v<sub>i</sub>, v<sub>j</sub>, v<sub>k</sub>, ..., v<sub>i</sub>."))) {
                    return null;
                }
                return new String[]{((JTextField)entry.getComponent()).getText()};
            }

            protected String getResultAsString(String result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                if (result.startsWith("(") && result.endsWith(")")) {
                    return "W=" + result;
                }
                return "W=(" + result + ")";
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, String[] solutions) {
                state.addTrail("W", GraphUtils.toTrail((String)solutions[0], (Graph)EulerianCycleAlgorithmPlugin.this.graphView.getGraph(), null).cast());
            }

            protected boolean examine(String[] results, AlgorithmState state) {
                Graph graph = EulerianCycleAlgorithmPlugin.this.graphView.getGraph();
                Trail t = GraphUtils.toTrail((String)results[0], (Graph)EulerianCycleAlgorithmPlugin.this.graphView.getGraph(), null);
                Trail w = state.getTrail("W", graph).cast();
                Trail w_apo = state.getTrail("W_Apo", graph).cast();
                Vertex start = w_apo.get(0);
                int possibilities = 0;
                if (t == null) {
                    return false;
                }
                int i = 0;
                while (i <= w.length()) {
                    if (w.get(i) == start) {
                        ++possibilities;
                    }
                    ++i;
                }
                int p = possibilities;
                while (p >= 1) {
                    Trail w_Tmp = w.clone();
                    w_Tmp.insert((Walk)w_apo, p);
                    if (this.compare((Trail<Vertex>)t, (Trail<Vertex>)w_Tmp)) {
                        return true;
                    }
                    --p;
                }
                return false;
            }

            private boolean compare(Trail<Vertex> t, Trail<Vertex> w) {
                if (t.length() != w.length()) {
                    return false;
                }
                int i = 0;
                while (i <= t.length()) {
                    if (t.get(i) != w.get(i)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        });
        step = new AlgorithmStep(enlargeParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP7_ENLARGMENT", (String)this.langID, (String)"Go to step 2."), 7);
        return text;
    }

    private void createLegend() {
        this.legendView.removeAll();
        this.legendView.add(new LegendItem("item1", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_V1", (String)this.langID, (String)"The vertex v<sub>1</sub>"), LegendItem.createCircleIcon((Color)this.colorV1, (Color)Color.black, (int)this.lineWidthV1)));
        this.legendView.add(new LegendItem("item2", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_V_k", (String)this.langID, (String)"The current vertex v<sub>k</sub>"), LegendItem.createCircleIcon((Color)this.colorV_k, (Color)Color.black, (int)this.lineWidthV_k)));
        this.legendView.add(new LegendItem("item3", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_W", (String)this.langID, (String)"The current cycle W"), LegendItem.createLineIcon((Color)this.colorW, (int)this.lineWidthW)));
        this.legendView.add(new LegendItem("item4", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_W_APOSTROPHE", (String)this.langID, (String)"The current cycle W'"), LegendItem.createLineIcon((Color)this.colorW_Apostrophe, (int)this.lineWidthW_Apostrophe)));
        this.legendView.add(new LegendItem("item5", this.cycleWView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_CYCLE_W_MODIFICATION", (String)this.langID, (String)"The cycle W becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
        this.legendView.add(new LegendItem("item6", this.cycleW_ApoView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_CYCLE_W_APOSTROPHE_MODIFICATION", (String)this.langID, (String)"The cycle W' becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
    }

    private class EulerianCycleRTE
    extends AlgorithmRTE {
        private int v1;
        private int v_k;
        private Trail<Vertex> W;
        private Trail<Vertex> W_Apo;
        private int userChoiceV1;
        private int userChoiceV_k;
        private Trail<Vertex> userChoiceW;
        private Trail<Vertex> userChoiceW_Apo;

        public EulerianCycleRTE() {
            super((AlgorithmPlugin)EulerianCycleAlgorithmPlugin.this, EulerianCycleAlgorithmPlugin.this.algoText);
            this.userChoiceV1 = 0;
            this.userChoiceV_k = 0;
            this.userChoiceW = null;
            this.userChoiceW_Apo = null;
        }

        protected int executeStep(int stepID, AlgorithmStateAttachment asa) throws Exception {
            Graph graph = EulerianCycleAlgorithmPlugin.this.graphView.getGraph();
            int nextStep = -1;
            switch (stepID) {
                case 1: {
                    this.v1 = this.userChoiceV1 > 0 ? this.userChoiceV1 : (graph.getOrder() > 0 ? graph.getVertex(0).getID() : 0);
                    this.userChoiceV1 = 0;
                    this.sleep(250L);
                    this.visualizeVertices();
                    this.sleep(750L);
                    if (this.v1 < 1) {
                        nextStep = -1;
                        break;
                    }
                    nextStep = 2;
                    break;
                }
                case 2: {
                    this.W = this.userChoiceW != null ? this.userChoiceW : this.findCircuit(graph.getVertexByID(this.v1), (Graph<Vertex, Edge>)graph);
                    this.userChoiceW = null;
                    this.sleep(250L);
                    int i = 0;
                    while (i < this.W.length()) {
                        GraphView.VisualEdge ve = EulerianCycleAlgorithmPlugin.this.graphView.getVisualEdge(this.W.getEdge(i));
                        ve.setColor(EulerianCycleAlgorithmPlugin.this.colorW);
                        ve.setLineWidth(EulerianCycleAlgorithmPlugin.this.lineWidthW);
                        EulerianCycleAlgorithmPlugin.this.graphView.repaint();
                        this.sleep(500L);
                        ++i;
                    }
                    EulerianCycleAlgorithmPlugin.this.cycleWView.setBackground(EulerianCycleAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeWAsText();
                    this.sleep(250L);
                    EulerianCycleAlgorithmPlugin.this.cycleWView.setBackground(Color.white);
                    this.sleep(250L);
                    nextStep = 3;
                    break;
                }
                case 3: {
                    this.sleep(1000L);
                    if (this.W.length() == graph.getSize()) {
                        nextStep = -1;
                        break;
                    }
                    nextStep = 4;
                    break;
                }
                case 4: {
                    if (this.userChoiceV_k > 0) {
                        this.v_k = this.userChoiceV_k;
                    } else {
                        this.v_k = 0;
                        int i = 0;
                        while (i < graph.getOrder()) {
                            Vertex v = graph.getVertex(i);
                            boolean contained = false;
                            boolean notContained = false;
                            if (v.getID() != this.v1) {
                                int j = 0;
                                while (j < v.getOutgoingEdgeCount()) {
                                    boolean contains = this.W.contains(v.getOutgoingEdge(j));
                                    contained = contained || contains;
                                    boolean bl = notContained = notContained || !contains;
                                    if (contained && notContained) break;
                                    ++j;
                                }
                                if (contained && notContained) {
                                    this.v_k = v.getID();
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                    this.userChoiceV_k = 0;
                    this.sleep(500L);
                    this.visualizeVertices();
                    this.sleep(500L);
                    if (this.v_k < 1) {
                        nextStep = -1;
                        break;
                    }
                    nextStep = 5;
                    break;
                }
                case 5: {
                    this.W_Apo = this.userChoiceW_Apo != null ? this.userChoiceW_Apo : this.findCircuit(graph.getVertexByID(this.v_k), (Graph<Vertex, Edge>)graph, this.W);
                    this.userChoiceW_Apo = null;
                    this.sleep(250L);
                    int i = 0;
                    while (i < this.W_Apo.length()) {
                        GraphView.VisualEdge ve = EulerianCycleAlgorithmPlugin.this.graphView.getVisualEdge(this.W_Apo.getEdge(i));
                        ve.setColor(EulerianCycleAlgorithmPlugin.this.colorW_Apostrophe);
                        ve.setLineWidth(EulerianCycleAlgorithmPlugin.this.lineWidthW_Apostrophe);
                        EulerianCycleAlgorithmPlugin.this.graphView.repaint();
                        this.sleep(500L);
                        ++i;
                    }
                    EulerianCycleAlgorithmPlugin.this.cycleW_ApoView.setBackground(EulerianCycleAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeW_ApoAsText();
                    this.sleep(250L);
                    EulerianCycleAlgorithmPlugin.this.cycleW_ApoView.setBackground(Color.white);
                    this.sleep(250L);
                    nextStep = 6;
                    break;
                }
                case 6: {
                    if (this.userChoiceW != null) {
                        this.W = this.userChoiceW;
                    } else {
                        this.W.insert(this.W_Apo, true);
                    }
                    this.userChoiceW = null;
                    this.W_Apo = null;
                    this.sleep(500L);
                    EulerianCycleAlgorithmPlugin.this.cycleWView.setBackground(EulerianCycleAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeWAsText();
                    this.sleep(250L);
                    EulerianCycleAlgorithmPlugin.this.cycleWView.setBackground(Color.white);
                    this.sleep(250L);
                    this.visualizeEdges();
                    this.sleep(1000L);
                    nextStep = 7;
                    break;
                }
                case 7: {
                    this.sleep(1000L);
                    nextStep = 3;
                }
            }
            return nextStep;
        }

        protected void storeState(AlgorithmState state) {
            state.addInt("v1", this.v1);
            state.addInt("v_k", this.v_k);
            state.addTrail("W", this.W != null ? this.W.cast() : null);
            state.addTrail("W_Apo", this.W_Apo != null ? this.W_Apo.cast() : null);
        }

        protected void restoreState(AlgorithmState state) {
            this.v1 = state.getInt("v1");
            this.v_k = state.getInt("v_k");
            TrailByID w = state.getTrail("W", EulerianCycleAlgorithmPlugin.this.graphView.getGraph());
            this.W = w != null ? w.cast() : null;
            TrailByID w_apo = state.getTrail("W_Apo", EulerianCycleAlgorithmPlugin.this.graphView.getGraph());
            this.W_Apo = w_apo != null ? w_apo.cast() : null;
        }

        protected void createInitialState(AlgorithmState state) {
            this.v1 = state.addInt("v1", 0);
            this.v_k = state.addInt("v_k", 0);
            state.addTrail("W", null);
            state.addTrail("W_Apo", null);
        }

        protected void rollBackStep(int stepID, int nextStepID) {
            if (stepID == 1) {
                this.visualizeVertices();
                this.visualizeWAsText();
            } else if (stepID == 2 || stepID == 6) {
                this.visualizeEdges();
                this.visualizeWAsText();
            } else if (stepID == 4) {
                this.visualizeVertices();
            } else if (stepID == 5) {
                this.visualizeEdges();
                this.visualizeW_ApoAsText();
            }
        }

        protected void adoptState(int stepID, AlgorithmState state) {
            if (stepID == 1) {
                this.userChoiceV1 = state.getInt("v1");
            } else if (stepID == 2 || stepID == 6) {
                this.userChoiceW = state.getTrail("W", EulerianCycleAlgorithmPlugin.this.graphView.getGraph()).cast();
            } else if (stepID == 4) {
                this.userChoiceV_k = state.getInt("v_k");
            } else if (stepID == 5) {
                this.userChoiceW_Apo = state.getTrail("W_Apo", EulerianCycleAlgorithmPlugin.this.graphView.getGraph()).cast();
            }
        }

        protected View[] getViews() {
            return new View[]{EulerianCycleAlgorithmPlugin.this.graphView, EulerianCycleAlgorithmPlugin.this.cycleWView, EulerianCycleAlgorithmPlugin.this.cycleW_ApoView};
        }

        private void visualizeVertices() {
            int i = 0;
            while (i < EulerianCycleAlgorithmPlugin.this.graphView.getVisualVertexCount()) {
                GraphView.VisualVertex vv = EulerianCycleAlgorithmPlugin.this.graphView.getVisualVertex(i);
                if (vv.getVertex().getID() == this.v1) {
                    vv.setBackground(EulerianCycleAlgorithmPlugin.this.colorV1);
                    vv.setEdgeWidth(EulerianCycleAlgorithmPlugin.this.lineWidthV1);
                } else if (vv.getVertex().getID() == this.v_k) {
                    vv.setBackground(EulerianCycleAlgorithmPlugin.this.colorV_k);
                    vv.setEdgeWidth(EulerianCycleAlgorithmPlugin.this.lineWidthV_k);
                } else {
                    vv.setBackground(GraphView.DEF_VERTEXBACKGROUND);
                    vv.setEdgeWidth(1);
                }
                ++i;
            }
            EulerianCycleAlgorithmPlugin.this.graphView.repaint();
        }

        private void visualizeEdges() {
            int i = 0;
            while (i < EulerianCycleAlgorithmPlugin.this.graphView.getVisualEdgeCount()) {
                GraphView.VisualEdge ve = EulerianCycleAlgorithmPlugin.this.graphView.getVisualEdge(i);
                if (this.W != null && this.W.contains(ve.getEdge())) {
                    ve.setColor(EulerianCycleAlgorithmPlugin.this.colorW);
                    ve.setLineWidth(EulerianCycleAlgorithmPlugin.this.lineWidthW);
                } else if (this.W_Apo != null && this.W_Apo.contains(ve.getEdge())) {
                    ve.setColor(EulerianCycleAlgorithmPlugin.this.colorW_Apostrophe);
                    ve.setLineWidth(EulerianCycleAlgorithmPlugin.this.lineWidthW_Apostrophe);
                } else {
                    ve.setColor(GraphView.DEF_EDGECOLOR);
                    ve.setLineWidth(1);
                }
                ++i;
            }
            EulerianCycleAlgorithmPlugin.this.graphView.repaint();
        }

        private void visualizeWAsText() {
            EulerianCycleAlgorithmPlugin.this.cycleWView.setText(this.W != null ? "W=" + this.W.toString() : "");
        }

        private void visualizeW_ApoAsText() {
            EulerianCycleAlgorithmPlugin.this.cycleW_ApoView.setText(this.W_Apo != null ? "W'=" + this.W_Apo.toString() : "");
        }

        private Trail<Vertex> findCircuit(Vertex start, Graph<Vertex, Edge> graph) {
            return this.findCircuit(start, graph, null);
        }

        private Trail<Vertex> findCircuit(Vertex start, Graph<Vertex, Edge> graph, Trail<Vertex> t) {
            Trail trail = new Trail(graph);
            this.findCircuit(start, null, (Trail<Vertex>)trail, (Trail<Vertex>)(t != null ? t : trail));
            return trail;
        }

        private boolean findCircuit(Vertex v, Edge e, Trail<Vertex> trail, Trail<Vertex> t) {
            boolean res = false;
            trail.add(v, e);
            if (trail.isClosed()) {
                return true;
            }
            int i = 0;
            while (i < v.getOutgoingEdgeCount()) {
                Edge edge = v.getOutgoingEdge(i);
                if (!t.contains(edge) && !trail.contains(edge) && (res = this.findCircuit(edge.getSuccessor(v), edge, trail, t))) break;
                ++i;
            }
            return res;
        }
    }
}

