/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileNameExtensionFilter;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.AlgorithmTextView;
import lavesdk.algorithm.plugin.views.DefaultNetworkView;
import lavesdk.algorithm.plugin.views.DefaultRNView;
import lavesdk.algorithm.plugin.views.ExecutionTableView;
import lavesdk.algorithm.plugin.views.GraphLayout;
import lavesdk.algorithm.plugin.views.GraphScene;
import lavesdk.algorithm.plugin.views.GraphTransferProtocol;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.LegendView;
import lavesdk.algorithm.plugin.views.TextAreaView;
import lavesdk.algorithm.plugin.views.VertexOnlyTransferProtocol;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.plugin.views.custom.CustomVisualFormula;
import lavesdk.algorithm.plugin.views.custom.CustomVisualObject;
import lavesdk.algorithm.plugin.views.renderers.DefaultNodeRenderer;
import lavesdk.algorithm.plugin.views.renderers.DefaultVertexRenderer;
import lavesdk.algorithm.plugin.views.renderers.VertexRenderer;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.algorithm.text.Annotation;
import lavesdk.algorithm.text.AnnotationImagesList;
import lavesdk.configuration.Configuration;
import lavesdk.gui.widgets.ColorProperty;
import lavesdk.gui.widgets.ExecutionTableColumn;
import lavesdk.gui.widgets.ExecutionTableItem;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;
import lavesdk.language.LanguageFile;
import lavesdk.math.Set;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.network.Arc;
import lavesdk.math.graph.network.Network;
import lavesdk.math.graph.network.Node;
import lavesdk.math.graph.network.RNEdge;
import lavesdk.math.graph.network.ResidualNetwork;
import lavesdk.math.graph.network.enums.FlowType;
import lavesdk.serialization.Serializer;

public class RelabelToFrontAlgorithmPlugin
implements AlgorithmPlugin {
    private PluginHost host;
    private Configuration config;
    private LanguageFile langFile;
    private String langID;
    private FileNameExtensionFilter vgfFileFilter;
    private FileNameExtensionFilter pngFileFilter;
    private AlgorithmText algoText;
    private DefaultNetworkView networkView;
    private DefaultRNView residualNetworkView;
    private ExecutionTableView heightView;
    private TextAreaView heightLastChangedView;
    private AlgorithmTextView algoTextView;
    private LegendView legendView;
    private RelabelToFrontRTE rte;
    private AnnotationImagesList imgList;
    private ViewGroup ab;
    private ViewGroup cd;
    private ViewGroup ef;
    private ViewGroup abcdef;
    private Color colorSource;
    private Color colorSink;
    private Color colorModified;
    private Color colorV;
    private Color colorU;
    private Color colorFlowChanged;
    private Color colorNeighbors;
    private Color colorEdgeVU;
    private int lineWidthV;
    private int lineWidthU;
    private int lineWidthEdgeVU;
    private int lineWidthFlowChanged;
    private static final String CFGKEY_COLOR_SOURCE = "colorSource";
    private static final String CFGKEY_COLOR_SINK = "colorSink";
    private static final String CFGKEY_COLOR_MODIFIED = "colorModified";
    private static final String CFGKEY_COLOR_V = "colorV";
    private static final String CFGKEY_COLOR_U = "colorU";
    private static final String CFGKEY_COLOR_FLOWCHANGED = "colorFlowChanged";
    private static final String CFGKEY_COLOR_NEIGHBORS = "colorNeighbors";
    private static final String CFGKEY_COLOR_EDGEVU = "colorEdgeVU";
    private static final String CFGKEY_LINEWIDTH_V = "lineWidthV";
    private static final String CFGKEY_LINEWIDTH_U = "lineWidthU";
    private static final String CFGKEY_LINEWIDTH_EDGEVU = "lineWidthEdgeVU";
    private static final String CFGKEY_LINEWIDTH_FLOWCHANGED = "lineWidthFlowChanged";

    public void initialize(PluginHost host, ResourceLoader resLoader, Configuration config) {
        try {
            this.langFile = new LanguageFile(resLoader.getResourceAsStream("main/resources/langRelabelToFront.txt"));
            this.langFile.include(host.getLanguageFile());
        }
        catch (IOException e) {
            this.langFile = null;
        }
        this.langID = host.getLanguageID();
        this.imgList = new AnnotationImagesList();
        this.imgList.add("network", resLoader.getResource("main/resources/network.png"));
        this.imgList.add("residual-network", resLoader.getResource("main/resources/residual-network.png"));
        this.imgList.add("excess-def-en", resLoader.getResource("main/resources/excess-def-en.png"));
        this.imgList.add("excess-def-de", resLoader.getResource("main/resources/excess-def-de.png"));
        this.host = host;
        this.config = config != null ? config : new Configuration();
        this.vgfFileFilter = new FileNameExtensionFilter("Visual Graph File (*.vgf)", "vgf");
        this.pngFileFilter = new FileNameExtensionFilter("Portable Network Graphic (*.png)", "png");
        this.networkView = new DefaultNetworkView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_NETWORK_TITLE", (String)this.langID, (String)"Network"), new Network(FlowType.PREFLOW, new Node("s"), new Node("s")), null, true, this.langFile, this.langID);
        this.residualNetworkView = new DefaultRNView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_RESIDUALNETWORK_TITLE", (String)this.langID, (String)"Residual Network"), false, this.langFile, this.langID, this.networkView);
        this.heightView = new ExecutionTableView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_HEIGHT_TITLE", (String)this.langID, (String)"height(v)"), true, this.langFile, this.langID);
        this.heightLastChangedView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_HEIGHTLASTCHANGED_TITLE", (String)this.langID, (String)"height(v): Last Changes"), true, this.langFile, this.langID);
        this.algoText = this.loadAlgorithmText();
        this.algoTextView = new AlgorithmTextView(host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ALGOTEXT_TITLE", (String)this.langID, (String)"Algorithm"), this.algoText, true, this.langFile, this.langID);
        this.legendView = new LegendView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LEGEND_TITLE", (String)this.langID, (String)"Legend"), true, this.langFile, this.langID);
        this.rte = new RelabelToFrontRTE();
        this.algoTextView.setAutoRepaint(true);
        this.heightView.setAutoRepaint(true);
        this.heightLastChangedView.setAutoRepaint(true);
        this.residualNetworkView.setEditable(false);
        this.residualNetworkView.setVisible(false);
        this.colorSource = this.config.getColor(CFGKEY_COLOR_SOURCE, new Color(70, 155, 215));
        this.colorSink = this.config.getColor(CFGKEY_COLOR_SINK, new Color(135, 195, 235));
        this.colorModified = this.config.getColor(CFGKEY_COLOR_MODIFIED, new Color(255, 180, 130));
        this.colorV = this.config.getColor(CFGKEY_COLOR_V, new Color(200, 145, 145));
        this.colorU = this.config.getColor(CFGKEY_COLOR_U, new Color(255, 220, 80));
        this.colorFlowChanged = this.config.getColor(CFGKEY_COLOR_FLOWCHANGED, new Color(0, 80, 130));
        this.colorNeighbors = this.config.getColor(CFGKEY_COLOR_NEIGHBORS, new Color(255, 220, 80));
        this.colorEdgeVU = this.config.getColor(CFGKEY_COLOR_EDGEVU, new Color(0, 80, 130));
        this.lineWidthV = this.config.getInt(CFGKEY_LINEWIDTH_V, 2);
        this.lineWidthU = this.config.getInt(CFGKEY_LINEWIDTH_U, 2);
        this.lineWidthEdgeVU = this.config.getInt(CFGKEY_LINEWIDTH_EDGEVU, 2);
        this.lineWidthFlowChanged = this.config.getInt(CFGKEY_LINEWIDTH_FLOWCHANGED, 2);
        this.networkView.loadConfiguration(config, "networkView");
        this.residualNetworkView.loadConfiguration(config, "residualNetworkView");
        this.heightView.loadConfiguration(config, "heightView");
        this.heightLastChangedView.loadConfiguration(config, "heightLastChangedView");
        this.algoTextView.loadConfiguration(config, "algoTextView");
        this.legendView.loadConfiguration(config, "legendView");
        this.createLegend();
    }

    public String getName() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_NAME", (String)this.langID, (String)"Relabel-to-front");
    }

    public String getDescription() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_DESC", (String)this.langID, (String)"Finds a flow of maximum strength in a network.");
    }

    public String getType() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_TYPE", (String)this.langID, (String)"Exact algorithm");
    }

    public String getAuthor() {
        return "Jan Dornseifer";
    }

    public String getAuthorContact() {
        return "jan.dornseifer@student.uni-siegen.de";
    }

    public String getAssumptions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_ASSUMPTIONS", (String)this.langID, (String)"A network (G, u, s, t).");
    }

    public String getProblemAffiliation() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_PROBLEMAFFILIATION", (String)this.langID, (String)"Flow problem");
    }

    public String getSubject() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_SUBJECT", (String)this.langID, (String)"Logistics");
    }

    public String getInstructions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_INSTRUCTIONS", (String)this.langID, (String)"<b>Creating problem entities</b>:<br>Create your own network and make sure that the network complies with the assumptions of the algorithm.<br><br><b>Exercise Mode</b>:<br>Activate the exercise mode to practice the algorithm in an interactive way. After you have started the algorithm<br>exercises are presented that you have to solve.<br>If an exercise can be solved directly in a view of the algorithm the corresponding view is highlighted with a border, there you can<br>enter your solution and afterwards you have to press the button to solve the exercise. Otherwise (if an exercise is not related to a specific<br>view) you can directly press the button to solve the exercise which opens a dialog where you can enter your solution of the exercise.");
    }

    public String getVersion() {
        return "1.0";
    }

    public LAVESDKV getUsedSDKVersion() {
        return new LAVESDKV(1, 3);
    }

    public AlgorithmRTE getRuntimeEnvironment() {
        return this.rte;
    }

    public AlgorithmText getText() {
        return this.algoText.getBaseCopy();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean hasExerciseMode() {
        return false;
    }

    public boolean hasCreatorPreferences() {
        return false;
    }

    public void loadCreatorPreferences(PropertiesListModel plm) {
    }

    public void onCreate(ViewContainer container, PropertiesListModel creatorProperties) {
        this.networkView.setGraph((Graph)new Network(FlowType.PREFLOW, new Node("s"), new Node("t")));
        this.networkView.layoutGraph((GraphLayout)this.networkView.createCircleGraphLayout());
        this.networkView.repaint();
        this.ab = new ViewGroup(1);
        this.cd = new ViewGroup(1);
        this.ef = new ViewGroup(1);
        this.abcdef = new ViewGroup(0);
        this.ab.add((Component)this.algoTextView);
        this.ab.add((Component)this.legendView);
        this.ab.restoreWeights((Serializer)this.config, "weights_ab", new float[]{0.6f, 0.4f});
        this.cd.add((Component)this.networkView);
        this.cd.add((Component)this.residualNetworkView);
        this.cd.restoreWeights((Serializer)this.config, "weights_cd", new float[]{0.5f, 0.5f});
        this.ef.add((Component)this.heightView);
        this.ef.add((Component)this.heightLastChangedView);
        this.ef.restoreWeights((Serializer)this.config, "weights_ef", new float[]{0.7f, 0.3f});
        this.abcdef.add((Component)this.ab);
        this.abcdef.add((Component)this.cd);
        this.abcdef.add((Component)this.ef);
        this.abcdef.restoreWeights((Serializer)this.config, "weights_abcdef", new float[]{0.3f, 0.5f, 0.2f});
        container.setLayout((LayoutManager)new BorderLayout());
        container.add((Component)this.abcdef, (Object)"Center");
    }

    public void onClose() {
        this.networkView.saveConfiguration(this.config, "networkView");
        this.algoTextView.saveConfiguration(this.config, "algoTextView");
        this.residualNetworkView.saveConfiguration(this.config, "residualNetworkView");
        this.heightView.saveConfiguration(this.config, "heightView");
        this.heightLastChangedView.saveConfiguration(this.config, "heightLastChangedView");
        this.legendView.saveConfiguration(this.config, "legendView");
        if (this.ab != null) {
            this.ab.storeWeights((Serializer)this.config, "weights_ab");
        }
        if (this.cd != null) {
            this.cd.storeWeights((Serializer)this.config, "weights_cd");
        }
        if (this.ef != null) {
            this.ef.storeWeights((Serializer)this.config, "weights_ef");
        }
        if (this.abcdef != null) {
            this.abcdef.storeWeights((Serializer)this.config, "weights_abcdef");
        }
        this.networkView.reset();
        this.residualNetworkView.reset();
        this.heightView.reset();
        this.heightLastChangedView.reset();
    }

    public boolean hasCustomization() {
        return true;
    }

    public void loadCustomization(PropertiesListModel plm) {
        plm.add((Property)new ColorProperty("algoTextHighlightForeground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTFOREGROUND", (String)this.langID, (String)"Foreground color of the current step in the algorithm"), this.algoTextView.getHighlightForeground()));
        plm.add((Property)new ColorProperty("algoTextHighlightBackground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTBACKGROUND", (String)this.langID, (String)"Background color of the current step in the algorithm"), this.algoTextView.getHighlightBackground()));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SOURCE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_SOURCE", (String)this.langID, (String)"Background color of the source node in the network"), this.colorSource));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SINK, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_SINK", (String)this.langID, (String)"Background color of the sink node in the network"), this.colorSink));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MODIFIED, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MODIFICATIONS", (String)this.langID, (String)"Color of modifications to objects"), this.colorModified));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_V, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_V", (String)this.langID, (String)"Color of the node v"), this.colorV));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_U, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_U", (String)this.langID, (String)"Color of the node u"), this.colorU));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_FLOWCHANGED, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_FLOWCHANGED", (String)this.langID, (String)"Color of the edge its flow is changed"), this.colorFlowChanged));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_NEIGHBORS, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_NEIGHBORS", (String)this.langID, (String)"Color of the neighbors of the node v"), this.colorNeighbors));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_EDGEVU, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_EDGEVU", (String)this.langID, (String)"Color of the edge between the nodes v and u"), this.colorEdgeVU));
        NumericProperty lwV = new NumericProperty(CFGKEY_LINEWIDTH_V, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_V", (String)this.langID, (String)"Line width of the node v"), (Number)this.lineWidthV, true);
        lwV.setMinimum(1);
        lwV.setMaximum(5);
        plm.add((Property)lwV);
        NumericProperty lwU = new NumericProperty(CFGKEY_LINEWIDTH_U, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_U", (String)this.langID, (String)"Line width of the node u"), (Number)this.lineWidthU, true);
        lwU.setMinimum(1);
        lwU.setMaximum(5);
        plm.add((Property)lwU);
        NumericProperty lwEdgeVU = new NumericProperty(CFGKEY_LINEWIDTH_EDGEVU, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_EDGEVU", (String)this.langID, (String)"Line width of the edge between the nodes v and u"), (Number)this.lineWidthEdgeVU, true);
        lwEdgeVU.setMinimum(1);
        lwEdgeVU.setMaximum(5);
        plm.add((Property)lwEdgeVU);
        NumericProperty lwFlowChanged = new NumericProperty(CFGKEY_LINEWIDTH_FLOWCHANGED, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_FLOWCHANGED", (String)this.langID, (String)"Line width of the edge its flow is changed"), (Number)this.lineWidthFlowChanged, true);
        lwFlowChanged.setMinimum(1);
        lwFlowChanged.setMaximum(5);
        plm.add((Property)lwFlowChanged);
    }

    public void applyCustomization(PropertiesListModel plm) {
        this.algoTextView.setHighlightForeground(plm.getColorProperty("algoTextHighlightForeground").getValue());
        this.algoTextView.setHighlightBackground(plm.getColorProperty("algoTextHighlightBackground").getValue());
        this.colorSource = this.config.addColor(CFGKEY_COLOR_SOURCE, plm.getColorProperty(CFGKEY_COLOR_SOURCE).getValue());
        this.colorSink = this.config.addColor(CFGKEY_COLOR_SINK, plm.getColorProperty(CFGKEY_COLOR_SINK).getValue());
        this.colorModified = this.config.addColor(CFGKEY_COLOR_MODIFIED, plm.getColorProperty(CFGKEY_COLOR_MODIFIED).getValue());
        this.colorV = this.config.addColor(CFGKEY_COLOR_V, plm.getColorProperty(CFGKEY_COLOR_V).getValue());
        this.colorU = this.config.addColor(CFGKEY_COLOR_U, plm.getColorProperty(CFGKEY_COLOR_U).getValue());
        this.colorFlowChanged = this.config.addColor(CFGKEY_COLOR_FLOWCHANGED, plm.getColorProperty(CFGKEY_COLOR_FLOWCHANGED).getValue());
        this.colorNeighbors = this.config.addColor(CFGKEY_COLOR_NEIGHBORS, plm.getColorProperty(CFGKEY_COLOR_NEIGHBORS).getValue());
        this.colorEdgeVU = this.config.addColor(CFGKEY_COLOR_EDGEVU, plm.getColorProperty(CFGKEY_COLOR_EDGEVU).getValue());
        this.lineWidthV = this.config.addInt(CFGKEY_LINEWIDTH_V, plm.getNumericProperty(CFGKEY_LINEWIDTH_V).getValue().intValue());
        this.lineWidthU = this.config.addInt(CFGKEY_LINEWIDTH_U, plm.getNumericProperty(CFGKEY_LINEWIDTH_U).getValue().intValue());
        this.lineWidthEdgeVU = this.config.addInt(CFGKEY_LINEWIDTH_EDGEVU, plm.getNumericProperty(CFGKEY_LINEWIDTH_EDGEVU).getValue().intValue());
        this.lineWidthFlowChanged = this.config.addInt(CFGKEY_LINEWIDTH_FLOWCHANGED, plm.getNumericProperty(CFGKEY_LINEWIDTH_FLOWCHANGED).getValue().intValue());
        this.createLegend();
    }

    public ToolBarExtension[] getToolBarExtensions() {
        return null;
    }

    public void save(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.networkView.save(file);
            } else if (this.pngFileFilter.accept(file)) {
                this.networkView.saveAsPNG(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE", (String)this.langID, (String)"File could not be saved!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE_TITLE", (String)this.langID, (String)"Save File"), MessageIcon.ERROR);
        }
    }

    public void open(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.networkView.load(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE", (String)this.langID, (String)"File could not be opened!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE_TITLE", (String)this.langID, (String)"Open File"), MessageIcon.ERROR);
        }
    }

    public FileNameExtensionFilter[] getSaveFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter, this.pngFileFilter};
    }

    public FileNameExtensionFilter[] getOpenFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter};
    }

    public void beforeStart(RTEvent e) {
        CustomVisualFormula flowStrength = new CustomVisualFormula("w(f) = 0", 5, 5);
        Network n = this.networkView.getGraph();
        this.residualNetworkView.setGraph((Graph)new ResidualNetwork(this.networkView.getGraph()));
        this.residualNetworkView.setVisible(false);
        this.networkView.setEditable(false);
        this.networkView.setVertexRenderer((VertexRenderer)new DefaultNodeRenderer());
        this.networkView.addVisualObject((CustomVisualObject)flowStrength);
        this.rte.setFlowStrengthDisplay(flowStrength);
        this.heightView.reset();
        int i = 0;
        while (i < n.getOrder()) {
            this.heightView.add(new ExecutionTableColumn(((Node)n.getVertex(i)).getCaption(), ((Node)n.getVertex(i)).getID()));
            ++i;
        }
        i = 0;
        while (i < n.getOrder()) {
            ((Node)n.getVertex(i)).setExcess(0.0f);
            ++i;
        }
        i = 0;
        while (i < n.getSize()) {
            ((Arc)n.getEdge(i)).setFlow(0.0f);
            ++i;
        }
        this.networkView.repaint();
    }

    public void beforeResume(RTEvent e) {
    }

    public void beforePause(RTEvent e) {
    }

    public void onStop() {
        this.networkView.setVertexRenderer((VertexRenderer)new DefaultVertexRenderer());
        this.networkView.setEditable(true);
        this.networkView.removeAllVisualObjects();
        this.residualNetworkView.reset();
        this.rte.setFlowStrengthDisplay(null);
        this.residualNetworkView.setVisible(false);
    }

    public void onRunning() {
    }

    public void onPause() {
    }

    private AlgorithmText loadAlgorithmText() {
        AlgorithmText text = new AlgorithmText();
        AlgorithmParagraph initParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_INITIALIZATION", (String)this.langID, (String)"1. Initialization:"), 1);
        AlgorithmParagraph stopParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_STOPCRITERION", (String)this.langID, (String)"2. Stop criterion:"), 2);
        AlgorithmParagraph drainageParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_DRAINAGE", (String)this.langID, (String)"3. Drainage:"), 3);
        AlgorithmParagraph relabelParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_RELABEL", (String)this.langID, (String)"4. Relabel:"), 4);
        AlgorithmStep step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP1_INIT", (String)this.langID, (String)"Let _latex{$f$} be a preflow with _latex{$f(s,v) := u(s,v)$} if _latex{$(s,v) \\in E$} and _latex{$f(e) := 0$} otherwise.\n"), 1);
        step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP2_INIT", (String)this.langID, (String)"Set _latex{$height(s) = n$} (_latex{$n = |V|$}) and _latex{$height(v) = 0$} for all _latex{$v \\in V \\setminus \\{s\\}$}.\n\n"), 2);
        Annotation step2_12_annotation = new Annotation(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP2_12_ANNOTATION", (String)this.langID, (String)"The height of the source and the sink remains constant at <i>n</i> resp. 0 during the entire algorithm."));
        step.setAnnotation(step2_12_annotation);
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP3_STOP", (String)this.langID, (String)"Determine the excess for each node except _latex{$s$} and _latex{$t$}.\n"), 3);
        step.setAnnotation(new Annotation(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP3_ANNOTATION", (String)this.langID, (String)"<b>Excess</b><br>Let <i>(G, u, s, t)</i> be a network with preflow <i>f</i>. For every node <i>v</i> except <i>s</i> and <i>t</i> depicts<br><img src=\"excess-def-en\"><br> the excess of <i>v</i>."), this.imgList));
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP4_STOP", (String)this.langID, (String)"If _latex{$excess(v) = 0$} for all _latex{$v \\in V \\setminus \\{s,t\\}$}, then stop.\n"), 4);
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5_STOP", (String)this.langID, (String)"Otherwise choose the node _latex{$v$} with _latex{$excess(v) > 0$}, where the height _latex{$height(v)$} was changed last.\n\n"), 5);
        step.setAnnotation(new Annotation(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5_ANNOTATION", (String)this.langID, (String)"To determine which height of which node was changed last, you can specify a list that contains all nodes sequentially.<br> If the height of a node changes, this node is set to the beginning of the list.")));
        step = new AlgorithmStep(drainageParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP6_DRAINAGE", (String)this.langID, (String)"Let the excess of _latex{$v$} drain by implementing the following steps for all neighbors _latex{$u \\in V$} of _latex{$v$}:\n"), 6);
        step = new AlgorithmStep(drainageParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP7_DRAINAGE", (String)this.langID, (String)"If both conditions _latex{$u'(v,u) > 0$} and _latex{$height(v) > height(u)$} are fulfilled, "), 7, 4);
        step.setAnnotation(new Annotation(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP7_ANNOTATION", (String)this.langID, (String)"<b>Meaning</b><br><ul><li>u'(v,u): there is capacity on the (residual) edge of <i>v</i> to <i>u</i>.<br>(The edge (v,u) must not exist in the network, but only in the residual network.)</li><li>height(v) > height(u): <i>v</i> is higher than <i>u</i>.</li></ul><b>Residual network</b><br>A residual network (G', u', s, t) to a flow f indicates the residual capacity of a network (G, u, s, t).<br>The weights u' for each edge (v, v') are defined as follows:<br>u'(v, v') := u(v, v') - f(v, v') as well as u'(v', v) := f(v, v')<br>The residual graph G' has the same vertex set as G and in addition to the forward edges e = (v, u) &isin; E with u'(e) > 0 the graph G' contains the backward edges e' = (u, v) too, if u'(e') > 0.<br><br><b>Example</b>:<br><table border=\"0\"><tr><td valign=\"top\">Network (G, u, s, t)</td><td valign=\"top\">Residual network (G', u', s, t)</td><td valign=\"top\"></td></tr><tr><td valign=\"top\"><img src=\"network\"></td><td valign=\"top\"><img src=\"residual-network\"></td><td valign=\"top\">Look at the red marked edges it is:<br>u'(s, 1) = u(s, 1) - f(s, 1) = 5 - 2 = 3 and u'(1, s) = f(s, 1) = 2<br>E.g. the edges (2, s) or (1, 2) are not available in the residual network,<br>because u'(2, s) = f(s, 2) = 0 and u'(1, 2) = u(1, 2) - f(1, 2) = 1 - 1 = 0.</td></tr></table>"), this.imgList));
        step = new AlgorithmStep(drainageParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP8_DRAINAGE", (String)this.langID, (String)"then set _latex{$f(v,u) = f(v,u) \\; + \\; min\\{excess(v), \\; u'(v,u)\\}$}. "), 8, 4);
        step = new AlgorithmStep(drainageParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP9_DRAINAGE", (String)this.langID, (String)"Determine the new _latex{$excess(v)$}.\n\n"), 9, 4);
        step = new AlgorithmStep(relabelParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP10_RELABEL", (String)this.langID, (String)"If _latex{$excess(v) = 0$} "), 10);
        step = new AlgorithmStep(relabelParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP11_RELABEL", (String)this.langID, (String)"then go to step 2.\n"), 11);
        step = new AlgorithmStep(relabelParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP12_RELABEL", (String)this.langID, (String)"Otherwise set _latex{$height(v) = height(v) + 1$} and go to step 3."), 12);
        step.setAnnotation(step2_12_annotation);
        return text;
    }

    private void createLegend() {
        this.legendView.removeAll();
        this.legendView.add(new LegendItem("item1", this.networkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_NETWORK_SOURCE", (String)this.langID, (String)"The node s (source)"), LegendItem.createCircleIcon((Color)this.colorSource, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item2", this.networkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_NETWORK_SINK", (String)this.langID, (String)"The node t (sink)"), LegendItem.createCircleIcon((Color)this.colorSink, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item3", this.networkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_NETWORK_V", (String)this.langID, (String)"The node v"), LegendItem.createCircleIcon((Color)this.colorV, (Color)Color.black, (int)this.lineWidthV)));
        this.legendView.add(new LegendItem("item4", this.networkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_NETWORK_U", (String)this.langID, (String)"The node u"), LegendItem.createCircleIcon((Color)this.colorU, (Color)Color.black, (int)this.lineWidthU)));
        this.legendView.add(new LegendItem("item5", this.networkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_NETWORK_NEIGHBORS", (String)this.langID, (String)"The neighbors of the node v"), LegendItem.createCircleIcon((Color)this.colorNeighbors, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item6", this.networkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_NETWORK_FLOWCHANGED", (String)this.langID, (String)"The edge its flow is changed"), LegendItem.createLineIcon((Color)this.colorFlowChanged, (int)this.lineWidthFlowChanged, (int)4)));
        this.legendView.add(new LegendItem("item7", this.residualNetworkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_RESIDUALNETWORK_V", (String)this.langID, (String)"The node v"), LegendItem.createCircleIcon((Color)this.colorV, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item8", this.residualNetworkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_RESIDUALNETWORK_U", (String)this.langID, (String)"The node u"), LegendItem.createCircleIcon((Color)this.colorU, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item9", this.residualNetworkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_RESIDUALNETWORK_EDGEVU", (String)this.langID, (String)"The edge u'(v,u) between the nodes v and u"), LegendItem.createLineIcon((Color)this.colorEdgeVU, (int)this.lineWidthEdgeVU, (int)4)));
        this.legendView.add(new LegendItem("item10", this.heightView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_HEIGHT_MODIFICATION", (String)this.langID, (String)"The height of a node becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
        this.legendView.add(new LegendItem("item11", this.heightLastChangedView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_HEIGHTLASTCHANGED_MODIFICATION", (String)this.langID, (String)"The list becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
    }

    private class RelabelToFrontRTE
    extends AlgorithmRTE {
        private Map<Integer, Integer> height;
        private List<Integer> heightLastChanged;
        private int v;
        private List<Integer> neighbors;
        private int u;
        private float u_apo_v_u;
        private boolean userDefinedResidualNetwork;
        private CustomVisualFormula flowStrengthDisplay;

        public RelabelToFrontRTE() {
            super((AlgorithmPlugin)RelabelToFrontAlgorithmPlugin.this, RelabelToFrontAlgorithmPlugin.this.algoText);
            this.userDefinedResidualNetwork = false;
        }

        public void setFlowStrengthDisplay(CustomVisualFormula display) {
            this.flowStrengthDisplay = display;
        }

        protected int executeStep(int stepID, AlgorithmStateAttachment asa) throws Exception {
            Network network = RelabelToFrontAlgorithmPlugin.this.networkView.getGraph();
            ResidualNetwork residualNetwork = RelabelToFrontAlgorithmPlugin.this.residualNetworkView.getGraph();
            int nextStepID = -1;
            switch (stepID) {
                case 1: {
                    GraphView.VisualVertex source = RelabelToFrontAlgorithmPlugin.this.networkView.getVisualVertex((Vertex)network.getSource());
                    GraphView.VisualVertex sink = RelabelToFrontAlgorithmPlugin.this.networkView.getVisualVertex((Vertex)network.getSink());
                    source.setBackground(RelabelToFrontAlgorithmPlugin.this.colorSource);
                    sink.setBackground(RelabelToFrontAlgorithmPlugin.this.colorSink);
                    RelabelToFrontAlgorithmPlugin.this.networkView.repaint();
                    this.sleep(750L);
                    GraphScene preflow_scene = new GraphScene((GraphView)RelabelToFrontAlgorithmPlugin.this.networkView);
                    preflow_scene.begin();
                    Set E = network.getEdgeSet();
                    int i = 0;
                    while (i < E.size()) {
                        Arc a;
                        a.setFlow((a = (Arc)E.get(i)).getPredecessor() == network.getSource() ? a.getWeight() : 0.0f);
                        ++i;
                    }
                    preflow_scene.end(true);
                    asa.addAttachment("preflow_scene", (Object)preflow_scene);
                    RelabelToFrontAlgorithmPlugin.this.networkView.repaint();
                    nextStepID = 2;
                    break;
                }
                case 2: {
                    this.heightLastChanged.clear();
                    int i = 0;
                    while (i < network.getOrder()) {
                        Node n = (Node)network.getVertex(i);
                        this.height.put(n.getID(), n == network.getSource() ? network.getOrder() : 0);
                        if (n != network.getSource() && n != network.getSink()) {
                            this.heightLastChanged.add(n.getID());
                        }
                        ++i;
                    }
                    this.sleep(1000L);
                    RelabelToFrontAlgorithmPlugin.this.heightView.add(new ExecutionTableItem(this.height, true));
                    this.sleep(250L);
                    RelabelToFrontAlgorithmPlugin.this.heightLastChangedView.setBackground(RelabelToFrontAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeHeightLastChanged();
                    this.sleep(250L);
                    RelabelToFrontAlgorithmPlugin.this.heightLastChangedView.setBackground(Color.white);
                    this.sleep(250L);
                    nextStepID = 3;
                    break;
                }
                case 3: {
                    this.sleep(750L);
                    GraphScene excess_scene = new GraphScene((GraphView)RelabelToFrontAlgorithmPlugin.this.networkView);
                    excess_scene.begin();
                    network.determineExcesses();
                    excess_scene.end(true);
                    asa.addAttachment("excess_scene", (Object)excess_scene);
                    RelabelToFrontAlgorithmPlugin.this.networkView.repaint();
                    this.sleep(750L);
                    nextStepID = 4;
                    break;
                }
                case 4: {
                    this.sleep(1000L);
                    boolean stop = true;
                    int i = 0;
                    while (i < network.getOrder()) {
                        Node n = (Node)network.getVertex(i);
                        if (n != network.getSource() && n != network.getSink()) {
                            if (n.getExcess() != 0.0f) {
                                stop = false;
                            }
                            if (!stop) break;
                        }
                        ++i;
                    }
                    if (stop) {
                        nextStepID = -1;
                        break;
                    }
                    nextStepID = 5;
                    break;
                }
                case 5: {
                    this.v = -1;
                    this.u = -1;
                    this.neighbors = null;
                    int i = 0;
                    while (i < this.heightLastChanged.size()) {
                        Node n = (Node)network.getVertexByID(this.heightLastChanged.get(i).intValue());
                        if (n != null && n.getExcess() > 0.0f) {
                            this.v = n.getID();
                        }
                        if (this.v >= 0) break;
                        ++i;
                    }
                    if (this.v < 0) {
                        nextStepID = -1;
                        break;
                    }
                    this.sleep(250L);
                    this.visualizeNodes();
                    this.sleep(750L);
                    RelabelToFrontAlgorithmPlugin.this.residualNetworkView.setGraph((Graph)new ResidualNetwork(network));
                    RelabelToFrontAlgorithmPlugin.this.residualNetworkView.setVisible(true);
                    RelabelToFrontAlgorithmPlugin.this.residualNetworkView.repaint();
                    nextStepID = 6;
                    break;
                }
                case 6: {
                    if (this.neighbors == null) {
                        Node n = (Node)network.getVertexByID(this.v);
                        this.neighbors = new ArrayList<Integer>(n.getOutgoingEdgeCount());
                        int i = 0;
                        while (i < n.getIncidentEdgeCount()) {
                            Edge e = n.getIncidentEdge(i);
                            if (e.getPredecessor() == n) {
                                this.neighbors.add(e.getSuccessor().getID());
                            } else {
                                this.neighbors.add(e.getPredecessor().getID());
                            }
                            ++i;
                        }
                    } else if (this.neighbors.isEmpty()) {
                        this.neighbors = null;
                    }
                    VertexOnlyTransferProtocol votp = this.userDefinedResidualNetwork ? new VertexOnlyTransferProtocol((GraphView)RelabelToFrontAlgorithmPlugin.this.residualNetworkView, false) : new VertexOnlyTransferProtocol((GraphView)RelabelToFrontAlgorithmPlugin.this.networkView, false, true);
                    votp.prepare();
                    asa.addAttachment("votp", (Object)votp);
                    if (!this.userDefinedResidualNetwork) {
                        residualNetwork = network.getResidualNetwork();
                        this.sleep(500L);
                        RelabelToFrontAlgorithmPlugin.this.residualNetworkView.setGraph((Graph)residualNetwork);
                        RelabelToFrontAlgorithmPlugin.this.residualNetworkView.transferGraph((GraphTransferProtocol)votp);
                    }
                    if (this.neighbors != null) {
                        this.u = this.neighbors.remove(0);
                        Vertex _v = residualNetwork.getVertexByCaption(((Node)network.getVertexByID(this.v)).getCaption());
                        Vertex _u = residualNetwork.getVertexByCaption(((Node)network.getVertexByID(this.u)).getCaption());
                        RNEdge e = _v != null && _u != null ? (RNEdge)residualNetwork.getEdge(_v, _u) : null;
                        this.u_apo_v_u = e != null ? e.getWeight() : 0.0f;
                    } else {
                        this.u = -1;
                        this.u_apo_v_u = 0.0f;
                    }
                    if (this.u < 0) {
                        nextStepID = 10;
                        break;
                    }
                    this.sleep(500L);
                    this.visualizeNodes();
                    this.visualizeVerticesInResidualNetwork();
                    this.visualizeEdgesInResidualNetwork();
                    this.sleep(750L);
                    nextStepID = 7;
                    break;
                }
                case 7: {
                    this.sleep(750L);
                    if (this.u_apo_v_u > 0.0f && this.height.get(this.v) > this.height.get(this.u)) {
                        nextStepID = 8;
                        break;
                    }
                    nextStepID = 6;
                    break;
                }
                case 8: {
                    GraphView.VisualEdge va;
                    boolean drainBack;
                    GraphScene networkScene = new GraphScene((GraphView)RelabelToFrontAlgorithmPlugin.this.networkView);
                    networkScene.begin();
                    Node n = (Node)network.getVertexByID(this.v);
                    Arc a = (Arc)network.getEdge(this.v, this.u);
                    boolean bl = drainBack = a == null;
                    if (drainBack) {
                        a = (Arc)network.getEdge(this.u, this.v);
                    }
                    if ((va = RelabelToFrontAlgorithmPlugin.this.networkView.getVisualEdge((Edge)a)) != null) {
                        va.setColor(RelabelToFrontAlgorithmPlugin.this.colorFlowChanged);
                        va.setLineWidth(RelabelToFrontAlgorithmPlugin.this.lineWidthFlowChanged);
                        RelabelToFrontAlgorithmPlugin.this.networkView.repaint();
                    }
                    this.sleep(250L);
                    if (!drainBack) {
                        a.setFlow(a.getFlow() + Math.min(n.getExcess(), this.u_apo_v_u));
                    } else {
                        a.setFlow(a.getFlow() - Math.min(n.getExcess(), this.u_apo_v_u));
                    }
                    this.visualizeFlowStrength();
                    this.sleep(250L);
                    if (va != null) {
                        va.setColor(GraphView.DEF_EDGECOLOR);
                        va.setLineWidth(1);
                        RelabelToFrontAlgorithmPlugin.this.networkView.repaint();
                    }
                    networkScene.end(true);
                    asa.addAttachment("network_scene", (Object)networkScene);
                    nextStepID = 9;
                    break;
                }
                case 9: {
                    this.sleep(750L);
                    GraphScene excess_scene = new GraphScene((GraphView)RelabelToFrontAlgorithmPlugin.this.networkView);
                    excess_scene.begin();
                    Node n = (Node)network.getVertexByID(this.v);
                    Node.determineExcess((Node)n);
                    excess_scene.end(true);
                    asa.addAttachment("excess_scene", (Object)excess_scene);
                    RelabelToFrontAlgorithmPlugin.this.networkView.repaint();
                    this.sleep(250L);
                    nextStepID = 6;
                    break;
                }
                case 10: {
                    RelabelToFrontAlgorithmPlugin.this.residualNetworkView.setVisible(false);
                    this.sleep(1000L);
                    Node n = (Node)network.getVertexByID(this.v);
                    if (n.getExcess() == 0.0f) {
                        nextStepID = 11;
                        break;
                    }
                    nextStepID = 12;
                    break;
                }
                case 11: {
                    this.v = -1;
                    this.u = -1;
                    this.neighbors = null;
                    this.visualizeNodes();
                    this.sleep(1000L);
                    nextStepID = 3;
                    break;
                }
                case 12: {
                    ExecutionTableItem item = new ExecutionTableItem(this.height, true);
                    RelabelToFrontAlgorithmPlugin.this.heightView.add(item);
                    RelabelToFrontAlgorithmPlugin.this.heightView.repaint();
                    this.height.put(this.v, this.height.get(this.v) + 1);
                    this.moveToFront(this.v, this.heightLastChanged);
                    this.sleep(250L);
                    item.setCellBackgroundByID(this.v, RelabelToFrontAlgorithmPlugin.this.colorModified);
                    RelabelToFrontAlgorithmPlugin.this.heightLastChangedView.setBackground(RelabelToFrontAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    item.setCellDataByID(this.height);
                    this.visualizeHeightLastChanged();
                    this.sleep(250L);
                    RelabelToFrontAlgorithmPlugin.this.heightLastChangedView.setBackground(Color.white);
                    item.setCellBackgroundByID(this.v, Color.white);
                    this.sleep(250L);
                    RelabelToFrontAlgorithmPlugin.this.residualNetworkView.setVisible(true);
                    nextStepID = 6;
                }
            }
            return nextStepID;
        }

        protected void storeState(AlgorithmState state) {
            state.addMap("height", this.height);
            state.addList("heightLastChanged", this.heightLastChanged);
            state.addInt("v", this.v);
            state.addList("neighbors", this.neighbors);
            state.addInt("u", this.u);
            state.addFloat("u_apo_v_u", this.u_apo_v_u);
            if (state.getStepID() == 11) {
                state.addAttachment("residual_network", (Object)RelabelToFrontAlgorithmPlugin.this.residualNetworkView.getGraph());
            }
        }

        protected void restoreState(AlgorithmState state) {
            GraphScene network_scene;
            GraphScene excess_scene;
            GraphScene preflow_scene;
            this.height = state.getMap("height");
            this.heightLastChanged = state.getList("heightLastChanged");
            this.v = state.getInt("v");
            this.neighbors = state.getList("neighbors");
            this.u = state.getInt("u");
            this.u_apo_v_u = state.getFloat("u_apo_v_u");
            Graph graph = (Graph)state.getAttachment("residual_network");
            VertexOnlyTransferProtocol votp = (VertexOnlyTransferProtocol)state.getAttachment("votp");
            if (graph != null && votp != null) {
                RelabelToFrontAlgorithmPlugin.this.residualNetworkView.setGraph(graph);
                if (graph.getOrder() > 0) {
                    RelabelToFrontAlgorithmPlugin.this.residualNetworkView.transferGraph((GraphTransferProtocol)votp);
                }
                RelabelToFrontAlgorithmPlugin.this.residualNetworkView.repaint();
            }
            if ((preflow_scene = (GraphScene)state.getAttachment("preflow_scene")) != null) {
                preflow_scene.reverse();
            }
            if ((excess_scene = (GraphScene)state.getAttachment("excess_scene")) != null) {
                excess_scene.reverse();
            }
            if ((network_scene = (GraphScene)state.getAttachment("network_scene")) != null) {
                network_scene.reverse();
            }
        }

        protected void createInitialState(AlgorithmState state) {
            this.height = state.addMap("height", new HashMap());
            this.heightLastChanged = state.addList("heightLastChanged", new ArrayList());
            this.v = state.addInt("v", -1);
            this.neighbors = state.addList("neighbors", null);
            this.u = state.addInt("u", -1);
            this.u_apo_v_u = state.addFloat("u_apo_v_u", 0.0f);
        }

        protected void rollBackStep(int stepID, int nextStepID) {
            switch (stepID) {
                case 1: 
                case 3: {
                    RelabelToFrontAlgorithmPlugin.this.networkView.repaint();
                    break;
                }
                case 2: 
                case 12: {
                    RelabelToFrontAlgorithmPlugin.this.heightView.remove(RelabelToFrontAlgorithmPlugin.this.heightView.getLastItem());
                    this.visualizeHeightLastChanged();
                    break;
                }
                case 5: {
                    RelabelToFrontAlgorithmPlugin.this.residualNetworkView.setVisible(false);
                    RelabelToFrontAlgorithmPlugin.this.residualNetworkView.repaint();
                    this.visualizeNodes();
                    break;
                }
                case 6: {
                    this.visualizeNodes();
                    this.visualizeVerticesInResidualNetwork();
                    this.visualizeEdgesInResidualNetwork();
                    break;
                }
                case 8: {
                    this.visualizeFlowStrength();
                    break;
                }
                case 9: {
                    RelabelToFrontAlgorithmPlugin.this.networkView.repaint();
                    break;
                }
                case 10: {
                    RelabelToFrontAlgorithmPlugin.this.residualNetworkView.setVisible(true);
                    RelabelToFrontAlgorithmPlugin.this.residualNetworkView.repaint();
                    break;
                }
                case 11: {
                    this.visualizeNodes();
                }
            }
        }

        protected void adoptState(int stepID, AlgorithmState state) {
        }

        protected View[] getViews() {
            return new View[]{RelabelToFrontAlgorithmPlugin.this.networkView, RelabelToFrontAlgorithmPlugin.this.residualNetworkView};
        }

        private void visualizeNodes() {
            Network network = RelabelToFrontAlgorithmPlugin.this.networkView.getGraph();
            int i = 0;
            while (i < RelabelToFrontAlgorithmPlugin.this.networkView.getVisualVertexCount()) {
                GraphView.VisualVertex vv = RelabelToFrontAlgorithmPlugin.this.networkView.getVisualVertex(i);
                if (((Node)vv.getVertex()).getID() == this.v) {
                    vv.setBackground(RelabelToFrontAlgorithmPlugin.this.colorV);
                    vv.setEdgeWidth(RelabelToFrontAlgorithmPlugin.this.lineWidthV);
                } else if (((Node)vv.getVertex()).getID() == this.u) {
                    vv.setBackground(RelabelToFrontAlgorithmPlugin.this.colorU);
                    vv.setEdgeWidth(RelabelToFrontAlgorithmPlugin.this.lineWidthU);
                } else if (this.neighbors != null && this.neighbors.contains(((Node)vv.getVertex()).getID())) {
                    vv.setBackground(RelabelToFrontAlgorithmPlugin.this.colorNeighbors);
                    vv.setEdgeWidth(1);
                } else if (vv.getVertex() == network.getSource()) {
                    vv.setBackground(RelabelToFrontAlgorithmPlugin.this.colorSource);
                    vv.setEdgeWidth(1);
                } else if (vv.getVertex() == network.getSink()) {
                    vv.setBackground(RelabelToFrontAlgorithmPlugin.this.colorSink);
                    vv.setEdgeWidth(1);
                } else {
                    vv.setBackground(GraphView.DEF_VERTEXBACKGROUND);
                    vv.setEdgeWidth(1);
                }
                ++i;
            }
            RelabelToFrontAlgorithmPlugin.this.networkView.repaint();
        }

        private void visualizeVerticesInResidualNetwork() {
            Network network = RelabelToFrontAlgorithmPlugin.this.networkView.getGraph();
            ResidualNetwork residualNetwork = RelabelToFrontAlgorithmPlugin.this.residualNetworkView.getGraph();
            Node v = (Node)network.getVertexByID(this.v);
            Node u = (Node)network.getVertexByID(this.u);
            Vertex _v = v != null ? residualNetwork.getVertexByCaption(v.getCaption()) : null;
            Vertex _u = u != null ? residualNetwork.getVertexByCaption(u.getCaption()) : null;
            int i = 0;
            while (i < RelabelToFrontAlgorithmPlugin.this.residualNetworkView.getVisualVertexCount()) {
                GraphView.VisualVertex vv = RelabelToFrontAlgorithmPlugin.this.residualNetworkView.getVisualVertex(i);
                if (vv.getVertex() == _v) {
                    vv.setBackground(RelabelToFrontAlgorithmPlugin.this.colorV);
                } else if (vv.getVertex() == _u) {
                    vv.setBackground(RelabelToFrontAlgorithmPlugin.this.colorU);
                } else if (vv.getVertex().getCaption().equals(network.getSource().getCaption())) {
                    vv.setBackground(RelabelToFrontAlgorithmPlugin.this.colorSource);
                } else if (vv.getVertex().getCaption().equals(network.getSink().getCaption())) {
                    vv.setBackground(RelabelToFrontAlgorithmPlugin.this.colorSink);
                } else {
                    vv.setBackground(GraphView.DEF_VERTEXBACKGROUND);
                }
                vv.setEdgeWidth(1);
                ++i;
            }
            RelabelToFrontAlgorithmPlugin.this.residualNetworkView.repaint();
        }

        private void visualizeEdgesInResidualNetwork() {
            Network network = RelabelToFrontAlgorithmPlugin.this.networkView.getGraph();
            ResidualNetwork residualNetwork = RelabelToFrontAlgorithmPlugin.this.residualNetworkView.getGraph();
            Node v = (Node)network.getVertexByID(this.v);
            Node u = (Node)network.getVertexByID(this.u);
            Vertex _v = v != null ? residualNetwork.getVertexByCaption(v.getCaption()) : null;
            Vertex _u = u != null ? residualNetwork.getVertexByCaption(u.getCaption()) : null;
            RNEdge e = _v != null && _u != null ? (RNEdge)residualNetwork.getEdge(_v, _u) : null;
            int i = 0;
            while (i < RelabelToFrontAlgorithmPlugin.this.residualNetworkView.getVisualEdgeCount()) {
                GraphView.VisualEdge ve = RelabelToFrontAlgorithmPlugin.this.residualNetworkView.getVisualEdge(i);
                if (ve.getEdge() == e) {
                    ve.setColor(RelabelToFrontAlgorithmPlugin.this.colorEdgeVU);
                    ve.setLineWidth(RelabelToFrontAlgorithmPlugin.this.lineWidthEdgeVU);
                } else {
                    ve.setColor(GraphView.DEF_EDGECOLOR);
                    ve.setLineWidth(1);
                }
                ++i;
            }
            RelabelToFrontAlgorithmPlugin.this.residualNetworkView.repaint();
        }

        private void visualizeHeightLastChanged() {
            Network network = RelabelToFrontAlgorithmPlugin.this.networkView.getGraph();
            StringBuilder sb = new StringBuilder();
            for (Integer id : this.heightLastChanged) {
                Node n = (Node)network.getVertexByID(id.intValue());
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(n.getCaption());
            }
            RelabelToFrontAlgorithmPlugin.this.heightLastChangedView.setText(sb.toString());
        }

        private void visualizeFlowStrength() {
            if (this.flowStrengthDisplay == null) {
                return;
            }
            this.flowStrengthDisplay.setExpression("w(f) = " + RelabelToFrontAlgorithmPlugin.this.networkView.getGraph().getFlowStrength());
            RelabelToFrontAlgorithmPlugin.this.networkView.repaint();
        }

        private void moveToFront(int n, List<Integer> l) {
            int index = -1;
            int i = 0;
            while (i < l.size()) {
                if (l.get(i).equals(n)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index < 0) {
                return;
            }
            i = index;
            while (i > 0) {
                l.set(i, l.get(i - 1));
                --i;
            }
            l.set(0, n);
        }
    }
}

