/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.CircleLayoutToolBarExtension;
import lavesdk.algorithm.plugin.extensions.CompleteGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.MatrixToGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.AlgorithmTextView;
import lavesdk.algorithm.plugin.views.DefaultGraphView;
import lavesdk.algorithm.plugin.views.ExecutionTableView;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.LegendView;
import lavesdk.algorithm.plugin.views.TextAreaView;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.configuration.Configuration;
import lavesdk.gui.dialogs.InputDialog;
import lavesdk.gui.dialogs.SolveExerciseDialog;
import lavesdk.gui.dialogs.SolveExercisePane;
import lavesdk.gui.dialogs.enums.AllowedGraphType;
import lavesdk.gui.widgets.ColorProperty;
import lavesdk.gui.widgets.ExecutionTableBorder;
import lavesdk.gui.widgets.ExecutionTableColumn;
import lavesdk.gui.widgets.ExecutionTableGroup;
import lavesdk.gui.widgets.ExecutionTableItem;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;
import lavesdk.language.LanguageFile;
import lavesdk.math.Set;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Path;
import lavesdk.math.graph.PathByID;
import lavesdk.math.graph.SimpleGraph;
import lavesdk.math.graph.Vertex;
import lavesdk.serialization.Serializer;
import lavesdk.utils.GraphUtils;
import lavesdk.utils.MathUtils;
import main.CombiViewExerciseExt;
import main.EdgePair;

public class TwoOptAlgorithmPlugin
implements AlgorithmPlugin {
    private PluginHost host;
    private Configuration config;
    private LanguageFile langFile;
    private String langID;
    private FileNameExtensionFilter vgfFileFilter;
    private FileNameExtensionFilter pngFileFilter;
    private AlgorithmText algoText;
    private DefaultGraphView graphView;
    private AlgorithmTextView algoTextView;
    private TextAreaView cycleView;
    private ExecutionTableView combinationsView;
    private LegendView legendView;
    private TwoOptRTE rte;
    private MatrixToGraphToolBarExtension<Vertex, Edge> matrixToGraph;
    private CompleteGraphToolBarExtension<Vertex, Edge> completeExt;
    private CircleLayoutToolBarExtension<Vertex, Edge> circleLayoutExt;
    private Icon addIconRes;
    private Icon removeIconRes;
    private ViewGroup ab;
    private ViewGroup cd;
    private ViewGroup abcde;
    private Color colorCycleR;
    private Color colorCurrEdgePair;
    private Color colorNewEdgePairCombi;
    private Color colorExistingEdgePairCombi;
    private Color colorMaxSavings;
    private Color colorModified;
    private int lineWidthCycleR;
    private static final String CFGKEY_COLOR_CYCLER = "colorCycleR";
    private static final String CFGKEY_COLOR_CURREDGEPAIR = "colorCurrEdgePair";
    private static final String CFGKEY_COLOR_NEWEDGEPAIRCOMBI = "colorNewEdgePairCombi";
    private static final String CFGKEY_COLOR_EXISTINGEDGEPAIRCOMBI = "colorExistingEdgePairCombi";
    private static final String CFGKEY_COLOR_MAXSAVINGS = "colorMaxSavings";
    private static final String CFGKEY_COLOR_MODIFIED = "colorModified";
    private static final String CFGKEY_LINEWIDTH_CYCLER = "lineWidthCycleR";

    public void initialize(PluginHost host, ResourceLoader resLoader, Configuration config) {
        try {
            this.langFile = new LanguageFile(resLoader.getResourceAsStream("main/resources/langTwoOpt.txt"));
            this.langFile.include(host.getLanguageFile());
        }
        catch (IOException e) {
            this.langFile = null;
        }
        this.langID = host.getLanguageID();
        this.host = host;
        this.config = config != null ? config : new Configuration();
        this.vgfFileFilter = new FileNameExtensionFilter("Visual Graph File (*.vgf)", "vgf");
        this.pngFileFilter = new FileNameExtensionFilter("Portable Network Graphic (*.png)", "png");
        this.graphView = new DefaultGraphView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_GRAPH_TITLE", (String)this.langID, (String)"Graph"), (Graph)new SimpleGraph(false), null, true, this.langFile, this.langID);
        this.cycleView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_CYCLE_TITLE", (String)this.langID, (String)"Hamiltonian Cycle r"), true, this.langFile, this.langID);
        this.combinationsView = new ExecutionTableView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_COMBI_TITLE", (String)this.langID, (String)"Combinations"), true, this.langFile, this.langID);
        this.algoText = this.loadAlgorithmText();
        this.algoTextView = new AlgorithmTextView(host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ALGOTEXT_TITLE", (String)this.langID, (String)"Algorithm"), this.algoText, true, this.langFile, this.langID);
        this.legendView = new LegendView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LEGEND_TITLE", (String)this.langID, (String)"Legend"), true, this.langFile, this.langID);
        this.rte = new TwoOptRTE();
        this.matrixToGraph = new MatrixToGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.UNDIRECTED_ONLY, this.langFile, this.langID, true);
        this.completeExt = new CompleteGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.UNDIRECTED_ONLY, this.langFile, this.langID, true);
        this.circleLayoutExt = new CircleLayoutToolBarExtension((GraphView)this.graphView, this.langFile, this.langID, false);
        this.addIconRes = resLoader.getResourceAsIcon("main/resources/plus.png");
        this.removeIconRes = resLoader.getResourceAsIcon("main/resources/minus.png");
        this.algoTextView.setAutoRepaint(true);
        this.cycleView.setAutoRepaint(true);
        this.combinationsView.setAutoRepaint(true);
        this.combinationsView.setAutoResizeColumns(false);
        this.colorCycleR = this.config.getColor(CFGKEY_COLOR_CYCLER, new Color(200, 145, 145));
        this.colorCurrEdgePair = this.config.getColor(CFGKEY_COLOR_CYCLER, new Color(235, 190, 80));
        this.colorNewEdgePairCombi = this.config.getColor(CFGKEY_COLOR_CYCLER, new Color(105, 150, 180));
        this.colorExistingEdgePairCombi = this.config.getColor(CFGKEY_COLOR_CYCLER, new Color(180, 180, 180));
        this.colorMaxSavings = this.config.getColor(CFGKEY_COLOR_MAXSAVINGS, new Color(120, 210, 80));
        this.colorModified = this.config.getColor(CFGKEY_COLOR_MODIFIED, new Color(255, 180, 130));
        this.lineWidthCycleR = this.config.getInt(CFGKEY_LINEWIDTH_CYCLER, 3);
        this.graphView.loadConfiguration(config, "graphView");
        this.algoTextView.loadConfiguration(config, "algoTextView");
        this.cycleView.loadConfiguration(config, "cycleView");
        this.combinationsView.loadConfiguration(config, "combinationsView");
        this.legendView.loadConfiguration(config, "legendView");
        this.createLegend();
    }

    public String getName() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_NAME", (String)this.langID, (String)"2-opt");
    }

    public String getDescription() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_DESC", (String)this.langID, (String)"An improvement algorithm to find a Hamiltonian cycle that contains each vertex of a graph exactly once.");
    }

    public String getType() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_TYPE", (String)this.langID, (String)"Heuristic");
    }

    public String getAuthor() {
        return "Jan Dornseifer";
    }

    public String getAuthorContact() {
        return "jan.dornseifer@student.uni-siegen.de";
    }

    public String getAssumptions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_ASSUMPTIONS", (String)this.langID, (String)"A non-negative weighted, undirected graph K<sub>n</sub> with n > 2 and a Hamiltonian cycle r.");
    }

    public String getProblemAffiliation() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_PROBLEMAFFILIATION", (String)this.langID, (String)"Traveling salesman problem");
    }

    public String getSubject() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_SUBJECT", (String)this.langID, (String)"Logistics");
    }

    public String getInstructions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_INSTRUCTIONS", (String)this.langID, (String)"<b>Creating problem entities</b>:<br>Create your own graph and make sure that the graph complies with the assumptions of the algorithm. You can use<br>the toolbar extensions to check whether the created graph is complete, to create a complete graph by indicating the number of vertices, to<br>create a graph by use of an adjacency matrix or you can arrange the vertices of your created graph in a circle.<br><br><b>Starting the algorithm</b>:<br>Before you start the algorithm select a Hamiltonian cycle <i>r</i> the algorithm should begin with. Create the starting Hamiltonian cycle<br>by selecting the vertices one after another so that a valid cycle develops (that is, the cycle is created using the selection order of the<br>vertices). It is also possible that you start the algorithm without selecting any vertices and after that you open the input dialog in the<br>information message to enter a Hamiltonian cycle with the keyboard.<br><br><b>Exercise Mode</b>:<br>Activate the exercise mode to practice the algorithm in an interactive way. After you have started the algorithm<br>exercises are presented that you have to solve.<br>If an exercise can be solved directly in a view of the algorithm the corresponding view is highlighted with a border, there you can<br>enter your solution and afterwards you have to press the button to solve the exercise. Otherwise (if an exercise is not related to a specific<br>view) you can directly press the button to solve the exercise which opens a dialog where you can enter your solution of the exercise.");
    }

    public String getVersion() {
        return "1.3";
    }

    public LAVESDKV getUsedSDKVersion() {
        return new LAVESDKV(1, 3);
    }

    public AlgorithmRTE getRuntimeEnvironment() {
        return this.rte;
    }

    public AlgorithmText getText() {
        return this.algoText.getBaseCopy();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean hasExerciseMode() {
        return true;
    }

    public boolean hasCreatorPreferences() {
        return false;
    }

    public void loadCreatorPreferences(PropertiesListModel plm) {
    }

    public void onCreate(ViewContainer container, PropertiesListModel creatorProperties) {
        this.graphView.setGraph((Graph)new SimpleGraph(false));
        this.graphView.repaint();
        this.ab = new ViewGroup(1);
        this.cd = new ViewGroup(1);
        this.abcde = new ViewGroup(0);
        this.ab.add((Component)this.algoTextView);
        this.ab.add((Component)this.legendView);
        this.ab.restoreWeights((Serializer)this.config, "weights_ab", new float[]{0.6f, 0.4f});
        this.cd.add((Component)this.graphView);
        this.cd.add((Component)this.cycleView);
        this.cd.restoreWeights((Serializer)this.config, "weights_cd", new float[]{0.6f, 0.4f});
        this.abcde.add((Component)this.ab);
        this.abcde.add((Component)this.cd);
        this.abcde.add((Component)this.combinationsView);
        this.abcde.restoreWeights((Serializer)this.config, "weights_abcde", new float[]{0.3f, 0.4f, 0.3f});
        container.setLayout((LayoutManager)new BorderLayout());
        container.add((Component)this.abcde, (Object)"Center");
    }

    public void onClose() {
        this.graphView.saveConfiguration(this.config, "graphView");
        this.algoTextView.saveConfiguration(this.config, "algoTextView");
        this.cycleView.saveConfiguration(this.config, "cycleView");
        this.combinationsView.saveConfiguration(this.config, "combinationsView");
        this.legendView.saveConfiguration(this.config, "legendView");
        if (this.ab != null) {
            this.ab.storeWeights((Serializer)this.config, "weights_ab");
        }
        if (this.cd != null) {
            this.cd.storeWeights((Serializer)this.config, "weights_cd");
        }
        if (this.abcde != null) {
            this.abcde.storeWeights((Serializer)this.config, "weights_abcde");
        }
        this.graphView.reset();
        this.cycleView.reset();
        this.combinationsView.reset();
    }

    public boolean hasCustomization() {
        return true;
    }

    public void loadCustomization(PropertiesListModel plm) {
        plm.add((Property)new ColorProperty("algoTextHighlightForeground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTFOREGROUND", (String)this.langID, (String)"Foreground color of the current step in the algorithm"), this.algoTextView.getHighlightForeground()));
        plm.add((Property)new ColorProperty("algoTextHighlightBackground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTBACKGROUND", (String)this.langID, (String)"Background color of the current step in the algorithm"), this.algoTextView.getHighlightBackground()));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_CYCLER, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_CYCLER", (String)this.langID, (String)"Color of the Hamiltonian cycle r"), this.colorCycleR));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_CURREDGEPAIR, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_CURREDGEPAIR", (String)this.langID, (String)"Color of the current edge-pair (v<sub>i</sub>,v<sub>j</sub>) (v'<sub>i</sub>,v'<sub>j</sub>)"), this.colorCurrEdgePair));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_NEWEDGEPAIRCOMBI, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_NEWEDGEPAIRCOMBI", (String)this.langID, (String)"Color of a new combination of an edge-pair"), this.colorNewEdgePairCombi));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_EXISTINGEDGEPAIRCOMBI, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_EXISTINGEDGEPAIRCOMBI", (String)this.langID, (String)"Color of an existing combination of an edge-pair"), this.colorExistingEdgePairCombi));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MAXSAVINGS, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MAXSAVINGS", (String)this.langID, (String)"Background color of an item in the combinations table with a largest savings"), this.colorMaxSavings));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MODIFIED, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MODIFICATIONS", (String)this.langID, (String)"Color of modifications to objects"), this.colorModified));
        NumericProperty lwCycleR = new NumericProperty(CFGKEY_LINEWIDTH_CYCLER, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_CYCLER", (String)this.langID, (String)"Line with of the Hamiltonian cycle r"), (Number)this.lineWidthCycleR, true);
        lwCycleR.setMinimum(1);
        lwCycleR.setMaximum(5);
        plm.add((Property)lwCycleR);
    }

    public void applyCustomization(PropertiesListModel plm) {
        this.algoTextView.setHighlightForeground(plm.getColorProperty("algoTextHighlightForeground").getValue());
        this.algoTextView.setHighlightBackground(plm.getColorProperty("algoTextHighlightBackground").getValue());
        this.colorCycleR = this.config.addColor(CFGKEY_COLOR_CYCLER, plm.getColorProperty(CFGKEY_COLOR_CYCLER).getValue());
        this.colorCurrEdgePair = this.config.addColor(CFGKEY_COLOR_CURREDGEPAIR, plm.getColorProperty(CFGKEY_COLOR_CURREDGEPAIR).getValue());
        this.colorNewEdgePairCombi = this.config.addColor(CFGKEY_COLOR_NEWEDGEPAIRCOMBI, plm.getColorProperty(CFGKEY_COLOR_NEWEDGEPAIRCOMBI).getValue());
        this.colorExistingEdgePairCombi = this.config.addColor(CFGKEY_COLOR_EXISTINGEDGEPAIRCOMBI, plm.getColorProperty(CFGKEY_COLOR_EXISTINGEDGEPAIRCOMBI).getValue());
        this.colorMaxSavings = this.config.addColor(CFGKEY_COLOR_MAXSAVINGS, plm.getColorProperty(CFGKEY_COLOR_MAXSAVINGS).getValue());
        this.colorModified = this.config.addColor(CFGKEY_COLOR_MODIFIED, plm.getColorProperty(CFGKEY_COLOR_MODIFIED).getValue());
        this.lineWidthCycleR = this.config.addInt(CFGKEY_LINEWIDTH_CYCLER, plm.getNumericProperty(CFGKEY_LINEWIDTH_CYCLER).getValue().intValue());
        this.createLegend();
    }

    public ToolBarExtension[] getToolBarExtensions() {
        return new ToolBarExtension[]{this.matrixToGraph, this.completeExt, this.circleLayoutExt};
    }

    public void save(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.save(file);
            } else if (this.pngFileFilter.accept(file)) {
                this.graphView.saveAsPNG(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE", (String)this.langID, (String)"File could not be saved!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE_TITLE", (String)this.langID, (String)"Save File"), MessageIcon.ERROR);
        }
    }

    public void open(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.load(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE", (String)this.langID, (String)"File could not be opened!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE_TITLE", (String)this.langID, (String)"Open File"), MessageIcon.ERROR);
        }
    }

    public FileNameExtensionFilter[] getSaveFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter, this.pngFileFilter};
    }

    public FileNameExtensionFilter[] getOpenFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter};
    }

    public void beforeStart(RTEvent e) {
        if (this.graphView.getGraph().getOrder() <= 3) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INSUFFICIENTVERTEXCOUNT", (String)this.langID, (String)"The created graph does not comply with the assumptions!\nThe vertex count is insufficient."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INSUFFICIENTVERTEXCOUNT_TITLE", (String)this.langID, (String)"Invalid graph"), MessageIcon.INFO);
            e.doit = false;
        } else if (this.containsGraphNegativeWeights()) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NEGATIVEWEIGHTS", (String)this.langID, (String)"The created graph contains edges with a negative weight!\nThe 2-opt algorithm can only be applied to non-negative weighted graphs."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NEGATIVEWEIGHTS_TITLE", (String)this.langID, (String)"Negative weights"), MessageIcon.INFO);
            e.doit = false;
        } else if (!GraphUtils.isComplete((Graph)this.graphView.getGraph())) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NOTCOMPLETE", (String)this.langID, (String)"The created graph is not complete!\nThe 2-opt algorithm can only be applied to complete graphs."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NOTCOMPLETE_TITLE", (String)this.langID, (String)"No complete graph"), MessageIcon.INFO);
            e.doit = false;
        }
        if (e.doit) {
            Path p = new Path(this.graphView.getGraph());
            try {
                int i = 0;
                while (i < this.graphView.getSelectedVertexCount()) {
                    p.add(this.graphView.getSelectedVertex(i).getVertex());
                    ++i;
                }
                if (this.graphView.getSelectedVertexCount() > 0) {
                    p.add(this.graphView.getSelectedVertex(0).getVertex());
                }
            }
            catch (IllegalArgumentException ex) {
                p = null;
            }
            if (p == null || !p.isClosed() || p.length() != this.graphView.getGraph().getOrder()) {
                Object[] options = new Object[]{LanguageFile.getLabel((LanguageFile)this.langFile, (String)"DLG_BTN_OK", (String)this.langID, (String)"Ok"), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_SELECTSTARTCYCLE_CREATE", (String)this.langID, (String)"Input...")};
                JOptionPane pane = new JOptionPane(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_SELECTSTARTCYCLE", (String)this.langID, (String)"Please select a valid starting Hamiltonian cycle!\nCreate the Hamiltonian cycle by selecting the vertices in the graph one after another so that a valid cycle develops\n(that is, the cycle is created using the selection order of the vertices).\n\nRemember that a Hamiltonian cycle contains all vertices of a graph!"), 1, 0, null, options, options[0]);
                JDialog dlg = pane.createDialog(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_SELECTSTARTCYCLE_TITLE", (String)this.langID, (String)"Select Hamiltonian cycle"));
                this.host.adaptDialog(dlg);
                dlg.setVisible(true);
                Object option = pane.getValue();
                if (option == null || option.equals(options[0])) {
                    e.doit = false;
                    return;
                }
                if (option.equals(options[1])) {
                    InputDialog inputDlg = new InputDialog(this.host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CYCLEINPUTDLG_TITLE", (String)this.langID, (String)"Enter starting Hamiltonian Cycle"), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CYCLEINPUTDLG_DESC", (String)this.langID, (String)"Use a comma as the delimiter!<br>Enter the starting Hamiltonian cycle in the following form:<br>v<sub>1</sub>, v<sub>2</sub>, ..., v<sub>1</sub>"), "r = ", this.langFile, this.langID);
                    inputDlg.setVisible(true);
                    p = null;
                    if (!(inputDlg.isCanceled() || (p = GraphUtils.toPath((String)inputDlg.getInput(), (Graph)this.graphView.getGraph())) != null && p.isClosed() && p.length() == this.graphView.getGraph().getOrder())) {
                        this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INVALIDCYCLEINPUT", (String)this.langID, (String)"Your input is incorrect!\nPlease enter the Hamiltonian cycle in the specified form and only use vertex captions that are existing."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INVALIDCYCLEINPUT_TITLE", (String)this.langID, (String)"Invalid input"), MessageIcon.INFO);
                        p = null;
                    }
                    if (p == null) {
                        e.doit = false;
                        return;
                    }
                }
            }
            this.graphView.deselectAll();
            this.graphView.setEditable(false);
            this.combinationsView.reset();
            this.cycleView.reset();
            this.rte.setStartingHamiltonianCycle((Path<Vertex>)p);
            ExecutionTableColumn column = new ExecutionTableColumn(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_COMBI_COLUMN_OUT", (String)this.langID, (String)"Out (v<sub>i</sub>,v<sub>j</sub>) (v'<sub>i</sub>,v'<sub>j</sub>)"));
            column.setWidth(125);
            this.combinationsView.add(column);
            column = new ExecutionTableColumn(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_COMBI_COLUMN_IN", (String)this.langID, (String)"In (v<sub>i</sub>,v'<sub>i</sub>) (v<sub>j</sub>,v'<sub>j</sub>)"));
            column.setWidth(125);
            this.combinationsView.add(column);
            column = new ExecutionTableColumn(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_COMBI_COLUMN_SAVINGS", (String)this.langID, (String)"Savings"));
            column.setWidth(125);
            this.combinationsView.add(column);
            column = new ExecutionTableColumn(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_COMBI_COLUMN_LENGTH", (String)this.langID, (String)"Length r'"));
            column.setWidth(75);
            this.combinationsView.add(column);
            ExecutionTableBorder groupBorder = new ExecutionTableBorder(2, Color.black);
            this.combinationsView.addColumnGroup(new ExecutionTableGroup(groupBorder, 0));
            this.combinationsView.addColumnGroup(new ExecutionTableGroup(groupBorder, 1));
        }
    }

    public void beforeResume(RTEvent e) {
    }

    public void beforePause(RTEvent e) {
    }

    public void onStop() {
        this.graphView.setEditable(true);
    }

    public void onRunning() {
    }

    public void onPause() {
    }

    private AlgorithmText loadAlgorithmText() {
        AlgorithmText text = new AlgorithmText();
        AlgorithmParagraph itParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_ITERATION", (String)this.langID, (String)"1. Iteration:"), 1);
        AlgorithmParagraph varParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_VARIATION", (String)this.langID, (String)"2. Variation:"), 2);
        AlgorithmParagraph stopParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_STOPCRITERION", (String)this.langID, (String)"3. Stop criterion:"), 3);
        AlgorithmStep step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP1_IT", (String)this.langID, (String)"Choose two edges _latex{$(v_i,v_j)$}, _latex{$(v'_i,v'_j)$} from _latex{$r$}, which have no common endpoint.\nExecute step 2 for all possible combinations of such edge-pairs.\n\n"), 1);
        step.setExercise(new AlgorithmExercise<List<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP1", (String)this.langID, (String)"Specify all possible combinations of edge-pairs and their substitutions in the table (<i>use the buttons in the header bar of the combinations view to add or remove items and regard that the input pattern has to be \"(...,...) (...,...)\", where the ellipsis have to be replaced with the corresponding vertex captions</i>)."), 2.0f, (View)this.combinationsView){
            private CombiViewExerciseExt ext;
            private int firstIndex;
            private boolean lastExaminationSucceeded;
            {
                this.firstIndex = -1;
                this.lastExaminationSucceeded = true;
            }

            protected void beforeRequestSolution(AlgorithmState state) {
                this.ext = new CombiViewExerciseExt(TwoOptAlgorithmPlugin.this.combinationsView, (Graph<Vertex, Edge>)TwoOptAlgorithmPlugin.this.graphView.getGraph(), TwoOptAlgorithmPlugin.this.addIconRes, TwoOptAlgorithmPlugin.this.removeIconRes, TwoOptAlgorithmPlugin.this.langFile, TwoOptAlgorithmPlugin.this.langID);
                this.ext.apply();
                TwoOptAlgorithmPlugin.this.combinationsView.getColumn(0).setEditable(true);
                TwoOptAlgorithmPlugin.this.combinationsView.getColumn(1).setEditable(true);
                if (this.lastExaminationSucceeded) {
                    this.firstIndex = TwoOptAlgorithmPlugin.this.combinationsView.getItemCount();
                } else {
                    int i = this.firstIndex;
                    while (i < TwoOptAlgorithmPlugin.this.combinationsView.getItemCount()) {
                        TwoOptAlgorithmPlugin.this.combinationsView.getItem(i).setEditable(false);
                        ++i;
                    }
                }
            }

            protected void afterRequestSolution(boolean omitted) {
                this.ext.remove();
                this.ext = null;
                TwoOptAlgorithmPlugin.this.combinationsView.getColumn(0).setEditable(false);
                TwoOptAlgorithmPlugin.this.combinationsView.getColumn(1).setEditable(false);
                if (omitted) {
                    int i = TwoOptAlgorithmPlugin.this.combinationsView.getItemCount() - 1;
                    while (i >= this.firstIndex) {
                        TwoOptAlgorithmPlugin.this.combinationsView.remove(TwoOptAlgorithmPlugin.this.combinationsView.getItem(i));
                        --i;
                    }
                } else {
                    int i = 0;
                    while (i < TwoOptAlgorithmPlugin.this.combinationsView.getItemCount()) {
                        TwoOptAlgorithmPlugin.this.combinationsView.getItem(i).setEditable(false);
                        ++i;
                    }
                }
                this.lastExaminationSucceeded = true;
            }

            protected List<?>[] requestSolution() {
                ArrayList<EdgePair> pairs = new ArrayList<EdgePair>();
                ArrayList<EdgePair> substitutedPairs = new ArrayList<EdgePair>();
                int i = this.firstIndex;
                while (i < TwoOptAlgorithmPlugin.this.combinationsView.getItemCount()) {
                    pairs.add((EdgePair)TwoOptAlgorithmPlugin.this.combinationsView.getItem(i).getCellObject(0));
                    substitutedPairs.add((EdgePair)TwoOptAlgorithmPlugin.this.combinationsView.getItem(i).getCellObject(1));
                    ++i;
                }
                return new List[]{pairs, substitutedPairs};
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, List<?>[] solutions) {
                List<?> pairs = solutions[0];
                state.addSet("edgePairs", new Set(pairs));
            }

            protected boolean examine(List<?>[] results, AlgorithmState state) {
                Graph graph = TwoOptAlgorithmPlugin.this.graphView.getGraph();
                Path r = state.getPath("r", graph).cast();
                Set edgePairs = new Set();
                Set substitutedPairs = new Set();
                int i = 0;
                while (i < r.length()) {
                    int v_i = r.get(i).getID();
                    int v_j = r.get(i + 1).getID();
                    int j = i + 2;
                    int k = 1;
                    while (k <= r.length() - 3) {
                        if (j >= r.length()) {
                            j -= r.length();
                        }
                        int v_i_Apo = r.get(j).getID();
                        int v_j_Apo = r.get(j + 1).getID();
                        EdgePair edgePair = new EdgePair((Graph<Vertex, Edge>)graph, v_i, v_j, v_i_Apo, v_j_Apo);
                        edgePairs.add((Object)edgePair);
                        substitutedPairs.add((Object)EdgePair.substitute(edgePair, (Graph<Vertex, Edge>)graph));
                        ++j;
                        ++k;
                    }
                    ++i;
                }
                this.lastExaminationSucceeded = edgePairs.size() == results[0].size() && edgePairs.containsAll(results[0]) && substitutedPairs.size() == results[1].size() && substitutedPairs.containsAll(results[1]);
                return this.lastExaminationSucceeded;
            }
        });
        step = new AlgorithmStep(varParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP2_VARIATION", (String)this.langID, (String)"Determine the length of the Hamiltonian cycle _latex{$r'$}, where compared to _latex{$r$} edges _latex{$(v_i,v_j)$} and _latex{$(v'_i,v'_j)$} are substituted by edges _latex{$(v_i,v'_i)$}, _latex{$(v_j,v'_j)$} and the path from _latex{$v_j$} to _latex{$v'_i$} will be traversed in reverse direction.\n\n"), 2);
        step.setExercise(new AlgorithmExercise<List<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP2", (String)this.langID, (String)"What are the savings and the consequent lengths of <i>r'</i> for the particular edge-pairs?"), 2.0f, (View)this.combinationsView){

            protected void beforeRequestSolution(AlgorithmState state) {
                TwoOptAlgorithmPlugin.this.combinationsView.getColumn(2).setEditable(true);
                TwoOptAlgorithmPlugin.this.combinationsView.getColumn(3).setEditable(true);
                ExecutionTableGroup group = TwoOptAlgorithmPlugin.this.combinationsView.getItemGroup(TwoOptAlgorithmPlugin.this.combinationsView.getItemGroupCount() - 1);
                int i = group.getStart();
                while (i < group.getStart() + group.getAmount()) {
                    ExecutionTableItem item = TwoOptAlgorithmPlugin.this.combinationsView.getItem(i);
                    item.setEditable(true);
                    item.setDefaultInputParser((ExecutionTableItem.InputParser)new ExecutionTableItem.NumericInputParser());
                    ++i;
                }
            }

            protected void afterRequestSolution(boolean omitted) {
                TwoOptAlgorithmPlugin.this.combinationsView.getColumn(2).setEditable(false);
                TwoOptAlgorithmPlugin.this.combinationsView.getColumn(3).setEditable(false);
                ExecutionTableGroup group = TwoOptAlgorithmPlugin.this.combinationsView.getItemGroup(TwoOptAlgorithmPlugin.this.combinationsView.getItemGroupCount() - 1);
                int i = group.getStart();
                while (i < group.getStart() + group.getAmount()) {
                    TwoOptAlgorithmPlugin.this.combinationsView.getItem(i).setEditable(false);
                    ++i;
                }
            }

            protected List<?>[] requestSolution() {
                ExecutionTableGroup group = TwoOptAlgorithmPlugin.this.combinationsView.getItemGroup(TwoOptAlgorithmPlugin.this.combinationsView.getItemGroupCount() - 1);
                ArrayList<Float> savings = new ArrayList<Float>();
                ArrayList<Float> lengths = new ArrayList<Float>();
                int i = group.getStart();
                while (i < group.getStart() + group.getAmount()) {
                    ExecutionTableItem item = TwoOptAlgorithmPlugin.this.combinationsView.getItem(i);
                    Number currSavings = (Number)item.getCellObject(2);
                    Number currLength = (Number)item.getCellObject(3);
                    savings.add(currSavings != null ? Float.valueOf(currSavings.floatValue()) : null);
                    lengths.add(currLength != null ? Float.valueOf(currLength.floatValue()) : null);
                    ++i;
                }
                return new List[]{savings, lengths};
            }

            protected boolean examine(List<?>[] results, AlgorithmState state) {
                Set pairs = state.getSet("edgePairs");
                PathByID r = state.getPath("r", TwoOptAlgorithmPlugin.this.graphView.getGraph());
                List<?> savings = results[0];
                List<?> lengths = results[1];
                int i = 0;
                while (i < pairs.size()) {
                    EdgePair ep = (EdgePair)pairs.get(i);
                    if (((Float)savings.get(i)).floatValue() != ep.getSavings() || ((Float)lengths.get(i)).floatValue() != r.getWeight() - ep.getSavings()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        });
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP3_STOP", (String)this.langID, (String)"If the shortest Hamiltonian cycle _latex{$r'$} found in step 2 is shorter than _latex{$r$} "), 3);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Boolean>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP3", (String)this.langID, (String)"Is their a shorter Hamiltonian cycle than <i>r</i>?"), 1.0f){
            private final String labelYes;
            private final String labelNo;
            {
                this.labelYes = LanguageFile.getLabel((LanguageFile)TwoOptAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP3_YES", (String)TwoOptAlgorithmPlugin.this.langID, (String)"Yes");
                this.labelNo = LanguageFile.getLabel((LanguageFile)TwoOptAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP3_NO", (String)TwoOptAlgorithmPlugin.this.langID, (String)"No");
            }

            protected Boolean[] requestSolution() {
                ButtonGroup group = new ButtonGroup();
                JRadioButton rdobtn1 = new JRadioButton(this.labelYes);
                JRadioButton rdobtn2 = new JRadioButton(this.labelNo);
                group.add(rdobtn1);
                group.add(rdobtn2);
                SolveExerciseDialog.SolutionEntry entryYes = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn1);
                SolveExerciseDialog.SolutionEntry entryNo = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn2);
                if (!SolveExercisePane.showDialog((PluginHost)TwoOptAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryYes, entryNo}, (LanguageFile)TwoOptAlgorithmPlugin.this.langFile, (String)TwoOptAlgorithmPlugin.this.langID)) {
                    return null;
                }
                return new Boolean[]{!rdobtn1.isSelected() && !rdobtn2.isSelected() ? null : Boolean.valueOf(rdobtn1.isSelected())};
            }

            protected String getResultAsString(Boolean result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return result == Boolean.TRUE ? this.labelYes : this.labelNo;
            }

            protected boolean examine(Boolean[] results, AlgorithmState state) {
                int maxSavingsEdgePair = state.getInt("maxSavingsEdgePair");
                return results[0] != null && results[0] == maxSavingsEdgePair >= 0;
            }
        });
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP4_STOP", (String)this.langID, (String)"then set _latex{$r = r'$} and go to step 1. "), 4);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<String>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP4", (String)this.langID, (String)"What is the new Hamiltonian cycle <i>r</i>?"), 1.0f){

            protected String[] requestSolution() {
                SolveExerciseDialog.SolutionEntry entry = new SolveExerciseDialog.SolutionEntry("r=", (Component)new JTextField());
                if (!SolveExercisePane.showDialog((PluginHost)TwoOptAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entry}, (LanguageFile)TwoOptAlgorithmPlugin.this.langFile, (String)TwoOptAlgorithmPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)TwoOptAlgorithmPlugin.this.langFile, (String)"EXERCISE_HINT_CYCLEINPUT", (String)TwoOptAlgorithmPlugin.this.langID, (String)"Use a comma as the delimiter!<br>Enter the starting Hamiltonian cycle in the following form:<br>v<sub>1</sub>, v<sub>2</sub>, ..., v<sub>1</sub>"))) {
                    return null;
                }
                Path p = GraphUtils.toPath((String)((JTextField)entry.getComponent()).getText(), (Graph)TwoOptAlgorithmPlugin.this.graphView.getGraph());
                if (p == null) {
                    TwoOptAlgorithmPlugin.this.host.showMessage((AlgorithmPlugin)TwoOptAlgorithmPlugin.this, LanguageFile.getLabel((LanguageFile)TwoOptAlgorithmPlugin.this.langFile, (String)"MSG_INFO_INVALIDCYCLEINPUT", (String)TwoOptAlgorithmPlugin.this.langID, (String)"Your input is incorrect!\nPlease enter the Hamiltonian cycle in the specified form and only use vertex captions that are existing."), LanguageFile.getLabel((LanguageFile)TwoOptAlgorithmPlugin.this.langFile, (String)"MSG_INFO_INVALIDCYCLEINPUT_TITLE", (String)TwoOptAlgorithmPlugin.this.langID, (String)"Invalid input"), MessageIcon.INFO);
                    return null;
                }
                return new String[]{((JTextField)entry.getComponent()).getText()};
            }

            protected String getResultAsString(String result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                if (result.startsWith("(") && result.endsWith(")")) {
                    return "r=" + result;
                }
                return "r=(" + result + ")";
            }

            protected boolean examine(String[] results, AlgorithmState state) {
                PathByID r = state.getPath("r", TwoOptAlgorithmPlugin.this.graphView.getGraph());
                Path p = GraphUtils.toPath((String)results[0], (Graph)TwoOptAlgorithmPlugin.this.graphView.getGraph());
                return r.equals(p.cast());
            }
        });
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5_STOP", (String)this.langID, (String)"Otherwise stop."), 5);
        return text;
    }

    private void createLegend() {
        this.legendView.removeAll();
        this.legendView.add(new LegendItem("item1", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CYCLER", (String)this.langID, (String)"The Hamiltonian cycle r"), LegendItem.createLineIcon((Color)this.colorCycleR, (int)this.lineWidthCycleR, (int)4)));
        this.legendView.add(new LegendItem("item2", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CURREDGEPAIR", (String)this.langID, (String)"The current edge-pair (v<sub>i</sub>,v<sub>j</sub>) (v'<sub>i</sub>,v'<sub>j</sub>)"), LegendItem.createLineIcon((Color)this.colorCurrEdgePair, (int)this.lineWidthCycleR, (int)4)));
        this.legendView.add(new LegendItem("item3", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_NEWEDGEPAIRCOMBI", (String)this.langID, (String)"A new combination of an edge-pair"), LegendItem.createLineIcon((Color)this.colorNewEdgePairCombi, (int)this.lineWidthCycleR, (int)4)));
        this.legendView.add(new LegendItem("item4", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_EXISTINGEDGEPAIRCOMBI", (String)this.langID, (String)"An existing combination of an edge-pair"), LegendItem.createLineIcon((Color)this.colorExistingEdgePairCombi, (int)this.lineWidthCycleR, (int)4)));
        this.legendView.add(new LegendItem("item5", this.combinationsView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_COMBI_CURREDGEPAIR", (String)this.langID, (String)"The current edge-pair that is inspected"), LegendItem.createRectangleIcon((Color)this.colorCurrEdgePair, (Color)this.colorCurrEdgePair, (int)0)));
        this.legendView.add(new LegendItem("item6", this.combinationsView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_COMBI_NEWEDGEPAIRCOMBI", (String)this.langID, (String)"The new edge-pair combination"), LegendItem.createRectangleIcon((Color)this.colorNewEdgePairCombi, (Color)this.colorNewEdgePairCombi, (int)0)));
        this.legendView.add(new LegendItem("item7", this.combinationsView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_COMBI_EXISTINGEDGEPAIRCOMBI", (String)this.langID, (String)"The existing edge-pair combination"), LegendItem.createRectangleIcon((Color)this.colorExistingEdgePairCombi, (Color)this.colorExistingEdgePairCombi, (int)0)));
        this.legendView.add(new LegendItem("item8", this.combinationsView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_COMBI_MAXSAVINGS", (String)this.langID, (String)"The edge-pair combination with a largest savings and thereby a shorter Hamiltonian cycle"), LegendItem.createRectangleIcon((Color)this.colorMaxSavings, (Color)this.colorMaxSavings, (int)0)));
        this.legendView.add(new LegendItem("item9", this.cycleView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_CYCLE_MODIFICATION", (String)this.langID, (String)"The Hamiltonian cycle r becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
    }

    private boolean containsGraphNegativeWeights() {
        Graph graph = this.graphView.getGraph();
        int i = 0;
        while (i < graph.getSize()) {
            if (graph.getEdge(i).getWeight() < 0.0f) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class TwoOptRTE
    extends AlgorithmRTE {
        private final String labelLengthCycle;
        private Path<Vertex> startR;
        private Path<Vertex> r;
        private Set<EdgePair> edgePairs;
        private int maxSavingsEdgePair;
        private Set<EdgePair> userChoiceEdgePairs;

        public TwoOptRTE() {
            super((AlgorithmPlugin)TwoOptAlgorithmPlugin.this, TwoOptAlgorithmPlugin.this.algoText);
            this.labelLengthCycle = LanguageFile.getLabel((LanguageFile)TwoOptAlgorithmPlugin.this.langFile, (String)"VIEW_CYCLE_LENGTH", (String)TwoOptAlgorithmPlugin.this.langID, (String)"Length:");
            this.r = null;
            this.userChoiceEdgePairs = null;
        }

        public void setStartingHamiltonianCycle(Path<Vertex> r) {
            this.startR = r.clone();
            this.r = this.startR.clone();
            this.visualizeCycleAsText();
            this.visualizeCycle();
        }

        protected int executeStep(int stepID, AlgorithmStateAttachment asa) throws Exception {
            Graph graph = TwoOptAlgorithmPlugin.this.graphView.getGraph();
            int nextStep = -1;
            switch (stepID) {
                case 1: {
                    if (this.userChoiceEdgePairs != null) {
                        this.edgePairs = this.userChoiceEdgePairs;
                    } else {
                        this.sleep(250L);
                        this.edgePairs = new Set();
                        int i = 0;
                        while (i < this.r.length()) {
                            int v_i = this.r.get(i).getID();
                            int v_j = this.r.get(i + 1).getID();
                            GraphView.VisualEdge veV_iV_j = TwoOptAlgorithmPlugin.this.graphView.getVisualEdge(graph.getEdge(v_i, v_j));
                            if (veV_iV_j != null) {
                                veV_iV_j.setColor(TwoOptAlgorithmPlugin.this.colorCurrEdgePair);
                                veV_iV_j.getPredecessor().setForeground(TwoOptAlgorithmPlugin.this.colorCurrEdgePair);
                                veV_iV_j.getSuccessor().setForeground(TwoOptAlgorithmPlugin.this.colorCurrEdgePair);
                                TwoOptAlgorithmPlugin.this.graphView.repaint();
                            }
                            this.sleep(250L);
                            int j = i + 2;
                            int k = 1;
                            while (k <= this.r.length() - 3) {
                                ExecutionTableItem item;
                                if (j >= this.r.length()) {
                                    j -= this.r.length();
                                }
                                int v_i_Apo = this.r.get(j).getID();
                                int v_j_Apo = this.r.get(j + 1).getID();
                                EdgePair ep = new EdgePair((Graph<Vertex, Edge>)graph, v_i, v_j, v_i_Apo, v_j_Apo);
                                GraphView.VisualEdge veV_i_ApoV_j_Apo = TwoOptAlgorithmPlugin.this.graphView.getVisualEdge(graph.getEdge(v_i_Apo, v_j_Apo));
                                if (veV_i_ApoV_j_Apo != null) {
                                    veV_i_ApoV_j_Apo.setColor(TwoOptAlgorithmPlugin.this.colorCurrEdgePair);
                                    veV_i_ApoV_j_Apo.getPredecessor().setForeground(TwoOptAlgorithmPlugin.this.colorCurrEdgePair);
                                    veV_i_ApoV_j_Apo.getSuccessor().setForeground(TwoOptAlgorithmPlugin.this.colorCurrEdgePair);
                                    TwoOptAlgorithmPlugin.this.graphView.repaint();
                                }
                                this.sleep(500L);
                                if (this.edgePairs.add((Object)ep)) {
                                    item = new ExecutionTableItem(new Object[]{ep, EdgePair.substitute(ep, (Graph<Vertex, Edge>)graph)});
                                    TwoOptAlgorithmPlugin.this.combinationsView.add(item);
                                    item.setBackground(TwoOptAlgorithmPlugin.this.colorNewEdgePairCombi);
                                    if (veV_iV_j != null && veV_i_ApoV_j_Apo != null) {
                                        veV_iV_j.setColor(TwoOptAlgorithmPlugin.this.colorNewEdgePairCombi);
                                        veV_i_ApoV_j_Apo.setColor(TwoOptAlgorithmPlugin.this.colorNewEdgePairCombi);
                                        TwoOptAlgorithmPlugin.this.graphView.repaint();
                                    }
                                } else {
                                    int itemIndex = -1;
                                    int l = 0;
                                    while (l < this.edgePairs.size()) {
                                        if (((EdgePair)this.edgePairs.get(l)).equals(ep)) {
                                            itemIndex = l;
                                            break;
                                        }
                                        ++l;
                                    }
                                    ExecutionTableItem executionTableItem = item = itemIndex >= 0 ? TwoOptAlgorithmPlugin.this.combinationsView.getItem(TwoOptAlgorithmPlugin.this.combinationsView.getItemCount() - this.edgePairs.size() + itemIndex) : null;
                                    if (item != null) {
                                        item.setBackground(TwoOptAlgorithmPlugin.this.colorExistingEdgePairCombi);
                                    }
                                    if (veV_iV_j != null && veV_i_ApoV_j_Apo != null) {
                                        veV_iV_j.setColor(TwoOptAlgorithmPlugin.this.colorExistingEdgePairCombi);
                                        veV_i_ApoV_j_Apo.setColor(TwoOptAlgorithmPlugin.this.colorExistingEdgePairCombi);
                                        TwoOptAlgorithmPlugin.this.graphView.repaint();
                                    }
                                }
                                this.sleep(250L);
                                if (item != null) {
                                    item.setBackground(Color.white);
                                }
                                if (veV_iV_j != null && veV_i_ApoV_j_Apo != null) {
                                    veV_iV_j.setColor(TwoOptAlgorithmPlugin.this.colorCurrEdgePair);
                                    veV_i_ApoV_j_Apo.setColor(TwoOptAlgorithmPlugin.this.colorCycleR);
                                    veV_i_ApoV_j_Apo.getPredecessor().setForeground(GraphView.DEF_VERTEXFOREGROUND);
                                    veV_i_ApoV_j_Apo.getSuccessor().setForeground(GraphView.DEF_VERTEXFOREGROUND);
                                    TwoOptAlgorithmPlugin.this.graphView.repaint();
                                }
                                ++j;
                                ++k;
                            }
                            this.sleep(250L);
                            if (veV_iV_j != null) {
                                veV_iV_j.setColor(TwoOptAlgorithmPlugin.this.colorCycleR);
                                veV_iV_j.getPredecessor().setForeground(GraphView.DEF_VERTEXFOREGROUND);
                                veV_iV_j.getSuccessor().setForeground(GraphView.DEF_VERTEXFOREGROUND);
                                TwoOptAlgorithmPlugin.this.graphView.repaint();
                            }
                            ++i;
                        }
                    }
                    this.userChoiceEdgePairs = null;
                    TwoOptAlgorithmPlugin.this.combinationsView.addItemGroup(new ExecutionTableGroup(new ExecutionTableBorder(2, Color.black), TwoOptAlgorithmPlugin.this.combinationsView.getItemCount() - this.edgePairs.size(), this.edgePairs.size()));
                    nextStep = 2;
                    break;
                }
                case 2: {
                    this.sleep(250L);
                    int i = 0;
                    while (i < this.edgePairs.size()) {
                        EdgePair ep = (EdgePair)this.edgePairs.get(i);
                        ExecutionTableItem item = TwoOptAlgorithmPlugin.this.combinationsView.getItem(TwoOptAlgorithmPlugin.this.combinationsView.getItemCount() - this.edgePairs.size() + i);
                        GraphView.VisualEdge veV_iV_j = TwoOptAlgorithmPlugin.this.graphView.getVisualEdge(graph.getEdge(ep.getV_i(), ep.getV_j()));
                        GraphView.VisualEdge veV_i_ApoV_j_Apo = TwoOptAlgorithmPlugin.this.graphView.getVisualEdge(graph.getEdge(ep.getV_i_Apo(), ep.getV_j_Apo()));
                        if (veV_iV_j != null && veV_i_ApoV_j_Apo != null) {
                            veV_iV_j.setColor(TwoOptAlgorithmPlugin.this.colorCurrEdgePair);
                            veV_i_ApoV_j_Apo.setColor(TwoOptAlgorithmPlugin.this.colorCurrEdgePair);
                            TwoOptAlgorithmPlugin.this.graphView.repaint();
                        }
                        this.sleep(500L);
                        item.setBackground(TwoOptAlgorithmPlugin.this.colorCurrEdgePair);
                        this.sleep(500L);
                        item.setCellObject(2, (Object)ep.savingsToString());
                        this.sleep(250L);
                        item.setCellObject(3, (Object)MathUtils.formatFloat((float)(this.r.getWeight() - ep.getSavings())));
                        this.sleep(500L);
                        if (veV_iV_j != null && veV_i_ApoV_j_Apo != null) {
                            veV_iV_j.setColor(TwoOptAlgorithmPlugin.this.colorCycleR);
                            veV_i_ApoV_j_Apo.setColor(TwoOptAlgorithmPlugin.this.colorCycleR);
                            TwoOptAlgorithmPlugin.this.graphView.repaint();
                        }
                        item.setBackground(Color.white);
                        ++i;
                    }
                    nextStep = 3;
                    break;
                }
                case 3: {
                    float maxSavings = 0.0f;
                    this.maxSavingsEdgePair = -1;
                    int i = 0;
                    while (i < this.edgePairs.size()) {
                        EdgePair ep = (EdgePair)this.edgePairs.get(i);
                        if (ep.getSavings() > maxSavings) {
                            maxSavings = ep.getSavings();
                            this.maxSavingsEdgePair = i;
                        }
                        ++i;
                    }
                    if (this.maxSavingsEdgePair >= 0) {
                        this.sleep(500L);
                        ExecutionTableItem item = TwoOptAlgorithmPlugin.this.combinationsView.getItem(TwoOptAlgorithmPlugin.this.combinationsView.getItemCount() - this.edgePairs.size() + this.maxSavingsEdgePair);
                        item.setBackground(TwoOptAlgorithmPlugin.this.colorMaxSavings);
                        this.sleep(1000L);
                        item.setBackground(Color.white);
                        TwoOptAlgorithmPlugin.this.combinationsView.repaint();
                        nextStep = 4;
                        break;
                    }
                    nextStep = 5;
                    break;
                }
                case 4: {
                    EdgePair ep = (EdgePair)this.edgePairs.get(this.maxSavingsEdgePair);
                    this.sleep(250L);
                    this.visualizeSubstitution();
                    List r_Apo = this.r.asList();
                    int v_jIndex = -1;
                    int v_i_ApoIndex = -1;
                    int i = 0;
                    while (i < r_Apo.size()) {
                        if (((Vertex)r_Apo.get(i)).getID() == ep.getV_j()) {
                            v_jIndex = i;
                        } else if (((Vertex)r_Apo.get(i)).getID() == ep.getV_i_Apo()) {
                            v_i_ApoIndex = i;
                        }
                        if (v_jIndex != -1 && v_i_ApoIndex != -1) break;
                        ++i;
                    }
                    if (v_jIndex < 0 || v_i_ApoIndex < 0) {
                        nextStep = -1;
                        break;
                    }
                    i = v_jIndex;
                    int j = v_i_ApoIndex;
                    while (i < j) {
                        Vertex tmpV = (Vertex)r_Apo.get(i);
                        r_Apo.set(i, (Vertex)r_Apo.get(j));
                        r_Apo.set(j, tmpV);
                        ++i;
                        --j;
                    }
                    this.r = new Path(graph, r_Apo);
                    this.sleep(250L);
                    TwoOptAlgorithmPlugin.this.cycleView.setBackground(TwoOptAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeCycleAsText();
                    this.sleep(250L);
                    TwoOptAlgorithmPlugin.this.cycleView.setBackground(Color.white);
                    this.sleep(250L);
                    this.visualizeCycle();
                    this.sleep(1000L);
                    nextStep = 1;
                    break;
                }
                case 5: {
                    this.sleep(1000L);
                    nextStep = -1;
                }
            }
            return nextStep;
        }

        protected void storeState(AlgorithmState state) {
            state.addPath("r", this.r.cast());
            state.addSet("edgePairs", this.edgePairs);
            state.addInt("maxSavingsEdgePair", this.maxSavingsEdgePair);
        }

        protected void restoreState(AlgorithmState state) {
            PathByID tmpR = state.getPath("", TwoOptAlgorithmPlugin.this.graphView.getGraph());
            this.r = tmpR != null ? tmpR.cast() : this.startR.clone();
            this.edgePairs = state.getSet("edgePairs");
            this.maxSavingsEdgePair = state.getInt("maxSavingsEdgePair");
        }

        protected void createInitialState(AlgorithmState state) {
            state.addPath("r", null);
            this.edgePairs = state.addSet("edgePairs", new Set());
            this.maxSavingsEdgePair = state.addInt("maxSavingsEdgePair", -1);
        }

        protected void rollBackStep(int stepID, int nextStepID) {
            switch (stepID) {
                case 1: {
                    ExecutionTableGroup group = TwoOptAlgorithmPlugin.this.combinationsView.getItemGroup(TwoOptAlgorithmPlugin.this.combinationsView.getItemGroupCount() - 1);
                    int i = group.getStart() + group.getAmount() - 1;
                    while (i >= group.getStart()) {
                        TwoOptAlgorithmPlugin.this.combinationsView.remove(TwoOptAlgorithmPlugin.this.combinationsView.getItem(i));
                        --i;
                    }
                    TwoOptAlgorithmPlugin.this.combinationsView.removeItemGroup(group);
                    break;
                }
                case 2: {
                    ExecutionTableGroup group = TwoOptAlgorithmPlugin.this.combinationsView.getItemGroup(TwoOptAlgorithmPlugin.this.combinationsView.getItemGroupCount() - 1);
                    int i = group.getStart();
                    while (i < group.getStart() + group.getAmount()) {
                        ExecutionTableItem item = TwoOptAlgorithmPlugin.this.combinationsView.getItem(i);
                        item.setCellObject(2, null);
                        item.setCellObject(3, null);
                        ++i;
                    }
                    this.visualizeCycle();
                    break;
                }
                case 3: {
                    this.visualizeCycle();
                    break;
                }
                case 4: {
                    this.visualizeCycle();
                    this.visualizeCycleAsText();
                    this.visualizeSubstitution();
                }
            }
        }

        protected void adoptState(int stepID, AlgorithmState state) {
            if (stepID == 1) {
                this.userChoiceEdgePairs = state.getSet("edgePairs");
            }
        }

        protected View[] getViews() {
            return new View[]{TwoOptAlgorithmPlugin.this.graphView, TwoOptAlgorithmPlugin.this.cycleView, TwoOptAlgorithmPlugin.this.combinationsView};
        }

        private void visualizeCycle() {
            if (this.r == null) {
                return;
            }
            int i = 0;
            while (i < TwoOptAlgorithmPlugin.this.graphView.getVisualEdgeCount()) {
                GraphView.VisualEdge ve = TwoOptAlgorithmPlugin.this.graphView.getVisualEdge(i);
                if (this.r.contains(ve.getEdge())) {
                    ve.setColor(TwoOptAlgorithmPlugin.this.colorCycleR);
                    ve.setLineWidth(TwoOptAlgorithmPlugin.this.lineWidthCycleR);
                } else {
                    ve.setColor(GraphView.DEF_EDGECOLOR);
                    ve.setLineWidth(1);
                }
                ++i;
            }
            TwoOptAlgorithmPlugin.this.graphView.repaint();
        }

        private void visualizeCycleAsText() {
            TwoOptAlgorithmPlugin.this.cycleView.setText(String.valueOf(this.r != null ? "r=" + this.r.toString() : "") + "\n" + this.labelLengthCycle + " " + MathUtils.formatFloat((float)this.r.getWeight()));
        }

        private void visualizeSubstitution() {
            Graph graph = TwoOptAlgorithmPlugin.this.graphView.getGraph();
            EdgePair ep = (EdgePair)this.edgePairs.get(this.maxSavingsEdgePair);
            EdgePair substitutedEP = EdgePair.substitute(ep, (Graph<Vertex, Edge>)graph);
            GraphView.VisualEdge veV_iV_j = TwoOptAlgorithmPlugin.this.graphView.getVisualEdge(graph.getEdge(ep.getV_i(), ep.getV_j()));
            GraphView.VisualEdge veV_i_ApoV_j_Apo = TwoOptAlgorithmPlugin.this.graphView.getVisualEdge(graph.getEdge(ep.getV_i_Apo(), ep.getV_j_Apo()));
            GraphView.VisualEdge veV_iV_i_Apo = TwoOptAlgorithmPlugin.this.graphView.getVisualEdge(graph.getEdge(substitutedEP.getV_i(), substitutedEP.getV_j()));
            GraphView.VisualEdge veV_jV_j_Apo = TwoOptAlgorithmPlugin.this.graphView.getVisualEdge(graph.getEdge(substitutedEP.getV_i_Apo(), substitutedEP.getV_j_Apo()));
            if (veV_iV_j != null && veV_i_ApoV_j_Apo != null && veV_iV_i_Apo != null && veV_jV_j_Apo != null) {
                veV_iV_j.setColor(TwoOptAlgorithmPlugin.this.colorCurrEdgePair);
                veV_i_ApoV_j_Apo.setColor(TwoOptAlgorithmPlugin.this.colorCurrEdgePair);
                veV_iV_i_Apo.setColor(TwoOptAlgorithmPlugin.this.colorCycleR);
                veV_iV_i_Apo.setLineWidth(TwoOptAlgorithmPlugin.this.lineWidthCycleR);
                veV_jV_j_Apo.setColor(TwoOptAlgorithmPlugin.this.colorCycleR);
                veV_jV_j_Apo.setLineWidth(TwoOptAlgorithmPlugin.this.lineWidthCycleR);
                TwoOptAlgorithmPlugin.this.graphView.repaint();
            }
        }
    }
}

