/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Component;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import lavesdk.algorithm.plugin.views.ExecutionTableView;
import lavesdk.gui.widgets.ExecutionTableItem;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import main.EdgePair;

public class EdgePairInputParser
implements ExecutionTableItem.InputParser<EdgePair> {
    private final ExecutionTableView view;
    private final Graph<Vertex, Edge> graph;
    private final LanguageFile langFile;
    private final String langID;
    private static final Pattern edgePairPattern = Pattern.compile("\\s*\\((.+?),(.+?)\\)\\s*\\((.+?),(.+?)\\)\\s*");

    public EdgePairInputParser(ExecutionTableView view, Graph<Vertex, Edge> graph, LanguageFile langFile, String langID) throws IllegalArgumentException {
        if (view == null || graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.view = view;
        this.graph = graph;
        this.langFile = langFile;
        this.langID = langID;
    }

    public Object prepareEditor(Object o) {
        return o;
    }

    public EdgePair parse(String input) {
        Matcher m = edgePairPattern.matcher(input);
        Vertex v_i = null;
        Vertex v_j = null;
        Vertex v_i_Apo = null;
        Vertex v_j_Apo = null;
        if (m.matches()) {
            v_i = this.graph.getVertexByCaption(m.group(1).trim());
            v_j = this.graph.getVertexByCaption(m.group(2).trim());
            v_i_Apo = this.graph.getVertexByCaption(m.group(3).trim());
            v_j_Apo = this.graph.getVertexByCaption(m.group(4).trim());
        }
        if (v_i == null || v_j == null || v_i_Apo == null || v_j_Apo == null) {
            JOptionPane.showMessageDialog((Component)this.view, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INVALIDEDGEPAIRINPUT", (String)this.langID, (String)"Your input is incorrect!\nPlease enter an edge-pair in the following pattern: (...,...) (...,...), where the ellipsis have to be\nreplaced with the corresponding vertex captions and ensure that specified vertices are existing."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INVALIDEDGEPAIRINPUT_TITLE", (String)this.langID, (String)"Invalid input"), 1);
            return null;
        }
        return new EdgePair(this.graph, v_i.getID(), v_j.getID(), v_i_Apo.getID(), v_j_Apo.getID());
    }
}

