/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.Serializable;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import lavesdk.utils.MathUtils;

public class EdgePair
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int v_i;
    private final int v_j;
    private final int v_i_Apo;
    private final int v_j_Apo;
    private final float savings;
    private final String savingsToString;
    private final String toString;

    public EdgePair(Graph<Vertex, Edge> graph, int v_i, int v_j, int v_i_Apo, int v_j_Apo) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.v_i = v_i;
        this.v_j = v_j;
        this.v_i_Apo = v_i_Apo;
        this.v_j_Apo = v_j_Apo;
        Vertex vi = graph.getVertexByID(this.v_i);
        Vertex vj = graph.getVertexByID(this.v_j);
        Vertex vi_Apo = graph.getVertexByID(this.v_i_Apo);
        Vertex vj_Apo = graph.getVertexByID(this.v_j_Apo);
        Edge eV_iV_j = graph.getEdge(this.v_i, this.v_j);
        Edge eV_iV_i_Apo = graph.getEdge(this.v_i, this.v_i_Apo);
        Edge eV_i_ApoV_j_Apo = graph.getEdge(this.v_i_Apo, this.v_j_Apo);
        Edge eV_jV_j_Apo = graph.getEdge(this.v_j, this.v_j_Apo);
        this.toString = vi == null || vj == null || vi_Apo == null || vj_Apo == null ? "" : "(" + vi.getCaption() + ", " + vj.getCaption() + ") (" + vi_Apo.getCaption() + ", " + vj_Apo.getCaption() + ")";
        if (eV_iV_j != null && eV_iV_i_Apo != null && eV_i_ApoV_j_Apo != null && eV_jV_j_Apo != null) {
            this.savings = eV_iV_j.getWeight() + eV_i_ApoV_j_Apo.getWeight() - (eV_iV_i_Apo.getWeight() + eV_jV_j_Apo.getWeight());
            this.savingsToString = "(" + MathUtils.formatFloat((float)eV_iV_j.getWeight()) + " + " + MathUtils.formatFloat((float)eV_i_ApoV_j_Apo.getWeight()) + ") - (" + MathUtils.formatFloat((float)eV_iV_i_Apo.getWeight()) + " + " + MathUtils.formatFloat((float)eV_jV_j_Apo.getWeight()) + ") = " + MathUtils.formatFloat((float)this.savings);
        } else {
            this.savings = 0.0f;
            this.savingsToString = "";
        }
    }

    public int getV_i() {
        return this.v_i;
    }

    public int getV_j() {
        return this.v_j;
    }

    public int getV_i_Apo() {
        return this.v_i_Apo;
    }

    public int getV_j_Apo() {
        return this.v_j_Apo;
    }

    public float getSavings() {
        return this.savings;
    }

    public String savingsToString() {
        return this.savingsToString;
    }

    public String toString() {
        return this.toString;
    }

    public boolean equals(EdgePair ep) {
        if (ep == null) {
            return false;
        }
        return this.equalEdges(this.v_i, this.v_j, ep.v_i, ep.v_j) && this.equalEdges(this.v_i_Apo, this.v_j_Apo, ep.v_i_Apo, ep.v_j_Apo) || this.equalEdges(this.v_i, this.v_j, ep.v_i_Apo, ep.v_j_Apo) && this.equalEdges(this.v_i_Apo, this.v_j_Apo, ep.v_i, ep.v_j);
    }

    private boolean equalEdges(int e1_i, int e1_j, int e2_i, int e2_j) {
        return e1_i == e2_i && e1_j == e2_j || e1_i == e2_j && e1_j == e2_i;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EdgePair) {
            return this.equals((EdgePair)obj);
        }
        return false;
    }

    public static EdgePair substitute(EdgePair ep, Graph<Vertex, Edge> graph) {
        return new EdgePair(graph, ep.v_i, ep.v_i_Apo, ep.v_j, ep.v_j_Apo);
    }
}

