/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import lavesdk.algorithm.plugin.views.ExecutionTableView;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewHeaderBarExtension;
import lavesdk.gui.widgets.ExecutionTableItem;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import main.EdgePairInputParser;

public class CombiViewExerciseExt
extends ViewHeaderBarExtension {
    private final ExecutionTableView view;
    private final int removeLimit;
    private final Icon addIcon;
    private final Icon removeIcon;
    private final EdgePairInputParser inputParser;

    public CombiViewExerciseExt(ExecutionTableView view, Graph<Vertex, Edge> graph, Icon addIcon, Icon removeIcon, LanguageFile langFile, String langID) throws IllegalArgumentException {
        super((View)view, true, langFile, langID);
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.view = view;
        this.removeLimit = view.getItemCount();
        this.addIcon = addIcon;
        this.removeIcon = removeIcon;
        this.inputParser = new EdgePairInputParser(view, graph, langFile, langID);
    }

    public EdgePairInputParser getInputParser() {
        return this.inputParser;
    }

    protected void createExtension() {
        JButton addBtn = new JButton(this.addIcon);
        addBtn.setToolTipText(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP1_BTN_ADD_TOOLTIP", (String)this.langID, (String)"Add new item"));
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecutionTableItem item = new ExecutionTableItem();
                item.setEditable(true);
                item.setDefaultInputParser((ExecutionTableItem.InputParser)CombiViewExerciseExt.this.inputParser);
                CombiViewExerciseExt.this.view.add(item);
            }
        });
        this.addComponent(addBtn);
        JButton removeBtn = new JButton(this.removeIcon);
        removeBtn.setToolTipText(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP1_BTN_REMOVE_TOOLTIP", (String)this.langID, (String)"Remove last added item"));
        removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CombiViewExerciseExt.this.view.getItemCount() > CombiViewExerciseExt.this.removeLimit) {
                    CombiViewExerciseExt.this.view.remove(CombiViewExerciseExt.this.view.getLastItem());
                }
            }
        });
        this.addComponent(removeBtn);
    }
}

