/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.BipartiteLayoutToolBarExtension;
import lavesdk.algorithm.plugin.extensions.CircleLayoutToolBarExtension;
import lavesdk.algorithm.plugin.extensions.CompleteBipartiteGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.CompleteGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.MatrixToGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.AlgorithmTextView;
import lavesdk.algorithm.plugin.views.DefaultGraphView;
import lavesdk.algorithm.plugin.views.ExecutionTableView;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.LegendView;
import lavesdk.algorithm.plugin.views.MatrixView;
import lavesdk.algorithm.plugin.views.TextAreaView;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.algorithm.text.Annotation;
import lavesdk.configuration.Configuration;
import lavesdk.gui.dialogs.SolveExerciseDialog;
import lavesdk.gui.dialogs.SolveExercisePane;
import lavesdk.gui.dialogs.enums.AllowedGraphType;
import lavesdk.gui.widgets.ColorProperty;
import lavesdk.gui.widgets.ExecutionTableColumn;
import lavesdk.gui.widgets.ExecutionTableItem;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.gui.widgets.Mask;
import lavesdk.gui.widgets.MatrixEditor;
import lavesdk.gui.widgets.MatrixElementFormat;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;
import lavesdk.language.LanguageFile;
import lavesdk.math.ElementParser;
import lavesdk.math.Matrix;
import lavesdk.math.Set;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.SimpleGraph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.matching.Matching;
import lavesdk.math.graph.matching.MatchingByID;
import lavesdk.serialization.Serializer;
import lavesdk.utils.GraphUtils;
import lavesdk.utils.MathUtils;
import main.RegretEntry;

public class VogelsApproximationMethodPlugin
implements AlgorithmPlugin {
    private PluginHost host;
    private Configuration config;
    private LanguageFile langFile;
    private String langID;
    private FileNameExtensionFilter vgfFileFilter;
    private FileNameExtensionFilter pngFileFilter;
    private AlgorithmText algoText;
    private DefaultGraphView graphView;
    private AlgorithmTextView algoTextView;
    private TextAreaView setView;
    private TextAreaView matchingView;
    private ExecutionTableView regretView;
    private MatrixView<Float> adjacencyMatrixView;
    private LegendView legendView;
    private VogelsApproximationRTE rte;
    private CompleteGraphToolBarExtension<Vertex, Edge> completeExt;
    private CircleLayoutToolBarExtension<Vertex, Edge> circleLayoutExt;
    private CompleteBipartiteGraphToolBarExtension<Vertex, Edge> completeBipartiteExt;
    private BipartiteLayoutToolBarExtension<Vertex, Edge> bipartiteLayoutExt;
    private MatrixToGraphToolBarExtension<Vertex, Edge> matrixToGraph;
    private ViewGroup ab;
    private ViewGroup defg;
    private ViewGroup cdefg;
    private ViewGroup abcdefg;
    private Color colorModified;
    private Color colorMatchedEdges;
    private Color colorCurrVertices;
    private Color colorCurrEdge;
    private Color colorSetL;
    private Color colorMinWeights;
    private Color colorLargestRegret;
    private int lineWidthMatchedEdges;
    private int lineWidthCurrEdge;
    private static final String CFGKEY_COLOR_MODIFIED = "colorModified";
    private static final String CFGKEY_COLOR_MATCHEDEDGES = "colorMatchedEdges";
    private static final String CFGKEY_COLOR_CURRVERTICES = "colorCurrVertices";
    private static final String CFGKEY_COLOR_CURREDGE = "colorCurrEdge";
    private static final String CFGKEY_COLOR_SETL = "colorSetL";
    private static final String CFGKEY_COLOR_MINWEIGHTS = "colorMinWeights";
    private static final String CFGKEY_COLOR_LARGESTREGRET = "colorLargestRegret";
    private static final String CFGKEY_LINEWIDTH_MATCHEDEDGES = "lineWidthMatchedEdges";
    private static final String CFGKEY_LINEWIDTH_CURREDGE = "lineWidthCurrEdge";

    public void initialize(PluginHost host, ResourceLoader resLoader, Configuration config) {
        try {
            this.langFile = new LanguageFile(resLoader.getResourceAsStream("main/resources/langVogelsApproximation.txt"));
            this.langFile.include(host.getLanguageFile());
        }
        catch (IOException e) {
            this.langFile = null;
        }
        this.langID = host.getLanguageID();
        this.host = host;
        this.config = config != null ? config : new Configuration();
        this.vgfFileFilter = new FileNameExtensionFilter("Visual Graph File (*.vgf)", "vgf");
        this.pngFileFilter = new FileNameExtensionFilter("Portable Network Graphic (*.png)", "png");
        this.graphView = new DefaultGraphView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_GRAPH_TITLE", (String)this.langID, (String)"Graph"), (Graph)new SimpleGraph(false), null, true, this.langFile, this.langID);
        this.setView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_SET_TITLE", (String)this.langID, (String)"Set L"), true, this.langFile, this.langID);
        this.matchingView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_MATCHING_TITLE", (String)this.langID, (String)"Matching M"), true, this.langFile, this.langID);
        this.regretView = new ExecutionTableView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_REGRET_TITLE", (String)this.langID, (String)"Regret"), true, this.langFile, this.langID);
        this.adjacencyMatrixView = new MatrixView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ADJACENCYMATRIX_TITLE", (String)this.langID, (String)"Adjacency Matrix"), (MatrixElementFormat)new MatrixEditor.FloatElementFormat(), true, this.langFile, this.langID);
        this.algoText = this.loadAlgorithmText();
        this.algoTextView = new AlgorithmTextView(host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ALGOTEXT_TITLE", (String)this.langID, (String)"Algorithm"), this.algoText, true, this.langFile, this.langID);
        this.legendView = new LegendView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LEGEND_TITLE", (String)this.langID, (String)"Legend"), true, this.langFile, this.langID);
        this.rte = new VogelsApproximationRTE();
        this.completeExt = new CompleteGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.UNDIRECTED_ONLY, this.langFile, this.langID, true);
        this.circleLayoutExt = new CircleLayoutToolBarExtension((GraphView)this.graphView, this.langFile, this.langID, false);
        this.completeBipartiteExt = new CompleteBipartiteGraphToolBarExtension(host, (GraphView)this.graphView, this.langFile, this.langID, true);
        this.bipartiteLayoutExt = new BipartiteLayoutToolBarExtension((GraphView)this.graphView, true, this.langFile, this.langID, false);
        this.matrixToGraph = new MatrixToGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.UNDIRECTED_ONLY, this.langFile, this.langID, true);
        this.algoTextView.setAutoRepaint(true);
        this.setView.setAutoRepaint(true);
        this.matchingView.setAutoRepaint(true);
        this.regretView.setAutoRepaint(true);
        this.adjacencyMatrixView.setAutoRepaint(true);
        this.regretView.setAutoResizeColumns(false);
        this.adjacencyMatrixView.addMask(new Mask((Object)Float.valueOf(0.0f), (Object)"-"));
        this.colorModified = this.config.getColor(CFGKEY_COLOR_MODIFIED, new Color(255, 180, 130));
        this.colorMatchedEdges = this.config.getColor(CFGKEY_COLOR_MATCHEDEDGES, Color.black);
        this.colorCurrVertices = this.config.getColor(CFGKEY_COLOR_CURRVERTICES, new Color(255, 220, 80));
        this.colorCurrEdge = this.config.getColor(CFGKEY_COLOR_CURREDGE, new Color(220, 105, 105));
        this.colorSetL = this.config.getColor(CFGKEY_COLOR_SETL, new Color(180, 210, 230));
        this.colorMinWeights = this.config.getColor(CFGKEY_COLOR_MINWEIGHTS, new Color(120, 210, 80));
        this.colorLargestRegret = this.config.getColor(CFGKEY_COLOR_LARGESTREGRET, new Color(255, 220, 80));
        this.lineWidthMatchedEdges = this.config.getInt(CFGKEY_LINEWIDTH_MATCHEDEDGES, 3);
        this.lineWidthCurrEdge = this.config.getInt(CFGKEY_LINEWIDTH_CURREDGE, 2);
        this.graphView.loadConfiguration(config, "graphView");
        this.algoTextView.loadConfiguration(config, "algoTextView");
        this.setView.loadConfiguration(config, "setView");
        this.matchingView.loadConfiguration(config, "matchingView");
        this.regretView.loadConfiguration(config, "regretView");
        this.adjacencyMatrixView.loadConfiguration(config, "adjacencyMatrixView");
        this.legendView.loadConfiguration(config, "legendView");
        this.createLegend();
    }

    public String getName() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_NAME", (String)this.langID, (String)"Greedy algorithm");
    }

    public String getDescription() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_DESC", (String)this.langID, (String)"Finds a perfect matching <i>M</i> with a low weight of the edges.");
    }

    public String getType() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_TYPE", (String)this.langID, (String)"Heuristic");
    }

    public String getAuthor() {
        return "Jan Dornseifer";
    }

    public String getAuthorContact() {
        return "jan.dornseifer@student.uni-siegen.de";
    }

    public String getAssumptions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_ASSUMPTIONS", (String)this.langID, (String)"A weighted complete graph K<sub>n</sub> with <i>n mod 2 = 0</i> (even number of vertices) or a weighted complete bipartite graph K<sub>n/2,n/2</sub>, n = |V|.");
    }

    public String getProblemAffiliation() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_PROBLEMAFFILIATION", (String)this.langID, (String)"Matching problem");
    }

    public String getSubject() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_SUBJECT", (String)this.langID, (String)"Logistics");
    }

    public String getInstructions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_INSTRUCTIONS", (String)this.langID, (String)"<b>Creating problem entities</b>:<br>Create your own graph and make sure that the graph complies with the assumptions of the algorithm. You can use<br>the toolbar extensions to check whether the created graph is complete or complete bipartite, to create a complete graph or a complete bipartite graph<br>by indicating the number of vertices, to create a graph by use of an adjacency matrix or you can arrange the vertices of your created graph<br>in a predefined layout.<br><br><b>Exercise Mode</b>:<br>Activate the exercise mode to practice the algorithm in an interactive way. After you have started the algorithm<br>exercises are presented that you have to solve.<br>If an exercise can be solved directly in a view of the algorithm the corresponding view is highlighted with a border, there you can<br>enter your solution and afterwards you have to press the button to solve the exercise. Otherwise (if an exercise is not related to a specific<br>view) you can directly press the button to solve the exercise which opens a dialog where you can enter your solution of the exercise.");
    }

    public String getVersion() {
        return "1.3";
    }

    public LAVESDKV getUsedSDKVersion() {
        return new LAVESDKV(1, 3);
    }

    public AlgorithmRTE getRuntimeEnvironment() {
        return this.rte;
    }

    public AlgorithmText getText() {
        return this.algoText.getBaseCopy();
    }

    public boolean hasExerciseMode() {
        return true;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean hasCreatorPreferences() {
        return false;
    }

    public void loadCreatorPreferences(PropertiesListModel plm) {
    }

    public void onCreate(ViewContainer container, PropertiesListModel creatorProperties) {
        this.graphView.setGraph((Graph)new SimpleGraph(false));
        this.graphView.repaint();
        this.ab = new ViewGroup(1);
        this.defg = new ViewGroup(0);
        this.cdefg = new ViewGroup(1);
        this.abcdefg = new ViewGroup(0);
        this.ab.add((Component)this.algoTextView);
        this.ab.add((Component)this.legendView);
        this.ab.restoreWeights((Serializer)this.config, "weights_ab", new float[]{0.6f, 0.4f});
        this.defg.add((Component)this.setView);
        this.defg.add((Component)this.matchingView);
        this.defg.add(this.adjacencyMatrixView);
        this.defg.add((Component)this.regretView);
        this.defg.restoreWeights((Serializer)this.config, "weights_defg", new float[]{0.25f, 0.25f, 0.25f, 0.25f});
        this.cdefg.add((Component)this.graphView);
        this.cdefg.add((Component)this.defg);
        this.cdefg.restoreWeights((Serializer)this.config, "weights_cdefg", new float[]{0.6f, 0.4f});
        this.abcdefg.add((Component)this.ab);
        this.abcdefg.add((Component)this.cdefg);
        this.abcdefg.restoreWeights((Serializer)this.config, "weights_abcdefg", new float[]{0.4f, 0.6f});
        container.setLayout((LayoutManager)new BorderLayout());
        container.add((Component)this.abcdefg, (Object)"Center");
    }

    public void onClose() {
        this.graphView.saveConfiguration(this.config, "graphView");
        this.algoTextView.saveConfiguration(this.config, "algoTextView");
        this.setView.saveConfiguration(this.config, "setView");
        this.matchingView.saveConfiguration(this.config, "matchingView");
        this.adjacencyMatrixView.saveConfiguration(this.config, "adjacencyMatrixView");
        this.regretView.saveConfiguration(this.config, "regretView");
        this.legendView.saveConfiguration(this.config, "legendView");
        if (this.ab != null) {
            this.ab.storeWeights((Serializer)this.config, "weights_ab");
        }
        if (this.defg != null) {
            this.defg.storeWeights((Serializer)this.config, "weights_defg");
        }
        if (this.cdefg != null) {
            this.cdefg.storeWeights((Serializer)this.config, "weights_cdefg");
        }
        if (this.abcdefg != null) {
            this.abcdefg.storeWeights((Serializer)this.config, "weights_abcdefg");
        }
        this.graphView.reset();
        this.setView.reset();
        this.matchingView.reset();
        this.adjacencyMatrixView.reset();
        this.regretView.reset();
    }

    public boolean hasCustomization() {
        return true;
    }

    public void loadCustomization(PropertiesListModel plm) {
        plm.add((Property)new ColorProperty("algoTextHighlightForeground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTFOREGROUND", (String)this.langID, (String)"Foreground color of the current step in the algorithm"), this.algoTextView.getHighlightForeground()));
        plm.add((Property)new ColorProperty("algoTextHighlightBackground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTBACKGROUND", (String)this.langID, (String)"Background color of the current step in the algorithm"), this.algoTextView.getHighlightBackground()));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MATCHEDEDGES, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MATCHEDEDGES", (String)this.langID, (String)"Color of the matching edges"), this.colorMatchedEdges));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_CURRVERTICES, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_CURRVERTICES", (String)this.langID, (String)"Background color of the current vertices v and v<sub>1</sub>(v)"), this.colorCurrVertices));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_CURREDGE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_CURREDGE", (String)this.langID, (String)"Color of the edge (v, v<sub>1</sub>(v))"), this.colorCurrEdge));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SETL, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_SETL", (String)this.langID, (String)"Background color of the vertices of set L"), this.colorSetL));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MINWEIGHTS, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MINWEIGHTS", (String)this.langID, (String)"Background color of the elements with the first and the second smallest weight of the edges (v, v<sub>1</sub>(v)) and (v, v<sub>2</sub>(v)) required to calculate the regret"), this.colorSetL));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_LARGESTREGRET, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_LARGESTREGRET", (String)this.langID, (String)"Background color of the item with a largest regret"), this.colorSetL));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MODIFIED, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MODIFICATIONS", (String)this.langID, (String)"Color of modifications of objects"), this.colorModified));
        NumericProperty lwMatchedEdges = new NumericProperty(CFGKEY_LINEWIDTH_MATCHEDEDGES, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIE_LINEWIDTH_MATCHEDEDGES", (String)this.langID, (String)"Line width of the matching edges"), (Number)this.lineWidthMatchedEdges, true);
        lwMatchedEdges.setMinimum(1);
        lwMatchedEdges.setMaximum(5);
        plm.add((Property)lwMatchedEdges);
        NumericProperty lwCurrEdge = new NumericProperty(CFGKEY_LINEWIDTH_CURREDGE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIE_LINEWIDTH_CURREDGE", (String)this.langID, (String)"Line width of the edge (v, v<sub>1</sub>(v))"), (Number)this.lineWidthCurrEdge, true);
        lwCurrEdge.setMinimum(1);
        lwCurrEdge.setMaximum(5);
        plm.add((Property)lwCurrEdge);
    }

    public void applyCustomization(PropertiesListModel plm) {
        this.algoTextView.setHighlightForeground(plm.getColorProperty("algoTextHighlightForeground").getValue());
        this.algoTextView.setHighlightBackground(plm.getColorProperty("algoTextHighlightBackground").getValue());
        this.colorMatchedEdges = this.config.addColor(CFGKEY_COLOR_MATCHEDEDGES, plm.getColorProperty(CFGKEY_COLOR_MATCHEDEDGES).getValue());
        this.colorCurrVertices = this.config.addColor(CFGKEY_COLOR_CURRVERTICES, plm.getColorProperty(CFGKEY_COLOR_CURRVERTICES).getValue());
        this.colorCurrEdge = this.config.addColor(CFGKEY_COLOR_CURREDGE, plm.getColorProperty(CFGKEY_COLOR_CURREDGE).getValue());
        this.colorSetL = this.config.addColor(CFGKEY_COLOR_SETL, plm.getColorProperty(CFGKEY_COLOR_SETL).getValue());
        this.colorSetL = this.config.addColor(CFGKEY_COLOR_MINWEIGHTS, plm.getColorProperty(CFGKEY_COLOR_MINWEIGHTS).getValue());
        this.colorSetL = this.config.addColor(CFGKEY_COLOR_LARGESTREGRET, plm.getColorProperty(CFGKEY_COLOR_LARGESTREGRET).getValue());
        this.colorModified = this.config.addColor(CFGKEY_COLOR_MODIFIED, plm.getColorProperty(CFGKEY_COLOR_MODIFIED).getValue());
        this.lineWidthMatchedEdges = this.config.addInt(CFGKEY_LINEWIDTH_MATCHEDEDGES, plm.getNumericProperty(CFGKEY_LINEWIDTH_MATCHEDEDGES).getValue().intValue());
        this.lineWidthCurrEdge = this.config.addInt(CFGKEY_LINEWIDTH_CURREDGE, plm.getNumericProperty(CFGKEY_LINEWIDTH_CURREDGE).getValue().intValue());
        this.createLegend();
    }

    public ToolBarExtension[] getToolBarExtensions() {
        return new ToolBarExtension[]{this.completeExt, this.circleLayoutExt, this.completeBipartiteExt, this.bipartiteLayoutExt, this.matrixToGraph};
    }

    public void save(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.save(file);
            } else if (this.pngFileFilter.accept(file)) {
                this.graphView.saveAsPNG(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE", (String)this.langID, (String)"File could not be saved!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE_TITLE", (String)this.langID, (String)"Save File"), MessageIcon.ERROR);
        }
    }

    public void open(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.load(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE", (String)this.langID, (String)"File could not be opened!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE_TITLE", (String)this.langID, (String)"Open File"), MessageIcon.ERROR);
        }
    }

    public FileNameExtensionFilter[] getSaveFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter, this.pngFileFilter};
    }

    public FileNameExtensionFilter[] getOpenFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter};
    }

    public void beforeStart(RTEvent e) {
        if (!this.areAssumptionsFulfilled()) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_GRAPHNOTPERMISSIBLE", (String)this.langID, (String)"The created graph is not permissible!\nThe graph has to fulfill the assumptions (see information bar)."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_GRAPHNOTPERMISSIBLE_TITLE", (String)this.langID, (String)"Impermissible graph"), MessageIcon.INFO);
            e.doit = false;
        } else if (this.containsGraphZeroWeights()) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_GRAPHZEROWEIGHTS", (String)this.langID, (String)"The created graph contains edges with a zero weight!\nPlease specify a valid weight for all edges of the graph."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_GRAPHZEROWEIGHTS_TITLE", (String)this.langID, (String)"Invalid weight"), MessageIcon.INFO);
            e.doit = false;
        }
        if (e.doit) {
            this.graphView.setEditable(false);
            this.graphView.deselectAll();
            this.regretView.reset();
            this.adjacencyMatrixView.reset();
            this.setView.reset();
            this.matchingView.reset();
            this.rte.initAdjacencyMatrixAndRegretDisplay();
            this.adjacencyMatrixView.repaint();
        }
    }

    public void beforeResume(RTEvent e) {
    }

    public void beforePause(RTEvent e) {
    }

    public void onStop() {
        this.graphView.setEditable(true);
    }

    public void onRunning() {
    }

    public void onPause() {
    }

    private AlgorithmText loadAlgorithmText() {
        AlgorithmText text = new AlgorithmText();
        AlgorithmExercise step1_8 = new AlgorithmExercise<Set<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP1_8", (String)this.langID, (String)"What is the set <i>L</i>?"), 1.0f){

            protected Set<?>[] requestSolution() {
                SolveExerciseDialog.SolutionEntry entryL = new SolveExerciseDialog.SolutionEntry("L=", (Component)new JTextField());
                if (!SolveExercisePane.showDialog((PluginHost)VogelsApproximationMethodPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryL}, (LanguageFile)VogelsApproximationMethodPlugin.this.langFile, (String)VogelsApproximationMethodPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)VogelsApproximationMethodPlugin.this.langFile, (String)"EXERCISE_HINT_SETINPUT", (String)VogelsApproximationMethodPlugin.this.langID, (String)"Use a comma as the delimiter!"))) {
                    return null;
                }
                Set.StringElementParser parser = new Set.StringElementParser();
                Set L = Set.parse((String)((JTextField)entryL.getComponent()).getText(), (ElementParser)parser);
                return new Set[]{L};
            }

            protected String getResultAsString(Set<?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                return "L=" + super.getResultAsString(result, index);
            }

            protected boolean examine(Set<?>[] results, AlgorithmState state) {
                Set L = VogelsApproximationMethodPlugin.this.toIDs(results[0]);
                return this.doAutoExamine(state, new String[]{"L"}, new Set[]{L});
            }
        };
        AlgorithmExercise step3_7 = new AlgorithmExercise<Matching<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP3_7", (String)this.langID, (String)"What is <i>M</i> after this step (<i>select all matched edges in the graph</i>)?"), 1.0f, (View)this.graphView){

            public boolean hasInputHint() {
                return true;
            }

            public Annotation getInputHintMessage(LanguageFile langFile, String langID) {
                return new Annotation(LanguageFile.getLabel((LanguageFile)VogelsApproximationMethodPlugin.this.langFile, (String)"EXERCISE_STEP3_7_INPUTHINT", (String)langID, (String)"<b>Select matched edges</b>:<br>Select the matched edges in the graph by using the mouse and pressing the <b>Ctrl</b>-key on your keyboard.<br>Afterwards click on the \"Solve Exercise\"-button of the task."));
            }

            protected void beforeRequestSolution(AlgorithmState state) {
                VogelsApproximationMethodPlugin.this.graphView.setSelectionType(GraphView.SelectionType.EDGES_ONLY);
                VogelsApproximationMethodPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                VogelsApproximationMethodPlugin.this.graphView.setSelectionType(GraphView.SelectionType.BOTH);
                VogelsApproximationMethodPlugin.this.graphView.setShowCursorToolAlways(false);
                VogelsApproximationMethodPlugin.this.graphView.deselectAll();
            }

            protected Matching<?>[] requestSolution() {
                if (VogelsApproximationMethodPlugin.this.graphView.getSelectedEdgeCount() == 0) {
                    return null;
                }
                Matching m = new Matching(VogelsApproximationMethodPlugin.this.graphView.getGraph());
                try {
                    int i = 0;
                    while (i < VogelsApproximationMethodPlugin.this.graphView.getSelectedEdgeCount()) {
                        m.add(VogelsApproximationMethodPlugin.this.graphView.getSelectedEdge(i).getEdge());
                        ++i;
                    }
                }
                catch (IllegalArgumentException e) {
                    m = null;
                }
                if (m != null) {
                    return new Matching[]{m};
                }
                return new Matching[0];
            }

            protected String getResultAsString(Matching<?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                return "M=" + super.getResultAsString(result, index);
            }

            protected boolean examine(Matching<?>[] results, AlgorithmState state) {
                MatchingByID m = state.getMatching("M", VogelsApproximationMethodPlugin.this.graphView.getGraph());
                return results[0].cast().equals((Collection)m);
            }
        };
        AlgorithmParagraph initParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_INITIALIZATION", (String)this.langID, (String)"1. Initialization:"), 1);
        AlgorithmParagraph stopParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_STOPCRITERION", (String)this.langID, (String)"2. Stop criterion:"), 2);
        AlgorithmParagraph regretParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_REGRET", (String)this.langID, (String)"3. Regret:"), 3);
        AlgorithmParagraph expParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_MATCHINGEXPANSION", (String)this.langID, (String)"4. Matching expansion:"), 4);
        AlgorithmParagraph updateParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_UPDATEL", (String)this.langID, (String)"5. Update L:"), 5);
        AlgorithmStep step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP1_INIT", (String)this.langID, (String)"Let _latex{$M := \\emptyset$}.\nLet _latex{$L := V$} be the set of all vertices of the graph.\n\n"), 1);
        step.setExercise(step1_8);
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP2_STOP", (String)this.langID, (String)"If _latex{$|L| = 2$} "), 2);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Boolean>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP2", (String)this.langID, (String)"Is |L| = 2?"), 1.0f){
            private final String labelYes;
            private final String labelNo;
            {
                this.labelYes = LanguageFile.getLabel((LanguageFile)VogelsApproximationMethodPlugin.this.langFile, (String)"EXERCISE_STEP2_YES", (String)VogelsApproximationMethodPlugin.this.langID, (String)"Yes");
                this.labelNo = LanguageFile.getLabel((LanguageFile)VogelsApproximationMethodPlugin.this.langFile, (String)"EXERCISE_STEP2_NO", (String)VogelsApproximationMethodPlugin.this.langID, (String)"No");
            }

            protected Boolean[] requestSolution() {
                ButtonGroup group = new ButtonGroup();
                JRadioButton rdobtn1 = new JRadioButton(this.labelYes);
                JRadioButton rdobtn2 = new JRadioButton(this.labelNo);
                group.add(rdobtn1);
                group.add(rdobtn2);
                SolveExerciseDialog.SolutionEntry entryYes = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn1);
                SolveExerciseDialog.SolutionEntry entryNo = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn2);
                if (!SolveExercisePane.showDialog((PluginHost)VogelsApproximationMethodPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryYes, entryNo}, (LanguageFile)VogelsApproximationMethodPlugin.this.langFile, (String)VogelsApproximationMethodPlugin.this.langID)) {
                    return null;
                }
                return new Boolean[]{!rdobtn1.isSelected() && !rdobtn2.isSelected() ? null : Boolean.valueOf(rdobtn1.isSelected())};
            }

            protected String getResultAsString(Boolean result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return result == Boolean.TRUE ? this.labelYes : this.labelNo;
            }

            protected boolean examine(Boolean[] results, AlgorithmState state) {
                Set L = state.getSet("L");
                return results[0] != null && results[0] == (L.size() == 2);
            }
        });
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP3_ADDLASTEDGE", (String)this.langID, (String)"then add the edge between the remaining vertices to the set _latex{$M$} and stop.\n"), 3);
        step.setExercise(step3_7);
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP4_STOP", (String)this.langID, (String)"Otherwise go to step 3.\n\n"), 4);
        step = new AlgorithmStep(regretParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5_REGRET", (String)this.langID, (String)"For each _latex{$v \\in L$} determine the regret as follows: Let _latex{$v_1(v) \\in argmin\\{c(v,v') | v' \\in L\\}$} and _latex{$v_2(v) \\in argmin\\{c(v,v') | v' \\in L \\setminus \\{v_1(v)\\}\\}$}. _latex{$regret(v) := c(v,v_2(v)) - c(v,v_1(v))$}.\n\n"), 5);
        step.setExercise(new AlgorithmExercise<Map<?, ?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP5", (String)this.langID, (String)"Determine the regrets."), 1.0f, (View)this.regretView){

            public boolean hasInputHint() {
                return true;
            }

            public Annotation getInputHintMessage(LanguageFile langFile, String langID) {
                return new Annotation(LanguageFile.getLabel((LanguageFile)VogelsApproximationMethodPlugin.this.langFile, (String)"EXERCISE_STEP5_INPUTHINT", (String)langID, (String)"<b>Input of regrets</b>:<br>Enter the regrets in the last column of the regret table. If their is no regret for a vertex to be calculated<br>(because the vertex is not in <i>L</i>) then leave the field blank.<br>After entering the regrets click on the \"Solve Exercise\"-button of the task."));
            }

            protected void beforeRequestSolution(AlgorithmState state) {
                ExecutionTableColumn c = new ExecutionTableColumn("");
                c.setWidth(30);
                c.setEditable(true);
                VogelsApproximationMethodPlugin.this.regretView.add(c);
            }

            protected void afterRequestSolution(boolean omitted) {
                VogelsApproximationMethodPlugin.this.regretView.remove(VogelsApproximationMethodPlugin.this.regretView.getLastColumn());
            }

            protected Map<?, ?>[] requestSolution() {
                HashMap<Integer, RegretEntry> regret = new HashMap<Integer, RegretEntry>();
                ExecutionTableColumn c = VogelsApproximationMethodPlugin.this.regretView.getLastColumn();
                int i = 0;
                while (i < VogelsApproximationMethodPlugin.this.regretView.getItemCount()) {
                    ExecutionTableItem item = VogelsApproximationMethodPlugin.this.regretView.getItem(i);
                    Number r = (Number)item.getCellObject(c.getIndex());
                    if (r != null) {
                        regret.put(item.getID(), new RegretEntry(item.getID(), 0, 0, r.floatValue()));
                    }
                    ++i;
                }
                return new Map[]{regret};
            }

            protected String getResultAsString(Map<?, ?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                Map<?, ?> regret = result;
                StringBuilder s = new StringBuilder();
                Iterator<?> it = regret.keySet().iterator();
                Graph graph = VogelsApproximationMethodPlugin.this.graphView.getGraph();
                boolean delimiter = false;
                while (it.hasNext()) {
                    Vertex v = graph.getVertexByID(((Integer)it.next()).intValue());
                    if (delimiter) {
                        s.append(", ");
                    }
                    s.append(String.valueOf(v.getCaption()) + " = " + MathUtils.formatFloat((float)((RegretEntry)regret.get((Object)Integer.valueOf((int)v.getID()))).regret));
                    delimiter = true;
                }
                return s.toString();
            }

            protected boolean examine(Map<?, ?>[] results, AlgorithmState state) {
                return this.doAutoExamine(state, new String[]{"regret"}, results);
            }
        });
        step = new AlgorithmStep(expParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP6_MATCHINGEXPANSION", (String)this.langID, (String)"Let _latex{$v \\in L$} be any vertex with a largest regret.\n"), 6);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Integer>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP6", (String)this.langID, (String)"Select a vertex <i>v</i> with a largest regret in the graph."), 1.0f, (View)this.graphView){

            protected void beforeRequestSolution(AlgorithmState state) {
                VogelsApproximationMethodPlugin.this.graphView.setSelectionType(GraphView.SelectionType.VERTICES_ONLY);
                VogelsApproximationMethodPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                VogelsApproximationMethodPlugin.this.graphView.setSelectionType(GraphView.SelectionType.BOTH);
                VogelsApproximationMethodPlugin.this.graphView.setShowCursorToolAlways(false);
                VogelsApproximationMethodPlugin.this.graphView.deselectAll();
            }

            protected Integer[] requestSolution() {
                if (VogelsApproximationMethodPlugin.this.graphView.getSelectedVertexCount() != 1) {
                    return null;
                }
                return new Integer[]{VogelsApproximationMethodPlugin.this.graphView.getSelectedVertex(0).getVertex().getID()};
            }

            protected String getResultAsString(Integer result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return VogelsApproximationMethodPlugin.this.graphView.getVisualVertexByID(result.intValue()).getVertex().getCaption();
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, Integer[] solutions) {
                state.addInt("v", solutions[0].intValue());
            }

            protected boolean examine(Integer[] results, AlgorithmState state) {
                Map regret = state.getMap("regret");
                Iterator it = regret.keySet().iterator();
                float maxRegret = Float.MIN_VALUE;
                while (it.hasNext()) {
                    float currRegret = ((RegretEntry)regret.get(it.next())).regret;
                    if (!(currRegret > maxRegret)) continue;
                    maxRegret = currRegret;
                }
                return ((RegretEntry)regret.get((Object)results[0])).regret == maxRegret;
            }
        });
        step = new AlgorithmStep(expParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP7_MATCHINGEXPANSION", (String)this.langID, (String)"Add _latex{$(v,v_1(v))$} to the matching _latex{$M$}.\n\n"), 7);
        step.setExercise(step3_7);
        step = new AlgorithmStep(updateParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP8_UPDATEL", (String)this.langID, (String)"Set _latex{$L := L \\setminus \\{v, v_1(v)\\}$} and go to step 2."), 8);
        step.setExercise(step1_8);
        return text;
    }

    private void createLegend() {
        this.legendView.removeAll();
        this.legendView.add(new LegendItem("item1", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_MATCHEDEDGES", (String)this.langID, (String)"The matched edges of matching M"), LegendItem.createLineIcon((Color)this.colorMatchedEdges, (int)this.lineWidthMatchedEdges, (int)4)));
        this.legendView.add(new LegendItem("item2", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_SETL", (String)this.langID, (String)"Vertices of the set L"), LegendItem.createCircleIcon((Color)this.colorSetL, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item3", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CURRVERTEX", (String)this.langID, (String)"The current vertex v"), LegendItem.createCircleIcon((Color)this.colorCurrVertices, (Color)Color.black, (int)2)));
        this.legendView.add(new LegendItem("item4", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CURRVERTEX1", (String)this.langID, (String)"The current vertex v<sub>1</sub>(v)"), LegendItem.createCircleIcon((Color)this.colorCurrVertices, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item5", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CURREDGE", (String)this.langID, (String)"The current edge (v, v<sub>1</sub>(v))"), LegendItem.createLineIcon((Color)this.colorCurrEdge, (int)this.lineWidthCurrEdge, (int)4)));
        this.legendView.add(new LegendItem("item6", this.setView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_SET_MODIFICATION", (String)this.langID, (String)"The set L becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
        this.legendView.add(new LegendItem("item7", this.matchingView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_MATCHING_MODIFICATION", (String)this.langID, (String)"The matching M becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
        this.legendView.add(new LegendItem("item8", this.adjacencyMatrixView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_ADJACENCYMATRIX_MINWEIGHTS", (String)this.langID, (String)"The first and the second smallest weight in a row resulting in the regret of the related vertex"), LegendItem.createRectangleIcon((Color)this.colorMinWeights, (Color)this.colorMinWeights, (int)0)));
        this.legendView.add(new LegendItem("item9", this.adjacencyMatrixView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_ADJACENCYMATRIX_CURREDGE", (String)this.langID, (String)"The current edge (v, v<sub>1</sub>(v))"), LegendItem.createRectangleIcon((Color)this.colorCurrEdge, (Color)this.colorCurrEdge, (int)0)));
        this.legendView.add(new LegendItem("item10", this.adjacencyMatrixView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_ADJACENCYMATRIX_STRIKEOUT", (String)this.langID, (String)"Striked off vertices its edge was added to the matching M"), LegendItem.createLineIcon((Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item11", this.regretView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_REGRET_DESC", (String)this.langID, (String)"the difference between the best and the second best edge concerning the weight")));
        this.legendView.add(new LegendItem("item12", this.regretView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_REGRET_LARGEST", (String)this.langID, (String)"A largest regret"), LegendItem.createRectangleIcon((Color)this.colorLargestRegret, (Color)this.colorLargestRegret, (int)0)));
    }

    private Set<Integer> toIDs(Set<?> set) {
        Graph graph = this.graphView.getGraph();
        Set res = new Set(set.size());
        for (Object caption : set) {
            Vertex v = graph.getVertexByCaption(caption.toString());
            if (v == null) {
                res.add((Object)-1);
                continue;
            }
            res.add((Object)v.getID());
        }
        return res;
    }

    private boolean areAssumptionsFulfilled() {
        Graph graph = this.graphView.getGraph();
        List subsets = GraphUtils.getBipartiteVertexSets((Graph)graph);
        if (graph.getOrder() % 2 != 0) {
            return false;
        }
        return GraphUtils.isComplete((Graph)graph) || GraphUtils.isCompleteBipartite((Graph)graph) && ((List)subsets.get(0)).size() == graph.getOrder() / 2 && ((List)subsets.get(0)).size() == ((List)subsets.get(1)).size();
    }

    private boolean containsGraphZeroWeights() {
        Graph graph = this.graphView.getGraph();
        int i = 0;
        while (i < graph.getSize()) {
            if (graph.getEdge(i).getWeight() == 0.0f) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class VogelsApproximationRTE
    extends AlgorithmRTE {
        private Matching<Edge> M;
        private Set<Integer> L;
        private Map<Integer, RegretEntry> regret;
        private int v;
        private int v1;
        private int userChoiceV;
        private List<Color> strikeoutColors;
        private int nextStrikeoutColorIndex;

        public VogelsApproximationRTE() {
            super((AlgorithmPlugin)VogelsApproximationMethodPlugin.this, VogelsApproximationMethodPlugin.this.algoText);
            this.userChoiceV = 0;
            this.strikeoutColors = new ArrayList<Color>(15);
            this.strikeoutColors.add(Color.black);
            this.strikeoutColors.add(Color.red);
            this.strikeoutColors.add(Color.blue);
            this.strikeoutColors.add(Color.green);
            this.strikeoutColors.add(Color.gray);
            this.strikeoutColors.add(Color.yellow);
            this.strikeoutColors.add(Color.magenta);
            this.strikeoutColors.add(Color.lightGray);
            this.strikeoutColors.add(Color.cyan);
            this.strikeoutColors.add(Color.orange);
        }

        public void initAdjacencyMatrixAndRegretDisplay() {
            Graph graph = VogelsApproximationMethodPlugin.this.graphView.getGraph();
            HashMap<Integer, String> labels = new HashMap<Integer, String>();
            int i = 0;
            while (i < graph.getOrder()) {
                labels.put(i, graph.getVertex(i).getCaption());
                ++i;
            }
            VogelsApproximationMethodPlugin.this.adjacencyMatrixView.setMatrix((Matrix)GraphUtils.createAdjacencyMatrix((Graph)graph));
            VogelsApproximationMethodPlugin.this.adjacencyMatrixView.setColumnLabels(labels);
            VogelsApproximationMethodPlugin.this.adjacencyMatrixView.setRowLabels(labels);
            VogelsApproximationMethodPlugin.this.adjacencyMatrixView.setPaintLabels(true);
            VogelsApproximationMethodPlugin.this.regretView.setColumnHeaderHeight(VogelsApproximationMethodPlugin.this.adjacencyMatrixView.getRowHeight() + 4);
            VogelsApproximationMethodPlugin.this.regretView.setItemHeight(VogelsApproximationMethodPlugin.this.adjacencyMatrixView.getRowHeight());
            i = 0;
            while (i < graph.getOrder()) {
                ExecutionTableItem item = new ExecutionTableItem(graph.getVertex(i).getID());
                item.setEditable(true);
                item.setDefaultInputParser((ExecutionTableItem.InputParser)new ExecutionTableItem.NumericInputParser());
                VogelsApproximationMethodPlugin.this.regretView.add(item);
                ++i;
            }
            this.nextStrikeoutColorIndex = 0;
        }

        protected int executeStep(int stepID, AlgorithmStateAttachment asa) throws Exception {
            Graph graph = VogelsApproximationMethodPlugin.this.graphView.getGraph();
            int nextStep = -1;
            switch (stepID) {
                case 1: {
                    this.M = new Matching(graph);
                    this.sleep(250L);
                    VogelsApproximationMethodPlugin.this.matchingView.setBackground(VogelsApproximationMethodPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeMatchingAsText();
                    this.visualizeMatching();
                    this.sleep(250L);
                    VogelsApproximationMethodPlugin.this.matchingView.setBackground(Color.white);
                    this.sleep(250L);
                    this.L.clear();
                    int i = 0;
                    while (i < graph.getOrder()) {
                        this.L.add((Object)graph.getVertex(i).getID());
                        ++i;
                    }
                    VogelsApproximationMethodPlugin.this.setView.setBackground(VogelsApproximationMethodPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeVertices();
                    this.visualizeSetAsText();
                    this.sleep(250L);
                    VogelsApproximationMethodPlugin.this.setView.setBackground(Color.white);
                    this.sleep(250L);
                    nextStep = 2;
                    break;
                }
                case 2: {
                    if (this.L.size() == 2) {
                        nextStep = 3;
                        break;
                    }
                    nextStep = 4;
                    break;
                }
                case 3: {
                    Edge e = graph.getEdge(((Integer)this.L.get(0)).intValue(), ((Integer)this.L.get(1)).intValue());
                    this.M.add(e);
                    this.sleep(250L);
                    GraphView.VisualEdge ve = VogelsApproximationMethodPlugin.this.graphView.getVisualEdge(e);
                    ve.setColor(VogelsApproximationMethodPlugin.this.colorCurrEdge);
                    ve.setLineWidth(VogelsApproximationMethodPlugin.this.lineWidthCurrEdge);
                    VogelsApproximationMethodPlugin.this.graphView.repaint();
                    this.sleep(500L);
                    VogelsApproximationMethodPlugin.this.matchingView.setBackground(VogelsApproximationMethodPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeMatchingAsText();
                    this.visualizeMatching();
                    this.sleep(250L);
                    VogelsApproximationMethodPlugin.this.matchingView.setBackground(Color.white);
                    this.sleep(250L);
                    this.L.clear();
                    this.visualizeVertices();
                    this.sleep(500L);
                    nextStep = -1;
                    break;
                }
                case 4: {
                    this.sleep(1000L);
                    nextStep = 5;
                    break;
                }
                case 5: {
                    ExecutionTableColumn column = new ExecutionTableColumn("");
                    column.setWidth(30);
                    VogelsApproximationMethodPlugin.this.regretView.add(column);
                    this.regret.clear();
                    int i = 0;
                    while (i < this.L.size()) {
                        Edge e;
                        Vertex vertex = graph.getVertexByID(((Integer)this.L.get(i)).intValue());
                        Vertex vertex1 = null;
                        float minWeightV_V1 = Float.MAX_VALUE;
                        int j = 0;
                        while (j < this.L.size()) {
                            Vertex vertex1_tmp = graph.getVertexByID(((Integer)this.L.get(j)).intValue());
                            e = graph.getEdge(vertex, vertex1_tmp);
                            if (e != null && e.getWeight() < minWeightV_V1) {
                                minWeightV_V1 = e.getWeight();
                                vertex1 = vertex1_tmp;
                            }
                            ++j;
                        }
                        this.sleep(250L);
                        VogelsApproximationMethodPlugin.this.adjacencyMatrixView.setElementBackground(vertex.getIndex(), vertex1.getIndex(), VogelsApproximationMethodPlugin.this.colorMinWeights);
                        this.sleep(500L);
                        Vertex vertex2 = null;
                        float minWeightV_V2 = Float.MAX_VALUE;
                        j = 0;
                        while (j < this.L.size()) {
                            Vertex vertex2_tmp = graph.getVertexByID(((Integer)this.L.get(j)).intValue());
                            if (vertex2_tmp != vertex1 && (e = graph.getEdge(vertex, vertex2_tmp)) != null && e.getWeight() < minWeightV_V2) {
                                minWeightV_V2 = e.getWeight();
                                vertex2 = vertex2_tmp;
                            }
                            ++j;
                        }
                        VogelsApproximationMethodPlugin.this.adjacencyMatrixView.setElementBackground(vertex.getIndex(), vertex2.getIndex(), VogelsApproximationMethodPlugin.this.colorMinWeights);
                        this.sleep(500L);
                        RegretEntry regretEntry = new RegretEntry(vertex.getID(), vertex1.getID(), vertex2.getID(), minWeightV_V2 - minWeightV_V1);
                        this.regret.put(vertex.getID(), regretEntry);
                        ExecutionTableItem item = VogelsApproximationMethodPlugin.this.regretView.getItem(vertex.getIndex());
                        item.setCellObject(VogelsApproximationMethodPlugin.this.regretView.getLastColumn().getIndex(), (Object)Float.valueOf(regretEntry.regret));
                        this.sleep(500L);
                        VogelsApproximationMethodPlugin.this.adjacencyMatrixView.setElementBackground(vertex.getIndex(), vertex1.getIndex(), Color.white);
                        VogelsApproximationMethodPlugin.this.adjacencyMatrixView.setElementBackground(vertex.getIndex(), vertex2.getIndex(), Color.white);
                        ++i;
                    }
                    nextStep = 6;
                    break;
                }
                case 6: {
                    Iterator<Integer> it = this.regret.keySet().iterator();
                    float largestRegret = Float.MIN_VALUE;
                    if (this.userChoiceV > 0) {
                        this.v = this.userChoiceV;
                        this.v1 = this.regret.get((Object)Integer.valueOf((int)this.v)).v1;
                    } else {
                        this.v = 0;
                        this.v1 = 0;
                        while (it.hasNext()) {
                            int currV = it.next();
                            RegretEntry currRegret = this.regret.get(currV);
                            if (!(currRegret.regret > largestRegret)) continue;
                            largestRegret = currRegret.regret;
                            this.v = currV;
                            this.v1 = currRegret.v1;
                        }
                    }
                    this.userChoiceV = 0;
                    if (this.v < 1) {
                        nextStep = -1;
                        break;
                    }
                    this.sleep(500L);
                    ExecutionTableItem item = VogelsApproximationMethodPlugin.this.regretView.getItemByID(this.v);
                    item.setCellBackground(VogelsApproximationMethodPlugin.this.regretView.getLastColumn().getIndex(), VogelsApproximationMethodPlugin.this.colorLargestRegret);
                    this.sleep(500L);
                    this.visualizeVertices();
                    item.setCellBackground(VogelsApproximationMethodPlugin.this.regretView.getLastColumn().getIndex(), Color.white);
                    this.sleep(500L);
                    nextStep = 7;
                    break;
                }
                case 7: {
                    Edge e = graph.getEdge(this.v, this.v1);
                    this.M.add(e);
                    this.sleep(250L);
                    Vertex vertex1 = graph.getVertexByID(this.v);
                    Vertex vertex2 = graph.getVertexByID(this.v1);
                    VogelsApproximationMethodPlugin.this.adjacencyMatrixView.setElementBackground(vertex1.getIndex(), vertex2.getIndex(), VogelsApproximationMethodPlugin.this.colorCurrEdge);
                    this.sleep(250L);
                    GraphView.VisualEdge ve = VogelsApproximationMethodPlugin.this.graphView.getVisualEdge(e);
                    ve.setColor(VogelsApproximationMethodPlugin.this.colorCurrEdge);
                    ve.setLineWidth(VogelsApproximationMethodPlugin.this.lineWidthCurrEdge);
                    GraphView.VisualVertex vv = VogelsApproximationMethodPlugin.this.graphView.getVisualVertexByID(this.v);
                    GraphView.VisualVertex vv1 = VogelsApproximationMethodPlugin.this.graphView.getVisualVertexByID(this.v1);
                    vv.setForeground(VogelsApproximationMethodPlugin.this.colorCurrEdge);
                    vv1.setForeground(VogelsApproximationMethodPlugin.this.colorCurrEdge);
                    VogelsApproximationMethodPlugin.this.graphView.repaint();
                    this.sleep(750L);
                    VogelsApproximationMethodPlugin.this.adjacencyMatrixView.setElementBackground(vertex1.getIndex(), vertex2.getIndex(), Color.white);
                    vv.setForeground(GraphView.DEF_VERTEXFOREGROUND);
                    vv1.setForeground(GraphView.DEF_VERTEXFOREGROUND);
                    VogelsApproximationMethodPlugin.this.matchingView.setBackground(VogelsApproximationMethodPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeMatchingAsText();
                    this.visualizeMatching();
                    this.sleep(250L);
                    VogelsApproximationMethodPlugin.this.matchingView.setBackground(Color.white);
                    this.sleep(250L);
                    nextStep = 8;
                    break;
                }
                case 8: {
                    this.L.remove((Object)this.v);
                    this.L.remove((Object)this.v1);
                    Edge e = graph.getEdge(this.v, this.v1);
                    int i = Math.min(e.getPredecessor().getIndex(), e.getSuccessor().getIndex());
                    int j = Math.max(e.getPredecessor().getIndex(), e.getSuccessor().getIndex());
                    Color c = this.getNextStrikeoutColor();
                    MatrixEditor.Strikeout s1 = new MatrixEditor.Strikeout(i, c, 2);
                    MatrixEditor.Strikeout s2 = new MatrixEditor.Strikeout(j, c, 2);
                    this.sleep(250L);
                    VogelsApproximationMethodPlugin.this.adjacencyMatrixView.addRowStrikeout(s1);
                    VogelsApproximationMethodPlugin.this.adjacencyMatrixView.addRowStrikeout(s2);
                    VogelsApproximationMethodPlugin.this.adjacencyMatrixView.addColumnStrikeout(s1);
                    VogelsApproximationMethodPlugin.this.adjacencyMatrixView.addColumnStrikeout(s2);
                    this.sleep(500L);
                    VogelsApproximationMethodPlugin.this.setView.setBackground(VogelsApproximationMethodPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeVertices();
                    this.visualizeSetAsText();
                    this.sleep(250L);
                    VogelsApproximationMethodPlugin.this.setView.setBackground(Color.white);
                    this.sleep(250L);
                    nextStep = 2;
                }
            }
            return nextStep;
        }

        protected void storeState(AlgorithmState state) {
            state.addMatching("M", this.M != null ? this.M.cast() : null);
            state.addSet("L", this.L);
            state.addMap("regret", this.regret);
            state.addInt("v", this.v);
            state.addInt("v1", this.v1);
        }

        protected void restoreState(AlgorithmState state) {
            MatchingByID m = state.getMatching("M", VogelsApproximationMethodPlugin.this.graphView.getGraph());
            this.M = m != null ? m.cast() : null;
            this.L = state.getSet("L");
            this.regret = state.getMap("regret");
            this.v = state.getInt("v");
            this.v1 = state.getInt("v1");
        }

        protected void createInitialState(AlgorithmState state) {
            state.addMatching("M", null);
            this.L = state.addSet("L", new Set());
            this.regret = state.addMap("regret", new HashMap());
            this.v = state.addInt("v", 0);
            this.v1 = state.addInt("v1", 0);
        }

        protected void rollBackStep(int stepID, int nextStepID) {
            if (stepID == 1 || stepID == 3) {
                this.visualizeVertices();
                this.visualizeSetAsText();
                this.visualizeMatching();
                this.visualizeMatchingAsText();
            }
            if (stepID == 5) {
                VogelsApproximationMethodPlugin.this.regretView.remove(VogelsApproximationMethodPlugin.this.regretView.getLastColumn());
            }
            if (stepID == 6) {
                this.visualizeVertices();
            }
            if (stepID == 7) {
                this.visualizeMatching();
                this.visualizeMatchingAsText();
            }
            if (stepID == 8) {
                this.visualizeVertices();
                this.visualizeSetAsText();
                VogelsApproximationMethodPlugin.this.adjacencyMatrixView.removeLastColumnStrikeout();
                VogelsApproximationMethodPlugin.this.adjacencyMatrixView.removeLastColumnStrikeout();
                VogelsApproximationMethodPlugin.this.adjacencyMatrixView.removeLastRowStrikeout();
                VogelsApproximationMethodPlugin.this.adjacencyMatrixView.removeLastRowStrikeout();
            }
        }

        protected void adoptState(int stepID, AlgorithmState state) {
            if (stepID == 6) {
                this.userChoiceV = state.getInt("v");
            }
        }

        protected View[] getViews() {
            return new View[]{VogelsApproximationMethodPlugin.this.graphView, VogelsApproximationMethodPlugin.this.setView, VogelsApproximationMethodPlugin.this.matchingView, VogelsApproximationMethodPlugin.this.adjacencyMatrixView, VogelsApproximationMethodPlugin.this.regretView};
        }

        private void visualizeVertices() {
            int i = 0;
            while (i < VogelsApproximationMethodPlugin.this.graphView.getVisualVertexCount()) {
                GraphView.VisualVertex vv = VogelsApproximationMethodPlugin.this.graphView.getVisualVertex(i);
                if (this.L.contains((Object)vv.getVertex().getID())) {
                    vv.setBackground(vv.getVertex().getID() == this.v || vv.getVertex().getID() == this.v1 ? VogelsApproximationMethodPlugin.this.colorCurrVertices : VogelsApproximationMethodPlugin.this.colorSetL);
                    vv.setEdgeWidth(vv.getVertex().getID() == this.v ? 2 : 1);
                } else {
                    vv.setBackground(GraphView.DEF_VERTEXBACKGROUND);
                    vv.setEdgeWidth(1);
                }
                ++i;
            }
            VogelsApproximationMethodPlugin.this.graphView.repaint();
        }

        private void visualizeMatching() {
            if (this.M == null) {
                return;
            }
            int i = 0;
            while (i < VogelsApproximationMethodPlugin.this.graphView.getVisualEdgeCount()) {
                GraphView.VisualEdge ve = VogelsApproximationMethodPlugin.this.graphView.getVisualEdge(i);
                if (this.M.contains((Object)ve.getEdge())) {
                    ve.setColor(VogelsApproximationMethodPlugin.this.colorMatchedEdges);
                    ve.setLineWidth(VogelsApproximationMethodPlugin.this.lineWidthMatchedEdges);
                } else {
                    ve.setColor(GraphView.DEF_EDGECOLOR);
                    ve.setLineWidth(1);
                }
                ++i;
            }
            VogelsApproximationMethodPlugin.this.graphView.repaint();
        }

        private void visualizeMatchingAsText() {
            VogelsApproximationMethodPlugin.this.matchingView.setText(this.M != null ? "M=" + this.M.toString() : "");
        }

        private void visualizeSetAsText() {
            VogelsApproximationMethodPlugin.this.setView.setText("L=" + this.toCaptions(this.L));
        }

        private Set<String> toCaptions(Set<Integer> set) {
            Graph graph = VogelsApproximationMethodPlugin.this.graphView.getGraph();
            Set res = new Set(set.size());
            for (Integer id : set) {
                res.add((Object)graph.getVertexByID(id.intValue()).getCaption());
            }
            return res;
        }

        private Color getNextStrikeoutColor() {
            return this.strikeoutColors.get(this.nextStrikeoutColorIndex++ % this.strikeoutColors.size());
        }
    }
}

