/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.CircleLayoutToolBarExtension;
import lavesdk.algorithm.plugin.extensions.MatrixToGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.RandomGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.AlgorithmTextView;
import lavesdk.algorithm.plugin.views.DefaultGraphView;
import lavesdk.algorithm.plugin.views.ExecutionTableView;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.LegendView;
import lavesdk.algorithm.plugin.views.TextAreaView;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.configuration.Configuration;
import lavesdk.gui.dialogs.SolveExerciseDialog;
import lavesdk.gui.dialogs.SolveExercisePane;
import lavesdk.gui.dialogs.enums.AllowedGraphType;
import lavesdk.gui.widgets.BooleanProperty;
import lavesdk.gui.widgets.BooleanPropertyGroup;
import lavesdk.gui.widgets.ColorProperty;
import lavesdk.gui.widgets.ExecutionTableBorder;
import lavesdk.gui.widgets.ExecutionTableColumn;
import lavesdk.gui.widgets.ExecutionTableGroup;
import lavesdk.gui.widgets.ExecutionTableItem;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.gui.widgets.Mask;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.NumericTextField;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;
import lavesdk.gui.widgets.Symbol;
import lavesdk.language.LanguageFile;
import lavesdk.math.ElementParser;
import lavesdk.math.Set;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.SimpleGraph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.Walk;
import lavesdk.serialization.Serializer;
import lavesdk.utils.GraphUtils;
import lavesdk.utils.MathUtils;

public class DijkstraAlgorithmPlugin
implements AlgorithmPlugin {
    private PluginHost host;
    private Configuration config;
    private LanguageFile langFile;
    private String langID;
    private FileNameExtensionFilter vgfFileFilter;
    private FileNameExtensionFilter pngFileFilter;
    private AlgorithmText algoText;
    private DefaultGraphView graphView;
    private AlgorithmTextView algoTextView;
    private ExecutionTableView execTableView;
    private TextAreaView setsView;
    private LegendView legendView;
    private DijkstraRTE rte;
    private MatrixToGraphToolBarExtension<Vertex, Edge> matrixToGraph;
    private RandomGraphToolBarExtension<Vertex, Edge> randomGraph;
    private CircleLayoutToolBarExtension<Vertex, Edge> circleLayoutExt;
    private String creatorPrefsDirected;
    private String creatorPrefsUndirected;
    private boolean creatorPrefsDirectedValue;
    private ViewGroup ab;
    private ViewGroup de;
    private ViewGroup abcde;
    private Color colorSetA;
    private Color colorSetB;
    private Color colorSetC;
    private Color colorVertexMinDist;
    private Color colorSetHighlight;
    private Color colorSetCurrElemHighlight;
    private Color colorModified;
    private int lineWidthStartVertex;
    private int lineWidthCurrEdge;
    private int lineWidthVertexMinDist;
    private static final String CFGKEY_CREATORPROP_DIRECTED = "creatorPropDirected";
    private static final String CFGKEY_COLOR_MODIFIED = "colorModified";
    private static final String CFGKEY_COLOR_SETHIGHLIGHT = "colorSetHighlight";
    private static final String CFGKEY_COLOR_SETCURRELEMHIGHLIGHT = "colorSetCurrElemHighlight";
    private static final String CFGKEY_COLOR_SETA = "colorSetA";
    private static final String CFGKEY_COLOR_SETB = "colorSetB";
    private static final String CFGKEY_COLOR_SETC = "colorSetC";
    private static final String CFGKEY_COLOR_VERTEXMINDIST = "colorVertexMinDist";
    private static final String CFGKEY_LINEWIDTH_STARTVERTEX = "lineWidthStartVertex";
    private static final String CFGKEY_LINEWIDTH_CURREDGE = "lineWidthCurrEdge";
    private static final String CFGKEY_LINEWIDTH_VERTEXMINDIST = "lineWidthVertexMinDist";

    public void initialize(PluginHost host, ResourceLoader resLoader, Configuration config) {
        try {
            this.langFile = new LanguageFile(resLoader.getResourceAsStream("main/resources/langDijkstra.txt"));
            this.langFile.include(host.getLanguageFile());
        }
        catch (IOException e) {
            this.langFile = null;
        }
        this.langID = host.getLanguageID();
        this.host = host;
        this.config = config != null ? config : new Configuration();
        this.vgfFileFilter = new FileNameExtensionFilter("Visual Graph File (*.vgf)", "vgf");
        this.pngFileFilter = new FileNameExtensionFilter("Portable Network Graphic (*.png)", "png");
        this.graphView = new DefaultGraphView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_GRAPH_TITLE", (String)this.langID, (String)"Graph"), (Graph)new SimpleGraph(false), null, true, this.langFile, this.langID);
        this.execTableView = new ExecutionTableView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_EXECTABLE_TITLE", (String)this.langID, (String)"Execution Table"), true, this.langFile, this.langID);
        this.setsView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_SETS_TITLE", (String)this.langID, (String)"Set Overview"), true, this.langFile, this.langID);
        this.algoText = this.loadAlgorithmText();
        this.algoTextView = new AlgorithmTextView(host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ALGOTEXT_TITLE", (String)this.langID, (String)"Algorithm"), this.algoText, true, this.langFile, this.langID);
        this.legendView = new LegendView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LEGEND_TITLE", (String)this.langID, (String)"Legend"), true, this.langFile, this.langID);
        this.rte = new DijkstraRTE();
        this.matrixToGraph = new MatrixToGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.BOTH, this.langFile, this.langID, true);
        this.randomGraph = new RandomGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.BOTH, this.langFile, this.langID, false);
        this.circleLayoutExt = new CircleLayoutToolBarExtension((GraphView)this.graphView, this.langFile, this.langID, false);
        this.creatorPrefsDirected = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_DIRECTED", (String)this.langID, (String)"directed");
        this.creatorPrefsUndirected = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_UNDIRECTED", (String)this.langID, (String)"undirected");
        this.algoTextView.setAutoRepaint(true);
        this.execTableView.setAutoRepaint(true);
        this.setsView.setAutoRepaint(true);
        this.creatorPrefsDirectedValue = this.config.getBoolean(CFGKEY_CREATORPROP_DIRECTED, false);
        this.colorSetA = this.config.getColor(CFGKEY_COLOR_SETA, new Color(180, 210, 230));
        this.colorSetB = this.config.getColor(CFGKEY_COLOR_SETB, new Color(255, 220, 80));
        this.colorSetC = this.config.getColor(CFGKEY_COLOR_SETC, Color.white);
        this.colorVertexMinDist = this.config.getColor(CFGKEY_COLOR_VERTEXMINDIST, new Color(120, 210, 80));
        this.colorSetHighlight = this.config.getColor(CFGKEY_COLOR_SETHIGHLIGHT, new Color(225, 235, 240));
        this.colorSetCurrElemHighlight = this.config.getColor(CFGKEY_COLOR_SETCURRELEMHIGHLIGHT, new Color(195, 210, 225));
        this.colorModified = this.config.getColor(CFGKEY_COLOR_MODIFIED, new Color(255, 180, 130));
        this.lineWidthStartVertex = this.config.getInt(CFGKEY_LINEWIDTH_STARTVERTEX, 2);
        this.lineWidthVertexMinDist = this.config.getInt(CFGKEY_LINEWIDTH_VERTEXMINDIST, 2);
        this.lineWidthCurrEdge = this.config.getInt(CFGKEY_LINEWIDTH_CURREDGE, 2);
        this.graphView.loadConfiguration(config, "graphView");
        this.algoTextView.loadConfiguration(config, "algoTextView");
        this.execTableView.loadConfiguration(config, "execTableView");
        this.setsView.loadConfiguration(config, "setsView");
        this.legendView.loadConfiguration(config, "legendView");
        this.createLegend();
    }

    public String getName() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_NAME", (String)this.langID, (String)"Dijkstra's Algorithm");
    }

    public String getDescription() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_DESC", (String)this.langID, (String)"Finds the shortest path between a starting vertex and another (or every other) vertex.");
    }

    public String getType() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_TYPE", (String)this.langID, (String)"Exact algorithm");
    }

    public String getAuthor() {
        return "Jan Dornseifer";
    }

    public String getAuthorContact() {
        return "jan.dornseifer@student.uni-siegen.de";
    }

    public String getAssumptions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_ASSUMPTIONS", (String)this.langID, (String)"A simple, non-negative weighted graph G = (V, E) and a starting vertex v<sub>1</sub>.");
    }

    public String getProblemAffiliation() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_PROBLEMAFFILIATION", (String)this.langID, (String)"Shortest path problem");
    }

    public String getSubject() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_SUBJECT", (String)this.langID, (String)"Logistics");
    }

    public String getInstructions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_INSTRUCTIONS", (String)this.langID, (String)"<b>Creating problem entities</b>:<br>Create your own graph and make sure that the graph complies with the assumptions of the algorithm. You can use<br>the toolbar extension to create a graph by use of an adjacency matrix.<br><br><b>Starting the algorithm</b>:<br>Before you start the algorithm select a vertex v<sub>1</sub> the algorithm should begin with.<br><br><b>Exercise Mode</b>:<br>Activate the exercise mode to practice the algorithm in an interactive way. After you have started the algorithm<br>exercises are presented that you have to solve.<br>If an exercise can be solved directly in a view of the algorithm the corresponding view is highlighted with a border, there you can<br>enter your solution and afterwards you have to press the button to solve the exercise. Otherwise (if an exercise is not related to a specific<br>view) you can directly press the button to solve the exercise which opens a dialog where you can enter your solution of the exercise.");
    }

    public String getVersion() {
        return "1.4";
    }

    public LAVESDKV getUsedSDKVersion() {
        return new LAVESDKV(1, 4);
    }

    public AlgorithmRTE getRuntimeEnvironment() {
        return this.rte;
    }

    public AlgorithmText getText() {
        return this.algoText.getBaseCopy();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean hasExerciseMode() {
        return true;
    }

    public boolean hasCreatorPreferences() {
        return true;
    }

    public void loadCreatorPreferences(PropertiesListModel plm) {
        BooleanPropertyGroup group = new BooleanPropertyGroup(plm);
        plm.add((Property)new BooleanProperty(this.creatorPrefsDirected, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_DIRECTED_DESC", (String)this.langID, (String)"Apply algorithm to a directed graph"), this.creatorPrefsDirectedValue, group));
        plm.add((Property)new BooleanProperty(this.creatorPrefsUndirected, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_UNDIRECTED_DESC", (String)this.langID, (String)"Apply algorithm to an undirected graph"), !this.creatorPrefsDirectedValue, group));
    }

    public void onCreate(ViewContainer container, PropertiesListModel creatorProperties) {
        this.creatorPrefsDirectedValue = creatorProperties != null ? creatorProperties.getBooleanProperty(this.creatorPrefsDirected).getValue() : false;
        this.config.addBoolean(CFGKEY_CREATORPROP_DIRECTED, this.creatorPrefsDirectedValue);
        this.graphView.setGraph((Graph)new SimpleGraph(this.creatorPrefsDirectedValue));
        this.graphView.repaint();
        this.matrixToGraph.setAllowedGraphType(this.creatorPrefsDirectedValue ? AllowedGraphType.DIRECTED_ONLY : AllowedGraphType.UNDIRECTED_ONLY);
        this.randomGraph.setAllowedGraphType(this.creatorPrefsDirectedValue ? AllowedGraphType.DIRECTED_ONLY : AllowedGraphType.UNDIRECTED_ONLY);
        this.ab = new ViewGroup(1);
        this.de = new ViewGroup(1);
        this.abcde = new ViewGroup(0);
        this.ab.add((Component)this.algoTextView);
        this.ab.add((Component)this.legendView);
        this.ab.restoreWeights((Serializer)this.config, "weights_ab", new float[]{0.6f, 0.4f});
        this.de.add((Component)this.execTableView);
        this.de.add((Component)this.setsView);
        this.de.restoreWeights((Serializer)this.config, "weights_de", new float[]{0.7f, 0.3f});
        this.abcde.add((Component)this.ab);
        this.abcde.add((Component)this.graphView);
        this.abcde.add((Component)this.de);
        this.abcde.restoreWeights((Serializer)this.config, "weights_abcde", new float[]{0.4f, 0.4f, 0.2f});
        container.setLayout((LayoutManager)new BorderLayout());
        container.add((Component)this.abcde, (Object)"Center");
    }

    public void onClose() {
        this.graphView.saveConfiguration(this.config, "graphView");
        this.algoTextView.saveConfiguration(this.config, "algoTextView");
        this.execTableView.saveConfiguration(this.config, "execTableView");
        this.setsView.saveConfiguration(this.config, "setsView");
        this.legendView.saveConfiguration(this.config, "legendView");
        if (this.ab != null) {
            this.ab.storeWeights((Serializer)this.config, "weights_ab");
        }
        if (this.de != null) {
            this.de.storeWeights((Serializer)this.config, "weights_de");
        }
        if (this.abcde != null) {
            this.abcde.storeWeights((Serializer)this.config, "weights_abcde");
        }
        this.graphView.reset();
        this.execTableView.reset();
        this.setsView.reset();
    }

    public boolean hasCustomization() {
        return true;
    }

    public void loadCustomization(PropertiesListModel plm) {
        plm.add((Property)new ColorProperty("algoTextHighlightForeground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTFOREGROUND", (String)this.langID, (String)"Foreground color of the current step in the algorithm"), this.algoTextView.getHighlightForeground()));
        plm.add((Property)new ColorProperty("algoTextHighlightBackground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTBACKGROUND", (String)this.langID, (String)"Background color of the current step in the algorithm"), this.algoTextView.getHighlightBackground()));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SETA, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_SETA", (String)this.langID, (String)"Background color of the vertices of set A"), this.colorSetA));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SETB, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_SETB", (String)this.langID, (String)"Background color of the vertices of set B"), this.colorSetB));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SETC, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_SETC", (String)this.langID, (String)"Background color of the vertices of set C"), this.colorSetC));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_VERTEXMINDIST, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MINDISTVERTEX", (String)this.langID, (String)"Background color of the vertex v<sub>a</sub>"), this.colorVertexMinDist));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SETHIGHLIGHT, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_CURRSETELEMS", (String)this.langID, (String)"Background color of the vertices in the execution table that are under investigation"), this.colorSetHighlight));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SETCURRELEMHIGHLIGHT, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_CURRVERTEX", (String)this.langID, (String)"Background color of the vertex in the execution table that is currently investigated"), this.colorSetCurrElemHighlight));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MODIFIED, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MODIFICATIONS", (String)this.langID, (String)"Color of modifications to objects"), this.colorModified));
        NumericProperty lwStartVertex = new NumericProperty(CFGKEY_LINEWIDTH_STARTVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_STARTVERTEX", (String)this.langID, (String)"Line width of the starting vertex"), (Number)this.lineWidthStartVertex, true);
        lwStartVertex.setMinimum(1);
        lwStartVertex.setMaximum(5);
        plm.add((Property)lwStartVertex);
        NumericProperty lwCurrEdge = new NumericProperty(CFGKEY_LINEWIDTH_CURREDGE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_CURREDGE", (String)this.langID, (String)"Line with of the edge that is currently investigated"), (Number)this.lineWidthCurrEdge, true);
        lwCurrEdge.setMinimum(1);
        lwCurrEdge.setMaximum(5);
        plm.add((Property)lwCurrEdge);
        NumericProperty lwVertexMinDist = new NumericProperty(CFGKEY_LINEWIDTH_VERTEXMINDIST, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_VERTEXMINDIST", (String)this.langID, (String)"Line with of the vertex v<sub>a</sub>"), (Number)this.lineWidthVertexMinDist, true);
        lwVertexMinDist.setMinimum(1);
        lwVertexMinDist.setMaximum(5);
        plm.add((Property)lwVertexMinDist);
    }

    public void applyCustomization(PropertiesListModel plm) {
        this.algoTextView.setHighlightForeground(plm.getColorProperty("algoTextHighlightForeground").getValue());
        this.algoTextView.setHighlightBackground(plm.getColorProperty("algoTextHighlightBackground").getValue());
        this.colorSetA = this.config.addColor(CFGKEY_COLOR_SETA, plm.getColorProperty(CFGKEY_COLOR_SETA).getValue());
        this.colorSetB = this.config.addColor(CFGKEY_COLOR_SETB, plm.getColorProperty(CFGKEY_COLOR_SETB).getValue());
        this.colorSetC = this.config.addColor(CFGKEY_COLOR_SETC, plm.getColorProperty(CFGKEY_COLOR_SETC).getValue());
        this.colorVertexMinDist = this.config.addColor(CFGKEY_COLOR_VERTEXMINDIST, plm.getColorProperty(CFGKEY_COLOR_VERTEXMINDIST).getValue());
        this.colorSetHighlight = this.config.addColor(CFGKEY_COLOR_SETHIGHLIGHT, plm.getColorProperty(CFGKEY_COLOR_SETHIGHLIGHT).getValue());
        this.colorSetCurrElemHighlight = this.config.addColor(CFGKEY_COLOR_SETCURRELEMHIGHLIGHT, plm.getColorProperty(CFGKEY_COLOR_SETCURRELEMHIGHLIGHT).getValue());
        this.colorModified = this.config.addColor(CFGKEY_COLOR_MODIFIED, plm.getColorProperty(CFGKEY_COLOR_MODIFIED).getValue());
        this.lineWidthStartVertex = this.config.addInt(CFGKEY_LINEWIDTH_STARTVERTEX, plm.getNumericProperty(CFGKEY_LINEWIDTH_STARTVERTEX).getValue().intValue());
        this.lineWidthVertexMinDist = this.config.addInt(CFGKEY_LINEWIDTH_VERTEXMINDIST, plm.getNumericProperty(CFGKEY_LINEWIDTH_VERTEXMINDIST).getValue().intValue());
        this.lineWidthCurrEdge = this.config.addInt(CFGKEY_LINEWIDTH_CURREDGE, plm.getNumericProperty(CFGKEY_LINEWIDTH_CURREDGE).getValue().intValue());
        this.createLegend();
    }

    public ToolBarExtension[] getToolBarExtensions() {
        return new ToolBarExtension[]{this.matrixToGraph, this.randomGraph, this.circleLayoutExt};
    }

    public void save(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.save(file);
            } else if (this.pngFileFilter.accept(file)) {
                this.graphView.saveAsPNG(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE", (String)this.langID, (String)"File could not be saved!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE_TITLE", (String)this.langID, (String)"Save File"), MessageIcon.ERROR);
        }
    }

    public void open(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.load(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE", (String)this.langID, (String)"File could not be opened!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE_TITLE", (String)this.langID, (String)"Open File"), MessageIcon.ERROR);
        }
    }

    public FileNameExtensionFilter[] getSaveFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter, this.pngFileFilter};
    }

    public FileNameExtensionFilter[] getOpenFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter};
    }

    public void beforeStart(RTEvent e) {
        if (this.graphView.getSelectedVertexCount() != 1) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_SELECTSTARTVERTEX", (String)this.langID, (String)"Please select the starting vertex in the graph!"), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_SELECTSTARTVERTEX_TITLE", (String)this.langID, (String)"Select starting vertex"), MessageIcon.INFO);
            e.doit = false;
        } else if (this.containsGraphNegativeWeights()) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NEGATIVEWEIGHTS", (String)this.langID, (String)"The created graph contains edges with a negative weight!\nDijkstra's algorithm can only be applied to non-negative weighted graphs."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NEGATIVEWEIGHTS_TITLE", (String)this.langID, (String)"Negative weights"), MessageIcon.INFO);
            e.doit = false;
        }
        if (e.doit) {
            Vertex startVertex = this.graphView.getSelectedVertex(0).getVertex();
            this.graphView.deselectAll();
            this.graphView.setEditable(false);
            this.rte.setStartVertex(startVertex);
            this.execTableView.reset();
            ExecutionTableColumn column = new ExecutionTableColumn(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_EXECTABLE_FIRSTCOL", (String)this.langID, (String)"Vertices:"), 0);
            column.addMask(new Mask((Object)Float.valueOf(1.0f), (Object)"d(v)"));
            this.execTableView.add(column);
            column = new ExecutionTableColumn(startVertex.getCaption(), startVertex.getID());
            column.addMask(new Mask((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Icon)Symbol.getPredefinedSymbol((Symbol.PredefinedSymbol)Symbol.PredefinedSymbol.INFINITY)));
            column.setEditable(true);
            this.execTableView.add(column);
            int i = 0;
            while (i < this.graphView.getVisualVertexCount()) {
                if (this.graphView.getVisualVertex(i).getVertex() != startVertex) {
                    column = new ExecutionTableColumn(this.graphView.getVisualVertex(i).getVertex().getCaption(), this.graphView.getVisualVertex(i).getVertex().getID());
                    column.addMask(new Mask((Object)Float.valueOf(Float.POSITIVE_INFINITY), (Icon)Symbol.getPredefinedSymbol((Symbol.PredefinedSymbol)Symbol.PredefinedSymbol.INFINITY)));
                    column.setEditable(true);
                    this.execTableView.add(column);
                }
                ++i;
            }
            this.execTableView.addColumnGroup(new ExecutionTableGroup(new ExecutionTableBorder(2, Color.black), 0));
            this.execTableView.addItemGroup(new ExecutionTableGroup(new ExecutionTableBorder(2, Color.black), 0, 2, true));
            this.setsView.reset();
            if (this.rte.isExerciseModeEnabled()) {
                Random rnd = new Random();
                Set vertices = this.graphView.getGraph().getVertexSet();
                vertices.remove((Object)startVertex);
                final Vertex rndTargetVertex = (Vertex)vertices.get(rnd.nextInt(vertices.size()));
                String finalExerciseText = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"FINAL_EXERCISE", (String)this.langID, (String)"What is the path from vertex &v_1& to vertex &v_i& and how long is the path?");
                finalExerciseText = finalExerciseText.replaceAll("&v_1&", startVertex.getCaption());
                finalExerciseText = finalExerciseText.replaceAll("&v_i&", rndTargetVertex.getCaption());
                this.algoText.setFinalExercise((AlgorithmExercise)new AlgorithmExercise<Object>(finalExerciseText, 3.0f){

                    protected Object[] requestSolution() {
                        SolveExerciseDialog.SolutionEntry entryPath = new SolveExerciseDialog.SolutionEntry(LanguageFile.getLabel((LanguageFile)DijkstraAlgorithmPlugin.this.langFile, (String)"FINAL_EXERCISE_PATH", (String)DijkstraAlgorithmPlugin.this.langID, (String)"Path ="), (Component)new JTextField());
                        SolveExerciseDialog.SolutionEntry entryLength = new SolveExerciseDialog.SolutionEntry(LanguageFile.getLabel((LanguageFile)DijkstraAlgorithmPlugin.this.langFile, (String)"FINAL_EXERCISE_LENGTH", (String)DijkstraAlgorithmPlugin.this.langID, (String)"Length ="), (Component)new NumericTextField());
                        if (!SolveExercisePane.showDialog((PluginHost)DijkstraAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryPath, entryLength}, (LanguageFile)DijkstraAlgorithmPlugin.this.langFile, (String)DijkstraAlgorithmPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)DijkstraAlgorithmPlugin.this.langFile, (String)"EXERCISE_HINT_SETINPUT", (String)DijkstraAlgorithmPlugin.this.langID, (String)"Use a comma as the delimiter!"))) {
                            return null;
                        }
                        Walk w = GraphUtils.toWalk((String)((JTextField)entryPath.getComponent()).getText(), (Graph)DijkstraAlgorithmPlugin.this.graphView.getGraph());
                        Number length = null;
                        try {
                            length = NumberFormat.getInstance().parse(((NumericTextField)entryLength.getComponent()).getText());
                        }
                        catch (ParseException e) {
                            length = null;
                        }
                        return new Object[]{w, length};
                    }

                    protected boolean examine(Object[] results, AlgorithmState state) {
                        Walk w = (Walk)results[0];
                        Number length = (Number)results[1];
                        Map d = state.getMap("d");
                        Map p = state.getMap("p");
                        if (w == null || length == null) {
                            return false;
                        }
                        if (length.floatValue() != ((Float)d.get(rndTargetVertex.getID())).floatValue()) {
                            return false;
                        }
                        Graph graph = DijkstraAlgorithmPlugin.this.graphView.getGraph();
                        Walk idealWalk = new Walk(graph);
                        Vertex v = rndTargetVertex;
                        while (v != null) {
                            idealWalk.add(0, v);
                            v = graph.getVertexByCaption((String)p.get(v.getID()));
                        }
                        return w.equals(idealWalk);
                    }
                });
            }
        }
    }

    public void beforeResume(RTEvent e) {
    }

    public void beforePause(RTEvent e) {
    }

    public void onStop() {
        this.graphView.setEditable(true);
        this.algoText.setFinalExercise(null);
    }

    public void onRunning() {
    }

    public void onPause() {
    }

    private AlgorithmText loadAlgorithmText() {
        AlgorithmText text = new AlgorithmText();
        AlgorithmParagraph initParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_INITIALIZATION", (String)this.langID, (String)"1. Initialization:"), 1);
        AlgorithmParagraph stopParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_STOPCRITERION", (String)this.langID, (String)"2. Stop criterion:"), 2);
        AlgorithmParagraph itParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_ITERATION", (String)this.langID, (String)"3. Iteration:"), 3);
        AlgorithmStep step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP1_INITSETS", (String)this.langID, (String)"Set _latex{$A := \\{v_1\\}$}, _latex{$B := \\{v_i \\in V | (v_1,v_i) \\in E \\}$} and _latex{$C := V \\setminus (A \\cup B)$}.\n"), 1);
        step.setExercise(new AlgorithmExercise<Set<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_SETP1", (String)this.langID, (String)"Specify the sets A, B and C."), 3.0f){

            protected Set<?>[] requestSolution() {
                SolveExerciseDialog.SolutionEntry entryA = new SolveExerciseDialog.SolutionEntry("A=", (Component)new JTextField());
                SolveExerciseDialog.SolutionEntry entryB = new SolveExerciseDialog.SolutionEntry("B=", (Component)new JTextField());
                SolveExerciseDialog.SolutionEntry entryC = new SolveExerciseDialog.SolutionEntry("C=", (Component)new JTextField());
                if (!SolveExercisePane.showDialog((PluginHost)DijkstraAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryA, entryB, entryC}, (LanguageFile)DijkstraAlgorithmPlugin.this.langFile, (String)DijkstraAlgorithmPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)DijkstraAlgorithmPlugin.this.langFile, (String)"EXERCISE_HINT_SETINPUT", (String)DijkstraAlgorithmPlugin.this.langID, (String)"Use a comma as the delimiter!"))) {
                    return null;
                }
                Set.StringElementParser parser = new Set.StringElementParser();
                Set A = Set.parse((String)((JTextField)entryA.getComponent()).getText(), (ElementParser)parser);
                Set B = Set.parse((String)((JTextField)entryB.getComponent()).getText(), (ElementParser)parser);
                Set C = Set.parse((String)((JTextField)entryC.getComponent()).getText(), (ElementParser)parser);
                return new Set[]{A, B, C};
            }

            protected String getResultAsString(Set<?> result, int index) {
                String setName = "";
                switch (index) {
                    case 0: {
                        setName = "A=";
                        break;
                    }
                    case 1: {
                        setName = "B=";
                        break;
                    }
                    case 2: {
                        setName = "C=";
                    }
                }
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                return String.valueOf(setName) + super.getResultAsString(result, index);
            }

            protected boolean examine(Set<?>[] results, AlgorithmState state) {
                Set A = DijkstraAlgorithmPlugin.this.toIDs(results[0]);
                Set B = DijkstraAlgorithmPlugin.this.toIDs(results[1]);
                Set C = DijkstraAlgorithmPlugin.this.toIDs(results[2]);
                return this.doAutoExamine(state, new String[]{"A", "B", "C"}, new Set[]{A, B, C});
            }
        });
        step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_SETP2_INITD", (String)this.langID, (String)"Set _latex{$d(v_1) := 0$}, _latex{$d(v_i) := c(v_1,v_i) \\; \\forall v_i \\in B$} and _latex{$d(v_i) := \\infty \\; \\forall v_i \\in C$}.\n"), 2);
        step.setExercise(new AlgorithmExercise<Map<?, ?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP2", (String)this.langID, (String)"Specify d(v) in the execution table (<i>use \"-\" as infinity</i>)."), 3.0f, (View)this.execTableView){

            protected void beforeRequestSolution(AlgorithmState state) {
                ExecutionTableItem item = new ExecutionTableItem((Object[])new String[]{"d(v)"});
                item.setDefaultInputParser((ExecutionTableItem.InputParser)new ExecutionTableItem.NumericInputParser());
                item.setEditable(true);
                item.setBorder(new ExecutionTableBorder(2, (Color)SystemColor.textHighlight));
                DijkstraAlgorithmPlugin.this.execTableView.add(item);
            }

            protected void afterRequestSolution(boolean omitted) {
                DijkstraAlgorithmPlugin.this.execTableView.remove(DijkstraAlgorithmPlugin.this.execTableView.getLastItem());
            }

            protected Map<?, ?>[] requestSolution() {
                ExecutionTableItem item = DijkstraAlgorithmPlugin.this.execTableView.getLastItem();
                HashMap<Integer, Float> d = new HashMap<Integer, Float>();
                d.put(0, Float.valueOf(1.0f));
                int i = 1;
                while (i < DijkstraAlgorithmPlugin.this.execTableView.getColumnCount()) {
                    Object o = item.getCellObject(i);
                    d.put(DijkstraAlgorithmPlugin.this.execTableView.getColumn(i).getID(), Float.valueOf(o != null ? ((Number)o).floatValue() : 0.0f));
                    ++i;
                }
                return new Map[]{d};
            }

            protected String getResultAsString(Map<?, ?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                Iterator<?> it = result.keySet().iterator();
                StringBuilder res = new StringBuilder();
                int c = 0;
                while (it.hasNext()) {
                    Integer id = (Integer)it.next();
                    if (id == 0) continue;
                    GraphView.VisualVertex vv = DijkstraAlgorithmPlugin.this.graphView.getVisualVertexByID(id.intValue());
                    if (vv != null) {
                        if (c > 0) {
                            res.append(", ");
                        }
                        res.append("(" + vv.getVertex().getCaption() + ", " + MathUtils.formatFloat((float)((Float)result.get(id)).floatValue()) + ")");
                    }
                    ++c;
                }
                return "d(v)=[" + res.toString() + "]";
            }

            protected boolean examine(Map<?, ?>[] results, AlgorithmState state) {
                return this.doAutoExamine(state, new String[]{"d"}, results);
            }
        });
        step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_SETP3_INITP", (String)this.langID, (String)"Set _latex{$p(v_i) := v_1 \\; \\forall v_i \\in B$}.\n\n"), 3);
        step.setExercise(new AlgorithmExercise<Map<?, ?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP3", (String)this.langID, (String)"Specify p(v) in the execution table."), 2.0f, (View)this.execTableView){

            protected void beforeRequestSolution(AlgorithmState state) {
                ExecutionTableItem item = new ExecutionTableItem((Object[])new String[]{"p(v)"});
                item.setDefaultInputParser((ExecutionTableItem.InputParser)new ExecutionTableItem.StringInputParser());
                item.setEditable(true);
                item.setBorder(new ExecutionTableBorder(2, (Color)SystemColor.textHighlight));
                DijkstraAlgorithmPlugin.this.execTableView.add(item);
            }

            protected void afterRequestSolution(boolean omitted) {
                DijkstraAlgorithmPlugin.this.execTableView.remove(DijkstraAlgorithmPlugin.this.execTableView.getLastItem());
            }

            protected Map<?, ?>[] requestSolution() {
                ExecutionTableItem item = DijkstraAlgorithmPlugin.this.execTableView.getLastItem();
                HashMap<Integer, String> p = new HashMap<Integer, String>();
                p.put(0, "p(v)");
                int i = 1;
                while (i < DijkstraAlgorithmPlugin.this.execTableView.getColumnCount()) {
                    Object o = item.getCellObject(i);
                    p.put(DijkstraAlgorithmPlugin.this.execTableView.getColumn(i).getID(), o != null && !o.toString().isEmpty() ? o.toString() : null);
                    ++i;
                }
                return new Map[]{p};
            }

            protected String getResultAsString(Map<?, ?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                Iterator<?> it = result.keySet().iterator();
                StringBuilder res = new StringBuilder();
                int c = 0;
                while (it.hasNext()) {
                    Integer id = (Integer)it.next();
                    if (id == 0) continue;
                    GraphView.VisualVertex vv = DijkstraAlgorithmPlugin.this.graphView.getVisualVertexByID(id.intValue());
                    if (vv != null) {
                        Object o = result.get(id);
                        if (o == null) {
                            o = "";
                        }
                        if (c > 0) {
                            res.append(", ");
                        }
                        res.append("(" + vv.getVertex().getCaption() + ", " + o + ")");
                    }
                    ++c;
                }
                return "p(v)=[" + res.toString() + "]";
            }

            protected boolean examine(Map<?, ?>[] results, AlgorithmState state) {
                return this.doAutoExamine(state, new String[]{"p"}, results);
            }
        });
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_SETP4_STOP", (String)this.langID, (String)"If _latex{$A = V$} or _latex{$B = \\emptyset$} then stop. Otherwise go to step 3.\n\n"), 4);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Boolean>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP4", (String)this.langID, (String)"Does the algorithm terminate or does he resume with 3.?"), 1.0f){
            private final String labelTerminate;
            private final String labelResume;
            {
                this.labelTerminate = LanguageFile.getLabel((LanguageFile)DijkstraAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP4_OPTIONTERMINATE", (String)DijkstraAlgorithmPlugin.this.langID, (String)"Algorithm terminates");
                this.labelResume = LanguageFile.getLabel((LanguageFile)DijkstraAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP4_OPTIONRESUME", (String)DijkstraAlgorithmPlugin.this.langID, (String)"Algorithm resumes with step 3");
            }

            protected Boolean[] requestSolution() {
                ButtonGroup group = new ButtonGroup();
                JRadioButton rdobtn1 = new JRadioButton(this.labelTerminate);
                JRadioButton rdobtn2 = new JRadioButton(this.labelResume);
                group.add(rdobtn1);
                group.add(rdobtn2);
                SolveExerciseDialog.SolutionEntry entryFinish = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn1);
                SolveExerciseDialog.SolutionEntry entryResume = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn2);
                if (!SolveExercisePane.showDialog((PluginHost)DijkstraAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryFinish, entryResume}, (LanguageFile)DijkstraAlgorithmPlugin.this.langFile, (String)DijkstraAlgorithmPlugin.this.langID)) {
                    return null;
                }
                return new Boolean[]{!rdobtn1.isSelected() && !rdobtn2.isSelected() ? null : Boolean.valueOf(rdobtn1.isSelected())};
            }

            protected String getResultAsString(Boolean result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return result == Boolean.TRUE ? this.labelTerminate : this.labelResume;
            }

            protected boolean examine(Boolean[] results, AlgorithmState state) {
                Set A = state.getSet("A");
                Set V = DijkstraAlgorithmPlugin.this.graphView.getGraph().getVertexByIDSet();
                return results[0] != null && results[0].booleanValue() == A.equals((Collection)V);
            }
        });
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_SETP5_DETERMINEVERTEXMINDIST", (String)this.langID, (String)"Determine _latex{$v_a \\in \\; \\underset{v_i \\in B}{argmin} \\; d(v_i)$} "), 5);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Integer>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP5", (String)this.langID, (String)"Choose the vertex in the graph with a minimum value in d(v)."), 1.0f, (View)this.graphView){

            protected void beforeRequestSolution(AlgorithmState state) {
                DijkstraAlgorithmPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                DijkstraAlgorithmPlugin.this.graphView.deselectAll();
                DijkstraAlgorithmPlugin.this.graphView.setShowCursorToolAlways(false);
            }

            protected Integer[] requestSolution() {
                if (DijkstraAlgorithmPlugin.this.graphView.getSelectedVertexCount() != 1) {
                    return null;
                }
                return new Integer[]{DijkstraAlgorithmPlugin.this.graphView.getSelectedVertex(0).getVertex().getID()};
            }

            protected String getResultAsString(Integer result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return DijkstraAlgorithmPlugin.this.graphView.getVisualVertexByID(result.intValue()).getVertex().getCaption();
            }

            protected boolean examine(Integer[] results, AlgorithmState state) {
                return this.doAutoExamine(state, new String[]{"v_a"}, results);
            }
        });
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_SETP6_UPDATESETS", (String)this.langID, (String)"and set _latex{$A = A \\cup \\{v_a\\}$} and _latex{$B = B \\setminus \\{v_a\\}$}.\n"), 6);
        step.setExercise(new AlgorithmExercise<Set<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP6", (String)this.langID, (String)"What are the sets A and B?"), 2.0f){

            protected Set<?>[] requestSolution() {
                SolveExerciseDialog.SolutionEntry entryA = new SolveExerciseDialog.SolutionEntry("A=", (Component)new JTextField());
                SolveExerciseDialog.SolutionEntry entryB = new SolveExerciseDialog.SolutionEntry("B=", (Component)new JTextField());
                if (!SolveExercisePane.showDialog((PluginHost)DijkstraAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryA, entryB}, (LanguageFile)DijkstraAlgorithmPlugin.this.langFile, (String)DijkstraAlgorithmPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)DijkstraAlgorithmPlugin.this.langFile, (String)"EXERCISE_HINT_SETINPUT", (String)DijkstraAlgorithmPlugin.this.langID, (String)"Use a comma as the delimiter!"))) {
                    return null;
                }
                Set.StringElementParser parser = new Set.StringElementParser();
                Set A = Set.parse((String)((JTextField)entryA.getComponent()).getText(), (ElementParser)parser);
                Set B = Set.parse((String)((JTextField)entryB.getComponent()).getText(), (ElementParser)parser);
                return new Set[]{A, B};
            }

            protected String getResultAsString(Set<?> result, int index) {
                String setName = "";
                switch (index) {
                    case 0: {
                        setName = "A=";
                        break;
                    }
                    case 1: {
                        setName = "B=";
                    }
                }
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                return String.valueOf(setName) + super.getResultAsString(result, index);
            }

            protected boolean examine(Set<?>[] results, AlgorithmState state) {
                Set A = DijkstraAlgorithmPlugin.this.toIDs(results[0]);
                Set B = DijkstraAlgorithmPlugin.this.toIDs(results[1]);
                return this.doAutoExamine(state, new String[]{"A", "B"}, new Set[]{A, B});
            }
        });
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_SETP7_UPDATEDANDPFORALLB", (String)this.langID, (String)"For all _latex{$v_i \\in B$} with _latex{$(v_a,v_i) \\in E$}:\nIf _latex{$d(v_a) + c(v_a,v_i) < d(v_i)$} then _latex{$d(v_i) = d(v_a) + c(v_a,v_i)$} and _latex{$p(v_i) = v_a$}\n"), 7);
        step.setExercise(new AlgorithmExercise<Map<?, ?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP7", (String)this.langID, (String)"What are d(v) and p(v) (<i>use \"-\" as infinity</i>)?"), 5.0f, (View)this.execTableView){

            protected void beforeRequestSolution(AlgorithmState state) {
                Map d = state.getMap("d");
                Map p = state.getMap("p");
                ExecutionTableItem itemD = new ExecutionTableItem(d, true);
                ExecutionTableItem itemP = new ExecutionTableItem(p, true);
                itemD.setDefaultInputParser((ExecutionTableItem.InputParser)new ExecutionTableItem.NumericInputParser());
                itemP.setDefaultInputParser((ExecutionTableItem.InputParser)new ExecutionTableItem.StringInputParser());
                itemD.setEditable(true);
                itemP.setEditable(true);
                itemD.setBorder(new ExecutionTableBorder(2, (Color)SystemColor.textHighlight));
                itemP.setBorder(new ExecutionTableBorder(2, (Color)SystemColor.textHighlight));
                DijkstraAlgorithmPlugin.this.execTableView.add(itemD);
                DijkstraAlgorithmPlugin.this.execTableView.add(itemP);
            }

            protected void afterRequestSolution(boolean omitted) {
                DijkstraAlgorithmPlugin.this.execTableView.remove(DijkstraAlgorithmPlugin.this.execTableView.getLastItem());
                DijkstraAlgorithmPlugin.this.execTableView.remove(DijkstraAlgorithmPlugin.this.execTableView.getLastItem());
            }

            protected Map<?, ?>[] requestSolution() {
                ExecutionTableItem itemD = DijkstraAlgorithmPlugin.this.execTableView.getItem(DijkstraAlgorithmPlugin.this.execTableView.getItemCount() - 2);
                HashMap<Integer, Float> d = new HashMap<Integer, Float>();
                d.put(0, Float.valueOf(1.0f));
                int i = 1;
                while (i < DijkstraAlgorithmPlugin.this.execTableView.getColumnCount()) {
                    Object o = itemD.getCellObject(i);
                    d.put(DijkstraAlgorithmPlugin.this.execTableView.getColumn(i).getID(), Float.valueOf(o != null ? ((Number)o).floatValue() : 0.0f));
                    ++i;
                }
                ExecutionTableItem itemP = DijkstraAlgorithmPlugin.this.execTableView.getLastItem();
                HashMap<Integer, String> p = new HashMap<Integer, String>();
                p.put(0, "p(v)");
                int i2 = 1;
                while (i2 < DijkstraAlgorithmPlugin.this.execTableView.getColumnCount()) {
                    Object o = itemP.getCellObject(i2);
                    p.put(DijkstraAlgorithmPlugin.this.execTableView.getColumn(i2).getID(), o != null && !o.toString().isEmpty() ? o.toString() : null);
                    ++i2;
                }
                return new Map[]{d, p};
            }

            protected String getResultAsString(Map<?, ?> result, int index) {
                String pre = "";
                switch (index) {
                    case 0: {
                        pre = "d(v)";
                        break;
                    }
                    case 1: {
                        pre = "p(v)";
                    }
                }
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                Iterator<?> it = result.keySet().iterator();
                StringBuilder res = new StringBuilder();
                int c = 0;
                while (it.hasNext()) {
                    Integer id = (Integer)it.next();
                    if (id == 0) continue;
                    GraphView.VisualVertex vv = DijkstraAlgorithmPlugin.this.graphView.getVisualVertexByID(id.intValue());
                    if (vv != null) {
                        Object o = result.get(id);
                        if (o == null) {
                            o = "";
                        } else {
                            Object object = o = index == 0 ? MathUtils.formatFloat((float)((Float)o).floatValue()) : o;
                        }
                        if (c > 0) {
                            res.append(", ");
                        }
                        res.append("(" + vv.getVertex().getCaption() + ", " + o + ")");
                    }
                    ++c;
                }
                return String.valueOf(pre) + "=[" + res.toString() + "]";
            }

            protected boolean examine(Map<?, ?>[] results, AlgorithmState state) {
                return this.doAutoExamine(state, new String[]{"d", "p"}, results);
            }
        });
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_SETP8_UPDATEDANDPFORALLC", (String)this.langID, (String)"For all _latex{$v_j \\in C$} with _latex{$(v_a,v_j) \\in E$}:\nSet _latex{$d(v_j) = d(v_a) + c(v_a,v_j)$}, _latex{$p(v_j) = v_a$}, _latex{$B = B \\cup \\{v_j\\}$} and _latex{$C = C \\setminus \\{v_j\\}$}.\n"), 8);
        step.setExercise(new AlgorithmExercise<Map<?, ?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP8", (String)this.langID, (String)"What are d(v) and p(v) (<i>use \"-\" as infinity</i>)?"), 5.0f, (View)this.execTableView){
            private ExecutionTableItem itemD;
            private ExecutionTableItem itemP;

            protected void beforeRequestSolution(AlgorithmState state) {
                this.itemD = DijkstraAlgorithmPlugin.this.execTableView.getItem(DijkstraAlgorithmPlugin.this.execTableView.getItemCount() - 2);
                this.itemP = DijkstraAlgorithmPlugin.this.execTableView.getLastItem();
                this.itemD.setDefaultInputParser((ExecutionTableItem.InputParser)new ExecutionTableItem.NumericInputParser());
                this.itemP.setDefaultInputParser((ExecutionTableItem.InputParser)new ExecutionTableItem.StringInputParser());
                this.itemD.setEditable(true);
                this.itemP.setEditable(true);
                this.itemD.setBorder(new ExecutionTableBorder(2, (Color)SystemColor.textHighlight));
                this.itemP.setBorder(new ExecutionTableBorder(2, (Color)SystemColor.textHighlight));
            }

            protected void afterRequestSolution(boolean omitted) {
                this.itemD.setEditable(false);
                this.itemP.setEditable(false);
                this.itemD.setBorder(null);
                this.itemP.setBorder(null);
            }

            protected Map<?, ?>[] requestSolution() {
                HashMap<Integer, Float> d = new HashMap<Integer, Float>();
                d.put(0, Float.valueOf(1.0f));
                int i = 1;
                while (i < DijkstraAlgorithmPlugin.this.execTableView.getColumnCount()) {
                    Object o = this.itemD.getCellObject(i);
                    d.put(DijkstraAlgorithmPlugin.this.execTableView.getColumn(i).getID(), Float.valueOf(o != null ? ((Number)o).floatValue() : 0.0f));
                    ++i;
                }
                HashMap<Integer, String> p = new HashMap<Integer, String>();
                p.put(0, "p(v)");
                int i2 = 1;
                while (i2 < DijkstraAlgorithmPlugin.this.execTableView.getColumnCount()) {
                    Object o = this.itemP.getCellObject(i2);
                    p.put(DijkstraAlgorithmPlugin.this.execTableView.getColumn(i2).getID(), o != null && !o.toString().isEmpty() ? o.toString() : null);
                    ++i2;
                }
                return new Map[]{d, p};
            }

            protected String getResultAsString(Map<?, ?> result, int index) {
                String pre = "";
                switch (index) {
                    case 0: {
                        pre = "d(v)";
                        break;
                    }
                    case 1: {
                        pre = "p(v)";
                    }
                }
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                Iterator<?> it = result.keySet().iterator();
                StringBuilder res = new StringBuilder();
                int c = 0;
                while (it.hasNext()) {
                    Integer id = (Integer)it.next();
                    if (id == 0) continue;
                    GraphView.VisualVertex vv = DijkstraAlgorithmPlugin.this.graphView.getVisualVertexByID(id.intValue());
                    if (vv != null) {
                        Object o = result.get(id);
                        if (o == null) {
                            o = "";
                        } else {
                            Object object = o = index == 0 ? MathUtils.formatFloat((float)((Float)o).floatValue()) : o;
                        }
                        if (c > 0) {
                            res.append(", ");
                        }
                        res.append("(" + vv.getVertex().getCaption() + ", " + o + ")");
                    }
                    ++c;
                }
                return String.valueOf(pre) + "=[" + res.toString() + "]";
            }

            protected boolean examine(Map<?, ?>[] results, AlgorithmState state) {
                return this.doAutoExamine(state, new String[]{"d", "p"}, results);
            }
        });
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP9_GOTO", (String)this.langID, (String)"Go to step 2."), 9);
        return text;
    }

    private void createLegend() {
        this.legendView.removeAll();
        this.legendView.add(new LegendItem("item1", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_STARTVERTEX", (String)this.langID, (String)"starting vertex v<sub>1</sub>"), LegendItem.createCircleIcon((Color)this.colorSetA, (Color)Color.black, (int)this.lineWidthStartVertex)));
        this.legendView.add(new LegendItem("item2", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_SETA", (String)this.langID, (String)"Set A of vertices where a shortest path is known"), LegendItem.createCircleIcon((Color)this.colorSetA, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item3", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_SETB", (String)this.langID, (String)"Set B of vertices that are not contained in A but connected with a vertex of set A"), LegendItem.createCircleIcon((Color)this.colorSetB, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item4", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_SETC", (String)this.langID, (String)"Set C of vertices that are not in set A and B meaning C = V \\ (A &cup; B)"), LegendItem.createCircleIcon((Color)this.colorSetC, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item5", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_MINDISTVERTEX", (String)this.langID, (String)"The current vertex v<sub>a</sub>"), LegendItem.createCircleIcon((Color)this.colorVertexMinDist, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item6", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CURREDGE", (String)this.langID, (String)"The current edge that is under investigation"), LegendItem.createLineIcon((Color)this.colorModified, (int)this.lineWidthCurrEdge)));
        this.legendView.add(new LegendItem("item7", this.execTableView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_EXECTABLE_CURRSETELEMS", (String)this.langID, (String)"Set of vertices that are under investigation"), LegendItem.createRectangleIcon((Color)this.colorSetHighlight, (Color)this.colorSetHighlight, (int)1)));
        this.legendView.add(new LegendItem("item8", this.execTableView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_EXECTABLE_CURRVERTEX", (String)this.langID, (String)"The current vertex that is under investigation"), LegendItem.createRectangleIcon((Color)this.colorSetCurrElemHighlight, (Color)this.colorSetCurrElemHighlight, (int)1)));
        this.legendView.add(new LegendItem("item9", this.execTableView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_EXECTABLE_CURRMINDISTVERTEX", (String)this.langID, (String)"The vertex of the investigated set with a current minimum value in d(v)"), LegendItem.createRectangleIcon((Color)Color.white, (Color)this.colorVertexMinDist, (int)this.lineWidthVertexMinDist)));
        this.legendView.add(new LegendItem("item10", this.execTableView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_EXECTABLE_MINDISTVERTEX", (String)this.langID, (String)"The current vertex v<sub>a</sub>"), LegendItem.createRectangleIcon((Color)this.colorVertexMinDist, (Color)this.colorVertexMinDist, (int)1)));
        this.legendView.add(new LegendItem("item11", this.execTableView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_EXECTABLE_MODIFICATIONS", (String)this.langID, (String)"Changes in d(v) and/or p(v)"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)1)));
        this.legendView.add(new LegendItem("item12", this.setsView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_SETS_MODIFICATIONS", (String)this.langID, (String)"Changes in the sets A, B or C"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)1)));
    }

    private Set<Integer> toIDs(Set<?> set) {
        Graph graph = this.graphView.getGraph();
        Set res = new Set(set.size());
        for (Object caption : set) {
            Vertex v = graph.getVertexByCaption(caption.toString());
            if (v == null) {
                res.add((Object)-1);
                continue;
            }
            res.add((Object)v.getID());
        }
        return res;
    }

    private boolean containsGraphNegativeWeights() {
        Graph graph = this.graphView.getGraph();
        int i = 0;
        while (i < graph.getSize()) {
            if (graph.getEdge(i).getWeight() < 0.0f) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class DijkstraRTE
    extends AlgorithmRTE {
        private Set<Integer> A;
        private Set<Integer> B;
        private Set<Integer> C;
        private Map<Integer, Float> d;
        private Map<Integer, String> p;
        private int v_a;
        private Vertex v_1;

        public DijkstraRTE() {
            super((AlgorithmPlugin)DijkstraAlgorithmPlugin.this, DijkstraAlgorithmPlugin.this.algoText);
            this.v_1 = null;
        }

        public void setStartVertex(Vertex v) {
            this.v_1 = v;
            this.visualizeVertices();
        }

        protected int executeStep(int stepID, AlgorithmStateAttachment asa) {
            Graph graph = DijkstraAlgorithmPlugin.this.graphView.getGraph();
            GraphView.VisualEdge ve = null;
            int nextStep = -1;
            switch (stepID) {
                case 1: {
                    this.A.add((Object)this.v_1.getID());
                    int i = 0;
                    while (i < this.v_1.getOutgoingEdgeCount()) {
                        this.B.add((Object)this.v_1.getOutgoingEdge(i).getSuccessor(this.v_1).getID());
                        ++i;
                    }
                    this.C = Set.complement((Set)graph.getVertexByIDSet(), (Set)Set.union(this.A, this.B));
                    this.sleep(250L);
                    this.visualizeSets();
                    this.sleep(500L);
                    this.visualizeVertices();
                    this.sleep(1000L);
                    nextStep = 2;
                    break;
                }
                case 2: {
                    this.d.put(this.v_1.getID(), Float.valueOf(0.0f));
                    Iterator iterator = this.B.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        this.d.put(i, Float.valueOf(graph.getEdge(this.v_1.getID(), i).getWeight()));
                    }
                    iterator = this.C.iterator();
                    while (iterator.hasNext()) {
                        int j = (Integer)iterator.next();
                        this.d.put(j, Float.valueOf(Float.POSITIVE_INFINITY));
                    }
                    this.d.put(0, Float.valueOf(1.0f));
                    DijkstraAlgorithmPlugin.this.execTableView.add(new ExecutionTableItem(this.d, true));
                    this.sleep(1000L);
                    nextStep = 3;
                    break;
                }
                case 3: {
                    Iterator iterator = this.B.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        this.p.put(i, this.v_1.getCaption());
                    }
                    this.p.put(this.v_1.getID(), null);
                    iterator = this.C.iterator();
                    while (iterator.hasNext()) {
                        int j = (Integer)iterator.next();
                        this.p.put(j, null);
                    }
                    this.p.put(0, "p(v)");
                    DijkstraAlgorithmPlugin.this.execTableView.add(new ExecutionTableItem(this.p, true));
                    this.sleep(1000L);
                    nextStep = 4;
                    break;
                }
                case 4: {
                    this.sleep(1000L);
                    if (this.A.equals((Collection)DijkstraAlgorithmPlugin.this.graphView.getGraph().getVertexByIDSet()) || this.B.isEmpty()) {
                        nextStep = -1;
                        break;
                    }
                    nextStep = 5;
                    break;
                }
                case 5: {
                    int i;
                    ExecutionTableItem item = DijkstraAlgorithmPlugin.this.execTableView.getItem(DijkstraAlgorithmPlugin.this.execTableView.getItemCount() - 2);
                    float minD = Float.MAX_VALUE;
                    this.v_a = 0;
                    this.sleep(250L);
                    Iterator iterator = this.B.iterator();
                    while (iterator.hasNext()) {
                        i = (Integer)iterator.next();
                        item.setCellBackgroundByID(i, DijkstraAlgorithmPlugin.this.colorSetHighlight);
                    }
                    iterator = this.B.iterator();
                    while (iterator.hasNext()) {
                        i = (Integer)iterator.next();
                        item.setCellBackgroundByID(i, DijkstraAlgorithmPlugin.this.colorSetCurrElemHighlight);
                        this.sleep(500L);
                        if (this.d.get(i).floatValue() < minD) {
                            if (this.v_a > 0) {
                                item.setCellBorderByID(this.v_a, null);
                            }
                            minD = this.d.get(i).floatValue();
                            this.v_a = i;
                            item.setCellBorderByID(this.v_a, DijkstraAlgorithmPlugin.this.colorVertexMinDist, DijkstraAlgorithmPlugin.this.lineWidthVertexMinDist);
                            this.sleep(1000L);
                        }
                        item.setCellBackgroundByID(i, Color.white);
                    }
                    if (this.v_a < 1) {
                        nextStep = -1;
                        break;
                    }
                    item.setCellBorderByID(this.v_a, null);
                    item.setCellBackgroundByID(this.v_a, DijkstraAlgorithmPlugin.this.colorVertexMinDist);
                    this.visualizeVertices();
                    this.sleep(1000L);
                    item.setCellBackgroundByID(this.v_a, Color.white);
                    nextStep = 6;
                    break;
                }
                case 6: {
                    this.sleep(250L);
                    DijkstraAlgorithmPlugin.this.setsView.setBackground(DijkstraAlgorithmPlugin.this.colorModified);
                    this.A.add((Object)this.v_a);
                    this.B.remove((Object)this.v_a);
                    this.sleep(500L);
                    this.visualizeSets();
                    this.visualizeVertices();
                    this.sleep(1000L);
                    DijkstraAlgorithmPlugin.this.setsView.setBackground(Color.white);
                    nextStep = 7;
                    break;
                }
                case 7: {
                    int i;
                    ExecutionTableItem itemD = new ExecutionTableItem(this.d, true);
                    ExecutionTableItem itemP = new ExecutionTableItem(this.p, true);
                    DijkstraAlgorithmPlugin.this.execTableView.add(itemD);
                    DijkstraAlgorithmPlugin.this.execTableView.add(itemP);
                    this.sleep(250L);
                    Iterator iterator = this.B.iterator();
                    while (iterator.hasNext()) {
                        i = (Integer)iterator.next();
                        itemD.setCellBackgroundByID(i, DijkstraAlgorithmPlugin.this.colorSetHighlight);
                        itemP.setCellBackgroundByID(i, DijkstraAlgorithmPlugin.this.colorSetHighlight);
                    }
                    iterator = this.B.iterator();
                    while (iterator.hasNext()) {
                        i = (Integer)iterator.next();
                        Edge e = graph.getEdge(this.v_a, i);
                        itemD.setCellBackgroundByID(i, DijkstraAlgorithmPlugin.this.colorSetCurrElemHighlight);
                        itemP.setCellBackgroundByID(i, DijkstraAlgorithmPlugin.this.colorSetCurrElemHighlight);
                        this.sleep(500L);
                        if (e != null) {
                            ve = DijkstraAlgorithmPlugin.this.graphView.getVisualEdgeByID(e.getID());
                            ve.setColor(DijkstraAlgorithmPlugin.this.colorModified);
                            ve.setLineWidth(2);
                            DijkstraAlgorithmPlugin.this.graphView.repaint();
                            if (this.d.get(this.v_a).floatValue() + e.getWeight() < this.d.get(i).floatValue()) {
                                this.d.put(i, Float.valueOf(this.d.get(this.v_a).floatValue() + e.getWeight()));
                                this.p.put(i, DijkstraAlgorithmPlugin.this.graphView.getVisualVertexByID(this.v_a).getVertex().getCaption());
                                itemD.setCellBackgroundByID(i, DijkstraAlgorithmPlugin.this.colorModified);
                                itemP.setCellBackgroundByID(i, DijkstraAlgorithmPlugin.this.colorModified);
                                this.sleep(250L);
                                itemD.setCellDataByID(this.d);
                                this.sleep(250L);
                                itemP.setCellDataByID(this.p);
                                this.sleep(750L);
                            }
                            ve.setColor(GraphView.DEF_EDGECOLOR);
                            ve.setLineWidth(1);
                            DijkstraAlgorithmPlugin.this.graphView.repaint();
                        }
                        itemD.setCellBackgroundByID(i, Color.white);
                        itemP.setCellBackgroundByID(i, Color.white);
                    }
                    nextStep = 8;
                    break;
                }
                case 8: {
                    int i;
                    ExecutionTableItem itemD2 = DijkstraAlgorithmPlugin.this.execTableView.getItem(DijkstraAlgorithmPlugin.this.execTableView.getItemCount() - 2);
                    ExecutionTableItem itemP2 = DijkstraAlgorithmPlugin.this.execTableView.getItem(DijkstraAlgorithmPlugin.this.execTableView.getItemCount() - 1);
                    this.sleep(250L);
                    Iterator iterator = this.C.iterator();
                    while (iterator.hasNext()) {
                        i = (Integer)iterator.next();
                        itemD2.setCellBackgroundByID(i, DijkstraAlgorithmPlugin.this.colorSetHighlight);
                        itemP2.setCellBackgroundByID(i, DijkstraAlgorithmPlugin.this.colorSetHighlight);
                    }
                    i = this.C.size() - 1;
                    while (i >= 0) {
                        int j = (Integer)this.C.get(i);
                        Edge e = graph.getEdge(this.v_a, j);
                        itemD2.setCellBackgroundByID(j, DijkstraAlgorithmPlugin.this.colorSetCurrElemHighlight);
                        itemP2.setCellBackgroundByID(j, DijkstraAlgorithmPlugin.this.colorSetCurrElemHighlight);
                        this.sleep(500L);
                        if (e != null) {
                            ve = DijkstraAlgorithmPlugin.this.graphView.getVisualEdgeByID(e.getID());
                            ve.setColor(DijkstraAlgorithmPlugin.this.colorModified);
                            ve.setLineWidth(2);
                            DijkstraAlgorithmPlugin.this.graphView.repaint();
                            this.d.put(j, Float.valueOf(this.d.get(this.v_a).floatValue() + e.getWeight()));
                            this.p.put(j, DijkstraAlgorithmPlugin.this.graphView.getVisualVertexByID(this.v_a).getVertex().getCaption());
                            this.B.add((Object)j);
                            this.C.remove((Object)j);
                            itemD2.setCellBackgroundByID(j, DijkstraAlgorithmPlugin.this.colorModified);
                            itemP2.setCellBackgroundByID(j, DijkstraAlgorithmPlugin.this.colorModified);
                            this.sleep(250L);
                            itemD2.setCellDataByID(this.d);
                            this.sleep(250L);
                            itemP2.setCellDataByID(this.p);
                            this.sleep(500L);
                            DijkstraAlgorithmPlugin.this.setsView.setBackground(DijkstraAlgorithmPlugin.this.colorModified);
                            this.sleep(250L);
                            this.visualizeSets();
                            this.visualizeVertices();
                            this.sleep(250L);
                            DijkstraAlgorithmPlugin.this.setsView.setBackground(Color.white);
                            this.sleep(750L);
                            ve.setColor(GraphView.DEF_EDGECOLOR);
                            ve.setLineWidth(1);
                            DijkstraAlgorithmPlugin.this.graphView.repaint();
                        }
                        itemD2.setCellBackgroundByID(j, Color.white);
                        itemP2.setCellBackgroundByID(j, Color.white);
                        --i;
                    }
                    nextStep = 9;
                    break;
                }
                case 9: {
                    this.sleep(750L);
                    nextStep = 4;
                }
            }
            return nextStep;
        }

        protected void storeState(AlgorithmState state) {
            state.addSet("A", this.A);
            state.addSet("B", this.B);
            state.addSet("C", this.C);
            state.addMap("d", this.d);
            state.addMap("p", this.p);
            state.addInt("v_a", this.v_a);
        }

        protected void restoreState(AlgorithmState state) {
            this.A = state.getSet("A");
            this.B = state.getSet("B");
            this.C = state.getSet("C");
            this.d = state.getMap("d");
            this.p = state.getMap("p");
            this.v_a = state.getInt("v_a");
        }

        protected void createInitialState(AlgorithmState state) {
            this.A = state.addSet("A", new Set());
            this.B = state.addSet("B", new Set());
            this.C = state.addSet("C", new Set());
            this.d = state.addMap("d", new HashMap());
            this.p = state.addMap("p", new HashMap());
            this.v_a = state.addInt("v_a", 0);
        }

        protected void rollBackStep(int stepID, int nextStepID) {
            switch (stepID) {
                case 1: 
                case 5: 
                case 6: {
                    this.visualizeVertices();
                    this.visualizeSets();
                    break;
                }
                case 2: 
                case 3: {
                    DijkstraAlgorithmPlugin.this.execTableView.remove(DijkstraAlgorithmPlugin.this.execTableView.getLastItem());
                    break;
                }
                case 7: {
                    DijkstraAlgorithmPlugin.this.execTableView.remove(DijkstraAlgorithmPlugin.this.execTableView.getLastItem());
                    DijkstraAlgorithmPlugin.this.execTableView.remove(DijkstraAlgorithmPlugin.this.execTableView.getLastItem());
                    break;
                }
                case 8: {
                    DijkstraAlgorithmPlugin.this.execTableView.getLastItem().setCellDataByID(this.p);
                    DijkstraAlgorithmPlugin.this.execTableView.getItem(DijkstraAlgorithmPlugin.this.execTableView.getItemCount() - 2).setCellDataByID(this.d);
                    this.visualizeVertices();
                    this.visualizeSets();
                }
            }
        }

        protected void adoptState(int stepID, AlgorithmState state) {
        }

        protected View[] getViews() {
            return new View[]{DijkstraAlgorithmPlugin.this.graphView, DijkstraAlgorithmPlugin.this.execTableView, DijkstraAlgorithmPlugin.this.setsView};
        }

        private void visualizeSets() {
            DijkstraAlgorithmPlugin.this.setsView.setText("A=" + this.toCaptions(this.A) + "\nB=" + this.toCaptions(this.B) + "\nC=" + this.toCaptions(this.C));
        }

        private void visualizeVertices() {
            int v;
            if (this.A.isEmpty()) {
                DijkstraAlgorithmPlugin.this.graphView.resetVisualAppearance();
            }
            GraphView.VisualVertex vv = DijkstraAlgorithmPlugin.this.graphView.getVisualVertexByID(this.v_1.getID());
            vv.setBackground(DijkstraAlgorithmPlugin.this.colorSetA);
            vv.setEdgeWidth(DijkstraAlgorithmPlugin.this.lineWidthStartVertex);
            Iterator iterator = this.A.iterator();
            while (iterator.hasNext()) {
                v = (Integer)iterator.next();
                if (v == this.v_1.getID()) continue;
                vv = DijkstraAlgorithmPlugin.this.graphView.getVisualVertexByID(v);
                vv.setBackground(DijkstraAlgorithmPlugin.this.colorSetA);
                vv.setEdgeWidth(1);
            }
            iterator = this.B.iterator();
            while (iterator.hasNext()) {
                v = (Integer)iterator.next();
                vv = DijkstraAlgorithmPlugin.this.graphView.getVisualVertexByID(v);
                vv.setBackground(DijkstraAlgorithmPlugin.this.colorSetB);
                vv.setEdgeWidth(1);
            }
            iterator = this.C.iterator();
            while (iterator.hasNext()) {
                v = (Integer)iterator.next();
                vv = DijkstraAlgorithmPlugin.this.graphView.getVisualVertexByID(v);
                vv.setBackground(DijkstraAlgorithmPlugin.this.colorSetC);
                vv.setEdgeWidth(1);
            }
            vv = DijkstraAlgorithmPlugin.this.graphView.getVisualVertexByID(this.v_a);
            if (vv != null) {
                vv.setBackground(DijkstraAlgorithmPlugin.this.colorVertexMinDist);
                vv.setEdgeWidth(1);
            }
            DijkstraAlgorithmPlugin.this.graphView.repaint();
        }

        private Set<String> toCaptions(Set<Integer> set) {
            Graph graph = DijkstraAlgorithmPlugin.this.graphView.getGraph();
            Set res = new Set(set.size());
            for (Integer id : set) {
                res.add((Object)graph.getVertexByID(id.intValue()).getCaption());
            }
            return res;
        }
    }
}

