/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.SortOrder;
import javax.swing.filechooser.FileNameExtensionFilter;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.BipartiteLayoutToolBarExtension;
import lavesdk.algorithm.plugin.extensions.CircleLayoutToolBarExtension;
import lavesdk.algorithm.plugin.extensions.CompleteBipartiteGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.CompleteGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.MatrixToGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.AlgorithmTextView;
import lavesdk.algorithm.plugin.views.DefaultGraphView;
import lavesdk.algorithm.plugin.views.ExecutionTableView;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.LegendView;
import lavesdk.algorithm.plugin.views.MatrixView;
import lavesdk.algorithm.plugin.views.TextAreaView;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.algorithm.text.Annotation;
import lavesdk.configuration.Configuration;
import lavesdk.gui.dialogs.SolveExerciseDialog;
import lavesdk.gui.dialogs.SolveExercisePane;
import lavesdk.gui.dialogs.enums.AllowedGraphType;
import lavesdk.gui.widgets.ColorProperty;
import lavesdk.gui.widgets.ExecutionTableColumn;
import lavesdk.gui.widgets.ExecutionTableItem;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.gui.widgets.ListProperty;
import lavesdk.gui.widgets.MatrixEditor;
import lavesdk.gui.widgets.MatrixElementFormat;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;
import lavesdk.language.LanguageFile;
import lavesdk.math.Matrix;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.SimpleGraph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.matching.Matching;
import lavesdk.math.graph.matching.MatchingByID;
import lavesdk.serialization.Serializer;
import lavesdk.utils.GraphUtils;

public class GreedyAlgorithmPlugin
implements AlgorithmPlugin {
    private PluginHost host;
    private Configuration config;
    private LanguageFile langFile;
    private String langID;
    private FileNameExtensionFilter vgfFileFilter;
    private FileNameExtensionFilter pngFileFilter;
    private AlgorithmText algoText;
    private DefaultGraphView graphView;
    private AlgorithmTextView algoTextView;
    private ExecutionTableView listView;
    private MatrixView<Float> adjacencyMatrixView;
    private TextAreaView matchingView;
    private LegendView legendView;
    private GreedyRTE rte;
    private CompleteGraphToolBarExtension<Vertex, Edge> completeExt;
    private CircleLayoutToolBarExtension<Vertex, Edge> circleLayoutExt;
    private CompleteBipartiteGraphToolBarExtension<Vertex, Edge> completeBipartiteExt;
    private BipartiteLayoutToolBarExtension<Vertex, Edge> bipartiteLayoutExt;
    private MatrixToGraphToolBarExtension<Vertex, Edge> matrixToGraph;
    private String creatorPrefsDispMode;
    private String dispModeWithoutAM;
    private String dispModeWithAM;
    private String creatorPrefsDispModeValue;
    private boolean adjacencyMatrixEnabled;
    private ViewGroup ab;
    private ViewGroup cd;
    private ViewGroup ef;
    private ViewGroup abcdef;
    private Color colorModified;
    private Color colorMatchedEdges;
    private Color colorCurrEdge;
    private Color colorEdgeToRemove;
    private int lineWidthMatchedEdges;
    private int lineWidthCurrEdge;
    private int lineWidthEdgeToRemove;
    private static final String CFGKEY_CREATORPROP_DISPMODE = "creatorPrefsDispModeValue";
    private static final String CFGKEY_COLOR_MODIFIED = "colorModified";
    private static final String CFGKEY_COLOR_MATCHEDEDGES = "colorMatchedEdges";
    private static final String CFGKEY_COLOR_CURREDGE = "colorCurrEdge";
    private static final String CFGKEY_COLOR_EDGETOREMOVE = "colorEdgeToRemove";
    private static final String CFGKEY_LINEWIDTH_MATCHEDEDGES = "lineWidthMatchedEdges";
    private static final String CFGKEY_LINEWIDTH_CURREDGE = "lineWidthCurrEdge";
    private static final String CFGKEY_LINEWIDTH_EDGETOREMOVE = "lineWidthEdgeToRemove";

    public void initialize(PluginHost host, ResourceLoader resLoader, Configuration config) {
        try {
            this.langFile = new LanguageFile(resLoader.getResourceAsStream("main/resources/langGreedy.txt"));
            this.langFile.include(host.getLanguageFile());
        }
        catch (IOException e) {
            this.langFile = null;
        }
        this.langID = host.getLanguageID();
        this.host = host;
        this.config = config != null ? config : new Configuration();
        this.vgfFileFilter = new FileNameExtensionFilter("Visual Graph File (*.vgf)", "vgf");
        this.pngFileFilter = new FileNameExtensionFilter("Portable Network Graphic (*.png)", "png");
        this.graphView = new DefaultGraphView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_GRAPH_TITLE", (String)this.langID, (String)"Graph"), (Graph)new SimpleGraph(false), null, true, this.langFile, this.langID);
        this.listView = new ExecutionTableView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LIST_TITLE", (String)this.langID, (String)"List L"), true, this.langFile, this.langID);
        this.adjacencyMatrixView = new MatrixView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ADJACENCYMATRIX_TITLE", (String)this.langID, (String)"Adjacency Matrix"), (MatrixElementFormat)new MatrixEditor.FloatElementFormat(), true, this.langFile, this.langID);
        this.matchingView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_MATCHING_TITLE", (String)this.langID, (String)"Matching M"), true, this.langFile, this.langID);
        this.algoText = this.loadAlgorithmText();
        this.algoTextView = new AlgorithmTextView(host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ALGOTEXT_TITLE", (String)this.langID, (String)"Algorithm"), this.algoText, true, this.langFile, this.langID);
        this.legendView = new LegendView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LEGEND_TITLE", (String)this.langID, (String)"Legend"), true, this.langFile, this.langID);
        this.rte = new GreedyRTE();
        this.completeExt = new CompleteGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.UNDIRECTED_ONLY, this.langFile, this.langID, true);
        this.circleLayoutExt = new CircleLayoutToolBarExtension((GraphView)this.graphView, this.langFile, this.langID, false);
        this.completeBipartiteExt = new CompleteBipartiteGraphToolBarExtension(host, (GraphView)this.graphView, this.langFile, this.langID, true);
        this.bipartiteLayoutExt = new BipartiteLayoutToolBarExtension((GraphView)this.graphView, true, this.langFile, this.langID, false);
        this.matrixToGraph = new MatrixToGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.UNDIRECTED_ONLY, this.langFile, this.langID, true);
        this.creatorPrefsDispMode = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_DISPLAYMODE", (String)this.langID, (String)"Display Mode");
        this.dispModeWithoutAM = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_DISPLAYMODE_WOAM", (String)this.langID, (String)"Without Adjacency Matrix");
        this.dispModeWithAM = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_DISPLAYMODE_WAM", (String)this.langID, (String)"With Adjacency Matrix");
        this.adjacencyMatrixEnabled = false;
        this.algoTextView.setAutoRepaint(true);
        this.listView.setAutoRepaint(true);
        this.adjacencyMatrixView.setAutoRepaint(true);
        this.matchingView.setAutoRepaint(true);
        this.creatorPrefsDispModeValue = this.config.getString(CFGKEY_CREATORPROP_DISPMODE, this.dispModeWithoutAM);
        this.colorModified = this.config.getColor(CFGKEY_COLOR_MODIFIED, new Color(255, 180, 130));
        this.colorMatchedEdges = this.config.getColor(CFGKEY_COLOR_MATCHEDEDGES, Color.black);
        this.colorCurrEdge = this.config.getColor(CFGKEY_COLOR_CURREDGE, new Color(105, 140, 75));
        this.colorEdgeToRemove = this.config.getColor(CFGKEY_COLOR_EDGETOREMOVE, new Color(215, 75, 75));
        this.lineWidthMatchedEdges = this.config.getInt(CFGKEY_LINEWIDTH_MATCHEDEDGES, 3);
        this.lineWidthCurrEdge = this.config.getInt(CFGKEY_LINEWIDTH_CURREDGE, 2);
        this.lineWidthEdgeToRemove = this.config.getInt(CFGKEY_LINEWIDTH_EDGETOREMOVE, 2);
        this.graphView.loadConfiguration(config, "graphView");
        this.algoTextView.loadConfiguration(config, "algoTextView");
        this.listView.loadConfiguration(config, "listView");
        this.adjacencyMatrixView.loadConfiguration(config, "adjacencyMatrixView");
        this.matchingView.loadConfiguration(config, "matchingView");
        this.legendView.loadConfiguration(config, "legendView");
        this.createLegend();
    }

    public String getName() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_NAME", (String)this.langID, (String)"Greedy algorithm");
    }

    public String getDescription() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_DESC", (String)this.langID, (String)"Finds a perfect matching <i>M</i> with a low weight of the edges.");
    }

    public String getType() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_TYPE", (String)this.langID, (String)"Heuristic");
    }

    public String getAuthor() {
        return "Jan Dornseifer";
    }

    public String getAuthorContact() {
        return "jan.dornseifer@student.uni-siegen.de";
    }

    public String getAssumptions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_ASSUMPTIONS", (String)this.langID, (String)"A weighted complete graph K<sub>n</sub> with <i>n mod 2 = 0</i> (even number of vertices) or a weighted complete bipartite graph K<sub>n/2,n/2</sub>, n = |V|.");
    }

    public String getProblemAffiliation() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_PROBLEMAFFILIATION", (String)this.langID, (String)"Matching problem");
    }

    public String getSubject() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_SUBJECT", (String)this.langID, (String)"Logistics");
    }

    public String getInstructions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_INSTRUCTIONS", (String)this.langID, (String)"<b>Creating problem entities</b>:<br>Create your own graph and make sure that the graph complies with the assumptions of the algorithm. You can use<br>the toolbar extensions to check whether the created graph is complete or complete bipartite, to create a complete graph or a complete bipartite graph<br>by indicating the number of vertices, to create a graph by use of an adjacency matrix or you can arrange the vertices of your created graph<br>in a predefined layout.<br><br><b>Exercise Mode</b>:<br>Activate the exercise mode to practice the algorithm in an interactive way. After you have started the algorithm<br>exercises are presented that you have to solve.<br>If an exercise can be solved directly in a view of the algorithm the corresponding view is highlighted with a border, there you can<br>enter your solution and afterwards you have to press the button to solve the exercise. Otherwise (if an exercise is not related to a specific<br>view) you can directly press the button to solve the exercise which opens a dialog where you can enter your solution of the exercise.");
    }

    public String getVersion() {
        return "1.3";
    }

    public LAVESDKV getUsedSDKVersion() {
        return new LAVESDKV(1, 3);
    }

    public AlgorithmRTE getRuntimeEnvironment() {
        return this.rte;
    }

    public AlgorithmText getText() {
        return this.algoText.getBaseCopy();
    }

    public boolean hasExerciseMode() {
        return true;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean hasCreatorPreferences() {
        return true;
    }

    public void loadCreatorPreferences(PropertiesListModel plm) {
        plm.add((Property)new ListProperty(this.creatorPrefsDispMode, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_DISPLAYMODE_DESC", (String)this.langID, (String)"Choose the display mode of the algorithm"), this.creatorPrefsDispModeValue, new String[]{this.dispModeWithoutAM, this.dispModeWithAM}));
    }

    public void onCreate(ViewContainer container, PropertiesListModel creatorProperties) {
        this.creatorPrefsDispModeValue = creatorProperties != null ? creatorProperties.getListProperty(this.creatorPrefsDispMode).getValue() : this.dispModeWithoutAM;
        this.adjacencyMatrixEnabled = this.creatorPrefsDispModeValue.equals(this.dispModeWithAM);
        this.config.addString(CFGKEY_CREATORPROP_DISPMODE, this.creatorPrefsDispModeValue);
        this.graphView.setGraph((Graph)new SimpleGraph(false));
        this.graphView.repaint();
        this.ab = new ViewGroup(1);
        this.cd = new ViewGroup(1);
        this.ef = new ViewGroup(1);
        this.abcdef = new ViewGroup(0);
        this.ab.add((Component)this.algoTextView);
        this.ab.add((Component)this.legendView);
        this.ab.restoreWeights((Serializer)this.config, "weights_ab", new float[]{0.6f, 0.4f});
        this.cd.add((Component)this.graphView);
        if (this.adjacencyMatrixEnabled) {
            this.cd.add(this.adjacencyMatrixView);
            this.cd.restoreWeights((Serializer)this.config, "weights_cd", new float[]{0.7f, 0.3f});
        } else {
            this.cd.restoreWeights((Serializer)this.config, "weights_c", new float[]{1.0f});
        }
        this.ef.add((Component)this.listView);
        this.ef.add((Component)this.matchingView);
        this.ef.restoreWeights((Serializer)this.config, "weights_ef", new float[]{0.8f, 0.2f});
        this.abcdef.add((Component)this.ab);
        this.abcdef.add((Component)this.cd);
        this.abcdef.add((Component)this.ef);
        this.abcdef.restoreWeights((Serializer)this.config, "weights_abcdef", new float[]{0.4f, 0.4f, 0.2f});
        container.setLayout((LayoutManager)new BorderLayout());
        container.add((Component)this.abcdef, (Object)"Center");
    }

    public void onClose() {
        this.graphView.saveConfiguration(this.config, "graphView");
        this.algoTextView.saveConfiguration(this.config, "algoTextView");
        this.listView.saveConfiguration(this.config, "listView");
        this.adjacencyMatrixView.saveConfiguration(this.config, "adjacencyMatrixView");
        this.matchingView.saveConfiguration(this.config, "matchingView");
        this.legendView.saveConfiguration(this.config, "legendView");
        if (this.ab != null) {
            this.ab.storeWeights((Serializer)this.config, "weights_ab");
        }
        if (this.cd != null) {
            if (this.adjacencyMatrixEnabled) {
                this.cd.storeWeights((Serializer)this.config, "weights_cd");
            } else {
                this.cd.storeWeights((Serializer)this.config, "weights_c");
            }
        }
        if (this.ef != null) {
            this.ef.storeWeights((Serializer)this.config, "weights_ef");
        }
        if (this.abcdef != null) {
            this.abcdef.storeWeights((Serializer)this.config, "weights_abcdef");
        }
        this.graphView.reset();
        this.listView.reset();
        this.adjacencyMatrixView.reset();
        this.matchingView.reset();
    }

    public boolean hasCustomization() {
        return true;
    }

    public void loadCustomization(PropertiesListModel plm) {
        plm.add((Property)new ColorProperty("algoTextHighlightForeground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTFOREGROUND", (String)this.langID, (String)"Foreground color of the current step in the algorithm"), this.algoTextView.getHighlightForeground()));
        plm.add((Property)new ColorProperty("algoTextHighlightBackground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTBACKGROUND", (String)this.langID, (String)"Background color of the current step in the algorithm"), this.algoTextView.getHighlightBackground()));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MATCHEDEDGES, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MATCHEDEDGES", (String)this.langID, (String)"Color of the matching edges"), this.colorMatchedEdges));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_CURREDGE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_CURREDGE", (String)this.langID, (String)"Color of the current edge (v<sub>i</sub>, v<sub>j</sub>)"), this.colorCurrEdge));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_EDGETOREMOVE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_EDGETOREMOVE", (String)this.langID, (String)"Color of the edge that has to be removed from L"), this.colorEdgeToRemove));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MODIFIED, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MODIFICATIONS", (String)this.langID, (String)"Color of modifications to objects"), this.colorModified));
        NumericProperty lwMatchedEdges = new NumericProperty(CFGKEY_LINEWIDTH_MATCHEDEDGES, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIE_LINEWIDTH_MATCHEDEDGES", (String)this.langID, (String)"Line width of matching edges"), (Number)this.lineWidthMatchedEdges, true);
        lwMatchedEdges.setMinimum(1);
        lwMatchedEdges.setMaximum(5);
        plm.add((Property)lwMatchedEdges);
        NumericProperty lwCurrEdge = new NumericProperty(CFGKEY_LINEWIDTH_CURREDGE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIE_LINEWIDTH_CURREDGE", (String)this.langID, (String)"Line width of the current edge (v<sub>i</sub>, v<sub>j</sub>)"), (Number)this.lineWidthCurrEdge, true);
        lwCurrEdge.setMinimum(1);
        lwCurrEdge.setMaximum(5);
        plm.add((Property)lwCurrEdge);
        NumericProperty lwEdgeToRemove = new NumericProperty(CFGKEY_LINEWIDTH_EDGETOREMOVE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIE_LINEWIDTH_EDGETOREMOVE", (String)this.langID, (String)"Line width of the edge that has to be removed from L"), (Number)this.lineWidthEdgeToRemove, true);
        lwEdgeToRemove.setMinimum(1);
        lwEdgeToRemove.setMaximum(5);
        plm.add((Property)lwEdgeToRemove);
    }

    public void applyCustomization(PropertiesListModel plm) {
        this.algoTextView.setHighlightForeground(plm.getColorProperty("algoTextHighlightForeground").getValue());
        this.algoTextView.setHighlightBackground(plm.getColorProperty("algoTextHighlightBackground").getValue());
        this.colorMatchedEdges = this.config.addColor(CFGKEY_COLOR_MATCHEDEDGES, plm.getColorProperty(CFGKEY_COLOR_MATCHEDEDGES).getValue());
        this.colorCurrEdge = this.config.addColor(CFGKEY_COLOR_CURREDGE, plm.getColorProperty(CFGKEY_COLOR_CURREDGE).getValue());
        this.colorEdgeToRemove = this.config.addColor(CFGKEY_COLOR_EDGETOREMOVE, plm.getColorProperty(CFGKEY_COLOR_EDGETOREMOVE).getValue());
        this.colorModified = this.config.addColor(CFGKEY_COLOR_MODIFIED, plm.getColorProperty(CFGKEY_COLOR_MODIFIED).getValue());
        this.lineWidthMatchedEdges = this.config.addInt(CFGKEY_LINEWIDTH_MATCHEDEDGES, plm.getNumericProperty(CFGKEY_LINEWIDTH_MATCHEDEDGES).getValue().intValue());
        this.lineWidthCurrEdge = this.config.addInt(CFGKEY_LINEWIDTH_CURREDGE, plm.getNumericProperty(CFGKEY_LINEWIDTH_CURREDGE).getValue().intValue());
        this.lineWidthEdgeToRemove = this.config.addInt(CFGKEY_LINEWIDTH_EDGETOREMOVE, plm.getNumericProperty(CFGKEY_LINEWIDTH_EDGETOREMOVE).getValue().intValue());
        this.createLegend();
    }

    public ToolBarExtension[] getToolBarExtensions() {
        return new ToolBarExtension[]{this.completeExt, this.circleLayoutExt, this.completeBipartiteExt, this.bipartiteLayoutExt, this.matrixToGraph};
    }

    public void save(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.save(file);
            } else if (this.pngFileFilter.accept(file)) {
                this.graphView.saveAsPNG(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE", (String)this.langID, (String)"File could not be saved!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE_TITLE", (String)this.langID, (String)"Save File"), MessageIcon.ERROR);
        }
    }

    public void open(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.load(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE", (String)this.langID, (String)"File could not be opened!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE_TITLE", (String)this.langID, (String)"Open File"), MessageIcon.ERROR);
        }
    }

    public FileNameExtensionFilter[] getSaveFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter, this.pngFileFilter};
    }

    public FileNameExtensionFilter[] getOpenFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter};
    }

    public void beforeStart(RTEvent e) {
        if (!this.areAssumptionsFulfilled()) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_GRAPHNOTPERMISSIBLE", (String)this.langID, (String)"The created graph is not permissible!\nThe graph has to fulfill the assumptions (see information bar)."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_GRAPHNOTPERMISSIBLE_TITLE", (String)this.langID, (String)"Impermissible graph"), MessageIcon.INFO);
            e.doit = false;
        }
        if (e.doit) {
            this.graphView.setEditable(false);
            this.graphView.deselectAll();
            this.listView.reset();
            this.listView.add(new ExecutionTableColumn(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LIST_COLUMNEDGE", (String)this.langID, (String)"Edge")));
            this.listView.add(new ExecutionTableColumn(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LIST_COLUMNWEIGHT", (String)this.langID, (String)"Weight")));
            this.matchingView.reset();
            this.adjacencyMatrixView.reset();
            this.rte.initAMDisplay();
        }
    }

    public void beforeResume(RTEvent e) {
    }

    public void beforePause(RTEvent e) {
    }

    public void onStop() {
        this.graphView.setEditable(true);
    }

    public void onRunning() {
    }

    public void onPause() {
    }

    private AlgorithmText loadAlgorithmText() {
        AlgorithmText text = new AlgorithmText();
        AlgorithmParagraph initParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_INITIALIZATION", (String)this.langID, (String)"1. Initialization:"), 1);
        AlgorithmParagraph expParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_MATCHINGEXPANSION", (String)this.langID, (String)"2. Matching expansion:"), 2);
        AlgorithmParagraph updateParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_UPDATEL", (String)this.langID, (String)"3. Update L:"), 3);
        AlgorithmParagraph stopParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_STOPCRITERION", (String)this.langID, (String)"4. Stop criterion:"), 4);
        AlgorithmStep step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP1_INIT", (String)this.langID, (String)"Let _latex{$M := \\emptyset$}.\nLet _latex{$L := E$} be the list of all edges of the graph.\n"), 1);
        step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP2_SORT", (String)this.langID, (String)"Sort _latex{$L$} non-decreasingly by the weight of the edges.\n\n"), 2);
        step.setExercise(new AlgorithmExercise<List<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP2", (String)this.langID, (String)"Sort <i>L</i> (<i>use the arrows in the list to change the positions of the edges</i>)."), 2.0f, (View)this.listView){

            protected void beforeRequestSolution(AlgorithmState state) {
                GreedyAlgorithmPlugin.this.listView.setSortable(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                GreedyAlgorithmPlugin.this.listView.setSortable(false);
            }

            protected List<?>[] requestSolution() {
                ArrayList<Integer> l = new ArrayList<Integer>();
                int i = 0;
                while (i < GreedyAlgorithmPlugin.this.listView.getItemCount()) {
                    l.add(GreedyAlgorithmPlugin.this.listView.getItem(i).getID());
                    ++i;
                }
                return new List[]{l};
            }

            protected String getResultAsString(List<?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                List<?> L = result;
                return "L=" + GreedyAlgorithmPlugin.this.getEdgeListAsString(L);
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, List<?>[] solutions) {
                List<?> L = solutions[0];
                state.addList("L", L);
            }

            protected boolean examine(List<?>[] results, AlgorithmState state) {
                List<?> L = results[0];
                Graph graph = GreedyAlgorithmPlugin.this.graphView.getGraph();
                float lastWeight = Float.MIN_VALUE;
                int i = 0;
                while (i < L.size()) {
                    Edge e = graph.getEdgeByID(((Integer)L.get(i)).intValue());
                    if (e.getWeight() < lastWeight) {
                        return false;
                    }
                    lastWeight = e.getWeight();
                    ++i;
                }
                return true;
            }
        });
        step = new AlgorithmStep(expParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP3_EXPANSION1", (String)this.langID, (String)"Let _latex{$(v_i,v_j)$} be the first edge in _latex{$L$}. "), 3);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Integer>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP3", (String)this.langID, (String)"Select the edge (v<sub>i</sub>, v<sub>j</sub>) in the graph."), 1.0f, (View)this.graphView){

            protected void beforeRequestSolution(AlgorithmState state) {
                GreedyAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.EDGES_ONLY);
                GreedyAlgorithmPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                GreedyAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.BOTH);
                GreedyAlgorithmPlugin.this.graphView.setShowCursorToolAlways(false);
                GreedyAlgorithmPlugin.this.graphView.deselectAll();
            }

            protected Integer[] requestSolution() {
                if (GreedyAlgorithmPlugin.this.graphView.getSelectedEdgeCount() != 1) {
                    return null;
                }
                return new Integer[]{GreedyAlgorithmPlugin.this.graphView.getSelectedEdge(0).getEdge().getID()};
            }

            protected String getResultAsString(Integer result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                Edge e = GreedyAlgorithmPlugin.this.graphView.getVisualEdgeByID(result.intValue()).getEdge();
                return "(" + e.getPredecessor() + ", " + e.getSuccessor() + ")";
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, Integer[] solutions) {
                state.addInt("firstEdge", solutions[0].intValue());
            }

            protected boolean examine(Integer[] results, AlgorithmState state) {
                List L = state.getList("L");
                return L.size() > 0 ? ((Integer)L.get(0)).equals(results[0]) : false;
            }
        });
        step = new AlgorithmStep(expParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP4_EXPANSION2", (String)this.langID, (String)"Add _latex{$(v_i,v_j)$} to the matching _latex{$M$}.\n\n"), 4);
        step.setExercise(new AlgorithmExercise<Matching<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP4", (String)this.langID, (String)"What is <i>M</i> after this step (<i>select all matched edges in the graph</i>)?"), 1.0f, (View)this.graphView){

            public boolean hasInputHint() {
                return true;
            }

            public Annotation getInputHintMessage(LanguageFile langFile, String langID) {
                return new Annotation(LanguageFile.getLabel((LanguageFile)GreedyAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP4_INPUTHINT", (String)langID, (String)"<b>Select matched edges</b>:<br>Select the matched edges in the graph by using the mouse and pressing the <b>Ctrl</b>-key on your keyboard.<br>Afterwards click on the \"Solve Exercise\"-button of the task."));
            }

            protected void beforeRequestSolution(AlgorithmState state) {
                GreedyAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.EDGES_ONLY);
                GreedyAlgorithmPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                GreedyAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.BOTH);
                GreedyAlgorithmPlugin.this.graphView.setShowCursorToolAlways(false);
                GreedyAlgorithmPlugin.this.graphView.deselectAll();
            }

            protected Matching<?>[] requestSolution() {
                if (GreedyAlgorithmPlugin.this.graphView.getSelectedEdgeCount() == 0) {
                    return null;
                }
                Matching m = new Matching(GreedyAlgorithmPlugin.this.graphView.getGraph());
                try {
                    int i = 0;
                    while (i < GreedyAlgorithmPlugin.this.graphView.getSelectedEdgeCount()) {
                        m.add(GreedyAlgorithmPlugin.this.graphView.getSelectedEdge(i).getEdge());
                        ++i;
                    }
                }
                catch (IllegalArgumentException e) {
                    m = null;
                }
                if (m != null) {
                    return new Matching[]{m};
                }
                return new Matching[0];
            }

            protected String getResultAsString(Matching<?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                return "M=" + super.getResultAsString(result, index);
            }

            protected boolean examine(Matching<?>[] results, AlgorithmState state) {
                MatchingByID m = state.getMatching("M", GreedyAlgorithmPlugin.this.graphView.getGraph());
                return results[0].cast().equals((Collection)m);
            }
        });
        step = new AlgorithmStep(updateParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5_UPDATEL", (String)this.langID, (String)"Delete all edges from _latex{$L$} which have _latex{$v_i$} or _latex{$v_j$} as endpoint.\n\n"), 5);
        step.setExercise(new AlgorithmExercise<List<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP5", (String)this.langID, (String)"Which edges will be removed from <i>L</i>?"), 2.0f){
            private final String remove;
            private List<Integer> L;
            {
                this.remove = LanguageFile.getLabel((LanguageFile)GreedyAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP5_REMOVE", (String)GreedyAlgorithmPlugin.this.langID, (String)"remove?");
            }

            protected void beforeRequestSolution(AlgorithmState state) {
                this.L = state.getList("L");
            }

            protected List<?>[] requestSolution() {
                Graph graph = GreedyAlgorithmPlugin.this.graphView.getGraph();
                SolveExerciseDialog.SolutionEntry[] entries = new SolveExerciseDialog.SolutionEntry[this.L.size()];
                int i = 0;
                while (i < this.L.size()) {
                    Edge e = graph.getEdgeByID(this.L.get(i).intValue());
                    entries[i] = new SolveExerciseDialog.SolutionEntry("(" + e.getPredecessor() + ", " + e.getSuccessor() + ")", (Component)new JCheckBox(this.remove));
                    ++i;
                }
                if (!SolveExercisePane.showDialog((PluginHost)GreedyAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])entries, (LanguageFile)GreedyAlgorithmPlugin.this.langFile, (String)GreedyAlgorithmPlugin.this.langID)) {
                    return null;
                }
                i = this.L.size() - 1;
                while (i >= 0) {
                    SolveExerciseDialog.SolutionEntry entry = entries[i];
                    if (((JCheckBox)entry.getComponent()).isSelected()) {
                        this.L.remove(i);
                    }
                    --i;
                }
                return new List[]{this.L};
            }

            protected String getResultAsString(List<?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                List<?> L = result;
                return "L=" + GreedyAlgorithmPlugin.this.getEdgeListAsString(L);
            }

            protected boolean examine(List<?>[] results, AlgorithmState state) {
                return this.doAutoExamine(state, new String[]{"L"}, results);
            }
        });
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP6_STOP", (String)this.langID, (String)"If _latex{$L = \\emptyset$} then stop. Otherwise go to step 2."), 6);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Boolean>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP6", (String)this.langID, (String)"Will the algorithm stop?"), 1.0f){
            private final String labelYes;
            private final String labelNo;
            {
                this.labelYes = LanguageFile.getLabel((LanguageFile)GreedyAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP6_YES", (String)GreedyAlgorithmPlugin.this.langID, (String)"Yes");
                this.labelNo = LanguageFile.getLabel((LanguageFile)GreedyAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP6_NO", (String)GreedyAlgorithmPlugin.this.langID, (String)"No");
            }

            protected Boolean[] requestSolution() {
                ButtonGroup group = new ButtonGroup();
                JRadioButton rdobtn1 = new JRadioButton(this.labelYes);
                JRadioButton rdobtn2 = new JRadioButton(this.labelNo);
                group.add(rdobtn1);
                group.add(rdobtn2);
                SolveExerciseDialog.SolutionEntry entryYes = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn1);
                SolveExerciseDialog.SolutionEntry entryNo = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn2);
                if (!SolveExercisePane.showDialog((PluginHost)GreedyAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryYes, entryNo}, (LanguageFile)GreedyAlgorithmPlugin.this.langFile, (String)GreedyAlgorithmPlugin.this.langID)) {
                    return null;
                }
                return new Boolean[]{!rdobtn1.isSelected() && !rdobtn2.isSelected() ? null : Boolean.valueOf(rdobtn1.isSelected())};
            }

            protected String getResultAsString(Boolean result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return result == Boolean.TRUE ? this.labelYes : this.labelNo;
            }

            protected boolean examine(Boolean[] results, AlgorithmState state) {
                List L = state.getList("L");
                return results[0] != null && results[0].booleanValue() == L.isEmpty();
            }
        });
        return text;
    }

    private void createLegend() {
        String amvAddition = " (" + LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_ADJACENCYMATRIX_OPTIONAL", (String)this.langID, (String)"optional") + ")";
        this.legendView.removeAll();
        this.legendView.add(new LegendItem("item1", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_MATCHEDEDGES", (String)this.langID, (String)"The matched edges of matching M"), LegendItem.createLineIcon((Color)this.colorMatchedEdges, (int)this.lineWidthMatchedEdges, (int)4)));
        this.legendView.add(new LegendItem("item2", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CURREDGE", (String)this.langID, (String)"The current edge (v<sub>i</sub>, v<sub>j</sub>)"), LegendItem.createLineIcon((Color)this.colorCurrEdge, (int)this.lineWidthCurrEdge, (int)4)));
        this.legendView.add(new LegendItem("item3", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_V_I_V_J", (String)this.langID, (String)"The vertices v<sub>i</sub> and v<sub>j</sub> of the current matched edge"), LegendItem.createCircleIcon((Color)Color.white, (Color)this.colorCurrEdge, (int)1)));
        this.legendView.add(new LegendItem("item4", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_REMOVABLEEDGE", (String)this.langID, (String)"Edge that shares an endpoint with the current edge (v<sub>i</sub>, v<sub>j</sub>) and has to be removed from L"), LegendItem.createLineIcon((Color)this.colorEdgeToRemove, (int)2, (int)4)));
        this.legendView.add(new LegendItem("item5", this.matchingView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_MATCHING_MODIFICATION", (String)this.langID, (String)"The matching M becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
        this.legendView.add(new LegendItem("item6", this.listView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_LIST_CURREDGE", (String)this.langID, (String)"The current edge (v<sub>i</sub>, v<sub>j</sub>)"), LegendItem.createRectangleIcon((Color)this.colorCurrEdge, (Color)this.colorCurrEdge, (int)0)));
        this.legendView.add(new LegendItem("item7", this.listView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_LIST_REMOVABLEEDGE", (String)this.langID, (String)"Edge that shares an endpoint with the current edge (v<sub>i</sub>, v<sub>j</sub>) and has to be removed from L"), LegendItem.createRectangleIcon((Color)this.colorEdgeToRemove, (Color)this.colorEdgeToRemove, (int)0)));
        this.legendView.add(new LegendItem("item8", String.valueOf(this.adjacencyMatrixView.getTitle()) + amvAddition, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_ADJACENCYMATRIX_CURREDGE", (String)this.langID, (String)"The current edge (v<sub>i</sub>, v<sub>j</sub>)"), LegendItem.createRectangleIcon((Color)this.colorCurrEdge, (Color)this.colorCurrEdge, (int)0)));
        this.legendView.add(new LegendItem("item9", String.valueOf(this.adjacencyMatrixView.getTitle()) + amvAddition, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_ADJACENCYMATRIX_STRIKEOUT", (String)this.langID, (String)"Striked off vertices its edge was added to the matching M"), LegendItem.createLineIcon((Color)Color.black, (int)1)));
    }

    private boolean areAssumptionsFulfilled() {
        Graph graph = this.graphView.getGraph();
        List subsets = GraphUtils.getBipartiteVertexSets((Graph)graph);
        if (graph.getOrder() % 2 != 0) {
            return false;
        }
        return GraphUtils.isComplete((Graph)graph) || GraphUtils.isCompleteBipartite((Graph)graph) && ((List)subsets.get(0)).size() == graph.getOrder() / 2 && ((List)subsets.get(0)).size() == ((List)subsets.get(1)).size();
    }

    private String getEdgeListAsString(List<Integer> l) {
        Graph graph = this.graphView.getGraph();
        StringBuilder s = new StringBuilder();
        boolean delimiter = false;
        s.append("[");
        int i = 0;
        while (i < l.size()) {
            Edge e = graph.getEdgeByID(l.get(i).intValue());
            if (delimiter) {
                s.append(",");
            }
            s.append("(" + e.getPredecessor() + ", " + e.getSuccessor() + ")");
            delimiter = true;
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    private class GreedyRTE
    extends AlgorithmRTE {
        private List<Integer> L;
        private Matching<Edge> M;
        private int firstEdge;
        private List<Integer> userSortL;
        private int userChoiceFirstEdge;
        private List<Color> strikeoutColors;
        private int nextStrikeoutColorIndex;

        public GreedyRTE() {
            super((AlgorithmPlugin)GreedyAlgorithmPlugin.this, GreedyAlgorithmPlugin.this.algoText);
            this.userSortL = null;
            this.userChoiceFirstEdge = 0;
            this.strikeoutColors = new ArrayList<Color>(15);
            this.strikeoutColors.add(Color.black);
            this.strikeoutColors.add(Color.red);
            this.strikeoutColors.add(Color.blue);
            this.strikeoutColors.add(Color.green);
            this.strikeoutColors.add(Color.gray);
            this.strikeoutColors.add(Color.yellow);
            this.strikeoutColors.add(Color.magenta);
            this.strikeoutColors.add(Color.lightGray);
            this.strikeoutColors.add(Color.cyan);
            this.strikeoutColors.add(Color.orange);
        }

        public void initAMDisplay() {
            if (!GreedyAlgorithmPlugin.this.adjacencyMatrixEnabled) {
                return;
            }
            Graph graph = GreedyAlgorithmPlugin.this.graphView.getGraph();
            HashMap<Integer, String> labels = new HashMap<Integer, String>();
            int i = 0;
            while (i < graph.getOrder()) {
                labels.put(i, graph.getVertex(i).getCaption());
                ++i;
            }
            GreedyAlgorithmPlugin.this.adjacencyMatrixView.setMatrix((Matrix)GraphUtils.createAdjacencyMatrix((Graph)graph, (boolean)true));
            GreedyAlgorithmPlugin.this.adjacencyMatrixView.setColumnLabels(labels);
            GreedyAlgorithmPlugin.this.adjacencyMatrixView.setRowLabels(labels);
            GreedyAlgorithmPlugin.this.adjacencyMatrixView.setPaintLabels(true);
            this.nextStrikeoutColorIndex = 0;
        }

        protected int executeStep(int stepID, AlgorithmStateAttachment asa) throws Exception {
            Graph graph = GreedyAlgorithmPlugin.this.graphView.getGraph();
            int nextStep = -1;
            switch (stepID) {
                case 1: {
                    this.M = new Matching(graph);
                    this.sleep(250L);
                    GreedyAlgorithmPlugin.this.matchingView.setBackground(GreedyAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeMatchingAsText();
                    this.visualizeMatching();
                    this.sleep(250L);
                    GreedyAlgorithmPlugin.this.matchingView.setBackground(Color.white);
                    this.sleep(250L);
                    this.L.clear();
                    for (Edge edge : graph.getEdgeSet()) {
                        this.L.add(edge.getID());
                        GreedyAlgorithmPlugin.this.listView.add(new ExecutionTableItem(new Object[]{"(" + edge.getPredecessor() + ", " + edge.getSuccessor() + ")", Float.valueOf(edge.getWeight())}, edge.getID()));
                        this.sleep(250L);
                    }
                    nextStep = 2;
                    break;
                }
                case 2: {
                    this.sleep(1000L);
                    if (this.userSortL != null) {
                        this.L = this.userSortL;
                    } else {
                        GreedyAlgorithmPlugin.this.listView.sortItems(1, SortOrder.ASCENDING);
                        this.L.clear();
                        int i = 0;
                        while (i < GreedyAlgorithmPlugin.this.listView.getItemCount()) {
                            this.L.add(GreedyAlgorithmPlugin.this.listView.getItem(i).getID());
                            ++i;
                        }
                        this.sleep(1500L);
                    }
                    this.userSortL = null;
                    nextStep = 3;
                    break;
                }
                case 3: {
                    int n = this.firstEdge = this.L.size() > 0 ? this.L.get(0) : 0;
                    if (this.userChoiceFirstEdge > 0) {
                        this.firstEdge = this.userChoiceFirstEdge;
                    }
                    this.userChoiceFirstEdge = 0;
                    if (this.firstEdge < 1) {
                        nextStep = -1;
                        break;
                    }
                    GraphView.VisualEdge ve = GreedyAlgorithmPlugin.this.graphView.getVisualEdgeByID(this.firstEdge);
                    ExecutionTableItem item = GreedyAlgorithmPlugin.this.listView.getVisibleRow(0);
                    this.sleep(500L);
                    item.setBackground(GreedyAlgorithmPlugin.this.colorCurrEdge);
                    ve.setColor(GreedyAlgorithmPlugin.this.colorCurrEdge);
                    ve.setLineWidth(GreedyAlgorithmPlugin.this.lineWidthCurrEdge);
                    GreedyAlgorithmPlugin.this.graphView.repaint();
                    this.sleep(750L);
                    item.setBackground(Color.white);
                    nextStep = 4;
                    break;
                }
                case 4: {
                    Edge e = graph.getEdgeByID(this.firstEdge);
                    this.M.add(e);
                    this.sleep(250L);
                    this.visualizeMatching();
                    this.sleep(250L);
                    GreedyAlgorithmPlugin.this.matchingView.setBackground(GreedyAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeMatchingAsText();
                    this.sleep(250L);
                    GreedyAlgorithmPlugin.this.matchingView.setBackground(Color.white);
                    this.sleep(500L);
                    nextStep = 5;
                    break;
                }
                case 5: {
                    Edge e = graph.getEdgeByID(this.firstEdge);
                    GraphView.VisualEdge ve = GreedyAlgorithmPlugin.this.graphView.getVisualEdgeByID(this.firstEdge);
                    GraphView.VisualVertex vv_i = ve.getPredecessor();
                    GraphView.VisualVertex vv_j = ve.getSuccessor();
                    ve.setColor(GreedyAlgorithmPlugin.this.colorCurrEdge);
                    ve.setLineWidth(GreedyAlgorithmPlugin.this.lineWidthCurrEdge);
                    vv_i.setForeground(GreedyAlgorithmPlugin.this.colorCurrEdge);
                    vv_j.setForeground(GreedyAlgorithmPlugin.this.colorCurrEdge);
                    GreedyAlgorithmPlugin.this.graphView.repaint();
                    this.sleep(500L);
                    int i = 0;
                    while (i < this.L.size()) {
                        Edge edge = graph.getEdgeByID(this.L.get(i).intValue());
                        if (edge == e || edge.getPredecessor() == e.getPredecessor() || edge.getSuccessor() == e.getSuccessor() || edge.getPredecessor() == e.getSuccessor() || edge.getSuccessor() == e.getPredecessor()) {
                            this.L.remove(i);
                            --i;
                            GraphView.VisualEdge vedge = GreedyAlgorithmPlugin.this.graphView.getVisualEdge(edge);
                            ExecutionTableItem item = GreedyAlgorithmPlugin.this.listView.getVisibleRowByID(edge.getID());
                            vedge.setColor(GreedyAlgorithmPlugin.this.colorEdgeToRemove);
                            vedge.setLineWidth(GreedyAlgorithmPlugin.this.lineWidthEdgeToRemove);
                            GreedyAlgorithmPlugin.this.graphView.repaint();
                            this.sleep(500L);
                            item.setBackground(GreedyAlgorithmPlugin.this.colorEdgeToRemove);
                            this.sleep(750L);
                            item.setVisible(false);
                            item.setBackground(Color.white);
                            vedge.setColor(edge == e ? GreedyAlgorithmPlugin.this.colorCurrEdge : GraphView.DEF_EDGECOLOR);
                            vedge.setLineWidth(edge == e ? GreedyAlgorithmPlugin.this.lineWidthCurrEdge : 1);
                            GreedyAlgorithmPlugin.this.graphView.repaint();
                            this.sleep(500L);
                        }
                        ++i;
                    }
                    if (GreedyAlgorithmPlugin.this.adjacencyMatrixEnabled) {
                        i = Math.min(ve.getEdge().getPredecessor().getIndex(), ve.getEdge().getSuccessor().getIndex());
                        int j = Math.max(ve.getEdge().getPredecessor().getIndex(), ve.getEdge().getSuccessor().getIndex());
                        Color c = this.getNextStrikeoutColor();
                        MatrixEditor.Strikeout s1 = new MatrixEditor.Strikeout(i, c, 2);
                        MatrixEditor.Strikeout s2 = new MatrixEditor.Strikeout(j, c, 2);
                        GreedyAlgorithmPlugin.this.adjacencyMatrixView.setElementBackground(i, j, GreedyAlgorithmPlugin.this.colorCurrEdge);
                        this.sleep(750L);
                        GreedyAlgorithmPlugin.this.adjacencyMatrixView.addRowStrikeout(s1);
                        GreedyAlgorithmPlugin.this.adjacencyMatrixView.addRowStrikeout(s2);
                        GreedyAlgorithmPlugin.this.adjacencyMatrixView.addColumnStrikeout(s1);
                        GreedyAlgorithmPlugin.this.adjacencyMatrixView.addColumnStrikeout(s2);
                        this.sleep(750L);
                        GreedyAlgorithmPlugin.this.adjacencyMatrixView.setElementBackground(i, j, Color.white);
                    }
                    vv_i.setForeground(GraphView.DEF_VERTEXFOREGROUND);
                    vv_j.setForeground(GraphView.DEF_VERTEXFOREGROUND);
                    this.visualizeMatching();
                    nextStep = 6;
                    break;
                }
                case 6: {
                    this.sleep(1000L);
                    nextStep = this.L.isEmpty() ? -1 : 3;
                }
            }
            return nextStep;
        }

        protected void storeState(AlgorithmState state) {
            state.addList("L", this.L);
            state.addMatching("M", this.M != null ? this.M.cast() : null);
            state.addInt("firstEdge", this.firstEdge);
        }

        protected void restoreState(AlgorithmState state) {
            this.L = state.getList("L");
            MatchingByID m = state.getMatching("M", GreedyAlgorithmPlugin.this.graphView.getGraph());
            this.M = m != null ? m.cast() : null;
            this.firstEdge = state.getInt("firstEdge");
        }

        protected void createInitialState(AlgorithmState state) {
            this.L = state.addList("L", new ArrayList());
            state.addMatching("M", null);
            this.firstEdge = state.addInt("firstEdge", 0);
        }

        protected void rollBackStep(int stepID, int nextStepID) {
            this.visualizeMatching();
            this.visualizeMatchingAsText();
            switch (stepID) {
                case 1: {
                    GreedyAlgorithmPlugin.this.listView.removeAllItems();
                    break;
                }
                case 2: {
                    GreedyAlgorithmPlugin.this.listView.sortItems(1, SortOrder.UNSORTED);
                    break;
                }
                case 5: {
                    int i = 0;
                    while (i < GreedyAlgorithmPlugin.this.listView.getItemCount()) {
                        ExecutionTableItem item = GreedyAlgorithmPlugin.this.listView.getItem(i);
                        item.setVisible(this.L.contains(item.getID()));
                        ++i;
                    }
                    if (!GreedyAlgorithmPlugin.this.adjacencyMatrixEnabled) break;
                    GreedyAlgorithmPlugin.this.adjacencyMatrixView.removeLastColumnStrikeout();
                    GreedyAlgorithmPlugin.this.adjacencyMatrixView.removeLastColumnStrikeout();
                    GreedyAlgorithmPlugin.this.adjacencyMatrixView.removeLastRowStrikeout();
                    GreedyAlgorithmPlugin.this.adjacencyMatrixView.removeLastRowStrikeout();
                }
            }
        }

        protected void adoptState(int stepID, AlgorithmState state) {
            if (stepID == 2) {
                this.userSortL = state.getList("L");
            } else if (stepID == 3) {
                this.userChoiceFirstEdge = state.getInt("firstEdge");
            }
        }

        protected View[] getViews() {
            return new View[]{GreedyAlgorithmPlugin.this.graphView, GreedyAlgorithmPlugin.this.adjacencyMatrixView, GreedyAlgorithmPlugin.this.listView, GreedyAlgorithmPlugin.this.matchingView};
        }

        private void visualizeMatching() {
            if (this.M == null) {
                return;
            }
            int i = 0;
            while (i < GreedyAlgorithmPlugin.this.graphView.getVisualEdgeCount()) {
                GraphView.VisualEdge ve = GreedyAlgorithmPlugin.this.graphView.getVisualEdge(i);
                if (this.M.contains((Object)ve.getEdge())) {
                    ve.setColor(GreedyAlgorithmPlugin.this.colorMatchedEdges);
                    ve.setLineWidth(GreedyAlgorithmPlugin.this.lineWidthMatchedEdges);
                } else {
                    ve.setColor(GraphView.DEF_EDGECOLOR);
                    ve.setLineWidth(1);
                }
                ++i;
            }
            GreedyAlgorithmPlugin.this.graphView.repaint();
        }

        private void visualizeMatchingAsText() {
            GreedyAlgorithmPlugin.this.matchingView.setText(this.M != null ? "M=" + this.M.toString() : "");
        }

        private Color getNextStrikeoutColor() {
            return this.strikeoutColors.get(this.nextStrikeoutColorIndex++ % this.strikeoutColors.size());
        }
    }
}

