/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import lavesdk.algorithm.plugin.views.renderers.DefaultVertexRenderer;
import lavesdk.math.graph.Vertex;
import lavesdk.utils.MathUtils;
import main.WeightedVertex;

public class WeightedVertexRenderer
extends DefaultVertexRenderer<WeightedVertex> {
    private int attachmentX = 0;
    private int attachmentY = 0;

    public void setAttachmentPoint(int x, int y) {
        super.setAttachmentPoint(x, y);
        this.attachmentX = x;
        this.attachmentY = y;
    }

    public void draw(Graphics2D g, WeightedVertex o) {
        super.draw(g, (Vertex)o);
        String weightAsString = MathUtils.formatFloat((float)o.getWeight());
        FontMetrics fm = g.getFontMetrics();
        g.drawString(weightAsString, this.attachmentX < this.xCenter ? this.attachmentX - fm.stringWidth(weightAsString) - 2 : this.attachmentX + 2, this.attachmentY > this.yCenter ? this.attachmentY + fm.getAscent() + fm.getLeading() : this.attachmentY - 2);
    }
}

