/*
 * Decompiled with CFR 0.152.
 */
package main;

import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.renderers.VertexRenderer;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.GraphFactory;
import lavesdk.math.graph.SimpleGraph;
import lavesdk.math.graph.Vertex;
import main.EdgeRenderer;
import main.SavingsGraphFactory;
import main.WeightedVertex;
import main.WeightedVertexRenderer;

public class SavingsGraphView
extends GraphView<WeightedVertex, Edge> {
    private static final long serialVersionUID = 1L;
    private final String vertexWeightLabel;

    public SavingsGraphView(String title, LanguageFile langFile, String langID) throws IllegalArgumentException {
        super(title, (Graph)new SimpleGraph(false), (GraphFactory)new SavingsGraphFactory(), false, langFile, langID);
        this.vertexWeightLabel = LanguageFile.getLabel((LanguageFile)langFile, (String)"VIEW_GRAPH_VERTEXPROP_WEIGHT", (String)langID, (String)"Weight");
        this.setVertexRenderer((VertexRenderer)new WeightedVertexRenderer());
        this.setEdgeRenderer((lavesdk.algorithm.plugin.views.renderers.EdgeRenderer)new EdgeRenderer());
    }

    public GraphView.VisualEdge addEdge(final WeightedVertex predecessor, final WeightedVertex successor, final boolean directed) {
        return (GraphView.VisualEdge)EDT.execute((GuiRequest)new GuiRequest<GraphView.VisualEdge>(){

            protected GraphView.VisualEdge execute() throws Throwable {
                return SavingsGraphView.this.createVisualEdge(SavingsGraphView.this.getVisualVertex(predecessor), SavingsGraphView.this.getVisualVertex(successor), directed);
            }
        });
    }

    public void removeEdge(final GraphView.VisualEdge ve) {
        EDT.execute((GuiJob)new GuiJob(){

            protected void execute() throws Throwable {
                SavingsGraphView.this.removeVisualEdge(ve);
            }
        });
    }

    protected void loadAdvancedVertexProperties(PropertiesListModel plm, WeightedVertex vertex) {
        super.loadAdvancedVertexProperties(plm, (Vertex)vertex);
        NumericProperty weightProp = new NumericProperty(this.vertexWeightLabel, "", (Number)Float.valueOf(vertex.getWeight()));
        plm.add((Property)weightProp);
    }

    protected void applyAdvancedVertexProperties(PropertiesListModel plm, WeightedVertex vertex) {
        super.applyAdvancedVertexProperties(plm, (Vertex)vertex);
        NumericProperty weightProp = plm.getNumericProperty(this.vertexWeightLabel);
        if (weightProp != null) {
            vertex.setWeight(weightProp.getValue().floatValue());
        }
    }
}

