/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.filechooser.FileNameExtensionFilter;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.CircleLayoutToolBarExtension;
import lavesdk.algorithm.plugin.extensions.CompleteGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.MatrixToGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.AlgorithmTextView;
import lavesdk.algorithm.plugin.views.DefaultTransferProtocol;
import lavesdk.algorithm.plugin.views.ExecutionTableView;
import lavesdk.algorithm.plugin.views.GraphScene;
import lavesdk.algorithm.plugin.views.GraphTransferProtocol;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.LegendView;
import lavesdk.algorithm.plugin.views.TextAreaView;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.plugin.views.custom.CustomVisualObject;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.algorithm.text.Annotation;
import lavesdk.algorithm.text.AnnotationImagesList;
import lavesdk.configuration.Configuration;
import lavesdk.gui.dialogs.InputDialog;
import lavesdk.gui.dialogs.SolveExerciseDialog;
import lavesdk.gui.dialogs.SolveExercisePane;
import lavesdk.gui.dialogs.enums.AllowedGraphType;
import lavesdk.gui.widgets.ColorProperty;
import lavesdk.gui.widgets.ExecutionTableColumn;
import lavesdk.gui.widgets.ExecutionTableItem;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;
import lavesdk.gui.widgets.enums.SelectionType;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.SimpleGraph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.Walk;
import lavesdk.math.graph.WalkByID;
import lavesdk.math.graph.enums.Type;
import lavesdk.serialization.Serializer;
import lavesdk.utils.GraphUtils;
import lavesdk.utils.MathUtils;
import main.DeliveryCapacityDisplay;
import main.ListViewExerciseExt;
import main.SavingsGraphView;
import main.SavingsViewExerciseExt;
import main.VertexPair;
import main.WeightedVertex;

public class SavingsAlgorithmPlugin
implements AlgorithmPlugin {
    private PluginHost host;
    private Configuration config;
    private LanguageFile langFile;
    private String langID;
    private FileNameExtensionFilter vgfFileFilter;
    private FileNameExtensionFilter pngFileFilter;
    private AlgorithmText algoText;
    private SavingsGraphView graphView;
    private AlgorithmTextView algoTextView;
    private TextAreaView cycleRView;
    private TextAreaView cycleR_ApoView;
    private ExecutionTableView listView;
    private ExecutionTableView savingsView;
    private LegendView legendView;
    private SavingsRTE rte;
    private Graph<WeightedVertex, Edge> userGraph;
    private GraphTransferProtocol<WeightedVertex, Edge> userGTP;
    private MatrixToGraphToolBarExtension<WeightedVertex, Edge> matrixToGraph;
    private CompleteGraphToolBarExtension<WeightedVertex, Edge> completeExt;
    private CircleLayoutToolBarExtension<WeightedVertex, Edge> circleLayoutExt;
    private AnnotationImagesList annotationImgList;
    private Icon addIconRes;
    private Icon removeIconRes;
    private Icon importIconRes;
    private ViewGroup ab;
    private ViewGroup cd;
    private ViewGroup ef;
    private ViewGroup abcdef;
    private Color colorStartVertex;
    private Color colorCycleR;
    private Color colorPositiveSavingsValue;
    private Color colorNonPositiveSavingsValue;
    private Color colorUsedEdges;
    private Color colorUnusedEdges;
    private Color colorVertexPair;
    private Color colorEdgesToRemove;
    private Color colorEdgeToAdd;
    private Color colorModified;
    private int lineWidthStartVertex;
    private int lineWidthCycleR;
    private int lineWidthEdgeToAdd;
    private static final String CFGKEY_COLOR_STARTVERTEX = "colorStartVertex";
    private static final String CFGKEY_COLOR_CYCLER = "colorCycleR";
    private static final String CFGKEY_COLOR_POSITIVESAVINGSVALUE = "colorPositiveSavingsValue";
    private static final String CFGKEY_COLOR_NONPOSITIVESAVINGSVALUE = "colorNonPositiveSavingsValue";
    private static final String CFGKEY_COLOR_USEDEDGES = "colorUsedEdges";
    private static final String CFGKEY_COLOR_UNUSEDEDGES = "colorUnusedEdges";
    private static final String CFGKEY_COLOR_VERTEXPAIR = "colorVertexPair";
    private static final String CFGKEY_COLOR_EDGESTOREMOVE = "colorEdgesToRemove";
    private static final String CFGKEY_COLOR_EDGETOADD = "colorEdgeToAdd";
    private static final String CFGKEY_COLOR_MODIFIED = "colorModified";
    private static final String CFGKEY_LINEWIDTH_STARTVERTEX = "lineWidthStartVertex";
    private static final String CFGKEY_LINEWIDTH_CYCLER = "lineWidthCycleR";
    private static final String CFGKEY_LINEWIDTH_EDGETOADD = "lineWidthEdgeToAdd";

    public void initialize(PluginHost host, ResourceLoader resLoader, Configuration config) {
        try {
            this.langFile = new LanguageFile(resLoader.getResourceAsStream("main/resources/langSavings.txt"));
            this.langFile.include(host.getLanguageFile());
        }
        catch (IOException e) {
            this.langFile = null;
        }
        this.langID = host.getLanguageID();
        this.annotationImgList = new AnnotationImagesList();
        this.annotationImgList.add("case1", resLoader.getResource("main/resources/case1.png"));
        this.annotationImgList.add("case2", resLoader.getResource("main/resources/case2.png"));
        this.annotationImgList.add("case3", resLoader.getResource("main/resources/case3.png"));
        this.annotationImgList.add("case4", resLoader.getResource("main/resources/case4.png"));
        this.host = host;
        this.config = config != null ? config : new Configuration();
        this.vgfFileFilter = new FileNameExtensionFilter("Visual Graph File (*.vgf)", "vgf");
        this.pngFileFilter = new FileNameExtensionFilter("Portable Network Graphic (*.png)", "png");
        this.graphView = new SavingsGraphView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_GRAPH_TITLE", (String)this.langID, (String)"Graph"), this.langFile, this.langID);
        this.cycleRView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_CYCLER_TITLE", (String)this.langID, (String)"Cycle r"), true, this.langFile, this.langID);
        this.cycleR_ApoView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_CYCLER_APOSTROPHE_TITLE", (String)this.langID, (String)"Cycle r'"), false, this.langFile, this.langID);
        this.listView = new ExecutionTableView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LIST_TITLE", (String)this.langID, (String)"List"), true, this.langFile, this.langID);
        this.savingsView = new ExecutionTableView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_SAVINGS_TITLE", (String)this.langID, (String)"Savings"), true, this.langFile, this.langID);
        this.algoText = this.loadAlgorithmText();
        this.algoTextView = new AlgorithmTextView(host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ALGOTEXT_TITLE", (String)this.langID, (String)"Algorithm"), this.algoText, true, this.langFile, this.langID);
        this.legendView = new LegendView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LEGEND_TITLE", (String)this.langID, (String)"Legend"), true, this.langFile, this.langID);
        this.rte = new SavingsRTE();
        this.userGraph = null;
        this.matrixToGraph = new MatrixToGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.UNDIRECTED_ONLY, this.langFile, this.langID, true);
        this.completeExt = new CompleteGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.UNDIRECTED_ONLY, this.langFile, this.langID, true);
        this.circleLayoutExt = new CircleLayoutToolBarExtension((GraphView)this.graphView, this.langFile, this.langID, false);
        this.addIconRes = resLoader.getResourceAsIcon("main/resources/plus.png");
        this.removeIconRes = resLoader.getResourceAsIcon("main/resources/minus.png");
        this.importIconRes = resLoader.getResourceAsIcon("main/resources/table-import.png");
        this.algoTextView.setAutoRepaint(true);
        this.cycleRView.setAutoRepaint(true);
        this.cycleR_ApoView.setAutoRepaint(true);
        this.listView.setAutoRepaint(true);
        this.savingsView.setAutoRepaint(true);
        this.cycleR_ApoView.setVisible(false);
        this.graphView.setEdgeOffsetDistance(16);
        this.colorStartVertex = this.config.getColor(CFGKEY_COLOR_STARTVERTEX, new Color(130, 200, 255));
        this.colorCycleR = this.config.getColor(CFGKEY_COLOR_CYCLER, new Color(200, 145, 145));
        this.colorPositiveSavingsValue = this.config.getColor(CFGKEY_COLOR_POSITIVESAVINGSVALUE, new Color(120, 210, 80));
        this.colorNonPositiveSavingsValue = this.config.getColor(CFGKEY_COLOR_NONPOSITIVESAVINGSVALUE, new Color(215, 75, 75));
        this.colorUsedEdges = this.config.getColor(CFGKEY_COLOR_USEDEDGES, new Color(155, 155, 155));
        this.colorUnusedEdges = this.config.getColor(CFGKEY_COLOR_UNUSEDEDGES, new Color(195, 195, 195));
        this.colorVertexPair = this.config.getColor(CFGKEY_COLOR_VERTEXPAIR, new Color(255, 220, 80));
        this.colorEdgesToRemove = this.config.getColor(CFGKEY_COLOR_EDGESTOREMOVE, new Color(255, 220, 80));
        this.colorEdgeToAdd = this.config.getColor(CFGKEY_COLOR_EDGETOADD, new Color(105, 150, 180));
        this.colorModified = this.config.getColor(CFGKEY_COLOR_MODIFIED, new Color(255, 180, 130));
        this.lineWidthStartVertex = this.config.getInt(CFGKEY_LINEWIDTH_STARTVERTEX, 2);
        this.lineWidthCycleR = this.config.getInt(CFGKEY_LINEWIDTH_CYCLER, 2);
        this.lineWidthEdgeToAdd = this.config.getInt(CFGKEY_LINEWIDTH_EDGETOADD, 2);
        this.graphView.loadConfiguration(config, "graphView");
        this.algoTextView.loadConfiguration(config, "algoTextView");
        this.cycleRView.loadConfiguration(config, "cycleRView");
        this.cycleR_ApoView.loadConfiguration(config, "cycleR_ApoView");
        this.listView.loadConfiguration(config, "listView");
        this.savingsView.loadConfiguration(config, "savingsView");
        this.legendView.loadConfiguration(config, "legendView");
        this.createLegend();
    }

    public String getName() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_NAME", (String)this.langID, (String)"Savings algorithm");
    }

    public String getDescription() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_DESC", (String)this.langID, (String)"Finds a cycle of little length which contains all vertices of the graph and which can be separated into disjoint cycles, each of which fulfill the delivery constraint.");
    }

    public String getType() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_TYPE", (String)this.langID, (String)"Heuristic");
    }

    public String getAuthor() {
        return "Jan Dornseifer";
    }

    public String getAuthorContact() {
        return "jan.dornseifer@student.uni-siegen.de";
    }

    public String getAssumptions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_ASSUMPTIONS", (String)this.langID, (String)"An edge- and vertex weighted (c(e), b(v), each non-negative), undirected graph K<sub>n</sub>, a starting vertex v<sub>s</sub> and a delivery capacity b<sub>max</sub> \u2265 max{b(v)}.");
    }

    public String getProblemAffiliation() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_PROBLEMAFFILIATION", (String)this.langID, (String)"Vehicle routing problem");
    }

    public String getSubject() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_SUBJECT", (String)this.langID, (String)"Logistics");
    }

    public String getInstructions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_INSTRUCTIONS", (String)this.langID, (String)"<b>Creating problem entities</b>:<br>Create your own graph and make sure that the graph complies with the assumptions of the algorithm. You can use<br>the toolbar extensions to check whether the created graph is complete, to create a complete graph by indicating the number of vertices, to<br>create a graph by use of an adjacency matrix or you can arrange the vertices of your created graph in a circle.<br><br><b>Starting the algorithm</b>:<br>Before you start the algorithm select a vertex v<sub>s</sub> the algorithm should begin with and afterwards enter the delivery capacity b<sub>max</sub> in the following dialog.<br><br><b>Exercise Mode</b>:<br>Activate the exercise mode to practice the algorithm in an interactive way. After you have started the algorithm<br>exercises are presented that you have to solve.<br>If an exercise can be solved directly in a view of the algorithm the corresponding view is highlighted with a border, there you can<br>enter your solution and afterwards you have to press the button to solve the exercise. Otherwise (if an exercise is not related to a specific<br>view) you can directly press the button to solve the exercise which opens a dialog where you can enter your solution of the exercise.");
    }

    public String getVersion() {
        return "1.3";
    }

    public LAVESDKV getUsedSDKVersion() {
        return new LAVESDKV(1, 3);
    }

    public AlgorithmRTE getRuntimeEnvironment() {
        return this.rte;
    }

    public AlgorithmText getText() {
        return this.algoText.getBaseCopy();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean hasExerciseMode() {
        return true;
    }

    public boolean hasCreatorPreferences() {
        return false;
    }

    public void loadCreatorPreferences(PropertiesListModel plm) {
    }

    public void onCreate(ViewContainer container, PropertiesListModel creatorProperties) {
        this.graphView.setGraph((Graph)new SimpleGraph(false));
        this.graphView.repaint();
        this.ab = new ViewGroup(1);
        this.cd = new ViewGroup(1);
        this.ef = new ViewGroup(1);
        this.abcdef = new ViewGroup(0);
        this.ab.add((Component)this.algoTextView);
        this.ab.add((Component)this.legendView);
        this.ab.restoreWeights((Serializer)this.config, "weights_ab", new float[]{0.6f, 0.4f});
        this.cd.add((Component)((Object)this.graphView));
        this.cd.add((Component)this.cycleRView);
        this.cd.add((Component)this.cycleR_ApoView);
        this.cd.restoreWeights((Serializer)this.config, "weights_cd", new float[]{0.6f, 0.2f, 0.2f});
        this.ef.add((Component)this.listView);
        this.ef.add((Component)this.savingsView);
        this.ef.restoreWeights((Serializer)this.config, "weights_ef", new float[]{0.5f, 0.5f});
        this.abcdef.add((Component)this.ab);
        this.abcdef.add((Component)this.cd);
        this.abcdef.add((Component)this.ef);
        this.abcdef.restoreWeights((Serializer)this.config, "weights_abcdef", new float[]{0.4f, 0.45f, 0.15f});
        container.setLayout((LayoutManager)new BorderLayout());
        container.add((Component)this.abcdef, (Object)"Center");
    }

    public void onClose() {
        this.graphView.saveConfiguration(this.config, "graphView");
        this.algoTextView.saveConfiguration(this.config, "algoTextView");
        this.cycleRView.saveConfiguration(this.config, "cycleView");
        this.cycleR_ApoView.saveConfiguration(this.config, "cycleR_ApoView");
        this.listView.saveConfiguration(this.config, "listView");
        this.savingsView.saveConfiguration(this.config, "savingsView");
        this.legendView.saveConfiguration(this.config, "legendView");
        if (this.ab != null) {
            this.ab.storeWeights((Serializer)this.config, "weights_ab");
        }
        if (this.cd != null) {
            this.cd.storeWeights((Serializer)this.config, "weights_cd");
        }
        if (this.ef != null) {
            this.ef.storeWeights((Serializer)this.config, "weights_ef");
        }
        if (this.abcdef != null) {
            this.abcdef.storeWeights((Serializer)this.config, "weights_abcdef");
        }
        this.graphView.reset();
        this.cycleRView.reset();
        this.cycleR_ApoView.reset();
        this.listView.reset();
        this.savingsView.reset();
    }

    public boolean hasCustomization() {
        return true;
    }

    public void loadCustomization(PropertiesListModel plm) {
        plm.add((Property)new ColorProperty("algoTextHighlightForeground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTFOREGROUND", (String)this.langID, (String)"Foreground color of the current step in the algorithm"), this.algoTextView.getHighlightForeground()));
        plm.add((Property)new ColorProperty("algoTextHighlightBackground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTBACKGROUND", (String)this.langID, (String)"Background color of the current step in the algorithm"), this.algoTextView.getHighlightBackground()));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_STARTVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_STARTVERTEX", (String)this.langID, (String)"Background color of the starting vertex v<sub>s</sub>"), this.colorStartVertex));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_CYCLER, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_CYCLER", (String)this.langID, (String)"Color of the cycle r"), this.colorCycleR));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_POSITIVESAVINGSVALUE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_POSITIVESAVINGSVALUE", (String)this.langID, (String)"Background color of an item with a positive savings value"), this.colorPositiveSavingsValue));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_NONPOSITIVESAVINGSVALUE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_NONPOSITIVESAVINGSVALUE", (String)this.langID, (String)"Background color of an item with a non-positive savings value"), this.colorNonPositiveSavingsValue));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_USEDEDGES, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_USEDEDGES", (String)this.langID, (String)"Color of the edges of the underlying undirected input graph that are contained in the cycle r"), this.colorUsedEdges));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_UNUSEDEDGES, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_UNUSEDEDGES", (String)this.langID, (String)"Color of the edges of the underlying undirected input graph that are not contained in the cycle r"), this.colorUnusedEdges));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_VERTEXPAIR, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_VERTEXPAIR", (String)this.langID, (String)"Background color of the current vertex pair v<sub>i</sub>, v<sub>j</sub>"), this.colorVertexPair));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_EDGESTOREMOVE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_EDGESTOREMOVE", (String)this.langID, (String)"Color of the edges of cycle r that are substituted"), this.colorEdgesToRemove));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_EDGETOADD, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_EDGETOADD", (String)this.langID, (String)"Color of the surrogate edge (v<sub>i</sub>, v<sub>j</sub>)"), this.colorEdgeToAdd));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MODIFIED, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MODIFICATIONS", (String)this.langID, (String)"Color of modifications to objects"), this.colorModified));
        NumericProperty lwStartVertex = new NumericProperty(CFGKEY_LINEWIDTH_STARTVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_STARTVERTEX", (String)this.langID, (String)"Line width of the starting vertex v<sub>s</sub>"), (Number)this.lineWidthStartVertex, true);
        lwStartVertex.setMinimum(1);
        lwStartVertex.setMaximum(5);
        plm.add((Property)lwStartVertex);
        NumericProperty lwCycleR = new NumericProperty(CFGKEY_LINEWIDTH_CYCLER, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_CYCLER", (String)this.langID, (String)"Line with of the cycle r"), (Number)this.lineWidthCycleR, true);
        lwCycleR.setMinimum(1);
        lwCycleR.setMaximum(5);
        plm.add((Property)lwCycleR);
        NumericProperty lwEdgeToAdd = new NumericProperty(CFGKEY_LINEWIDTH_EDGETOADD, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_EDGETOADD", (String)this.langID, (String)"Line with of the surrogate edge"), (Number)this.lineWidthEdgeToAdd, true);
        lwEdgeToAdd.setMinimum(1);
        lwEdgeToAdd.setMaximum(5);
        plm.add((Property)lwEdgeToAdd);
    }

    public void applyCustomization(PropertiesListModel plm) {
        this.algoTextView.setHighlightForeground(plm.getColorProperty("algoTextHighlightForeground").getValue());
        this.algoTextView.setHighlightBackground(plm.getColorProperty("algoTextHighlightBackground").getValue());
        this.colorStartVertex = this.config.addColor(CFGKEY_COLOR_STARTVERTEX, plm.getColorProperty(CFGKEY_COLOR_STARTVERTEX).getValue());
        this.colorCycleR = this.config.addColor(CFGKEY_COLOR_CYCLER, plm.getColorProperty(CFGKEY_COLOR_CYCLER).getValue());
        this.colorPositiveSavingsValue = this.config.addColor(CFGKEY_COLOR_POSITIVESAVINGSVALUE, plm.getColorProperty(CFGKEY_COLOR_POSITIVESAVINGSVALUE).getValue());
        this.colorNonPositiveSavingsValue = this.config.addColor(CFGKEY_COLOR_NONPOSITIVESAVINGSVALUE, plm.getColorProperty(CFGKEY_COLOR_NONPOSITIVESAVINGSVALUE).getValue());
        this.colorUsedEdges = this.config.addColor(CFGKEY_COLOR_USEDEDGES, plm.getColorProperty(CFGKEY_COLOR_USEDEDGES).getValue());
        this.colorUnusedEdges = this.config.addColor(CFGKEY_COLOR_UNUSEDEDGES, plm.getColorProperty(CFGKEY_COLOR_UNUSEDEDGES).getValue());
        this.colorVertexPair = this.config.addColor(CFGKEY_COLOR_VERTEXPAIR, plm.getColorProperty(CFGKEY_COLOR_VERTEXPAIR).getValue());
        this.colorEdgesToRemove = this.config.addColor(CFGKEY_COLOR_EDGESTOREMOVE, plm.getColorProperty(CFGKEY_COLOR_EDGESTOREMOVE).getValue());
        this.colorEdgeToAdd = this.config.addColor(CFGKEY_COLOR_EDGETOADD, plm.getColorProperty(CFGKEY_COLOR_EDGETOADD).getValue());
        this.colorModified = this.config.addColor(CFGKEY_COLOR_MODIFIED, plm.getColorProperty(CFGKEY_COLOR_MODIFIED).getValue());
        this.lineWidthStartVertex = this.config.addInt(CFGKEY_LINEWIDTH_STARTVERTEX, plm.getNumericProperty(CFGKEY_LINEWIDTH_STARTVERTEX).getValue().intValue());
        this.lineWidthCycleR = this.config.addInt(CFGKEY_LINEWIDTH_CYCLER, plm.getNumericProperty(CFGKEY_LINEWIDTH_CYCLER).getValue().intValue());
        this.lineWidthEdgeToAdd = this.config.addInt(CFGKEY_LINEWIDTH_EDGETOADD, plm.getNumericProperty(CFGKEY_LINEWIDTH_EDGETOADD).getValue().intValue());
        this.createLegend();
    }

    public ToolBarExtension[] getToolBarExtensions() {
        return new ToolBarExtension[]{this.matrixToGraph, this.completeExt, this.circleLayoutExt};
    }

    public void save(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.save(file);
            } else if (this.pngFileFilter.accept(file)) {
                this.graphView.saveAsPNG(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE", (String)this.langID, (String)"File could not be saved!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE_TITLE", (String)this.langID, (String)"Save File"), MessageIcon.ERROR);
        }
    }

    public void open(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.load(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE", (String)this.langID, (String)"File could not be opened!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE_TITLE", (String)this.langID, (String)"Open File"), MessageIcon.ERROR);
        }
    }

    public FileNameExtensionFilter[] getSaveFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter, this.pngFileFilter};
    }

    public FileNameExtensionFilter[] getOpenFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter};
    }

    public void beforeStart(RTEvent e) {
        if (this.graphView.getSelectedVertexCount() != 1) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_SELECTSTARTVERTEX", (String)this.langID, (String)"Please select the starting vertex in the graph!"), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_SELECTSTARTVERTEX_TITLE", (String)this.langID, (String)"Select starting vertex"), MessageIcon.INFO);
            e.doit = false;
        } else if (!GraphUtils.isComplete((Graph)this.graphView.getGraph())) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NOTCOMPLETE", (String)this.langID, (String)"The created graph is not complete!\nThe Savings algorithm can only be applied to complete graphs."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NOTCOMPLETE_TITLE", (String)this.langID, (String)"No complete graph"), MessageIcon.INFO);
            e.doit = false;
        } else if (this.containsNegativeWeights()) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NEGATIVEWEIGHTS", (String)this.langID, (String)"The created graph contains negative weights!\nThe Savings algorithm can only be applied to non-negative weighted graphs (see assumptions)."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NEGATIVEWEIGHTS_TITLE", (String)this.langID, (String)"Negative weights"), MessageIcon.INFO);
            e.doit = false;
        }
        if (e.doit) {
            Number b_max = null;
            InputDialog inputDlg = new InputDialog(this.host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"DELIVERYCAPACITYDLG_TITLE", (String)this.langID, (String)"Delivery Capacity"), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"DELIVERYCAPACITYDLG_DESC", (String)this.langID, (String)"Enter the delivery capacity b<sub>max</sub> \u2265 max{b(v)}."), "b<sub>max</sub> = ", this.langFile, this.langID);
            inputDlg.setVisible(true);
            if (!inputDlg.isCanceled()) {
                try {
                    b_max = NumberFormat.getInstance().parse(inputDlg.getInput());
                    int i = 0;
                    while (i < this.graphView.getGraph().getOrder()) {
                        if (b_max.floatValue() < ((WeightedVertex)this.graphView.getGraph().getVertex(i)).getWeight()) {
                            e.doit = false;
                            break;
                        }
                        ++i;
                    }
                }
                catch (ParseException e1) {
                    e.doit = false;
                }
            } else {
                e.doit = false;
            }
            if (!e.doit) {
                this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INVALIDDELIVERYCAPACITY", (String)this.langID, (String)"Your input is incorrect!\nThe delivery capacity has to be a number and must be greater or equal the maximum vertex weight in the graph."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INVALIDDELIVERYCAPACITY_TITLE", (String)this.langID, (String)"Invalid input"), MessageIcon.INFO);
                return;
            }
            String selVertexCaption = ((WeightedVertex)this.graphView.getSelectedVertex(0).getVertex()).getCaption();
            this.graphView.setEditable(false);
            this.userGraph = this.graphView.getGraph();
            this.userGTP = new DefaultTransferProtocol((GraphView)this.graphView, false);
            this.userGTP.prepare();
            this.graphView.setGraph(new Graph(Type.MIXED));
            this.graphView.transferGraph(this.userGTP);
            this.graphView.selectVertex(this.graphView.getVisualVertexByCaption(selVertexCaption), false);
            WeightedVertex startVertex = (WeightedVertex)this.graphView.getSelectedVertex(0).getVertex();
            this.graphView.deselectAll();
            this.rte.setStartVertex(startVertex);
            this.rte.setDeliveryCapacity(b_max.floatValue());
            this.graphView.addVisualObject((CustomVisualObject)new DeliveryCapacityDisplay(b_max.floatValue()));
            this.graphView.repaint();
            this.listView.reset();
            this.savingsView.reset();
            this.cycleRView.reset();
            this.cycleR_ApoView.reset();
            this.cycleR_ApoView.setVisible(false);
            ExecutionTableColumn column = new ExecutionTableColumn("v<sub>i</sub>");
            column.setWidth(30);
            this.listView.add(column);
            column = new ExecutionTableColumn("v<sub>j</sub>");
            column.setWidth(30);
            this.listView.add(column);
            this.listView.add(new ExecutionTableColumn("sav(v<sub>i</sub>,v<sub>j</sub>)"));
            column = new ExecutionTableColumn("v<sub>i</sub>");
            column.setWidth(30);
            this.savingsView.add(column);
            column = new ExecutionTableColumn("v<sub>j</sub>");
            column.setWidth(30);
            this.savingsView.add(column);
            this.savingsView.add(new ExecutionTableColumn("sav(v<sub>i</sub>,v<sub>j</sub>)"));
        }
    }

    public void beforeResume(RTEvent e) {
    }

    public void beforePause(RTEvent e) {
    }

    public void onStop() {
        this.graphView.setGraph(this.userGraph);
        this.graphView.transferGraph(this.userGTP);
        this.graphView.setEditable(true);
        this.graphView.removeAllVisualObjects();
        this.graphView.repaint();
        this.userGraph = null;
        this.cycleR_ApoView.setVisible(false);
    }

    public void onRunning() {
    }

    public void onPause() {
    }

    private AlgorithmText loadAlgorithmText() {
        AlgorithmText text = new AlgorithmText();
        AlgorithmParagraph initParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_INITIALIZATION", (String)this.langID, (String)"1. Initialization:"), 1);
        AlgorithmParagraph itParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_ITERATION", (String)this.langID, (String)"2. Iteration:"), 2);
        AlgorithmStep step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP1_INIT", (String)this.langID, (String)"Set _latex{$r := (v_s,v_1,v_s,v_2,v_s,...)$} with _latex{$v_i \\in V$}, _latex{$i = 1, 2, ..., n - 1$} (Oscillation Tours).\n"), 1);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<String>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP1", (String)this.langID, (String)"Specify an Oscillation Tour."), 1.0f){

            protected String[] requestSolution() {
                SolveExerciseDialog.SolutionEntry entry = new SolveExerciseDialog.SolutionEntry("r=", (Component)new JTextField());
                if (!SolveExercisePane.showDialog((PluginHost)SavingsAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entry}, (LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)SavingsAlgorithmPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)"EXERCISE_HINT_CYCLEINPUT", (String)SavingsAlgorithmPlugin.this.langID, (String)"Use a comma as the delimiter!"))) {
                    return null;
                }
                Walk w = GraphUtils.toWalk((String)((JTextField)entry.getComponent()).getText(), (Graph)SavingsAlgorithmPlugin.this.graphView.getGraph());
                if (w == null) {
                    SavingsAlgorithmPlugin.this.host.showMessage((AlgorithmPlugin)SavingsAlgorithmPlugin.this, LanguageFile.getLabel((LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)"MSG_INFO_INVALIDCYCLEINPUT", (String)SavingsAlgorithmPlugin.this.langID, (String)"Your input is incorrect!\nPlease enter the cycle in the specified form and only use vertex captions that are existing."), LanguageFile.getLabel((LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)"MSG_INFO_INVALIDCYCLEINPUT_TITLE", (String)SavingsAlgorithmPlugin.this.langID, (String)"Invalid input"), MessageIcon.INFO);
                    return null;
                }
                return new String[]{((JTextField)entry.getComponent()).getText()};
            }

            protected String getResultAsString(String result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                if (result.startsWith("(") && result.endsWith(")")) {
                    return "r=" + result;
                }
                return "r=(" + result + ")";
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, String[] solutions) {
                state.addWalk("r", GraphUtils.toWalk((String)solutions[0], (Graph)SavingsAlgorithmPlugin.this.graphView.getGraph()).cast());
            }

            protected boolean examine(String[] results, AlgorithmState state) {
                Walk r = GraphUtils.toWalk((String)results[0], (Graph)SavingsAlgorithmPlugin.this.graphView.getGraph());
                int v_s = SavingsAlgorithmPlugin.this.rte.getStartVertex().getID();
                boolean[] visited = new boolean[SavingsAlgorithmPlugin.this.graphView.getGraph().getOrder()];
                boolean startVertex = true;
                if (!r.isClosed()) {
                    return false;
                }
                int i = 0;
                while (i <= r.length()) {
                    WeightedVertex v = (WeightedVertex)r.get(i);
                    if (startVertex && v.getID() != v_s) {
                        return false;
                    }
                    if (!startVertex && v.getID() == v_s) {
                        return false;
                    }
                    if (!startVertex && visited[v.getIndex()]) {
                        return false;
                    }
                    visited[v.getIndex()] = true;
                    startVertex = !startVertex;
                    ++i;
                }
                boolean[] blArray = visited;
                int n = visited.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean b = blArray[n2];
                    if (!b) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        });
        step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP2_INIT", (String)this.langID, (String)"Calculate the savings for each pair of vertices _latex{$v_i,v_j \\in V \\setminus \\{v_s\\}$}:  _latex{$sav(v_i,v_j) := c(v_s,v_i) + c(v_s,v_j) - c(v_i,v_j)$}.\n"), 2);
        step.setExercise(new AlgorithmExercise<List<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP2", (String)this.langID, (String)"Calculate the savings (<i>use the buttons in the header bar of the savings view to add or remove items</i>)."), 2.0f, (View)this.savingsView){
            private SavingsViewExerciseExt ext;

            protected void beforeRequestSolution(AlgorithmState state) {
                this.ext = new SavingsViewExerciseExt(SavingsAlgorithmPlugin.this.savingsView, SavingsAlgorithmPlugin.this.addIconRes, SavingsAlgorithmPlugin.this.removeIconRes, SavingsAlgorithmPlugin.this.langFile, SavingsAlgorithmPlugin.this.langID);
                this.ext.apply();
                int i = 0;
                while (i < SavingsAlgorithmPlugin.this.savingsView.getColumnCount()) {
                    SavingsAlgorithmPlugin.this.savingsView.getColumn(i).setEditable(true);
                    ++i;
                }
            }

            protected void afterRequestSolution(boolean omitted) {
                this.ext.remove();
                this.ext = null;
                int i = 0;
                while (i < SavingsAlgorithmPlugin.this.savingsView.getColumnCount()) {
                    SavingsAlgorithmPlugin.this.savingsView.getColumn(i).setEditable(true);
                    ++i;
                }
                if (omitted) {
                    SavingsAlgorithmPlugin.this.savingsView.removeAllItems();
                } else {
                    i = 0;
                    while (i < SavingsAlgorithmPlugin.this.savingsView.getItemCount()) {
                        SavingsAlgorithmPlugin.this.savingsView.getItem(i).setEditable(false);
                        ++i;
                    }
                }
            }

            protected List<?>[] requestSolution() {
                Graph graph = SavingsAlgorithmPlugin.this.graphView.getGraph();
                ArrayList<VertexPair> savings = new ArrayList<VertexPair>();
                int i = 0;
                while (i < SavingsAlgorithmPlugin.this.savingsView.getItemCount()) {
                    ExecutionTableItem item = SavingsAlgorithmPlugin.this.savingsView.getItem(i);
                    WeightedVertex v_i = (WeightedVertex)graph.getVertexByCaption(item.getCellObject(0).toString());
                    WeightedVertex v_j = (WeightedVertex)graph.getVertexByCaption(item.getCellObject(1).toString());
                    Number sav = (Number)item.getCellObject(2);
                    VertexPair vp = new VertexPair(v_i != null ? v_i.getID() : -1, v_j != null ? v_j.getID() : -1, sav != null ? sav.floatValue() : 0.0f);
                    savings.add(vp);
                    item.setUserData((Object)vp);
                    ++i;
                }
                return new List[]{savings};
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, List<?>[] solutions) {
                List<?> savings = solutions[0];
                state.addList("savings", savings);
            }

            protected String getResultAsString(List<?> result, int index) {
                List<?> list = result;
                Graph graph = SavingsAlgorithmPlugin.this.graphView.getGraph();
                if (list == null) {
                    return super.getResultAsString(result, index);
                }
                StringBuilder s = new StringBuilder();
                boolean delimiter = false;
                s.append("[");
                for (VertexPair vp : list) {
                    if (delimiter) {
                        s.append(", ");
                    }
                    s.append("(" + ((WeightedVertex)graph.getVertexByID(vp.v_i)).getCaption() + ", " + ((WeightedVertex)graph.getVertexByID(vp.v_j)).getCaption() + ") " + MathUtils.formatFloat((float)vp.savings));
                    delimiter = true;
                }
                s.append("]");
                return s.toString();
            }

            protected boolean examine(List<?>[] results, AlgorithmState state) {
                List result = results[0];
                Graph graph = SavingsAlgorithmPlugin.this.graphView.getGraph();
                WeightedVertex v_s = SavingsAlgorithmPlugin.this.rte.getStartVertex();
                ArrayList<VertexPair> savings = new ArrayList<VertexPair>();
                int i = 0;
                while (i < graph.getOrder()) {
                    int j = i;
                    while (j < graph.getOrder()) {
                        if (i != j && i != v_s.getIndex() && j != v_s.getIndex()) {
                            WeightedVertex v_i = (WeightedVertex)graph.getVertex(i);
                            WeightedVertex v_j = (WeightedVertex)graph.getVertex(j);
                            Edge eV_sV_i = graph.getEdge((Vertex)v_s, (Vertex)v_i);
                            Edge eV_sV_j = graph.getEdge((Vertex)v_s, (Vertex)v_j);
                            Edge eV_iV_j = graph.getEdge((Vertex)v_i, (Vertex)v_j);
                            savings.add(new VertexPair(v_i.getID(), v_j.getID(), eV_sV_i.getWeight() + eV_sV_j.getWeight() - eV_iV_j.getWeight()));
                        }
                        ++j;
                    }
                    ++i;
                }
                return result.size() == savings.size() && result.containsAll(savings);
            }
        });
        step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP3_INIT", (String)this.langID, (String)"List all pairs of vertices with positive savings value in non-increasing order according to their savings value.\n\n"), 3);
        step.setExercise(new AlgorithmExercise<List<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP3", (String)this.langID, (String)"List all pairs of vertices with positive savings value and sort them (<i>select the items in the savings view and use the button in the header bar of the list view to import the selected items</i>)."), 2.0f, new View[]{this.listView, this.savingsView}){
            private ListViewExerciseExt ext;

            protected void beforeRequestSolution(AlgorithmState state) {
                this.ext = new ListViewExerciseExt(SavingsAlgorithmPlugin.this.listView, SavingsAlgorithmPlugin.this.savingsView, SavingsAlgorithmPlugin.this.importIconRes, SavingsAlgorithmPlugin.this.langFile, SavingsAlgorithmPlugin.this.langID);
                this.ext.apply();
                SavingsAlgorithmPlugin.this.listView.setSortable(true);
                SavingsAlgorithmPlugin.this.savingsView.setSelectionType(SelectionType.ROWS);
            }

            protected void afterRequestSolution(boolean omitted) {
                this.ext.remove();
                this.ext = null;
                SavingsAlgorithmPlugin.this.listView.setSortable(false);
                SavingsAlgorithmPlugin.this.savingsView.setSelectionType(SelectionType.NONE);
                int i = 0;
                while (i < SavingsAlgorithmPlugin.this.listView.getColumnCount()) {
                    SavingsAlgorithmPlugin.this.listView.getColumn(i).setEditable(true);
                    ++i;
                }
                if (omitted) {
                    SavingsAlgorithmPlugin.this.listView.removeAllItems();
                }
            }

            protected List<?>[] requestSolution() {
                ArrayList<VertexPair> list = new ArrayList<VertexPair>();
                int i = 0;
                while (i < SavingsAlgorithmPlugin.this.listView.getItemCount()) {
                    list.add((VertexPair)SavingsAlgorithmPlugin.this.listView.getItem(i).getUserData());
                    ++i;
                }
                return new List[]{list};
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, List<?>[] solutions) {
                List<?> list = solutions[0];
                state.addList("list", list);
            }

            protected String getResultAsString(List<?> result, int index) {
                List<?> list = result;
                Graph graph = SavingsAlgorithmPlugin.this.graphView.getGraph();
                if (list == null) {
                    return super.getResultAsString(result, index);
                }
                StringBuilder s = new StringBuilder();
                boolean delimiter = false;
                s.append("[");
                for (VertexPair vp : list) {
                    if (delimiter) {
                        s.append(", ");
                    }
                    s.append("(" + ((WeightedVertex)graph.getVertexByID(vp.v_i)).getCaption() + ", " + ((WeightedVertex)graph.getVertexByID(vp.v_j)).getCaption() + ") " + MathUtils.formatFloat((float)vp.savings));
                    delimiter = true;
                }
                s.append("]");
                return s.toString();
            }

            protected boolean examine(List<?>[] results, AlgorithmState state) {
                List savings = state.getList("savings");
                List<?> list = results[0];
                VertexPair lastVP = null;
                int posSavValuesCount = 0;
                for (VertexPair vp : savings) {
                    if (!(vp.savings > 0.0f)) continue;
                    ++posSavValuesCount;
                }
                if (list.size() != posSavValuesCount) {
                    return false;
                }
                int i = 0;
                while (i < list.size()) {
                    VertexPair currVP = (VertexPair)list.get(i);
                    if (lastVP != null && currVP.savings > lastVP.savings) {
                        return false;
                    }
                    lastVP = currVP;
                    ++i;
                }
                return true;
            }
        });
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP4_IT", (String)this.langID, (String)"For each vertex pair _latex{$v_i,v_j$} from the list:"), 4);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Integer>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP4", (String)this.langID, (String)"Select the current vertex pair in the graph."), 1.0f, (View)this.graphView){

            protected void beforeRequestSolution(AlgorithmState state) {
                SavingsAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.VERTICES_ONLY);
                SavingsAlgorithmPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                SavingsAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.BOTH);
                SavingsAlgorithmPlugin.this.graphView.setShowCursorToolAlways(false);
                SavingsAlgorithmPlugin.this.graphView.deselectAll();
            }

            protected Integer[] requestSolution() {
                if (SavingsAlgorithmPlugin.this.graphView.getSelectedVertexCount() != 2) {
                    return null;
                }
                return new Integer[]{((WeightedVertex)SavingsAlgorithmPlugin.this.graphView.getSelectedVertex(0).getVertex()).getID(), ((WeightedVertex)SavingsAlgorithmPlugin.this.graphView.getSelectedVertex(1).getVertex()).getID()};
            }

            protected String getResultAsString(Integer result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return ((WeightedVertex)SavingsAlgorithmPlugin.this.graphView.getVisualVertexByID(result).getVertex()).getCaption();
            }

            protected boolean examine(Integer[] results, AlgorithmState state) {
                VertexPair vp = (VertexPair)state.getObject("currVertexPair");
                return vp.v_i == results[0] && vp.v_j == results[1] || vp.v_i == results[1] && vp.v_j == results[0];
            }
        });
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5_IT", (String)this.langID, (String)"If the edges _latex{$(v_s,v_i)$} (_latex{$(v_i,v_s)$}, resp.) and _latex{$(v_s,v_j)$} (_latex{$(v_j,v_s)$}, resp.) are still contained in _latex{$r$} and if _latex{$v_i$} and _latex{$v_j$} are elements in different tours, merge the corresponding disjoint cycles within _latex{$r$} in such a way to a new tour _latex{$r'$} that both mentioned edges are being substituted by _latex{$(v_i,v_j)$}. "), 5, 4);
        step.setAnnotation(new Annotation(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5_ANNOTATION", (String)this.langID, (String)"<b>Cycle creation</b><br>Cases that need to be checked:<br><table border=\"0\"><tr><td valign=\"top\"></td><td valign=\"top\"></td><td valign=\"top\"><b>Resolve to</b></td></tr><tr><td valign=\"top\"><b>1. (v<sub>i</sub>, v<sub>s</sub>) and (v<sub>s</sub>, v<sub>j</sub>)</b></td><td valign=\"top\"><img src=\"case1\"></td><td valign=\"top\">Merge the pitch cycle of v<sub>i</sub> with the pitch cycle of v<sub>j</sub><br><b>Example</b>: v<sub>i</sub> = 1, v<sub>j</sub> = 3, (s, 2, 1, s) and (s, 3, 4, s)<br>Result: (s, 2, 1, 3, 4, s)</td></tr><tr><td valign=\"top\"><b>2. (v<sub>s</sub>, v<sub>i</sub>) and (v<sub>j</sub>, v<sub>s</sub>)</b></td><td valign=\"top\"><img src=\"case2\"></td><td valign=\"top\">Merge the pitch cycle of v<sub>j</sub> with the pitch cycle of v<sub>i</sub><br><b>Example</b>: v<sub>i</sub> = 1, v<sub>j</sub> = 3, (s, 1, 2, s) and (s, 4, 3, s)<br>Result: (s, 4, 3, 1, 2, s)</td></tr><tr><td valign=\"top\"><b>3. (v<sub>i</sub>, v<sub>s</sub>) and (v<sub>j</sub>, v<sub>s</sub>)</b></td><td valign=\"top\"><img src=\"case3\"></td><td valign=\"top\">Merge the pitch cycle of v<sub>i</sub> with the reversed pitch cycle of v<sub>j</sub><br><b>Example</b>: v<sub>i</sub> = 1, v<sub>j</sub> = 3, (s, 2, 1, s) and (s, 4, 3, s)<br>Reverse: (s, 4, 3, s) to (s, 3, 4, s)<br>Result: (s, 2, 1, 3, 4, s)</td></tr><tr><td valign=\"top\"><b>4. (v<sub>s</sub>, v<sub>i</sub>) and (v<sub>s</sub>, v<sub>j</sub>)</b></td><td valign=\"top\"><img src=\"case4\"></td><td valign=\"top\">Reverse the pitch cycle of v<sub>i</sub> and merge it with the pitch cycle of <sub>j</sub><br><b>Example</b>: v<sub>i</sub> = 1, v<sub>j</sub> = 3, (s, 1, 2, s) and (s, 3, 4, s)<br>Reverse: (s, 1, 2, s) to (s, 2, 1, s)<br>Result: (s, 2, 1, 3, 4, s)</td></tr></table>"), this.annotationImgList));
        step.setExercise(new AlgorithmExercise<Walk<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP5", (String)this.langID, (String)"Is it possible to create a new tour <i>r'</i> and if so, what is it?"), 2.0f){
            private final String labelYes;
            private final String labelNo;
            {
                this.labelYes = LanguageFile.getLabel((LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP5_6_YES", (String)SavingsAlgorithmPlugin.this.langID, (String)"Yes");
                this.labelNo = LanguageFile.getLabel((LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP5_6_NO", (String)SavingsAlgorithmPlugin.this.langID, (String)"No");
            }

            protected Walk<?>[] requestSolution() {
                ButtonGroup group = new ButtonGroup();
                final JRadioButton rdobtn1 = new JRadioButton(this.labelNo);
                final JRadioButton rdobtn2 = new JRadioButton(this.labelYes);
                final JTextField txtCycle = new JTextField();
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (e.getSource() == rdobtn1) {
                            txtCycle.setEnabled(false);
                        } else if (e.getSource() == rdobtn2) {
                            txtCycle.setEnabled(true);
                        }
                    }
                };
                group.add(rdobtn1);
                group.add(rdobtn2);
                txtCycle.setEnabled(false);
                rdobtn1.addActionListener(al);
                rdobtn2.addActionListener(al);
                SolveExerciseDialog.SolutionEntry entryNotPossible = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn1);
                SolveExerciseDialog.SolutionEntry entryPossible = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn2);
                SolveExerciseDialog.SolutionEntry entryCycle = new SolveExerciseDialog.SolutionEntry("r'=", (Component)txtCycle);
                if (!SolveExercisePane.showDialog((PluginHost)SavingsAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryNotPossible, entryPossible, entryCycle}, (LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)SavingsAlgorithmPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)"EXERCISE_HINT_CYCLEINPUT", (String)SavingsAlgorithmPlugin.this.langID, (String)"Use a comma as the delimiter!"))) {
                    return null;
                }
                Walk w = null;
                if (rdobtn2.isSelected() && (w = GraphUtils.toWalk((String)((JTextField)entryCycle.getComponent()).getText(), (Graph)SavingsAlgorithmPlugin.this.graphView.getGraph())) == null) {
                    SavingsAlgorithmPlugin.this.host.showMessage((AlgorithmPlugin)SavingsAlgorithmPlugin.this, LanguageFile.getLabel((LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)"MSG_INFO_INVALIDCYCLEINPUT", (String)SavingsAlgorithmPlugin.this.langID, (String)"Your input is incorrect!\nPlease enter the cycle in the specified form and only use vertex captions that are existing."), LanguageFile.getLabel((LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)"MSG_INFO_INVALIDCYCLEINPUT_TITLE", (String)SavingsAlgorithmPlugin.this.langID, (String)"Invalid input"), MessageIcon.INFO);
                    return null;
                }
                return new Walk[]{w};
            }

            protected String getResultAsString(Walk<?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                return "r'=" + result.toString();
            }

            protected boolean examine(Walk<?>[] results, AlgorithmState state) {
                Walk r_Apo;
                WalkByID r_ApoTmp = state.getWalk("r_Apo", SavingsAlgorithmPlugin.this.graphView.getGraph());
                Walk walk = r_Apo = r_ApoTmp != null ? r_ApoTmp.cast() : null;
                return r_Apo == null && results[0] == null || results[0] != null && r_Apo.equals(results[0]);
            }
        });
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP6_IT", (String)this.langID, (String)"If the resulting tour _latex{$r'$} fulfills the capacity constraints, set _latex{$r := r'$}."), 6, 4);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Boolean>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP6", (String)this.langID, (String)"Does <i>r'</i> fulfill the delivery constraint?"), 1.0f){
            private final String labelYes;
            private final String labelNo;
            {
                this.labelYes = LanguageFile.getLabel((LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP5_6_YES", (String)SavingsAlgorithmPlugin.this.langID, (String)"Yes");
                this.labelNo = LanguageFile.getLabel((LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP5_6_NO", (String)SavingsAlgorithmPlugin.this.langID, (String)"No");
            }

            protected Boolean[] requestSolution() {
                ButtonGroup group = new ButtonGroup();
                JRadioButton rdobtn1 = new JRadioButton(this.labelYes);
                JRadioButton rdobtn2 = new JRadioButton(this.labelNo);
                group.add(rdobtn1);
                group.add(rdobtn2);
                SolveExerciseDialog.SolutionEntry entryYes = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn1);
                SolveExerciseDialog.SolutionEntry entryNo = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn2);
                if (!SolveExercisePane.showDialog((PluginHost)SavingsAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryYes, entryNo}, (LanguageFile)SavingsAlgorithmPlugin.this.langFile, (String)SavingsAlgorithmPlugin.this.langID)) {
                    return null;
                }
                return new Boolean[]{!rdobtn1.isSelected() && !rdobtn2.isSelected() ? null : Boolean.valueOf(rdobtn1.isSelected())};
            }

            protected String getResultAsString(Boolean result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return result == Boolean.TRUE ? this.labelYes : this.labelNo;
            }

            protected boolean examine(Boolean[] results, AlgorithmState state) {
                return results[0] != null && results[0].equals(SavingsAlgorithmPlugin.this.rte.checkDeliveryConstraint());
            }
        });
        return text;
    }

    private void createLegend() {
        this.legendView.removeAll();
        this.legendView.add(new LegendItem("item1", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_STARTVERTEX", (String)this.langID, (String)"The starting vertex v<sub>s</sub>"), LegendItem.createCircleIcon((Color)this.colorStartVertex, (Color)Color.black, (int)this.lineWidthStartVertex)));
        this.legendView.add(new LegendItem("item2", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CYCLER_DIRECTED", (String)this.langID, (String)"The cycle r, whereby the directed edges show the running direction of the walk"), LegendItem.createLineIcon((Color)this.colorCycleR, (int)this.lineWidthCycleR, (int)4)));
        this.legendView.add(new LegendItem("item3", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CYCLER_UNDIRECTED", (String)this.langID, (String)"The undirected edges of the cycle r"), LegendItem.createLineIcon((Color)this.colorUsedEdges, (int)1)));
        this.legendView.add(new LegendItem("item4", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_UNUSEDEDGES", (String)this.langID, (String)"The currently unused edges of the graph"), LegendItem.createLineIcon((Color)this.colorUnusedEdges, (int)1)));
        this.legendView.add(new LegendItem("item5", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CURRVERTEXPAIR", (String)this.langID, (String)"The current vertex pair v<sub>i</sub>, v<sub>j</sub>"), LegendItem.createCircleIcon((Color)this.colorVertexPair, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item6", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_EDGESTOREMOVE", (String)this.langID, (String)"The edges of the cycle r that are substituted by (v<sub>i</sub>, v<sub>j</sub>)"), LegendItem.createLineIcon((Color)this.colorEdgesToRemove, (int)this.lineWidthCycleR, (int)4)));
        this.legendView.add(new LegendItem("item7", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_EDGETOADD", (String)this.langID, (String)"The edge (v<sub>i</sub>, v<sub>j</sub>) that substitutes the edges (v<sub>s</sub>, v<sub>i</sub>) ((v<sub>i</sub>, v<sub>s</sub>), resp.) and (v<sub>s</sub>, v<sub>j</sub>) (v<sub>j</sub>, v<sub>s</sub>), resp.)"), LegendItem.createLineIcon((Color)this.colorEdgeToAdd, (int)this.lineWidthCycleR, (int)4)));
        this.legendView.add(new LegendItem("item8", this.savingsView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_SAVINGS_POSITIVESAVINGSVALUE", (String)this.langID, (String)"A positive savings value"), LegendItem.createRectangleIcon((Color)this.colorPositiveSavingsValue, (Color)this.colorPositiveSavingsValue, (int)0)));
        this.legendView.add(new LegendItem("item9", this.savingsView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_SAVINGS_NONPOSITIVESAVINGSVALUE", (String)this.langID, (String)"A non-positive savings value"), LegendItem.createRectangleIcon((Color)this.colorNonPositiveSavingsValue, (Color)this.colorNonPositiveSavingsValue, (int)0)));
        this.legendView.add(new LegendItem("item10", this.listView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_LIST_CURRVERTEXPAIR", (String)this.langID, (String)"The current vertex pair v<sub>i</sub>, v<sub>j</sub>"), LegendItem.createRectangleIcon((Color)this.colorVertexPair, (Color)this.colorVertexPair, (int)0)));
        this.legendView.add(new LegendItem("item11", this.cycleRView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_CYCLE_MODIFICATION", (String)this.langID, (String)"The cycle r becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
    }

    private boolean containsNegativeWeights() {
        Graph graph = this.graphView.getGraph();
        int i = 0;
        while (i < graph.getOrder()) {
            if (((WeightedVertex)graph.getVertex(i)).getWeight() < 0.0f) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < graph.getSize()) {
            if (graph.getEdge(i).getWeight() < 0.0f) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class SavingsRTE
    extends AlgorithmRTE {
        private WeightedVertex v_s;
        private float b_max;
        private Walk<WeightedVertex> r;
        private List<VertexPair> savings;
        private List<VertexPair> list;
        private VertexPair currVertexPair;
        private int edge1_toRemove;
        private int edge2_toRemove;
        private int edge_toAdd;
        private Walk<WeightedVertex> r_Apo;
        private Walk<WeightedVertex> userChoiceR;
        private List<VertexPair> userChoiceSavings;
        private List<VertexPair> userChoiceList;

        public SavingsRTE() {
            super((AlgorithmPlugin)SavingsAlgorithmPlugin.this, SavingsAlgorithmPlugin.this.algoText);
            this.v_s = null;
            this.b_max = 0.0f;
            this.userChoiceR = null;
            this.userChoiceSavings = null;
            this.userChoiceList = null;
        }

        public WeightedVertex getStartVertex() {
            return this.v_s;
        }

        public void setStartVertex(WeightedVertex v) {
            this.v_s = v;
            this.visualizeVertices();
        }

        public void setDeliveryCapacity(float b_max) {
            this.b_max = b_max;
        }

        public boolean checkDeliveryConstraint() {
            if (this.r_Apo == null) {
                return false;
            }
            float currCapacity = 0.0f;
            int i = 1;
            while (i <= this.r_Apo.length()) {
                WeightedVertex v = (WeightedVertex)this.r_Apo.get(i);
                if (v.getID() == this.v_s.getID()) {
                    if (currCapacity > this.b_max) {
                        return false;
                    }
                    currCapacity = 0.0f;
                } else {
                    currCapacity += v.getWeight();
                }
                ++i;
            }
            return true;
        }

        protected int executeStep(int stepID, AlgorithmStateAttachment asa) throws Exception {
            Graph graph = SavingsAlgorithmPlugin.this.graphView.getGraph();
            int nextStep = 0;
            GraphView.VisualEdge ve1_toRemove = null;
            GraphView.VisualEdge ve2_toRemove = null;
            GraphView.VisualEdge ve_toAdd = null;
            switch (stepID) {
                case 1: {
                    GraphView.VisualEdge ve;
                    int i;
                    this.visualizeVertices();
                    this.sleep(250L);
                    if (this.userChoiceR != null) {
                        this.r = this.userChoiceR;
                    } else {
                        this.r = new Walk(graph);
                        this.r.add((Vertex)this.v_s);
                        i = 0;
                        while (i < this.v_s.getOutgoingEdgeCount()) {
                            this.r.add((Vertex)((WeightedVertex)graph.getVertexByID(this.v_s.getOutgoingEdge(i).getSuccessor((Vertex)this.v_s).getID())));
                            this.r.add((Vertex)this.v_s);
                            ++i;
                        }
                    }
                    this.userChoiceR = null;
                    GraphScene scene = new GraphScene((GraphView)SavingsAlgorithmPlugin.this.graphView);
                    scene.begin();
                    i = 0;
                    while (i < SavingsAlgorithmPlugin.this.graphView.getVisualEdgeCount()) {
                        ve = SavingsAlgorithmPlugin.this.graphView.getVisualEdge(i);
                        if (this.r.contains(ve.getEdge())) {
                            ve.setColor(SavingsAlgorithmPlugin.this.colorUsedEdges);
                        } else {
                            ve.setColor(SavingsAlgorithmPlugin.this.colorUnusedEdges);
                        }
                        ++i;
                    }
                    i = 1;
                    while (i <= this.r.length()) {
                        ve = SavingsAlgorithmPlugin.this.graphView.addEdge((WeightedVertex)this.r.get(i - 1), (WeightedVertex)this.r.get(i), true);
                        ve.setColor(SavingsAlgorithmPlugin.this.colorCycleR);
                        ve.setLineWidth(SavingsAlgorithmPlugin.this.lineWidthCycleR);
                        ++i;
                    }
                    SavingsAlgorithmPlugin.this.graphView.repaint();
                    scene.end(false);
                    asa.addAttachment("scene", (Object)scene);
                    this.sleep(250L);
                    SavingsAlgorithmPlugin.this.cycleRView.setBackground(SavingsAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeCycleRAsText();
                    this.sleep(250L);
                    SavingsAlgorithmPlugin.this.cycleRView.setBackground(Color.white);
                    this.sleep(250L);
                    nextStep = 2;
                    break;
                }
                case 2: {
                    this.sleep(250L);
                    this.savings.clear();
                    if (this.userChoiceSavings != null) {
                        this.savings = this.userChoiceSavings;
                    } else {
                        int i = 0;
                        while (i < graph.getOrder()) {
                            int j = i;
                            while (j < graph.getOrder()) {
                                if (i != j && i != this.v_s.getIndex() && j != this.v_s.getIndex()) {
                                    WeightedVertex v_i = (WeightedVertex)graph.getVertex(i);
                                    WeightedVertex v_j = (WeightedVertex)graph.getVertex(j);
                                    Edge eV_sV_i = graph.getEdge((Vertex)this.v_s, (Vertex)v_i);
                                    Edge eV_sV_j = graph.getEdge((Vertex)this.v_s, (Vertex)v_j);
                                    Edge eV_iV_j = graph.getEdge((Vertex)v_i, (Vertex)v_j);
                                    if (eV_sV_i == null || eV_sV_j == null || eV_iV_j == null) {
                                        return -1;
                                    }
                                    GraphView.VisualVertex vv_i = SavingsAlgorithmPlugin.this.graphView.getVisualVertex(v_i);
                                    GraphView.VisualVertex vv_j = SavingsAlgorithmPlugin.this.graphView.getVisualVertex(v_j);
                                    vv_i.setBackground(SavingsAlgorithmPlugin.this.colorVertexPair);
                                    vv_j.setBackground(SavingsAlgorithmPlugin.this.colorVertexPair);
                                    SavingsAlgorithmPlugin.this.graphView.repaint();
                                    this.sleep(500L);
                                    VertexPair vp = new VertexPair(v_i.getID(), v_j.getID(), eV_sV_i.getWeight() + eV_sV_j.getWeight() - eV_iV_j.getWeight());
                                    this.savings.add(vp);
                                    ExecutionTableItem item = new ExecutionTableItem(new Object[]{v_i.getCaption(), v_j.getCaption(), Float.valueOf(vp.savings)}, vp.id);
                                    item.setUserData((Object)vp);
                                    SavingsAlgorithmPlugin.this.savingsView.add(item);
                                    vv_i.setBackground(GraphView.DEF_VERTEXBACKGROUND);
                                    vv_j.setBackground(GraphView.DEF_VERTEXBACKGROUND);
                                    SavingsAlgorithmPlugin.this.graphView.repaint();
                                    this.sleep(500L);
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    this.userChoiceSavings = null;
                    nextStep = 3;
                    break;
                }
                case 3: {
                    if (this.userChoiceList != null) {
                        this.list = this.userChoiceList;
                    } else {
                        VertexPair vp;
                        this.sleep(250L);
                        int i = 0;
                        while (i < this.savings.size()) {
                            vp = this.savings.get(i);
                            ExecutionTableItem item = SavingsAlgorithmPlugin.this.savingsView.getItem(i);
                            if (vp.savings > 0.0f) {
                                item.setBackground(SavingsAlgorithmPlugin.this.colorPositiveSavingsValue);
                                this.sleep(250L);
                                ExecutionTableItem posSavValueItem = new ExecutionTableItem(new Object[]{item.getCellObject(0), item.getCellObject(1), item.getCellObject(2)}, vp.id);
                                posSavValueItem.setUserData((Object)vp);
                                SavingsAlgorithmPlugin.this.listView.add(posSavValueItem);
                            } else {
                                item.setBackground(SavingsAlgorithmPlugin.this.colorNonPositiveSavingsValue);
                            }
                            this.sleep(250L);
                            item.setBackground(Color.white);
                            ++i;
                        }
                        this.sleep(750L);
                        SavingsAlgorithmPlugin.this.listView.sortItems(2, SortOrder.DESCENDING);
                        this.sleep(250L);
                        this.list.clear();
                        i = 0;
                        while (i < SavingsAlgorithmPlugin.this.listView.getItemCount()) {
                            vp = null;
                            int j = 0;
                            while (j < this.savings.size()) {
                                if (this.savings.get((int)j).id == SavingsAlgorithmPlugin.this.listView.getItem(i).getID()) {
                                    vp = this.savings.get(j);
                                    break;
                                }
                                ++j;
                            }
                            if (vp == null) {
                                return -1;
                            }
                            this.list.add(vp);
                            ++i;
                        }
                    }
                    this.userChoiceList = null;
                    nextStep = 4;
                    break;
                }
                case 4: {
                    this.currVertexPair = this.forEachGetNext(this.list);
                    this.sleep(500L);
                    if (this.currVertexPair == null) {
                        nextStep = -1;
                        break;
                    }
                    ExecutionTableItem item = SavingsAlgorithmPlugin.this.listView.getItemByID(this.currVertexPair.id);
                    item.setBackground(SavingsAlgorithmPlugin.this.colorVertexPair);
                    this.sleep(500L);
                    this.visualizeVertices();
                    this.sleep(500L);
                    item.setBackground(Color.white);
                    nextStep = 5;
                    break;
                }
                case 5: {
                    List<Walk<WeightedVertex>> pitchCycles = this.getPitchCycles((Graph<WeightedVertex, Edge>)graph);
                    int[] pitchCycleIndices = this.getPitchCycleIndices((Graph<WeightedVertex, Edge>)graph, this.currVertexPair.v_i, this.currVertexPair.v_j, pitchCycles);
                    boolean diffPitchCycles = pitchCycleIndices[0] >= 0 && pitchCycleIndices[1] >= 0 && pitchCycleIndices[0] != pitchCycleIndices[1];
                    ArrayList<WeightedVertex> r_ApoTmp = new ArrayList<WeightedVertex>();
                    boolean containsV_iV_s = this.containsEdge(this.currVertexPair.v_i, this.v_s.getID());
                    boolean containsV_sV_i = this.containsEdge(this.v_s.getID(), this.currVertexPair.v_i);
                    boolean containsV_jV_s = this.containsEdge(this.currVertexPair.v_j, this.v_s.getID());
                    boolean containsV_sV_j = this.containsEdge(this.v_s.getID(), this.currVertexPair.v_j);
                    if (diffPitchCycles && containsV_iV_s && containsV_sV_j) {
                        int i = 0;
                        while (i < pitchCycles.size()) {
                            Walk<WeightedVertex> currCycle = pitchCycles.get(i);
                            if (i == pitchCycleIndices[0]) {
                                this.connectCycles(r_ApoTmp, currCycle.asList(), 2);
                                this.connectCycles(r_ApoTmp, pitchCycles.get(pitchCycleIndices[1]).asList(), 1);
                            } else if (i != pitchCycleIndices[1]) {
                                this.connectCycles(r_ApoTmp, currCycle.asList());
                            }
                            ++i;
                        }
                        ve1_toRemove = SavingsAlgorithmPlugin.this.graphView.getVisualEdge(this.getDirectedEdge((Graph<WeightedVertex, Edge>)graph, this.currVertexPair.v_i, this.v_s.getID()));
                        ve2_toRemove = SavingsAlgorithmPlugin.this.graphView.getVisualEdge(this.getDirectedEdge((Graph<WeightedVertex, Edge>)graph, this.v_s.getID(), this.currVertexPair.v_j));
                    } else if (diffPitchCycles && containsV_sV_i && containsV_jV_s) {
                        int i = 0;
                        while (i < pitchCycles.size()) {
                            Walk<WeightedVertex> currCycle = pitchCycles.get(i);
                            if (i == pitchCycleIndices[0]) {
                                this.connectCycles(r_ApoTmp, pitchCycles.get(pitchCycleIndices[1]).asList(), 2);
                                this.connectCycles(r_ApoTmp, currCycle.asList(), 1);
                            } else if (i != pitchCycleIndices[1]) {
                                this.connectCycles(r_ApoTmp, currCycle.asList());
                            }
                            ++i;
                        }
                        ve1_toRemove = SavingsAlgorithmPlugin.this.graphView.getVisualEdge(this.getDirectedEdge((Graph<WeightedVertex, Edge>)graph, this.v_s.getID(), this.currVertexPair.v_i));
                        ve2_toRemove = SavingsAlgorithmPlugin.this.graphView.getVisualEdge(this.getDirectedEdge((Graph<WeightedVertex, Edge>)graph, this.currVertexPair.v_j, this.v_s.getID()));
                    } else if (diffPitchCycles && containsV_iV_s && containsV_jV_s) {
                        int i = 0;
                        while (i < pitchCycles.size()) {
                            Walk<WeightedVertex> currCycle = pitchCycles.get(i);
                            if (i == pitchCycleIndices[0]) {
                                this.connectCycles(r_ApoTmp, currCycle.asList(), 2);
                                this.connectCycles(r_ApoTmp, this.reverseCycle(pitchCycles.get(pitchCycleIndices[1]).asList()), 1);
                            } else if (i != pitchCycleIndices[1]) {
                                this.connectCycles(r_ApoTmp, currCycle.asList());
                            }
                            ++i;
                        }
                        ve1_toRemove = SavingsAlgorithmPlugin.this.graphView.getVisualEdge(this.getDirectedEdge((Graph<WeightedVertex, Edge>)graph, this.currVertexPair.v_i, this.v_s.getID()));
                        ve2_toRemove = SavingsAlgorithmPlugin.this.graphView.getVisualEdge(this.getDirectedEdge((Graph<WeightedVertex, Edge>)graph, this.currVertexPair.v_j, this.v_s.getID()));
                    } else if (diffPitchCycles && containsV_sV_i && containsV_sV_j) {
                        int i = 0;
                        while (i < pitchCycles.size()) {
                            Walk<WeightedVertex> currCycle = pitchCycles.get(i);
                            if (i == pitchCycleIndices[0]) {
                                this.connectCycles(r_ApoTmp, this.reverseCycle(currCycle.asList()), 2);
                                this.connectCycles(r_ApoTmp, pitchCycles.get(pitchCycleIndices[1]).asList(), 1);
                            } else if (i != pitchCycleIndices[1]) {
                                this.connectCycles(r_ApoTmp, currCycle.asList());
                            }
                            ++i;
                        }
                        ve1_toRemove = SavingsAlgorithmPlugin.this.graphView.getVisualEdge(this.getDirectedEdge((Graph<WeightedVertex, Edge>)graph, this.v_s.getID(), this.currVertexPair.v_i));
                        ve2_toRemove = SavingsAlgorithmPlugin.this.graphView.getVisualEdge(this.getDirectedEdge((Graph<WeightedVertex, Edge>)graph, this.v_s.getID(), this.currVertexPair.v_j));
                    }
                    if (r_ApoTmp.size() > 0) {
                        this.r_Apo = new Walk(graph, r_ApoTmp);
                        SavingsAlgorithmPlugin.this.cycleR_ApoView.reset();
                        SavingsAlgorithmPlugin.this.cycleR_ApoView.setVisible(true);
                        ve_toAdd = SavingsAlgorithmPlugin.this.graphView.getVisualEdge(graph.getEdge(this.currVertexPair.v_i, this.currVertexPair.v_j));
                        ve1_toRemove.setColor(SavingsAlgorithmPlugin.this.colorEdgesToRemove);
                        ve2_toRemove.setColor(SavingsAlgorithmPlugin.this.colorEdgesToRemove);
                        ve_toAdd.setColor(SavingsAlgorithmPlugin.this.colorEdgeToAdd);
                        ve_toAdd.setLineWidth(SavingsAlgorithmPlugin.this.lineWidthEdgeToAdd);
                        SavingsAlgorithmPlugin.this.graphView.repaint();
                        this.sleep(250L);
                        this.visualizeCycleR_ApoAsText();
                        this.sleep(750L);
                        ve1_toRemove.setColor(SavingsAlgorithmPlugin.this.colorCycleR);
                        ve2_toRemove.setColor(SavingsAlgorithmPlugin.this.colorCycleR);
                        ve_toAdd.setColor(SavingsAlgorithmPlugin.this.colorUnusedEdges);
                        ve_toAdd.setLineWidth(1);
                        SavingsAlgorithmPlugin.this.graphView.repaint();
                        this.edge1_toRemove = ve1_toRemove.getEdge().getID();
                        this.edge2_toRemove = ve2_toRemove.getEdge().getID();
                        this.edge_toAdd = ve_toAdd.getEdge().getID();
                        nextStep = 6;
                        break;
                    }
                    this.r_Apo = null;
                    this.edge1_toRemove = 0;
                    this.edge2_toRemove = 0;
                    this.edge_toAdd = 0;
                    nextStep = 4;
                    break;
                }
                case 6: {
                    ve1_toRemove = SavingsAlgorithmPlugin.this.graphView.getVisualEdgeByID(this.edge1_toRemove);
                    ve2_toRemove = SavingsAlgorithmPlugin.this.graphView.getVisualEdgeByID(this.edge2_toRemove);
                    ve_toAdd = SavingsAlgorithmPlugin.this.graphView.getVisualEdgeByID(this.edge_toAdd);
                    this.edge1_toRemove = 0;
                    this.edge2_toRemove = 0;
                    this.edge_toAdd = 0;
                    ve1_toRemove.setColor(SavingsAlgorithmPlugin.this.colorEdgesToRemove);
                    ve2_toRemove.setColor(SavingsAlgorithmPlugin.this.colorEdgesToRemove);
                    ve_toAdd.setColor(SavingsAlgorithmPlugin.this.colorEdgeToAdd);
                    ve_toAdd.setLineWidth(SavingsAlgorithmPlugin.this.lineWidthEdgeToAdd);
                    SavingsAlgorithmPlugin.this.graphView.repaint();
                    this.sleep(750L);
                    ve1_toRemove.setColor(SavingsAlgorithmPlugin.this.colorCycleR);
                    ve2_toRemove.setColor(SavingsAlgorithmPlugin.this.colorCycleR);
                    ve_toAdd.setColor(SavingsAlgorithmPlugin.this.colorUnusedEdges);
                    ve_toAdd.setLineWidth(1);
                    SavingsAlgorithmPlugin.this.graphView.repaint();
                    if (this.checkDeliveryConstraint()) {
                        GraphView.VisualEdge ve;
                        this.r = this.r_Apo.clone();
                        GraphScene scene = new GraphScene((GraphView)SavingsAlgorithmPlugin.this.graphView);
                        scene.begin();
                        int i = SavingsAlgorithmPlugin.this.graphView.getVisualEdgeCount() - 1;
                        while (i >= 0) {
                            ve = SavingsAlgorithmPlugin.this.graphView.getVisualEdge(i);
                            if (ve.getEdge().isDirected()) {
                                SavingsAlgorithmPlugin.this.graphView.removeEdge(ve);
                            } else if (this.r.contains(ve.getEdge())) {
                                ve.setColor(SavingsAlgorithmPlugin.this.colorUsedEdges);
                            } else {
                                ve.setColor(SavingsAlgorithmPlugin.this.colorUnusedEdges);
                            }
                            --i;
                        }
                        i = 1;
                        while (i <= this.r.length()) {
                            ve = SavingsAlgorithmPlugin.this.graphView.addEdge((WeightedVertex)this.r.get(i - 1), (WeightedVertex)this.r.get(i), true);
                            ve.setColor(SavingsAlgorithmPlugin.this.colorCycleR);
                            ve.setLineWidth(SavingsAlgorithmPlugin.this.lineWidthCycleR);
                            ++i;
                        }
                        scene.end(false);
                        asa.addAttachment("scene", (Object)scene);
                        SavingsAlgorithmPlugin.this.graphView.repaint();
                        this.sleep(250L);
                        SavingsAlgorithmPlugin.this.cycleRView.setBackground(SavingsAlgorithmPlugin.this.colorModified);
                        this.sleep(250L);
                        this.visualizeCycleRAsText();
                        this.sleep(250L);
                        SavingsAlgorithmPlugin.this.cycleRView.setBackground(Color.white);
                        this.sleep(250L);
                    }
                    SavingsAlgorithmPlugin.this.cycleR_ApoView.setVisible(false);
                    nextStep = 4;
                }
            }
            return nextStep;
        }

        protected void storeState(AlgorithmState state) {
            state.addWalk("r", this.r != null ? this.r.cast() : null);
            state.addList("savings", this.savings);
            state.addList("list", this.list);
            state.addObject("currVertexPair", (Serializable)this.currVertexPair);
            state.addInt("edge1_toRemove", this.edge1_toRemove);
            state.addInt("edge2_toRemove", this.edge2_toRemove);
            state.addInt("edgeSurrogate", this.edge_toAdd);
            state.addWalk("r_Apo", this.r_Apo != null ? this.r_Apo.cast() : null);
        }

        protected void restoreState(AlgorithmState state) {
            WalkByID rTmp = state.getWalk("r", SavingsAlgorithmPlugin.this.graphView.getGraph());
            this.r = rTmp != null ? rTmp.cast() : null;
            this.savings = state.getList("savings");
            this.list = state.getList("list");
            this.currVertexPair = (VertexPair)state.getObject("currVertexPair");
            this.edge1_toRemove = state.getInt("edge1_toRemove");
            this.edge2_toRemove = state.getInt("edge2_toRemove");
            this.edge_toAdd = state.getInt("edgeSurrogate");
            WalkByID r_ApoTmp = state.getWalk("r_Apo", SavingsAlgorithmPlugin.this.graphView.getGraph());
            this.r_Apo = r_ApoTmp != null ? r_ApoTmp.cast() : null;
            GraphScene scene = (GraphScene)state.getAttachment("scene");
            if (scene != null) {
                scene.reverse();
            }
        }

        protected void createInitialState(AlgorithmState state) {
            state.addWalk("r", null);
            this.savings = state.addList("savings", new ArrayList());
            this.list = state.addList("list", new ArrayList());
            this.currVertexPair = (VertexPair)state.addObject("currVertexPair", null);
            state.addInt("edge1_toRemove", 0);
            state.addInt("edge2_toRemove", 0);
            state.addInt("edgeSurrogate", 0);
            state.addWalk("r_Apo", null);
            state.addAttachment("scene", null);
        }

        protected void rollBackStep(int stepID, int nextStepID) {
            switch (stepID) {
                case 1: {
                    this.visualizeVertices();
                    this.visualizeCycleRAsText();
                    break;
                }
                case 2: {
                    SavingsAlgorithmPlugin.this.savingsView.removeAllItems();
                    break;
                }
                case 3: {
                    SavingsAlgorithmPlugin.this.listView.removeAllItems();
                    break;
                }
                case 4: {
                    SavingsAlgorithmPlugin.this.cycleR_ApoView.setVisible(false);
                    this.visualizeVertices();
                    break;
                }
                case 6: {
                    SavingsAlgorithmPlugin.this.cycleR_ApoView.setVisible(true);
                    this.visualizeCycleRAsText();
                    this.visualizeCycleR_ApoAsText();
                }
            }
        }

        protected void adoptState(int stepID, AlgorithmState state) {
            switch (stepID) {
                case 1: {
                    this.userChoiceR = state.getWalk("r", SavingsAlgorithmPlugin.this.graphView.getGraph()).cast();
                    break;
                }
                case 2: {
                    this.userChoiceSavings = state.getList("savings");
                    break;
                }
                case 3: {
                    this.userChoiceList = state.getList("list");
                }
            }
        }

        protected View[] getViews() {
            return new View[]{SavingsAlgorithmPlugin.this.graphView, SavingsAlgorithmPlugin.this.cycleRView, SavingsAlgorithmPlugin.this.listView, SavingsAlgorithmPlugin.this.savingsView};
        }

        private void visualizeVertices() {
            int v_s = this.v_s != null ? this.v_s.getID() : 0;
            int v_i = this.currVertexPair != null ? this.currVertexPair.v_i : 0;
            int v_j = this.currVertexPair != null ? this.currVertexPair.v_j : 0;
            int i = 0;
            while (i < SavingsAlgorithmPlugin.this.graphView.getVisualVertexCount()) {
                GraphView.VisualVertex vv = SavingsAlgorithmPlugin.this.graphView.getVisualVertex(i);
                if (((WeightedVertex)vv.getVertex()).getID() == v_s) {
                    vv.setBackground(SavingsAlgorithmPlugin.this.colorStartVertex);
                    vv.setEdgeWidth(SavingsAlgorithmPlugin.this.lineWidthStartVertex);
                } else if (((WeightedVertex)vv.getVertex()).getID() == v_i || ((WeightedVertex)vv.getVertex()).getID() == v_j) {
                    vv.setBackground(SavingsAlgorithmPlugin.this.colorVertexPair);
                    vv.setEdgeWidth(1);
                } else {
                    vv.setBackground(GraphView.DEF_VERTEXBACKGROUND);
                    vv.setEdgeWidth(1);
                }
                ++i;
            }
        }

        private void visualizeCycleRAsText() {
            SavingsAlgorithmPlugin.this.cycleRView.setText(this.r != null ? "r=" + this.r.toString() : "");
        }

        private void visualizeCycleR_ApoAsText() {
            SavingsAlgorithmPlugin.this.cycleR_ApoView.setText(this.r_Apo != null ? "r'=" + this.r_Apo.toString() : "");
        }

        private VertexPair forEachGetNext(List<VertexPair> list) {
            VertexPair next = null;
            if (list.size() > 0) {
                next = list.get(0);
                list.remove(0);
            }
            return next;
        }

        private boolean containsEdge(int v, int u) {
            if (this.r == null) {
                return false;
            }
            int i = 0;
            while (i < this.r.length()) {
                if (((WeightedVertex)this.r.get(i)).getID() == v && ((WeightedVertex)this.r.get(i + 1)).getID() == u) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private Edge getDirectedEdge(Graph<WeightedVertex, Edge> graph, int v, int u) {
            List edges = graph.getEdges(v, u);
            if (edges == null) {
                return null;
            }
            int i = 0;
            while (i < edges.size()) {
                if (((Edge)edges.get(i)).isDirected()) {
                    return (Edge)edges.get(i);
                }
                ++i;
            }
            return null;
        }

        private List<Walk<WeightedVertex>> getPitchCycles(Graph<WeightedVertex, Edge> graph) {
            ArrayList<Walk<WeightedVertex>> pitchCycles = new ArrayList<Walk<WeightedVertex>>();
            Walk currCycle = new Walk(graph);
            boolean open = false;
            int i = 0;
            while (i <= this.r.length()) {
                WeightedVertex v = (WeightedVertex)this.r.get(i);
                currCycle.add((Vertex)v);
                if (!open && v.getID() == this.v_s.getID()) {
                    open = true;
                } else if (open && v.getID() == this.v_s.getID()) {
                    pitchCycles.add((Walk<WeightedVertex>)currCycle);
                    currCycle = new Walk(graph);
                    currCycle.add((Vertex)v);
                    open = true;
                }
                ++i;
            }
            return pitchCycles;
        }

        private int[] getPitchCycleIndices(Graph<WeightedVertex, Edge> graph, int v_i, int v_j, List<Walk<WeightedVertex>> pitchCycles) {
            int[] res = new int[]{-1, -1};
            int i = 0;
            while (i < pitchCycles.size()) {
                Walk<WeightedVertex> currCycle = pitchCycles.get(i);
                if (res[0] < 0 && currCycle.contains((Vertex)((WeightedVertex)graph.getVertexByID(v_i)))) {
                    res[0] = i;
                } else if (res[1] < 0 && currCycle.contains((Vertex)((WeightedVertex)graph.getVertexByID(v_j)))) {
                    res[1] = i;
                }
                if (res[0] >= 0 && res[1] >= 0) break;
                ++i;
            }
            return res;
        }

        private List<WeightedVertex> reverseCycle(List<WeightedVertex> cycle) {
            int i = 0;
            int j = cycle.size() - 1;
            while (i < j) {
                WeightedVertex tmpV = cycle.get(i);
                cycle.set(i, cycle.get(j));
                cycle.set(j, tmpV);
                ++i;
                --j;
            }
            return cycle;
        }

        private void connectCycles(List<WeightedVertex> baseCycle, List<WeightedVertex> pitchCycle) {
            this.connectCycles(baseCycle, pitchCycle, 0);
        }

        private void connectCycles(List<WeightedVertex> baseCycle, List<WeightedVertex> pitchCycle, int option) {
            int start;
            int i = start = baseCycle.size() > 0 && pitchCycle.size() > 0 && baseCycle.get(baseCycle.size() - 1).getID() == pitchCycle.get(0).getID() ? 1 : 0;
            while (i < pitchCycle.size()) {
                if (!(option == 2 && i == pitchCycle.size() - 1 || option == 1 && i == 0)) {
                    baseCycle.add(pitchCycle.get(i));
                }
                ++i;
            }
        }
    }
}

