/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileNameExtensionFilter;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.AlgorithmTextView;
import lavesdk.algorithm.plugin.views.DefaultNetworkView;
import lavesdk.algorithm.plugin.views.DefaultRNView;
import lavesdk.algorithm.plugin.views.GraphLayout;
import lavesdk.algorithm.plugin.views.GraphScene;
import lavesdk.algorithm.plugin.views.GraphTransferProtocol;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.LegendView;
import lavesdk.algorithm.plugin.views.VertexOnlyTransferProtocol;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.plugin.views.custom.CustomVisualFormula;
import lavesdk.algorithm.plugin.views.custom.CustomVisualObject;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.algorithm.text.Annotation;
import lavesdk.algorithm.text.AnnotationImagesList;
import lavesdk.configuration.Configuration;
import lavesdk.gui.dialogs.SolveExerciseDialog;
import lavesdk.gui.dialogs.SolveExercisePane;
import lavesdk.gui.widgets.ColorProperty;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;
import lavesdk.language.LanguageFile;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Path;
import lavesdk.math.graph.PathByID;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.network.Arc;
import lavesdk.math.graph.network.Network;
import lavesdk.math.graph.network.Node;
import lavesdk.math.graph.network.RNEdge;
import lavesdk.math.graph.network.ResidualNetwork;
import lavesdk.math.graph.network.enums.FlowType;
import lavesdk.serialization.Serializer;
import lavesdk.utils.GraphUtils;
import lavesdk.utils.MathUtils;

public class FordFulkersonAlgorithmPlugin
implements AlgorithmPlugin {
    private PluginHost host;
    private Configuration config;
    private LanguageFile langFile;
    private String langID;
    private FileNameExtensionFilter vgfFileFilter;
    private FileNameExtensionFilter pngFileFilter;
    private AlgorithmText algoText;
    private DefaultNetworkView networkView;
    private DefaultRNView residualNetworkView;
    private AlgorithmTextView algoTextView;
    private LegendView legendView;
    private FordFulkersonRTE rte;
    private AnnotationImagesList imgList;
    private ViewGroup ab;
    private ViewGroup cd;
    private ViewGroup abcd;
    private Color colorSource;
    private Color colorSink;
    private Color colorPath;
    private Color colorCurrEdge;
    private int lineWidthPath;
    private int lineWidthMinWeightEdge;
    private static final String CFGKEY_COLOR_SOURCE = "colorSource";
    private static final String CFGKEY_COLOR_SINK = "colorSink";
    private static final String CFGKEY_COLOR_PATH = "colorPath";
    private static final String CFGKEY_COLOR_CURREDGE = "colorCurrEdge";
    private static final String CFGKEY_LINEWIDTH_PATH = "lineWidthPath";
    private static final String CFGKEY_LINEWIDTH_MINWEIGHTEDGE = "lineWidthMinWeightEdge";

    public void initialize(PluginHost host, ResourceLoader resLoader, Configuration config) {
        try {
            this.langFile = new LanguageFile(resLoader.getResourceAsStream("main/resources/langFordFulkerson.txt"));
            this.langFile.include(host.getLanguageFile());
        }
        catch (IOException e) {
            this.langFile = null;
        }
        this.langID = host.getLanguageID();
        this.imgList = new AnnotationImagesList();
        this.imgList.add("network", resLoader.getResource("main/resources/network.png"));
        this.imgList.add("residual-network", resLoader.getResource("main/resources/residual-network.png"));
        this.imgList.add("path", resLoader.getResource("main/resources/path.png"));
        this.imgList.add("network-flow-changed", resLoader.getResource("main/resources/network-flow-changed.png"));
        this.host = host;
        this.config = config != null ? config : new Configuration();
        this.vgfFileFilter = new FileNameExtensionFilter("Visual Graph File (*.vgf)", "vgf");
        this.pngFileFilter = new FileNameExtensionFilter("Portable Network Graphic (*.png)", "png");
        this.networkView = new DefaultNetworkView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_NETWORK_TITLE", (String)this.langID, (String)"Network"), new Network(FlowType.FLOW, new Node("s"), new Node("s")), null, true, this.langFile, this.langID);
        this.residualNetworkView = new DefaultRNView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_RESIDUALNETWORK_TITLE", (String)this.langID, (String)"Residual Network"), this.langFile, this.langID, this.networkView);
        this.algoText = this.loadAlgorithmText();
        this.algoTextView = new AlgorithmTextView(host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ALGOTEXT_TITLE", (String)this.langID, (String)"Algorithm"), this.algoText, true, this.langFile, this.langID);
        this.legendView = new LegendView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LEGEND_TITLE", (String)this.langID, (String)"Legend"), true, this.langFile, this.langID);
        this.rte = new FordFulkersonRTE();
        this.algoTextView.setAutoRepaint(true);
        this.residualNetworkView.setEditable(false);
        this.colorSource = this.config.getColor(CFGKEY_COLOR_SOURCE, new Color(70, 155, 215));
        this.colorSink = this.config.getColor(CFGKEY_COLOR_SINK, new Color(135, 195, 235));
        this.colorPath = this.config.getColor(CFGKEY_COLOR_SOURCE, new Color(200, 145, 145));
        this.colorCurrEdge = this.config.getColor(CFGKEY_COLOR_CURREDGE, new Color(255, 220, 80));
        this.lineWidthPath = this.config.getInt(CFGKEY_LINEWIDTH_PATH, 2);
        this.lineWidthMinWeightEdge = this.config.getInt(CFGKEY_LINEWIDTH_MINWEIGHTEDGE, 4);
        this.networkView.loadConfiguration(config, "networkView");
        this.algoTextView.loadConfiguration(config, "algoTextView");
        this.residualNetworkView.loadConfiguration(config, "residualNetworkView");
        this.legendView.loadConfiguration(config, "legendView");
        this.createLegend();
    }

    public String getName() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_NAME", (String)this.langID, (String)"Ford-Fulkerson algorithm");
    }

    public String getDescription() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_DESC", (String)this.langID, (String)"Finds a flow of maximum strength in a network.");
    }

    public String getType() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_TYPE", (String)this.langID, (String)"Exact algorithm");
    }

    public String getAuthor() {
        return "Jan Dornseifer";
    }

    public String getAuthorContact() {
        return "jan.dornseifer@student.uni-siegen.de";
    }

    public String getAssumptions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_ASSUMPTIONS", (String)this.langID, (String)"A network (G, u, s, t) with flow f.");
    }

    public String getProblemAffiliation() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_PROBLEMAFFILIATION", (String)this.langID, (String)"Flow problem");
    }

    public String getSubject() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_SUBJECT", (String)this.langID, (String)"Logistics");
    }

    public String getInstructions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_INSTRUCTIONS", (String)this.langID, (String)"<b>Creating problem entities</b>:<br>Create your own network and make sure that the network complies with the assumptions of the algorithm.<br><br><b>Exercise Mode</b>:<br>Activate the exercise mode to practice the algorithm in an interactive way. After you have started the algorithm<br>exercises are presented that you have to solve.<br>If an exercise can be solved directly in a view of the algorithm the corresponding view is highlighted with a border, there you can<br>enter your solution and afterwards you have to press the button to solve the exercise. Otherwise (if an exercise is not related to a specific<br>view) you can directly press the button to solve the exercise which opens a dialog where you can enter your solution of the exercise.");
    }

    public String getVersion() {
        return "1.3";
    }

    public LAVESDKV getUsedSDKVersion() {
        return new LAVESDKV(1, 3);
    }

    public AlgorithmRTE getRuntimeEnvironment() {
        return this.rte;
    }

    public AlgorithmText getText() {
        return this.algoText.getBaseCopy();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean hasExerciseMode() {
        return true;
    }

    public boolean hasCreatorPreferences() {
        return false;
    }

    public void loadCreatorPreferences(PropertiesListModel plm) {
    }

    public void onCreate(ViewContainer container, PropertiesListModel creatorProperties) {
        this.networkView.setGraph((Graph)new Network(FlowType.FLOW, new Node("s"), new Node("t")));
        this.networkView.layoutGraph((GraphLayout)this.networkView.createCircleGraphLayout());
        this.networkView.repaint();
        this.ab = new ViewGroup(1);
        this.cd = new ViewGroup(1);
        this.abcd = new ViewGroup(0);
        this.ab.add((Component)this.algoTextView);
        this.ab.add((Component)this.legendView);
        this.ab.restoreWeights((Serializer)this.config, "weights_ab", new float[]{0.6f, 0.4f});
        this.cd.add((Component)this.networkView);
        this.cd.add((Component)this.residualNetworkView);
        this.cd.restoreWeights((Serializer)this.config, "weights_cd", new float[]{0.5f, 0.5f});
        this.abcd.add((Component)this.ab);
        this.abcd.add((Component)this.cd);
        this.abcd.restoreWeights((Serializer)this.config, "weights_abcd", new float[]{0.4f, 0.6f});
        container.setLayout((LayoutManager)new BorderLayout());
        container.add((Component)this.abcd, (Object)"Center");
    }

    public void onClose() {
        this.networkView.saveConfiguration(this.config, "networkView");
        this.algoTextView.saveConfiguration(this.config, "algoTextView");
        this.residualNetworkView.saveConfiguration(this.config, "residualNetworkView");
        this.legendView.saveConfiguration(this.config, "legendView");
        if (this.ab != null) {
            this.ab.storeWeights((Serializer)this.config, "weights_ab");
        }
        if (this.cd != null) {
            this.cd.storeWeights((Serializer)this.config, "weights_cd");
        }
        if (this.abcd != null) {
            this.abcd.storeWeights((Serializer)this.config, "weights_abcd");
        }
        this.networkView.reset();
        this.residualNetworkView.reset();
    }

    public boolean hasCustomization() {
        return true;
    }

    public void loadCustomization(PropertiesListModel plm) {
        plm.add((Property)new ColorProperty("algoTextHighlightForeground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTFOREGROUND", (String)this.langID, (String)"Foreground color of the current step in the algorithm"), this.algoTextView.getHighlightForeground()));
        plm.add((Property)new ColorProperty("algoTextHighlightBackground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTBACKGROUND", (String)this.langID, (String)"Background color of the current step in the algorithm"), this.algoTextView.getHighlightBackground()));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SOURCE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_SOURCE", (String)this.langID, (String)"Background color of the source node in the network"), this.colorSource));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SINK, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_SINK", (String)this.langID, (String)"Background color of the sink node in the network"), this.colorSink));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_PATH, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_PATH", (String)this.langID, (String)"Color of the path in the residual network"), this.colorPath));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_CURREDGE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_CURREDGE", (String)this.langID, (String)"Color of the current edge its flow is modified"), this.colorCurrEdge));
        NumericProperty lwPath = new NumericProperty(CFGKEY_LINEWIDTH_PATH, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_PATH", (String)this.langID, (String)"Line width of the path in the residual network"), (Number)this.lineWidthPath, true);
        lwPath.setMinimum(1);
        lwPath.setMaximum(5);
        plm.add((Property)lwPath);
        NumericProperty lwMinWeightEdge = new NumericProperty(CFGKEY_LINEWIDTH_MINWEIGHTEDGE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_MINWEIGHTEDGE", (String)this.langID, (String)"Line width of the edge in the path with a minimum weight"), (Number)this.lineWidthMinWeightEdge, true);
        lwMinWeightEdge.setMinimum(lwPath.getMinimum());
        lwMinWeightEdge.setMaximum(lwPath.getMaximum() + 3);
        plm.add((Property)lwMinWeightEdge);
    }

    public void applyCustomization(PropertiesListModel plm) {
        this.algoTextView.setHighlightForeground(plm.getColorProperty("algoTextHighlightForeground").getValue());
        this.algoTextView.setHighlightBackground(plm.getColorProperty("algoTextHighlightBackground").getValue());
        this.colorSource = this.config.addColor(CFGKEY_COLOR_SOURCE, plm.getColorProperty(CFGKEY_COLOR_SOURCE).getValue());
        this.colorSink = this.config.addColor(CFGKEY_COLOR_SINK, plm.getColorProperty(CFGKEY_COLOR_SINK).getValue());
        this.colorPath = this.config.addColor(CFGKEY_COLOR_PATH, plm.getColorProperty(CFGKEY_COLOR_PATH).getValue());
        this.colorCurrEdge = this.config.addColor(CFGKEY_COLOR_CURREDGE, plm.getColorProperty(CFGKEY_COLOR_CURREDGE).getValue());
        this.lineWidthPath = this.config.addInt(CFGKEY_LINEWIDTH_PATH, plm.getNumericProperty(CFGKEY_LINEWIDTH_PATH).getValue().intValue());
        this.lineWidthMinWeightEdge = this.config.addInt(CFGKEY_LINEWIDTH_MINWEIGHTEDGE, plm.getNumericProperty(CFGKEY_LINEWIDTH_MINWEIGHTEDGE).getValue().intValue());
        this.createLegend();
    }

    public ToolBarExtension[] getToolBarExtensions() {
        return null;
    }

    public void save(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.networkView.save(file);
            } else if (this.pngFileFilter.accept(file)) {
                this.networkView.saveAsPNG(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE", (String)this.langID, (String)"File could not be saved!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE_TITLE", (String)this.langID, (String)"Save File"), MessageIcon.ERROR);
        }
    }

    public void open(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.networkView.load(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE", (String)this.langID, (String)"File could not be opened!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE_TITLE", (String)this.langID, (String)"Open File"), MessageIcon.ERROR);
        }
    }

    public FileNameExtensionFilter[] getSaveFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter, this.pngFileFilter};
    }

    public FileNameExtensionFilter[] getOpenFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter};
    }

    public void beforeStart(RTEvent e) {
        Network network = this.networkView.getGraph();
        if (!network.checkFlowConservationCondition()) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INVALIDFLOW", (String)this.langID, (String)"You have entered an invalid flow!\nThe flow does not complies with the flow conservation condition."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INVALIDFLOW_TITLE", (String)this.langID, (String)"Invalid flow"), MessageIcon.INFO);
            e.doit = false;
        }
        if (e.doit) {
            CustomVisualFormula flowStrength = new CustomVisualFormula("w(f) = " + network.getFlowStrength(), 5, 5);
            this.residualNetworkView.setGraph((Graph)new ResidualNetwork(network));
            this.residualNetworkView.repaint();
            this.networkView.setEditable(false);
            this.networkView.addVisualObject((CustomVisualObject)flowStrength);
            this.rte.setFlowStrengthDisplay(flowStrength);
        }
    }

    public void beforeResume(RTEvent e) {
    }

    public void beforePause(RTEvent e) {
    }

    public void onStop() {
        this.networkView.setEditable(true);
        this.networkView.removeAllVisualObjects();
        this.residualNetworkView.reset();
        this.rte.setFlowStrengthDisplay(null);
    }

    public void onRunning() {
    }

    public void onPause() {
    }

    private AlgorithmText loadAlgorithmText() {
        AlgorithmText text = new AlgorithmText();
        AlgorithmParagraph rnParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_RESIDUALNETWORK", (String)this.langID, (String)"1. Residual Network:"), 1);
        AlgorithmParagraph apParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_AUGMENTINGPATH", (String)this.langID, (String)"2. Augmenting Path:"), 2);
        AlgorithmParagraph stopParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_STOP", (String)this.langID, (String)"3. Stop:"), 3);
        AlgorithmParagraph expParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_EXPANSION", (String)this.langID, (String)"4. Expansion:"), 4);
        AlgorithmStep step = new AlgorithmStep(rnParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP1", (String)this.langID, (String)"Determine the residual network using _latex{$f$}.\n\n"), 1);
        step.setAnnotation(new Annotation(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP1_ANNOTATION", (String)this.langID, (String)"<b>Residual network</b><br>A residual network (G', u', s, t) to a flow f indicates the residual capacity of a network (G, u, s, t).<br>The weights u' for each edge (v, v') are defined as follows:<br>u'(v, v') := u(v, v') - f(v, v') as well as u'(v', v) := f(v, v')<br>The residual graph G' has the same vertex set as G and in addition to the forward edges e = (v, u) &isin; E with u'(e) > 0 the graph G' contains the backward edges e' = (u, v) too, if u'(e') > 0.<br><br><b>Example</b>:<br><table border=\"0\"><tr><td valign=\"top\">Network (G, u, s, t)</td><td valign=\"top\">Residual network (G', u', s, t)</td><td valign=\"top\"></td></tr><tr><td valign=\"top\"><img src=\"network\"></td><td valign=\"top\"><img src=\"residual-network\"></td><td valign=\"top\">Look at the red marked edges it is:<br>u'(s, 1) = u(s, 1) - f(s, 1) = 5 - 2 = 3 and u'(1, s) = f(s, 1) = 2<br>E.g. the edges (2, s) or (1, 2) are not available in the residual network,<br>because u'(2, s) = f(s, 2) = 0 and u'(1, 2) = u(1, 2) - f(1, 2) = 1 - 1 = 0.</td></tr></table>"), this.imgList));
        step.setExercise(new AlgorithmExercise<Graph<?, ?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP1", (String)this.langID, (String)"Determine the residual network."), 2.0f, (View)this.residualNetworkView){
            private boolean createNewGraph;
            {
                this.createNewGraph = true;
            }

            protected void exited() {
                this.createNewGraph = true;
            }

            protected void beforeRequestSolution(AlgorithmState state) {
                if (this.createNewGraph) {
                    FordFulkersonAlgorithmPlugin.this.residualNetworkView.setGraph((Graph)new ResidualNetwork(FordFulkersonAlgorithmPlugin.this.networkView.getGraph()));
                    FordFulkersonAlgorithmPlugin.this.residualNetworkView.repaint();
                    this.createNewGraph = false;
                }
                FordFulkersonAlgorithmPlugin.this.residualNetworkView.setEditable(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                FordFulkersonAlgorithmPlugin.this.residualNetworkView.setEditable(false);
            }

            protected Graph<?, ?>[] requestSolution() {
                return new Graph[]{FordFulkersonAlgorithmPlugin.this.residualNetworkView.getGraph()};
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, Graph<?, ?>[] solutions) {
                state.addBoolean("userDefinedResidualNetwork", true);
            }

            protected boolean examine(Graph<?, ?>[] results, AlgorithmState state) {
                ResidualNetwork rn = FordFulkersonAlgorithmPlugin.this.networkView.getGraph().getResidualNetwork();
                return results[0].equals((Object)rn);
            }
        });
        step = new AlgorithmStep(apParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP2", (String)this.langID, (String)"Determine a path _latex{$w$} from _latex{$s$} to _latex{$t$} in the residual network, if such a path exists.\n\n"), 2);
        step.setExercise(new AlgorithmExercise<Path<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP2", (String)this.langID, (String)"Determine a path <i>w</i> (<i>select the nodes of the path in the residual network one after another so that a valid path develops or select nothing if their is no path</i>)."), 1.0f, (View)this.residualNetworkView){

            protected void beforeRequestSolution(AlgorithmState state) {
                FordFulkersonAlgorithmPlugin.this.residualNetworkView.setSelectionType(GraphView.SelectionType.VERTICES_ONLY);
                FordFulkersonAlgorithmPlugin.this.residualNetworkView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                FordFulkersonAlgorithmPlugin.this.residualNetworkView.setSelectionType(GraphView.SelectionType.BOTH);
                FordFulkersonAlgorithmPlugin.this.residualNetworkView.setShowCursorToolAlways(false);
                FordFulkersonAlgorithmPlugin.this.residualNetworkView.deselectAll();
            }

            protected Path<?>[] requestSolution() {
                if (FordFulkersonAlgorithmPlugin.this.residualNetworkView.getSelectedVertexCount() == 0) {
                    return new Path[]{new Path((Graph)FordFulkersonAlgorithmPlugin.this.residualNetworkView.getGraph())};
                }
                Path p = new Path((Graph)FordFulkersonAlgorithmPlugin.this.residualNetworkView.getGraph());
                try {
                    int i = 0;
                    while (i < FordFulkersonAlgorithmPlugin.this.residualNetworkView.getSelectedVertexCount()) {
                        p.add(FordFulkersonAlgorithmPlugin.this.residualNetworkView.getSelectedVertex(i).getVertex());
                        ++i;
                    }
                }
                catch (IllegalArgumentException e) {
                    FordFulkersonAlgorithmPlugin.this.host.showMessage((AlgorithmPlugin)FordFulkersonAlgorithmPlugin.this, LanguageFile.getLabel((LanguageFile)FordFulkersonAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP2_MSG_ERR_NOPATH", (String)FordFulkersonAlgorithmPlugin.this.langID, (String)"The specified nodes do not describe a valid path in the residual network!%nChoose the nodes one after another so that a valid path develops."), LanguageFile.getLabel((LanguageFile)FordFulkersonAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP2_MSG_ERR_NOPATH_TITLE", (String)FordFulkersonAlgorithmPlugin.this.langID, (String)"Invalid path"), MessageIcon.ERROR);
                    p = null;
                }
                if (p != null) {
                    return new Path[]{p};
                }
                return null;
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, Path<?>[] solutions) {
                Path<?> w = solutions[0];
                state.addPath("w", w.cast());
            }

            protected boolean examine(Path<?>[] results, AlgorithmState state) {
                Network network = FordFulkersonAlgorithmPlugin.this.networkView.getGraph();
                ResidualNetwork residualNetwork = FordFulkersonAlgorithmPlugin.this.residualNetworkView.getGraph();
                Path p = GraphUtils.findShortestPathFromTo((Graph)residualNetwork, (Vertex)residualNetwork.getVertexByCaption(network.getSource().getCaption()), (Vertex)residualNetwork.getVertexByCaption(network.getSink().getCaption()));
                Path<?> w = results[0];
                if (w.length() == 0) {
                    return p.length() == 0;
                }
                return p.length() > 0 && w.get(0).getCaption().equals(network.getSource().getCaption()) && w.get(w.length()).getCaption().equals(network.getSink().getCaption());
            }
        });
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP3_STOP", (String)this.langID, (String)"If their is no such a path _latex{$w$} "), 3);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Boolean>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP3", (String)this.langID, (String)"Will the algorithm stop?"), 1.0f){
            private final String labelYes;
            private final String labelNo;
            {
                this.labelYes = LanguageFile.getLabel((LanguageFile)FordFulkersonAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP3_YES", (String)FordFulkersonAlgorithmPlugin.this.langID, (String)"Yes");
                this.labelNo = LanguageFile.getLabel((LanguageFile)FordFulkersonAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP3_NO", (String)FordFulkersonAlgorithmPlugin.this.langID, (String)"No");
            }

            protected Boolean[] requestSolution() {
                ButtonGroup group = new ButtonGroup();
                JRadioButton rdobtn1 = new JRadioButton(this.labelYes);
                JRadioButton rdobtn2 = new JRadioButton(this.labelNo);
                group.add(rdobtn1);
                group.add(rdobtn2);
                SolveExerciseDialog.SolutionEntry entryYes = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn1);
                SolveExerciseDialog.SolutionEntry entryNo = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn2);
                if (!SolveExercisePane.showDialog((PluginHost)FordFulkersonAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryYes, entryNo}, (LanguageFile)FordFulkersonAlgorithmPlugin.this.langFile, (String)FordFulkersonAlgorithmPlugin.this.langID)) {
                    return null;
                }
                return new Boolean[]{!rdobtn1.isSelected() && !rdobtn2.isSelected() ? null : Boolean.valueOf(rdobtn1.isSelected())};
            }

            protected String getResultAsString(Boolean result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return result == Boolean.TRUE ? this.labelYes : this.labelNo;
            }

            protected boolean examine(Boolean[] results, AlgorithmState state) {
                PathByID path = state.getPath("w", (Graph)FordFulkersonAlgorithmPlugin.this.residualNetworkView.getGraph());
                return results[0] != null && results[0] == (path == null || path.length() == 0);
            }
        });
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP4_STOP", (String)this.langID, (String)"then stop. Flow _latex{$f$} has maximum strength.\n\n"), 4);
        step = new AlgorithmStep(expParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5", (String)this.langID, (String)"For each edge _latex{$e$} in the path _latex{$w$} set: _latex{$f(e) = f(e) \\; + \\; \\underset{e \\in w}{min} u'(e)$} and go to step 1."), 5);
        step.setAnnotation(new Annotation(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5_ANNOTATION", (String)this.langID, (String)"<b>Example</b><br><img src=\"path\">&nbsp;&nbsp;&nbsp;&nbsp;<img src=\"network-flow-changed\"><br>Figure 1 shows a found path <i>w</i> (marked red) in the residual network.<br>The minimum weight is 1 = min{u'(s, 1), u'(1, 3), u'(3, t)} = min{2, 1, 3}.<br>Figure 2 shows the changed flow f in the network for each edge of the path: f(s, 1) = 3 + 1 = 4, f(1, 3) = 3 + 1 = 4 and f(3, t) = 4 + 1."), this.imgList));
        step.setExercise(new AlgorithmExercise<Map<?, ?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP5", (String)this.langID, (String)"What is the flow <i>f</i> in the network after this step?<br>(<i>Tip: you can select an arc and enter the flow using the keyboard</i>)"), 2.0f, (View)this.networkView){
            private GraphScene<Node, Arc> scene;

            protected void beforeRequestSolution(AlgorithmState state) {
                FordFulkersonAlgorithmPlugin.this.networkView.setSelectionType(GraphView.SelectionType.EDGES_ONLY);
                FordFulkersonAlgorithmPlugin.this.networkView.setHideGraphToolsAlways(true);
                FordFulkersonAlgorithmPlugin.this.networkView.setApplyInputToFlow(true);
                FordFulkersonAlgorithmPlugin.this.networkView.setRestorableEditMode(false);
                FordFulkersonAlgorithmPlugin.this.networkView.setEditable(true);
                this.scene = new GraphScene((GraphView)FordFulkersonAlgorithmPlugin.this.networkView);
                this.scene.begin();
            }

            protected void afterRequestSolution(boolean omitted) {
                FordFulkersonAlgorithmPlugin.this.networkView.setSelectionType(GraphView.SelectionType.BOTH);
                FordFulkersonAlgorithmPlugin.this.networkView.setHideGraphToolsAlways(false);
                FordFulkersonAlgorithmPlugin.this.networkView.setApplyInputToFlow(false);
                FordFulkersonAlgorithmPlugin.this.networkView.setEditable(false);
                FordFulkersonAlgorithmPlugin.this.networkView.setRestorableEditMode(true);
                this.scene.end(true);
                this.scene.reverse();
            }

            protected Map<?, ?>[] requestSolution() {
                Network network = FordFulkersonAlgorithmPlugin.this.networkView.getGraph();
                HashMap<Integer, Float> flow = new HashMap<Integer, Float>();
                int i = 0;
                while (i < network.getSize()) {
                    flow.put(((Arc)network.getEdge(i)).getID(), Float.valueOf(((Arc)network.getEdge(i)).getFlow()));
                    ++i;
                }
                return new Map[]{flow};
            }

            protected String getResultAsString(Map<?, ?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                Network network = FordFulkersonAlgorithmPlugin.this.networkView.getGraph();
                StringBuilder s = new StringBuilder();
                Map<?, ?> flow = result;
                Iterator<?> it = flow.keySet().iterator();
                boolean delimiter = false;
                s.append("[");
                while (it.hasNext()) {
                    if (delimiter) {
                        s.append(", ");
                    }
                    Arc arc = (Arc)network.getEdgeByID(((Integer)it.next()).intValue());
                    Float f = (Float)flow.get(arc.getID());
                    s.append("(" + arc.getPredecessor() + "," + arc.getSuccessor() + ") " + MathUtils.formatFloat((float)f.floatValue()) + "/" + MathUtils.formatFloat((float)arc.getWeight()));
                    delimiter = true;
                }
                s.append("]");
                return s.toString();
            }

            protected boolean examine(Map<?, ?>[] results, AlgorithmState state) {
                Network network = FordFulkersonAlgorithmPlugin.this.networkView.getGraph();
                Map<?, ?> flow = results[0];
                int i = 0;
                while (i < network.getSize()) {
                    Float f = (Float)flow.get(((Arc)network.getEdge(i)).getID());
                    if (f == null || f.floatValue() != ((Arc)network.getEdge(i)).getFlow()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        });
        return text;
    }

    private void createLegend() {
        this.legendView.removeAll();
        this.legendView.add(new LegendItem("item1", this.networkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_NETWORK_SOURCE", (String)this.langID, (String)"The node s (source)"), LegendItem.createCircleIcon((Color)this.colorSource, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item2", this.networkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_NETWORK_SINK", (String)this.langID, (String)"The node t (sink)"), LegendItem.createCircleIcon((Color)this.colorSink, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item3", this.networkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_NETWORK_CURREDGE", (String)this.langID, (String)"The current edge its flow becomes modified"), LegendItem.createLineIcon((Color)this.colorCurrEdge, (int)this.lineWidthPath, (int)4)));
        this.legendView.add(new LegendItem("item4", this.residualNetworkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_RESIDUALNETWORK_PATH", (String)this.langID, (String)"The path w"), LegendItem.createLineIcon((Color)this.colorPath, (int)this.lineWidthPath, (int)4)));
        this.legendView.add(new LegendItem("item5", this.residualNetworkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_RESIDUALNETWORK_MINWEIGHTEDGE", (String)this.langID, (String)"The edge in the path w with a minimum weight"), LegendItem.createLineIcon((Color)this.colorPath, (int)this.lineWidthMinWeightEdge, (int)4)));
        this.legendView.add(new LegendItem("item6", this.residualNetworkView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_RESIDUALNETWORK_CURREDGE", (String)this.langID, (String)"The current edge of the path w"), LegendItem.createLineIcon((Color)this.colorCurrEdge, (int)this.lineWidthPath, (int)4)));
    }

    private class FordFulkersonRTE
    extends AlgorithmRTE {
        private Path<Vertex> w;
        private boolean userDefinedResidualNetwork;
        private Path<Vertex> userChoiceW;
        private CustomVisualFormula flowStrengthDisplay;

        public FordFulkersonRTE() {
            super((AlgorithmPlugin)FordFulkersonAlgorithmPlugin.this, FordFulkersonAlgorithmPlugin.this.algoText);
            this.userDefinedResidualNetwork = false;
            this.userChoiceW = null;
        }

        public void setFlowStrengthDisplay(CustomVisualFormula display) {
            this.flowStrengthDisplay = display;
        }

        protected int executeStep(int stepID, AlgorithmStateAttachment asa) throws Exception {
            Network network = FordFulkersonAlgorithmPlugin.this.networkView.getGraph();
            ResidualNetwork residualNetwork = FordFulkersonAlgorithmPlugin.this.residualNetworkView.getGraph();
            int nextStep = -1;
            switch (stepID) {
                case 1: {
                    this.w = null;
                    GraphView.VisualVertex source = FordFulkersonAlgorithmPlugin.this.networkView.getVisualVertex((Vertex)network.getSource());
                    GraphView.VisualVertex sink = FordFulkersonAlgorithmPlugin.this.networkView.getVisualVertex((Vertex)network.getSink());
                    source.setBackground(FordFulkersonAlgorithmPlugin.this.colorSource);
                    sink.setBackground(FordFulkersonAlgorithmPlugin.this.colorSink);
                    FordFulkersonAlgorithmPlugin.this.networkView.repaint();
                    VertexOnlyTransferProtocol votp = this.userDefinedResidualNetwork ? new VertexOnlyTransferProtocol((GraphView)FordFulkersonAlgorithmPlugin.this.residualNetworkView, false) : new VertexOnlyTransferProtocol((GraphView)FordFulkersonAlgorithmPlugin.this.networkView, false);
                    votp.prepare();
                    asa.addAttachment("votp", (Object)votp);
                    if (!this.userDefinedResidualNetwork) {
                        residualNetwork = network.getResidualNetwork();
                        this.sleep(500L);
                        FordFulkersonAlgorithmPlugin.this.residualNetworkView.setGraph((Graph)residualNetwork);
                        FordFulkersonAlgorithmPlugin.this.residualNetworkView.transferGraph((GraphTransferProtocol)votp);
                        FordFulkersonAlgorithmPlugin.this.residualNetworkView.repaint();
                    }
                    this.visualizeVerticesInResidualNetwork();
                    this.sleep(1000L);
                    this.userDefinedResidualNetwork = false;
                    nextStep = 2;
                    break;
                }
                case 2: {
                    this.w = this.userChoiceW != null ? this.userChoiceW : GraphUtils.findShortestPathFromTo((Graph)residualNetwork, (Vertex)residualNetwork.getVertexByCaption(network.getSource().getCaption()), (Vertex)residualNetwork.getVertexByCaption(network.getSink().getCaption()));
                    this.sleep(250L);
                    this.visualizePathInResidualNetwork();
                    this.sleep(1000L);
                    nextStep = 3;
                    break;
                }
                case 3: {
                    this.sleep(750L);
                    if (this.w == null || this.w.length() == 0) {
                        nextStep = 4;
                        break;
                    }
                    nextStep = 5;
                    break;
                }
                case 4: {
                    this.sleep(750L);
                    nextStep = -1;
                    break;
                }
                case 5: {
                    GraphView.VisualEdge veMinWeight = null;
                    float minWeight = Float.MAX_VALUE;
                    int i = 1;
                    while (i <= this.w.length()) {
                        RNEdge e = (RNEdge)residualNetwork.getEdge(this.w.get(i - 1), this.w.get(i));
                        if (e.getWeight() < minWeight) {
                            minWeight = e.getWeight();
                            veMinWeight = FordFulkersonAlgorithmPlugin.this.residualNetworkView.getVisualEdge((Edge)e);
                        }
                        ++i;
                    }
                    this.sleep(250L);
                    if (veMinWeight != null) {
                        veMinWeight.setLineWidth(FordFulkersonAlgorithmPlugin.this.lineWidthMinWeightEdge);
                        FordFulkersonAlgorithmPlugin.this.residualNetworkView.repaint();
                    }
                    this.sleep(250L);
                    GraphScene networkScene = new GraphScene((GraphView)FordFulkersonAlgorithmPlugin.this.networkView);
                    networkScene.begin();
                    int i2 = 1;
                    while (i2 <= this.w.length()) {
                        boolean reflow;
                        Vertex v = this.w.get(i2 - 1);
                        Vertex u = this.w.get(i2);
                        Arc arc = (Arc)network.getEdge((Vertex)((Node)network.getVertexByCaption(v.getCaption())), (Vertex)((Node)network.getVertexByCaption(u.getCaption())));
                        if (arc == null) {
                            arc = (Arc)network.getEdge((Vertex)((Node)network.getVertexByCaption(u.getCaption())), (Vertex)((Node)network.getVertexByCaption(v.getCaption())));
                            reflow = true;
                        } else {
                            reflow = false;
                        }
                        GraphView.VisualEdge veRN = FordFulkersonAlgorithmPlugin.this.residualNetworkView.getVisualEdge(residualNetwork.getEdge(v, u));
                        GraphView.VisualEdge veN = FordFulkersonAlgorithmPlugin.this.networkView.getVisualEdge((Edge)arc);
                        veRN.setColor(FordFulkersonAlgorithmPlugin.this.colorCurrEdge);
                        FordFulkersonAlgorithmPlugin.this.residualNetworkView.repaint();
                        this.sleep(500L);
                        veN.setColor(FordFulkersonAlgorithmPlugin.this.colorCurrEdge);
                        veN.setLineWidth(FordFulkersonAlgorithmPlugin.this.lineWidthPath);
                        FordFulkersonAlgorithmPlugin.this.networkView.repaint();
                        this.sleep(250L);
                        arc.setFlow(!reflow ? arc.getFlow() + minWeight : arc.getFlow() - minWeight);
                        FordFulkersonAlgorithmPlugin.this.networkView.repaint();
                        this.sleep(500L);
                        veRN.setColor(FordFulkersonAlgorithmPlugin.this.colorPath);
                        FordFulkersonAlgorithmPlugin.this.residualNetworkView.repaint();
                        veN.setColor(GraphView.DEF_EDGECOLOR);
                        veN.setLineWidth(1);
                        FordFulkersonAlgorithmPlugin.this.networkView.repaint();
                        this.sleep(250L);
                        ++i2;
                    }
                    networkScene.end(true);
                    asa.addAttachment("network_scene", (Object)networkScene);
                    if (veMinWeight != null) {
                        veMinWeight.setLineWidth(FordFulkersonAlgorithmPlugin.this.lineWidthPath);
                        FordFulkersonAlgorithmPlugin.this.residualNetworkView.repaint();
                    }
                    this.visualizeFlowStrength();
                    nextStep = 1;
                }
            }
            return nextStep;
        }

        protected void storeState(AlgorithmState state) {
            if (state.getStepID() == 1) {
                state.addAttachment("residual_network", (Object)FordFulkersonAlgorithmPlugin.this.residualNetworkView.getGraph());
            }
            state.addPath("w", this.w != null ? this.w.cast() : null);
        }

        protected void restoreState(AlgorithmState state) {
            PathByID p;
            Graph graph = (Graph)state.getAttachment("residual_network");
            VertexOnlyTransferProtocol votp = (VertexOnlyTransferProtocol)state.getAttachment("votp");
            if (graph != null && votp != null) {
                FordFulkersonAlgorithmPlugin.this.residualNetworkView.setGraph(graph);
                if (graph.getOrder() > 0) {
                    FordFulkersonAlgorithmPlugin.this.residualNetworkView.transferGraph((GraphTransferProtocol)votp);
                }
                FordFulkersonAlgorithmPlugin.this.residualNetworkView.repaint();
            }
            this.w = (p = state.getPath("w", (Graph)FordFulkersonAlgorithmPlugin.this.residualNetworkView.getGraph())) != null ? p.cast() : null;
            GraphScene network_scene = (GraphScene)state.getAttachment("network_scene");
            if (network_scene != null) {
                network_scene.reverse();
            }
        }

        protected void createInitialState(AlgorithmState state) {
            state.addPath("w", null);
            this.w = null;
        }

        protected void rollBackStep(int stepID, int nextStepID) {
            switch (stepID) {
                case 1: {
                    this.visualizeVerticesInResidualNetwork();
                    break;
                }
                case 2: 
                case 5: {
                    this.visualizePathInResidualNetwork();
                    this.visualizeFlowStrength();
                }
            }
        }

        protected void adoptState(int stepID, AlgorithmState state) {
            switch (stepID) {
                case 1: {
                    this.userDefinedResidualNetwork = state.getBoolean("userDefinedResidualNetwork");
                    break;
                }
                case 2: {
                    PathByID p = state.getPath("w", (Graph)FordFulkersonAlgorithmPlugin.this.residualNetworkView.getGraph());
                    this.userChoiceW = p != null ? p.cast() : null;
                }
            }
        }

        protected View[] getViews() {
            return new View[]{FordFulkersonAlgorithmPlugin.this.networkView, FordFulkersonAlgorithmPlugin.this.residualNetworkView};
        }

        private void visualizeVerticesInResidualNetwork() {
            Network network = FordFulkersonAlgorithmPlugin.this.networkView.getGraph();
            GraphView.VisualVertex source = FordFulkersonAlgorithmPlugin.this.residualNetworkView.getVisualVertexByCaption(network.getSource().getCaption());
            GraphView.VisualVertex sink = FordFulkersonAlgorithmPlugin.this.residualNetworkView.getVisualVertexByCaption(network.getSink().getCaption());
            if (source != null && sink != null) {
                source.setBackground(FordFulkersonAlgorithmPlugin.this.colorSource);
                sink.setBackground(FordFulkersonAlgorithmPlugin.this.colorSink);
            }
            FordFulkersonAlgorithmPlugin.this.residualNetworkView.repaint();
        }

        private void visualizePathInResidualNetwork() {
            int i = 0;
            while (i < FordFulkersonAlgorithmPlugin.this.residualNetworkView.getVisualEdgeCount()) {
                GraphView.VisualEdge ve = FordFulkersonAlgorithmPlugin.this.residualNetworkView.getVisualEdge(i);
                if (this.w != null && this.w.contains(ve.getEdge())) {
                    ve.setColor(FordFulkersonAlgorithmPlugin.this.colorPath);
                    ve.setLineWidth(FordFulkersonAlgorithmPlugin.this.lineWidthPath);
                } else {
                    ve.setColor(GraphView.DEF_EDGECOLOR);
                    ve.setLineWidth(1);
                }
                ++i;
            }
            FordFulkersonAlgorithmPlugin.this.residualNetworkView.repaint();
        }

        private void visualizeFlowStrength() {
            if (this.flowStrengthDisplay == null) {
                return;
            }
            this.flowStrengthDisplay.setExpression("w(f) = " + FordFulkersonAlgorithmPlugin.this.networkView.getGraph().getFlowStrength());
            FordFulkersonAlgorithmPlugin.this.networkView.repaint();
        }
    }
}

