/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.BipartiteGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.BipartiteLayoutToolBarExtension;
import lavesdk.algorithm.plugin.extensions.CompleteBipartiteGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.AlgorithmTextView;
import lavesdk.algorithm.plugin.views.DefaultGraphView;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.LegendView;
import lavesdk.algorithm.plugin.views.TextAreaView;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.plugin.views.renderers.DefaultEdgeRenderer;
import lavesdk.algorithm.plugin.views.renderers.EdgeRenderer;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.algorithm.text.Annotation;
import lavesdk.configuration.Configuration;
import lavesdk.gui.dialogs.SolveExerciseDialog;
import lavesdk.gui.dialogs.SolveExercisePane;
import lavesdk.gui.widgets.ColorProperty;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;
import lavesdk.language.LanguageFile;
import lavesdk.math.ElementParser;
import lavesdk.math.Set;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Path;
import lavesdk.math.graph.PathByID;
import lavesdk.math.graph.SimpleGraph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.matching.Matching;
import lavesdk.math.graph.matching.MatchingByID;
import lavesdk.serialization.Serializer;
import lavesdk.utils.GraphUtils;

public class HungarianMethodPlugin
implements AlgorithmPlugin {
    private PluginHost host;
    private Configuration config;
    private LanguageFile langFile;
    private String langID;
    private FileNameExtensionFilter vgfFileFilter;
    private FileNameExtensionFilter pngFileFilter;
    private AlgorithmText algoText;
    private DefaultGraphView graphView;
    private AlgorithmTextView algoTextView;
    private TextAreaView setView;
    private TextAreaView matchingView;
    private LegendView legendView;
    private HungarianRTE rte;
    private BipartiteGraphToolBarExtension<Vertex, Edge> bipartiteExt;
    private CompleteBipartiteGraphToolBarExtension<Vertex, Edge> completeBipartiteExt;
    private BipartiteLayoutToolBarExtension<Vertex, Edge> bipartiteLayoutExt;
    private ViewGroup ab;
    private ViewGroup de;
    private ViewGroup cde;
    private ViewGroup abcde;
    private Color colorModified;
    private Color colorMatchedEdges;
    private Color colorSetS;
    private Color colorCurrVertex;
    private Color colorAugmentingPath;
    private int lineWidthMatchedEdges;
    private int lineWidthCurrVertex;
    private static final String CFGKEY_COLOR_MODIFIED = "colorModified";
    private static final String CFGKEY_COLOR_MATCHEDEDGES = "colorMatchedEdges";
    private static final String CFGKEY_COLOR_SETS = "colorSetS";
    private static final String CFGKEY_COLOR_AUGMENTINGPATH = "colorAugmentingPath";
    private static final String CFGKEY_COLOR_CURRVERTEX = "colorCurrVertex";
    private static final String CFGKEY_LINEWIDTH_MATCHEDEDGES = "lineWidthMatchedEdges";
    private static final String CFGKEY_LINEWIDTH_CURRVERTEX = "lineWidthCurrVertex";

    public void initialize(PluginHost host, ResourceLoader resLoader, Configuration config) {
        try {
            this.langFile = new LanguageFile(resLoader.getResourceAsStream("main/resources/langHungarian.txt"));
            this.langFile.include(host.getLanguageFile());
        }
        catch (IOException e) {
            this.langFile = null;
        }
        this.langID = host.getLanguageID();
        this.host = host;
        this.config = config != null ? config : new Configuration();
        this.vgfFileFilter = new FileNameExtensionFilter("Visual Graph File (*.vgf)", "vgf");
        this.pngFileFilter = new FileNameExtensionFilter("Portable Network Graphic (*.png)", "png");
        this.graphView = new DefaultGraphView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_GRAPH_TITLE", (String)this.langID, (String)"Graph"), (Graph)new SimpleGraph(false), null, true, this.langFile, this.langID);
        this.setView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_SET_TITLE", (String)this.langID, (String)"Set S"), true, this.langFile, this.langID);
        this.matchingView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_MATCHING_TITLE", (String)this.langID, (String)"Matching M"), true, this.langFile, this.langID);
        this.algoText = this.loadAlgorithmText();
        this.algoTextView = new AlgorithmTextView(host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ALGOTEXT_TITLE", (String)this.langID, (String)"Algorithm"), this.algoText, true, this.langFile, this.langID);
        this.legendView = new LegendView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LEGEND_TITLE", (String)this.langID, (String)"Legend"), true, this.langFile, this.langID);
        this.rte = new HungarianRTE();
        this.bipartiteExt = new BipartiteGraphToolBarExtension((GraphView)this.graphView, this.langFile, this.langID, true);
        this.completeBipartiteExt = new CompleteBipartiteGraphToolBarExtension(host, (GraphView)this.graphView, this.langFile, this.langID, false);
        this.bipartiteLayoutExt = new BipartiteLayoutToolBarExtension((GraphView)this.graphView, false, this.langFile, this.langID, false);
        this.algoTextView.setAutoRepaint(true);
        this.setView.setAutoRepaint(true);
        this.matchingView.setAutoRepaint(true);
        this.graphView.setEdgeRenderer((EdgeRenderer)new DefaultEdgeRenderer(false));
        this.colorSetS = this.config.getColor(CFGKEY_COLOR_SETS, new Color(180, 210, 230));
        this.colorCurrVertex = this.config.getColor(CFGKEY_COLOR_CURRVERTEX, new Color(255, 230, 105));
        this.colorMatchedEdges = this.config.getColor(CFGKEY_COLOR_MATCHEDEDGES, Color.black);
        this.colorAugmentingPath = this.config.getColor(CFGKEY_COLOR_AUGMENTINGPATH, new Color(90, 190, 20));
        this.colorModified = this.config.getColor(CFGKEY_COLOR_MODIFIED, new Color(255, 180, 130));
        this.lineWidthCurrVertex = this.config.getInt(CFGKEY_LINEWIDTH_CURRVERTEX, 2);
        this.lineWidthMatchedEdges = this.config.getInt(CFGKEY_LINEWIDTH_MATCHEDEDGES, 3);
        this.graphView.loadConfiguration(config, "graphView");
        this.algoTextView.loadConfiguration(config, "algoTextView");
        this.setView.loadConfiguration(config, "execTableView");
        this.matchingView.loadConfiguration(config, "setsView");
        this.legendView.loadConfiguration(config, "legendView");
        this.createLegend();
    }

    public String getName() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_NAME", (String)this.langID, (String)"Hungarian method");
    }

    public String getDescription() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_DESC", (String)this.langID, (String)"Finds a maximal matching in a graph.");
    }

    public String getType() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_TYPE", (String)this.langID, (String)"Exact algorithm");
    }

    public String getAuthor() {
        return "Jan Dornseifer";
    }

    public String getAuthorContact() {
        return "jan.dornseifer@student.uni-siegen.de";
    }

    public String getAssumptions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_ASSUMPTIONS", (String)this.langID, (String)"A bipartite graph G = (V<sub>1</sub> &cup; V<sub>2</sub>, E), where V<sub>1</sub> is the partition with fewer or equivalent elements and a matching M (poss. M = &Oslash;).");
    }

    public String getProblemAffiliation() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_PROBLEMAFFILIATION", (String)this.langID, (String)"Matching problem");
    }

    public String getSubject() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_SUBJECT", (String)this.langID, (String)"Logistics");
    }

    public String getInstructions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_INSTRUCTIONS", (String)this.langID, (String)"<b>Creating problem entities</b>:<br>Create your own graph and make sure that the graph complies with the assumptions of the algorithm. You can use<br>the toolbar extensions to check whether the created graph is bipartite or complete bipartite, to create a complete bipartite graph<br>by indicating the number of vertices in the particular subsets or you can arrange the vertices of your created graph in a predefined layout.<br><br><b>Starting the algorithm</b>:<br>Before you start the algorithm you can indicate a matching the algorithm should begin with by selecting the edges in the graph.<br>If you don't select anything the algorithm starts with M = &Oslash;.<br><br><b>Exercise Mode</b>:<br>Activate the exercise mode to practice the algorithm in an interactive way. After you have started the algorithm<br>exercises are presented that you have to solve.<br>If an exercise can be solved directly in a view of the algorithm the corresponding view is highlighted with a border, there you can<br>enter your solution and afterwards you have to press the button to solve the exercise. Otherwise (if an exercise is not related to a specific<br>view) you can directly press the button to solve the exercise which opens a dialog where you can enter your solution of the exercise.");
    }

    public String getVersion() {
        return "1.3";
    }

    public LAVESDKV getUsedSDKVersion() {
        return new LAVESDKV(1, 3);
    }

    public AlgorithmRTE getRuntimeEnvironment() {
        return this.rte;
    }

    public AlgorithmText getText() {
        return this.algoText.getBaseCopy();
    }

    public boolean hasExerciseMode() {
        return true;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean hasCreatorPreferences() {
        return false;
    }

    public void loadCreatorPreferences(PropertiesListModel plm) {
    }

    public void onCreate(ViewContainer container, PropertiesListModel creatorProperties) {
        this.graphView.setGraph((Graph)new SimpleGraph(false));
        this.graphView.repaint();
        this.ab = new ViewGroup(1);
        this.de = new ViewGroup(0);
        this.cde = new ViewGroup(1);
        this.abcde = new ViewGroup(0);
        this.ab.add((Component)this.algoTextView);
        this.ab.add((Component)this.legendView);
        this.ab.restoreWeights((Serializer)this.config, "weights_ab", new float[]{0.6f, 0.4f});
        this.de.add((Component)this.setView);
        this.de.add((Component)this.matchingView);
        this.de.restoreWeights((Serializer)this.config, "weights_de", new float[]{0.5f, 0.5f});
        this.cde.add((Component)this.graphView);
        this.cde.add((Component)this.de);
        this.cde.restoreWeights((Serializer)this.config, "weights_cde", new float[]{0.7f, 0.3f});
        this.abcde.add((Component)this.ab);
        this.abcde.add((Component)this.cde);
        this.abcde.restoreWeights((Serializer)this.config, "weights_abcde", new float[]{0.4f, 0.6f});
        container.setLayout((LayoutManager)new BorderLayout());
        container.add((Component)this.abcde, (Object)"Center");
    }

    public void onClose() {
        this.graphView.saveConfiguration(this.config, "graphView");
        this.algoTextView.saveConfiguration(this.config, "algoTextView");
        this.setView.saveConfiguration(this.config, "setView");
        this.matchingView.saveConfiguration(this.config, "matchingView");
        if (this.ab != null) {
            this.ab.storeWeights((Serializer)this.config, "weights_ab");
        }
        if (this.de != null) {
            this.de.storeWeights((Serializer)this.config, "weights_de");
        }
        if (this.cde != null) {
            this.cde.storeWeights((Serializer)this.config, "weights_cde");
        }
        if (this.abcde != null) {
            this.abcde.storeWeights((Serializer)this.config, "weights_abcde");
        }
        this.graphView.reset();
        this.setView.reset();
        this.matchingView.reset();
    }

    public boolean hasCustomization() {
        return true;
    }

    public void loadCustomization(PropertiesListModel plm) {
        plm.add((Property)new ColorProperty("algoTextHighlightForeground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTFOREGROUND", (String)this.langID, (String)"Foreground color of the current step in the algorithm"), this.algoTextView.getHighlightForeground()));
        plm.add((Property)new ColorProperty("algoTextHighlightBackground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTBACKGROUND", (String)this.langID, (String)"Background color of the current step in the algorithm"), this.algoTextView.getHighlightBackground()));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SETS, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_SETS", (String)this.langID, (String)"Background color of the vertices of set S"), this.colorSetS));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_CURRVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_CURRVERTEX", (String)this.langID, (String)"Background color of the vertex v<sub>s</sub>"), this.colorCurrVertex));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MATCHEDEDGES, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MATCHEDEDGES", (String)this.langID, (String)"Color of the matching edges"), this.colorMatchedEdges));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_AUGMENTINGPATH, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_AUGMENTINGPATH", (String)this.langID, (String)"Color of the augmenting path"), this.colorAugmentingPath));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MODIFIED, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MODIFICATIONS", (String)this.langID, (String)"Color of modifications to objects"), this.colorModified));
        NumericProperty lwCurrVertex = new NumericProperty(CFGKEY_LINEWIDTH_CURRVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_CURRVERTEX", (String)this.langID, (String)"Line width of the vertex v<sub>s</sub>"), (Number)this.lineWidthCurrVertex, true);
        lwCurrVertex.setMinimum(1);
        lwCurrVertex.setMaximum(5);
        plm.add((Property)lwCurrVertex);
        NumericProperty lwMatchedEdge = new NumericProperty(CFGKEY_LINEWIDTH_MATCHEDEDGES, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIE_LINEWIDTH_MATCHEDEDGES", (String)this.langID, (String)"Line width of the matching edges"), (Number)this.lineWidthMatchedEdges, true);
        lwMatchedEdge.setMinimum(1);
        lwMatchedEdge.setMaximum(5);
        plm.add((Property)lwMatchedEdge);
    }

    public void applyCustomization(PropertiesListModel plm) {
        this.algoTextView.setHighlightForeground(plm.getColorProperty("algoTextHighlightForeground").getValue());
        this.algoTextView.setHighlightBackground(plm.getColorProperty("algoTextHighlightBackground").getValue());
        this.colorSetS = this.config.addColor(CFGKEY_COLOR_SETS, plm.getColorProperty(CFGKEY_COLOR_SETS).getValue());
        this.colorCurrVertex = this.config.addColor(CFGKEY_COLOR_CURRVERTEX, plm.getColorProperty(CFGKEY_COLOR_CURRVERTEX).getValue());
        this.colorMatchedEdges = this.config.addColor(CFGKEY_COLOR_MATCHEDEDGES, plm.getColorProperty(CFGKEY_COLOR_MATCHEDEDGES).getValue());
        this.colorAugmentingPath = this.config.addColor(CFGKEY_COLOR_AUGMENTINGPATH, plm.getColorProperty(CFGKEY_COLOR_AUGMENTINGPATH).getValue());
        this.colorModified = this.config.addColor(CFGKEY_COLOR_MODIFIED, plm.getColorProperty(CFGKEY_COLOR_MODIFIED).getValue());
        this.lineWidthCurrVertex = this.config.addInt(CFGKEY_LINEWIDTH_CURRVERTEX, plm.getNumericProperty(CFGKEY_LINEWIDTH_CURRVERTEX).getValue().intValue());
        this.lineWidthMatchedEdges = this.config.addInt(CFGKEY_LINEWIDTH_MATCHEDEDGES, plm.getNumericProperty(CFGKEY_LINEWIDTH_MATCHEDEDGES).getValue().intValue());
        this.createLegend();
    }

    public ToolBarExtension[] getToolBarExtensions() {
        return new ToolBarExtension[]{this.bipartiteExt, this.completeBipartiteExt, this.bipartiteLayoutExt};
    }

    public void save(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.save(file);
            } else if (this.pngFileFilter.accept(file)) {
                this.graphView.saveAsPNG(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE", (String)this.langID, (String)"File could not be saved!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE_TITLE", (String)this.langID, (String)"Save File"), MessageIcon.ERROR);
        }
    }

    public void open(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.load(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE", (String)this.langID, (String)"File could not be opened!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE_TITLE", (String)this.langID, (String)"Open File"), MessageIcon.ERROR);
        }
    }

    public FileNameExtensionFilter[] getSaveFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter, this.pngFileFilter};
    }

    public FileNameExtensionFilter[] getOpenFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter};
    }

    public void beforeStart(RTEvent e) {
        Matching<Edge> m = this.getInputMatching();
        if (!this.isGraphBipartite()) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NOTBIPARTITE", (String)this.langID, (String)"The created graph is not bipartite!/nThe Hungarian method can only be applied to bipartite graphs."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NOTBIPARTITE_TITLE", (String)this.langID, (String)"No bipartite graph"), MessageIcon.INFO);
            e.doit = false;
        } else if (m == null) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INVALIDMATCHING", (String)this.langID, (String)"The selected edges do not result in a valid matching!/nDeselect the edges to start with a zero matching."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INVALIDMATCHING_TITLE", (String)this.langID, (String)"Invalid matching"), MessageIcon.INFO);
            e.doit = false;
        }
        if (e.doit) {
            this.graphView.setEditable(false);
            this.graphView.deselectAll();
            this.setView.reset();
            this.matchingView.reset();
            this.rte.setStartMatching(m);
        }
    }

    public void beforeResume(RTEvent e) {
    }

    public void beforePause(RTEvent e) {
    }

    public void onStop() {
        this.graphView.setEditable(true);
    }

    public void onRunning() {
    }

    public void onPause() {
    }

    private AlgorithmText loadAlgorithmText() {
        AlgorithmText text = new AlgorithmText();
        AlgorithmExercise step1_5_8 = new AlgorithmExercise<Set<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP1_5_8", (String)this.langID, (String)"What is <i>S</i>?"), 1.0f){

            protected Set<?>[] requestSolution() {
                SolveExerciseDialog.SolutionEntry entryS = new SolveExerciseDialog.SolutionEntry("S=", (Component)new JTextField());
                if (!SolveExercisePane.showDialog((PluginHost)HungarianMethodPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryS}, (LanguageFile)HungarianMethodPlugin.this.langFile, (String)HungarianMethodPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)HungarianMethodPlugin.this.langFile, (String)"EXERCISE_HINT_SETINPUT", (String)HungarianMethodPlugin.this.langID, (String)"Use a comma as the delimiter!"))) {
                    return null;
                }
                Set.StringElementParser parser = new Set.StringElementParser();
                Set S = Set.parse((String)((JTextField)entryS.getComponent()).getText(), (ElementParser)parser);
                return new Set[]{S};
            }

            protected String getResultAsString(Set<?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                return "S=" + super.getResultAsString(result, index);
            }

            protected boolean examine(Set<?>[] results, AlgorithmState state) {
                Set S = HungarianMethodPlugin.this.toIDs(results[0]);
                return this.doAutoExamine(state, new String[]{"S"}, new Set[]{S});
            }
        };
        AlgorithmParagraph initParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_INITIALIZATION", (String)this.langID, (String)"1. Initialization:"), 1);
        AlgorithmParagraph stopParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_STOPCRITERION", (String)this.langID, (String)"2. Stop criterion:"), 2);
        AlgorithmParagraph apParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_AUGMENTINGPATH", (String)this.langID, (String)"3. Augmenting Path:"), 3);
        AlgorithmParagraph improveParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_IMPROVEMENT", (String)this.langID, (String)"4. Improvement:"), 4);
        AlgorithmStep step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP1_INIT", (String)this.langID, (String)"Let _latex{$S \\subseteq V_1$} be the set of vertices from _latex{$V_1$} that are not endpoint of an matching edge.\n\n"), 1);
        step.setExercise(step1_5_8);
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP2_STOP", (String)this.langID, (String)"If _latex{$S = \\emptyset$} then _latex{$M$} is maximal. Stop.\n\n"), 2);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Boolean>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP2", (String)this.langID, (String)"Will the algorithm stop?"), 1.0f){
            private final String labelYes;
            private final String labelNo;
            {
                this.labelYes = LanguageFile.getLabel((LanguageFile)HungarianMethodPlugin.this.langFile, (String)"EXERCISE_STEP2_YES", (String)HungarianMethodPlugin.this.langID, (String)"Yes");
                this.labelNo = LanguageFile.getLabel((LanguageFile)HungarianMethodPlugin.this.langFile, (String)"EXERCISE_STEP2_NO", (String)HungarianMethodPlugin.this.langID, (String)"No");
            }

            protected Boolean[] requestSolution() {
                ButtonGroup group = new ButtonGroup();
                JRadioButton rdobtn1 = new JRadioButton(this.labelYes);
                JRadioButton rdobtn2 = new JRadioButton(this.labelNo);
                group.add(rdobtn1);
                group.add(rdobtn2);
                SolveExerciseDialog.SolutionEntry entryYes = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn1);
                SolveExerciseDialog.SolutionEntry entryNo = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn2);
                if (!SolveExercisePane.showDialog((PluginHost)HungarianMethodPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryYes, entryNo}, (LanguageFile)HungarianMethodPlugin.this.langFile, (String)HungarianMethodPlugin.this.langID)) {
                    return null;
                }
                return new Boolean[]{!rdobtn1.isSelected() && !rdobtn2.isSelected() ? null : Boolean.valueOf(rdobtn1.isSelected())};
            }

            protected String getResultAsString(Boolean result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return result == Boolean.TRUE ? this.labelYes : this.labelNo;
            }

            protected boolean examine(Boolean[] results, AlgorithmState state) {
                Set S = state.getSet("S");
                return results[0] != null && results[0].booleanValue() == S.isEmpty();
            }
        });
        step = new AlgorithmStep(apParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP3_CHOOSEVERTEX", (String)this.langID, (String)"Choose a vertex _latex{$v_s \\in S$}.\n"), 3);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Integer>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP3", (String)this.langID, (String)"Select v<sub>s</sub>."), 1.0f, (View)this.graphView){

            protected void beforeRequestSolution(AlgorithmState state) {
                HungarianMethodPlugin.this.graphView.setSelectionType(GraphView.SelectionType.VERTICES_ONLY);
                HungarianMethodPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                HungarianMethodPlugin.this.graphView.setSelectionType(GraphView.SelectionType.BOTH);
                HungarianMethodPlugin.this.graphView.setShowCursorToolAlways(false);
                HungarianMethodPlugin.this.graphView.deselectAll();
            }

            protected Integer[] requestSolution() {
                if (HungarianMethodPlugin.this.graphView.getSelectedVertexCount() != 1) {
                    return null;
                }
                return new Integer[]{HungarianMethodPlugin.this.graphView.getSelectedVertex(0).getVertex().getID()};
            }

            protected String getResultAsString(Integer result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return HungarianMethodPlugin.this.graphView.getVisualVertexByID(result.intValue()).getVertex().getCaption();
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, Integer[] solutions) {
                state.addInt("v_s", solutions[0].intValue());
            }

            protected boolean examine(Integer[] results, AlgorithmState state) {
                Set S = state.getSet("S");
                return S.contains((Object)results[0]);
            }
        });
        step = new AlgorithmStep(apParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP4_FINDAUGMENTINGPATH", (String)this.langID, (String)"Starting from _latex{$v_s$} find any path that is eligible as an augmenting path.\n"), 4);
        step.setExercise(new AlgorithmExercise<Path<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP4", (String)this.langID, (String)"Find an augmenting path if possible and select the related vertices in the graph one after another so that a correct path develops (<i>if their is no augmenting path then do not choose anything</i>)."), 2.0f, (View)this.graphView){

            public boolean hasInputHint() {
                return true;
            }

            public Annotation getInputHintMessage(LanguageFile langFile, String langID) {
                return new Annotation(LanguageFile.getLabel((LanguageFile)HungarianMethodPlugin.this.langFile, (String)"EXERCISE_STEP4_INPUTHINT", (String)langID, (String)"<b>Select an augmenting path</b>:<br>Select the vertices of the augmenting path in the graph one after another by using the mouse, while pressing the <b>Ctrl</b>-key<br>on your keyboard.<br>Make sure that a correct path develops. Afterwards click on the \"Solve Exercise\"-button of the task."));
            }

            protected void beforeRequestSolution(AlgorithmState state) {
                HungarianMethodPlugin.this.graphView.setSelectionType(GraphView.SelectionType.VERTICES_ONLY);
                HungarianMethodPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                HungarianMethodPlugin.this.graphView.setSelectionType(GraphView.SelectionType.BOTH);
                HungarianMethodPlugin.this.graphView.setShowCursorToolAlways(false);
                HungarianMethodPlugin.this.graphView.deselectAll();
            }

            protected Path<?>[] requestSolution() {
                if (HungarianMethodPlugin.this.graphView.getSelectedVertexCount() == 0) {
                    return new Path[]{new Path(HungarianMethodPlugin.this.graphView.getGraph())};
                }
                Path p = new Path(HungarianMethodPlugin.this.graphView.getGraph());
                try {
                    int i = 0;
                    while (i < HungarianMethodPlugin.this.graphView.getSelectedVertexCount()) {
                        p.add(HungarianMethodPlugin.this.graphView.getSelectedVertex(i).getVertex());
                        ++i;
                    }
                }
                catch (IllegalArgumentException e) {
                    HungarianMethodPlugin.this.host.showMessage((AlgorithmPlugin)HungarianMethodPlugin.this, LanguageFile.getLabel((LanguageFile)HungarianMethodPlugin.this.langFile, (String)"EXERCISE_STEP4_MSG_ERR_NOPATH", (String)HungarianMethodPlugin.this.langID, (String)"The specified vertices do not describe a valid path in the graph!%nChoose the vertices one after another so that a valid path develops."), LanguageFile.getLabel((LanguageFile)HungarianMethodPlugin.this.langFile, (String)"EXERCISE_STEP4_MSG_ERR_NOPATH_TITLE", (String)HungarianMethodPlugin.this.langID, (String)"Invalid path"), MessageIcon.ERROR);
                    p = null;
                }
                if (p != null) {
                    return new Path[]{p};
                }
                return null;
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, Path<?>[] solutions) {
                Path<?> p = solutions[0];
                state.addPath("AP", p.cast());
            }

            protected boolean examine(Path<?>[] results, AlgorithmState state) {
                Path<?> p = results[0];
                Graph g = HungarianMethodPlugin.this.graphView.getGraph();
                Vertex start = g.getVertexByID(state.getInt("v_s"));
                Matching m = state.getMatching("M", g).cast();
                if (p.length() > 0 && p.get(0) != start) {
                    return false;
                }
                Path ap = GraphUtils.findAugmentingPath((Graph)g, (Vertex)start, (Matching)m);
                if (ap == null) {
                    return p.length() == 0;
                }
                return GraphUtils.isAugmentingPath(p, (Matching)m);
            }
        });
        step = new AlgorithmStep(apParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5_NOAUGMENTINGPATH", (String)this.langID, (String)"If no such augmenting path can be found then put _latex{$S = S \\setminus \\{v_s\\}$} and go to 2. "), 5);
        step.setExercise(step1_5_8);
        step = new AlgorithmStep(apParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP6_AUGMENTINGPATH", (String)this.langID, (String)"Otherwise choose an arbitrary augmenting path (from the just determined) and go to step 4.\n\n"), 6);
        step = new AlgorithmStep(improveParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP7_IMPROVE1", (String)this.langID, (String)"Enlarge the matching with the found augmenting path.\n"), 7);
        step.setExercise(new AlgorithmExercise<Matching<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP7", (String)this.langID, (String)"What is <i>M</i> after this step (<i>select all matched edges in the graph</i>)?"), 1.0f, (View)this.graphView){

            public boolean hasInputHint() {
                return true;
            }

            public Annotation getInputHintMessage(LanguageFile langFile, String langID) {
                return new Annotation(LanguageFile.getLabel((LanguageFile)HungarianMethodPlugin.this.langFile, (String)"EXERCISE_STEP7_INPUTHINT", (String)langID, (String)"<b>Select matched edges</b>:<br>Select the matched edges in the graph by using the mouse and pressing the <b>Ctrl</b>-key on your keyboard.<br>Afterwards click on the \"Solve Exercise\"-button of the task."));
            }

            protected void beforeRequestSolution(AlgorithmState state) {
                HungarianMethodPlugin.this.graphView.setSelectionType(GraphView.SelectionType.EDGES_ONLY);
                HungarianMethodPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                HungarianMethodPlugin.this.graphView.setSelectionType(GraphView.SelectionType.BOTH);
                HungarianMethodPlugin.this.graphView.setShowCursorToolAlways(false);
                HungarianMethodPlugin.this.graphView.deselectAll();
            }

            protected Matching<?>[] requestSolution() {
                if (HungarianMethodPlugin.this.graphView.getSelectedEdgeCount() == 0) {
                    return null;
                }
                Matching m = new Matching(HungarianMethodPlugin.this.graphView.getGraph());
                try {
                    int i = 0;
                    while (i < HungarianMethodPlugin.this.graphView.getSelectedEdgeCount()) {
                        m.add(HungarianMethodPlugin.this.graphView.getSelectedEdge(i).getEdge());
                        ++i;
                    }
                }
                catch (IllegalArgumentException e) {
                    m = null;
                }
                if (m != null) {
                    return new Matching[]{m};
                }
                return new Matching[0];
            }

            protected String getResultAsString(Matching<?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                return "M=" + super.getResultAsString(result, index);
            }

            protected boolean examine(Matching<?>[] results, AlgorithmState state) {
                MatchingByID m = state.getMatching("M", HungarianMethodPlugin.this.graphView.getGraph());
                return results[0].cast().equals((Collection)m);
            }
        });
        step = new AlgorithmStep(improveParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP8_IMPROVE2", (String)this.langID, (String)"Set _latex{$S = S \\setminus \\{v_s\\}$} and go to step 2."), 8);
        step.setExercise(step1_5_8);
        return text;
    }

    private void createLegend() {
        this.legendView.removeAll();
        this.legendView.add(new LegendItem("item1", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_SETS", (String)this.langID, (String)"The vertices of set S that are free meaning no endpoints of a matched edge"), LegendItem.createCircleIcon((Color)this.colorSetS, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item2", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CURRVERTEX", (String)this.langID, (String)"The current vertex v<sub>s</sub>"), LegendItem.createCircleIcon((Color)this.colorCurrVertex, (Color)Color.black, (int)this.lineWidthCurrVertex)));
        this.legendView.add(new LegendItem("item3", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_MATCHEDEDGES", (String)this.langID, (String)"The matched edges of matching M"), LegendItem.createLineIcon((Color)this.colorMatchedEdges, (int)this.lineWidthMatchedEdges, (int)4)));
        this.legendView.add(new LegendItem("item4", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_AUGMENTINGPATH", (String)this.langID, (String)"A found path that is qualified for an augmenting path"), LegendItem.createLineIcon((Color)this.colorAugmentingPath, (int)2, (int)4)));
        this.legendView.add(new LegendItem("item5", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_MATCHINGENLARGEMENT", (String)this.langID, (String)"The unmatched edges of the augmenting path which enlarge the matching M"), LegendItem.createLineIcon((Color)this.colorModified, (int)2, (int)4)));
        this.legendView.add(new LegendItem("item6", this.setView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_SET_MODIFICATION", (String)this.langID, (String)"The set S becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
        this.legendView.add(new LegendItem("item7", this.matchingView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_MATCHING_MODIFICATION", (String)this.langID, (String)"The matching M becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
    }

    private boolean isGraphBipartite() {
        Graph graph = this.graphView.getGraph();
        return GraphUtils.isBipartite((Graph)graph);
    }

    private Matching<Edge> getInputMatching() {
        Matching m = new Matching(this.graphView.getGraph());
        try {
            int i = 0;
            while (i < this.graphView.getSelectedEdgeCount()) {
                m.add(this.graphView.getSelectedEdge(i).getEdge());
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return m;
    }

    private Set<Integer> toIDs(Set<?> set) {
        Graph graph = this.graphView.getGraph();
        Set res = new Set(set.size());
        for (Object caption : set) {
            Vertex v = graph.getVertexByCaption(caption.toString());
            if (v == null) {
                res.add((Object)-1);
                continue;
            }
            res.add((Object)v.getID());
        }
        return res;
    }

    private class HungarianRTE
    extends AlgorithmRTE {
        private Matching<Edge> startMatching;
        private Matching<Edge> M;
        private Set<Integer> S;
        private Path<Vertex> AP;
        private int v_s;
        private int userChoiceV_S;
        private Path<Vertex> userChoiceAP;

        public HungarianRTE() {
            super((AlgorithmPlugin)HungarianMethodPlugin.this, HungarianMethodPlugin.this.algoText);
            this.userChoiceV_S = 0;
            this.userChoiceAP = null;
        }

        public void setStartMatching(Matching<Edge> m) throws IllegalArgumentException {
            if (m == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.startMatching = m;
            this.M = this.startMatching;
            this.visualizeMatching();
            this.visualizeMatchingAsText();
        }

        protected int executeStep(int stepID, AlgorithmStateAttachment asa) throws Exception {
            Graph graph = HungarianMethodPlugin.this.graphView.getGraph();
            int nextStep = -1;
            switch (stepID) {
                case 1: {
                    this.M = this.startMatching.clone();
                    this.sleep(250L);
                    this.visualizeMatching();
                    this.sleep(1000L);
                    HungarianMethodPlugin.this.matchingView.setBackground(HungarianMethodPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeMatchingAsText();
                    this.sleep(250L);
                    HungarianMethodPlugin.this.matchingView.setBackground(Color.white);
                    List subsets = GraphUtils.getBipartiteVertexSets((Graph)graph, (boolean)false);
                    List V1 = ((List)subsets.get(0)).size() <= ((List)subsets.get(1)).size() ? (List)subsets.get(0) : (List)subsets.get(1);
                    for (Vertex v : V1) {
                        if (this.M.isMatched(v)) continue;
                        this.S.add((Object)v.getID());
                    }
                    this.sleep(250L);
                    HungarianMethodPlugin.this.setView.setBackground(HungarianMethodPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeVertices();
                    this.visualizeSetAsText();
                    this.sleep(250L);
                    HungarianMethodPlugin.this.setView.setBackground(Color.white);
                    this.sleep(1000L);
                    nextStep = 2;
                    break;
                }
                case 2: {
                    this.sleep(1000L);
                    if (this.S.isEmpty()) {
                        nextStep = -1;
                        break;
                    }
                    nextStep = 3;
                    break;
                }
                case 3: {
                    this.v_s = this.userChoiceV_S > 0 ? (this.S.contains((Object)this.userChoiceV_S) ? this.userChoiceV_S : (Integer)this.S.get(0)) : (Integer)this.S.get(0);
                    this.userChoiceV_S = 0;
                    this.sleep(250L);
                    this.visualizeVertices();
                    this.sleep(1000L);
                    if (this.v_s < 1) {
                        nextStep = -1;
                        break;
                    }
                    nextStep = 4;
                    break;
                }
                case 4: {
                    Path ap = GraphUtils.findAugmentingPath((Graph)graph, (Vertex)graph.getVertexByID(this.v_s), this.M);
                    this.AP = ap == null ? null : (this.userChoiceAP != null ? this.userChoiceAP : ap);
                    this.userChoiceAP = null;
                    this.sleep(250L);
                    this.visualizeAugmentingPath(HungarianMethodPlugin.this.colorAugmentingPath);
                    this.sleep(1500L);
                    if (this.AP == null) {
                        nextStep = 5;
                        break;
                    }
                    nextStep = 6;
                    break;
                }
                case 5: {
                    this.S.remove((Object)this.v_s);
                    this.sleep(250L);
                    HungarianMethodPlugin.this.setView.setBackground(HungarianMethodPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeSetAsText();
                    this.sleep(250L);
                    HungarianMethodPlugin.this.setView.setBackground(Color.white);
                    this.sleep(250L);
                    this.visualizeVertices();
                    this.sleep(1000L);
                    nextStep = 2;
                    break;
                }
                case 6: {
                    this.sleep(1000L);
                    nextStep = 7;
                    break;
                }
                case 7: {
                    ArrayList<Edge> matchEdges = new ArrayList<Edge>();
                    ArrayList<Edge> unmatchEdges = new ArrayList<Edge>();
                    int i = 0;
                    while (i < this.AP.length()) {
                        if (i % 2 == 0) {
                            matchEdges.add(graph.getEdge(this.AP.get(i), this.AP.get(i + 1)));
                        } else {
                            unmatchEdges.add(graph.getEdge(this.AP.get(i), this.AP.get(i + 1)));
                        }
                        ++i;
                    }
                    for (Edge e : unmatchEdges) {
                        this.M.remove((Object)e);
                    }
                    for (Edge e : matchEdges) {
                        this.M.add(e);
                        GraphView.VisualEdge ve = HungarianMethodPlugin.this.graphView.getVisualEdge(e);
                        if (ve == null) continue;
                        ve.setColor(HungarianMethodPlugin.this.colorModified);
                    }
                    HungarianMethodPlugin.this.graphView.repaint();
                    this.sleep(250L);
                    HungarianMethodPlugin.this.matchingView.setBackground(HungarianMethodPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeMatchingAsText();
                    this.sleep(250L);
                    HungarianMethodPlugin.this.matchingView.setBackground(Color.white);
                    this.sleep(500L);
                    this.visualizeMatching();
                    this.sleep(1000L);
                    nextStep = 8;
                    break;
                }
                case 8: {
                    this.S.remove((Object)this.v_s);
                    this.sleep(250L);
                    HungarianMethodPlugin.this.setView.setBackground(HungarianMethodPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeSetAsText();
                    this.sleep(250L);
                    HungarianMethodPlugin.this.setView.setBackground(Color.white);
                    this.sleep(250L);
                    this.visualizeVertices();
                    this.sleep(1000L);
                    nextStep = 2;
                }
            }
            return nextStep;
        }

        protected void storeState(AlgorithmState state) {
            state.addMatching("M", this.M != null ? this.M.cast() : null);
            state.addSet("S", this.S);
            state.addInt("v_s", this.v_s);
            state.addPath("AP", this.AP != null ? this.AP.cast() : null);
        }

        protected void restoreState(AlgorithmState state) {
            MatchingByID m = state.getMatching("M", HungarianMethodPlugin.this.graphView.getGraph());
            this.M = m != null ? m.cast() : this.startMatching;
            this.S = state.getSet("S");
            this.v_s = state.getInt("v_s");
            PathByID ap = state.getPath("AP", HungarianMethodPlugin.this.graphView.getGraph());
            this.AP = ap != null ? ap.cast() : null;
        }

        protected void createInitialState(AlgorithmState state) {
            state.addMatching("M", null);
            this.S = state.addSet("S", new Set());
            this.v_s = state.addInt("v_s", 0);
            state.addPath("AP", null);
        }

        protected void rollBackStep(int stepID, int nextStepID) {
            this.visualizeVertices();
            this.visualizeMatching();
            this.visualizeMatchingAsText();
            this.visualizeSetAsText();
            if (stepID >= 5 && stepID <= 7) {
                this.visualizeAugmentingPath();
            } else if (stepID == 1) {
                HungarianMethodPlugin.this.matchingView.setText("");
                HungarianMethodPlugin.this.setView.setText("");
            }
        }

        protected void adoptState(int stepID, AlgorithmState state) {
            switch (stepID) {
                case 3: {
                    this.userChoiceV_S = state.getInt("v_s");
                    break;
                }
                case 4: {
                    PathByID ucAP = state.getPath("AP", HungarianMethodPlugin.this.graphView.getGraph());
                    this.userChoiceAP = ucAP != null ? ucAP.cast() : null;
                }
            }
        }

        protected View[] getViews() {
            return new View[]{HungarianMethodPlugin.this.graphView, HungarianMethodPlugin.this.setView, HungarianMethodPlugin.this.matchingView};
        }

        private void visualizeVertices() {
            int i = 0;
            while (i < HungarianMethodPlugin.this.graphView.getVisualVertexCount()) {
                GraphView.VisualVertex vv = HungarianMethodPlugin.this.graphView.getVisualVertex(i);
                if (vv.getVertex().getID() == this.v_s) {
                    vv.setBackground(HungarianMethodPlugin.this.colorCurrVertex);
                    vv.setEdgeWidth(HungarianMethodPlugin.this.lineWidthCurrVertex);
                } else if (this.S.contains((Object)vv.getVertex().getID())) {
                    vv.setBackground(HungarianMethodPlugin.this.colorSetS);
                    vv.setEdgeWidth(1);
                } else {
                    vv.setBackground(GraphView.DEF_VERTEXBACKGROUND);
                    vv.setEdgeWidth(1);
                }
                ++i;
            }
            HungarianMethodPlugin.this.graphView.repaint();
        }

        private void visualizeMatching() {
            if (this.M == null) {
                return;
            }
            int i = 0;
            while (i < HungarianMethodPlugin.this.graphView.getVisualEdgeCount()) {
                GraphView.VisualEdge ve = HungarianMethodPlugin.this.graphView.getVisualEdge(i);
                if (this.M.contains((Object)ve.getEdge())) {
                    ve.setColor(HungarianMethodPlugin.this.colorMatchedEdges);
                    ve.setLineWidth(HungarianMethodPlugin.this.lineWidthMatchedEdges);
                } else {
                    ve.setColor(GraphView.DEF_EDGECOLOR);
                    ve.setLineWidth(1);
                }
                ++i;
            }
            HungarianMethodPlugin.this.graphView.repaint();
        }

        private void visualizeAugmentingPath() {
            this.visualizeAugmentingPath(HungarianMethodPlugin.this.colorAugmentingPath);
        }

        private void visualizeAugmentingPath(Color color) {
            if (this.AP == null) {
                return;
            }
            Graph graph = HungarianMethodPlugin.this.graphView.getGraph();
            int i = 0;
            while (i < this.AP.length()) {
                GraphView.VisualEdge ve = HungarianMethodPlugin.this.graphView.getVisualEdge(graph.getEdge(this.AP.get(i), this.AP.get(i + 1)));
                if (ve != null) {
                    ve.setColor(color);
                    ve.setLineWidth(ve.getLineWidth() + 1);
                }
                ++i;
            }
            HungarianMethodPlugin.this.graphView.repaint();
        }

        private void visualizeSetAsText() {
            HungarianMethodPlugin.this.setView.setText(this.S != null ? "S=" + this.toCaptions(this.S) : "");
        }

        private void visualizeMatchingAsText() {
            HungarianMethodPlugin.this.matchingView.setText(this.M != null ? "M=" + this.M.toString() : "");
        }

        private Set<String> toCaptions(Set<Integer> set) {
            Graph graph = HungarianMethodPlugin.this.graphView.getGraph();
            Set res = new Set(set.size());
            for (Integer id : set) {
                res.add((Object)graph.getVertexByID(id.intValue()).getCaption());
            }
            return res;
        }
    }
}

