/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmExercise;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.AlgorithmState;
import lavesdk.algorithm.AlgorithmStateAttachment;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.CircleLayoutToolBarExtension;
import lavesdk.algorithm.plugin.extensions.CompleteGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.MatrixToGraphToolBarExtension;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.AlgorithmTextView;
import lavesdk.algorithm.plugin.views.DefaultGraphView;
import lavesdk.algorithm.plugin.views.GraphView;
import lavesdk.algorithm.plugin.views.LegendView;
import lavesdk.algorithm.plugin.views.TextAreaView;
import lavesdk.algorithm.plugin.views.View;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.text.AlgorithmParagraph;
import lavesdk.algorithm.text.AlgorithmStep;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.configuration.Configuration;
import lavesdk.gui.dialogs.SolveExerciseDialog;
import lavesdk.gui.dialogs.SolveExercisePane;
import lavesdk.gui.dialogs.enums.AllowedGraphType;
import lavesdk.gui.widgets.BooleanProperty;
import lavesdk.gui.widgets.BooleanPropertyGroup;
import lavesdk.gui.widgets.ColorProperty;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;
import lavesdk.language.LanguageFile;
import lavesdk.math.ElementParser;
import lavesdk.math.Set;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Path;
import lavesdk.math.graph.PathByID;
import lavesdk.math.graph.SimpleGraph;
import lavesdk.math.graph.Vertex;
import lavesdk.serialization.Serializer;
import lavesdk.utils.GraphUtils;

public class NearestNeighborAlgorithmPlugin
implements AlgorithmPlugin {
    private PluginHost host;
    private Configuration config;
    private LanguageFile langFile;
    private String langID;
    private FileNameExtensionFilter vgfFileFilter;
    private FileNameExtensionFilter pngFileFilter;
    private AlgorithmText algoText;
    private DefaultGraphView graphView;
    private AlgorithmTextView algoTextView;
    private TextAreaView cycleView;
    private TextAreaView setView;
    private LegendView legendView;
    private NearestNeighborRTE rte;
    private MatrixToGraphToolBarExtension<Vertex, Edge> matrixToGraph;
    private CompleteGraphToolBarExtension<Vertex, Edge> completeExt;
    private CircleLayoutToolBarExtension<Vertex, Edge> circleLayoutExt;
    private String creatorPrefsDirected;
    private String creatorPrefsUndirected;
    private boolean creatorPrefsDirectedValue;
    private ViewGroup ab;
    private ViewGroup de;
    private ViewGroup cde;
    private ViewGroup abcde;
    private Color colorSetV_Apostrophe;
    private Color colorStartVertex;
    private Color colorCycleR;
    private Color colorV_Akt;
    private Color colorV_Apostrophe;
    private Color colorCurrEdgeMinWeight;
    private Color colorModified;
    private int lineWidthStartVertex;
    private int lineWidthCycleR;
    private int lineWidthV_Akt;
    private int lineWidthCurrEdgeMinWeight;
    private static final String CFGKEY_CREATORPROP_DIRECTED = "creatorPropDirected";
    private static final String CFGKEY_COLOR_SETV_APOSTROPHE = "colorSetV_Apostrophe";
    private static final String CFGKEY_COLOR_STARTVERTEX = "colorStartVertex";
    private static final String CFGKEY_COLOR_CYCLER = "colorCycleR";
    private static final String CFGKEY_COLOR_V_AKT = "colorV_Akt";
    private static final String CFGKEY_COLOR_V_APOSTROPHE = "colorV_Apostrophe";
    private static final String CFGKEY_COLOR_CURREDGEMINWEIGHT = "colorCurrEdgeMinWeight";
    private static final String CFGKEY_COLOR_MODIFIED = "colorModified";
    private static final String CFGKEY_LINEWIDTH_STARTVERTEX = "lineWidthStartVertex";
    private static final String CFGKEY_LINEWIDTH_CYCLER = "lineWidthCycleR";
    private static final String CFGKEY_LINEWIDTH_V_AKT = "lineWidthV_Akt";
    private static final String CFGKEY_LINEWIDTH_CURREDGEMINWEIGHT = "lineWidthCurrEdgeMinWeight";

    public void initialize(PluginHost host, ResourceLoader resLoader, Configuration config) {
        try {
            this.langFile = new LanguageFile(resLoader.getResourceAsStream("main/resources/langNearestNeighbor.txt"));
            this.langFile.include(host.getLanguageFile());
        }
        catch (IOException e) {
            this.langFile = null;
        }
        this.langID = host.getLanguageID();
        this.host = host;
        this.config = config != null ? config : new Configuration();
        this.vgfFileFilter = new FileNameExtensionFilter("Visual Graph File (*.vgf)", "vgf");
        this.pngFileFilter = new FileNameExtensionFilter("Portable Network Graphic (*.png)", "png");
        this.graphView = new DefaultGraphView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_GRAPH_TITLE", (String)this.langID, (String)"Graph"), (Graph)new SimpleGraph(false), null, true, this.langFile, this.langID);
        this.cycleView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_CYCLE_TITLE", (String)this.langID, (String)"Hamiltonian Cycle r"), true, this.langFile, this.langID);
        this.setView = new TextAreaView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_SET_TITLE", (String)this.langID, (String)"Set V'"), true, this.langFile, this.langID);
        this.algoText = this.loadAlgorithmText();
        this.algoTextView = new AlgorithmTextView(host, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_ALGOTEXT_TITLE", (String)this.langID, (String)"Algorithm"), this.algoText, true, this.langFile, this.langID);
        this.legendView = new LegendView(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"VIEW_LEGEND_TITLE", (String)this.langID, (String)"Legend"), true, this.langFile, this.langID);
        this.rte = new NearestNeighborRTE();
        this.matrixToGraph = new MatrixToGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.BOTH, this.langFile, this.langID, true);
        this.completeExt = new CompleteGraphToolBarExtension(host, (GraphView)this.graphView, AllowedGraphType.BOTH, this.langFile, this.langID, true);
        this.circleLayoutExt = new CircleLayoutToolBarExtension((GraphView)this.graphView, this.langFile, this.langID, false);
        this.creatorPrefsDirected = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_DIRECTED", (String)this.langID, (String)"directed");
        this.creatorPrefsUndirected = LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_UNDIRECTED", (String)this.langID, (String)"undirected");
        this.algoTextView.setAutoRepaint(true);
        this.cycleView.setAutoRepaint(true);
        this.setView.setAutoRepaint(true);
        this.creatorPrefsDirectedValue = this.config.getBoolean(CFGKEY_CREATORPROP_DIRECTED, false);
        this.colorSetV_Apostrophe = this.config.getColor(CFGKEY_COLOR_SETV_APOSTROPHE, new Color(180, 210, 230));
        this.colorStartVertex = this.config.getColor(CFGKEY_COLOR_STARTVERTEX, new Color(130, 200, 255));
        this.colorCycleR = this.config.getColor(CFGKEY_COLOR_CYCLER, new Color(200, 145, 145));
        this.colorV_Akt = this.config.getColor(CFGKEY_COLOR_V_AKT, new Color(255, 220, 80));
        this.colorV_Apostrophe = this.config.getColor(CFGKEY_COLOR_V_APOSTROPHE, new Color(235, 190, 80));
        this.colorCurrEdgeMinWeight = this.config.getColor(CFGKEY_COLOR_CURREDGEMINWEIGHT, new Color(50, 110, 150));
        this.colorModified = this.config.getColor(CFGKEY_COLOR_MODIFIED, new Color(255, 180, 130));
        this.lineWidthStartVertex = this.config.getInt(CFGKEY_LINEWIDTH_STARTVERTEX, 2);
        this.lineWidthCycleR = this.config.getInt(CFGKEY_LINEWIDTH_CYCLER, 3);
        this.lineWidthV_Akt = this.config.getInt(CFGKEY_LINEWIDTH_V_AKT, 2);
        this.lineWidthCurrEdgeMinWeight = this.config.getInt(CFGKEY_LINEWIDTH_CURREDGEMINWEIGHT, 3);
        this.graphView.loadConfiguration(config, "graphView");
        this.algoTextView.loadConfiguration(config, "algoTextView");
        this.cycleView.loadConfiguration(config, "cycleView");
        this.setView.loadConfiguration(config, "setView");
        this.legendView.loadConfiguration(config, "legendView");
        this.createLegend();
    }

    public String getName() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_NAME", (String)this.langID, (String)"Nearest neighbor");
    }

    public String getDescription() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_DESC", (String)this.langID, (String)"A starting algorithm to find a Hamiltonian cycle that contains each vertex of a graph exactly once.");
    }

    public String getType() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_TYPE", (String)this.langID, (String)"Heuristic");
    }

    public String getAuthor() {
        return "Jan Dornseifer";
    }

    public String getAuthorContact() {
        return "jan.dornseifer@student.uni-siegen.de";
    }

    public String getAssumptions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_ASSUMPTIONS", (String)this.langID, (String)"A non-negative weighted graph K<sub>n</sub> with n > 2 and a starting vertex v<sub>s</sub>.");
    }

    public String getProblemAffiliation() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_PROBLEMAFFILIATION", (String)this.langID, (String)"Traveling salesman problem");
    }

    public String getSubject() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_SUBJECT", (String)this.langID, (String)"Logistics");
    }

    public String getInstructions() {
        return LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGO_INSTRUCTIONS", (String)this.langID, (String)"<b>Creating problem entities</b>:<br>Create your own graph and make sure that the graph complies with the assumptions of the algorithm. You can use<br>the toolbar extensions to check whether the created graph is complete, to create a complete graph by indicating the number of vertices, to<br>create a graph by use of an adjacency matrix or you can arrange the vertices of your created graph in a circle.<br><br><b>Starting the algorithm</b>:<br>Before you start the algorithm select a vertex v<sub>s</sub> the algorithm should begin with.<br><br><b>Exercise Mode</b>:<br>Activate the exercise mode to practice the algorithm in an interactive way. After you have started the algorithm<br>exercises are presented that you have to solve.<br>If an exercise can be solved directly in a view of the algorithm the corresponding view is highlighted with a border, there you can<br>enter your solution and afterwards you have to press the button to solve the exercise. Otherwise (if an exercise is not related to a specific<br>view) you can directly press the button to solve the exercise which opens a dialog where you can enter your solution of the exercise.");
    }

    public String getVersion() {
        return "1.3";
    }

    public LAVESDKV getUsedSDKVersion() {
        return new LAVESDKV(1, 3);
    }

    public AlgorithmRTE getRuntimeEnvironment() {
        return this.rte;
    }

    public AlgorithmText getText() {
        return this.algoText.getBaseCopy();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean hasExerciseMode() {
        return true;
    }

    public boolean hasCreatorPreferences() {
        return true;
    }

    public void loadCreatorPreferences(PropertiesListModel plm) {
        BooleanPropertyGroup group = new BooleanPropertyGroup(plm);
        plm.add((Property)new BooleanProperty(this.creatorPrefsDirected, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_DIRECTED_DESC", (String)this.langID, (String)"Apply algorithm to a directed graph"), this.creatorPrefsDirectedValue, group));
        plm.add((Property)new BooleanProperty(this.creatorPrefsUndirected, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CREATORPREFS_UNDIRECTED_DESC", (String)this.langID, (String)"Apply algorithm to an undirected graph"), !this.creatorPrefsDirectedValue, group));
    }

    public void onCreate(ViewContainer container, PropertiesListModel creatorProperties) {
        this.creatorPrefsDirectedValue = creatorProperties != null ? creatorProperties.getBooleanProperty(this.creatorPrefsDirected).getValue() : false;
        this.config.addBoolean(CFGKEY_CREATORPROP_DIRECTED, this.creatorPrefsDirectedValue);
        this.graphView.setGraph((Graph)new SimpleGraph(this.creatorPrefsDirectedValue));
        this.graphView.repaint();
        this.matrixToGraph.setAllowedGraphType(this.creatorPrefsDirectedValue ? AllowedGraphType.DIRECTED_ONLY : AllowedGraphType.UNDIRECTED_ONLY);
        this.completeExt.setAllowedGraphType(this.creatorPrefsDirectedValue ? AllowedGraphType.DIRECTED_ONLY : AllowedGraphType.UNDIRECTED_ONLY);
        this.ab = new ViewGroup(1);
        this.de = new ViewGroup(0);
        this.cde = new ViewGroup(1);
        this.abcde = new ViewGroup(0);
        this.ab.add((Component)this.algoTextView);
        this.ab.add((Component)this.legendView);
        this.ab.restoreWeights((Serializer)this.config, "weights_ab", new float[]{0.6f, 0.4f});
        this.de.add((Component)this.cycleView);
        this.de.add((Component)this.setView);
        this.de.restoreWeights((Serializer)this.config, "weights_de", new float[]{0.6f, 0.4f});
        this.cde.add((Component)this.graphView);
        this.cde.add((Component)this.de);
        this.cde.restoreWeights((Serializer)this.config, "weights_cde", new float[]{0.7f, 0.3f});
        this.abcde.add((Component)this.ab);
        this.abcde.add((Component)this.cde);
        this.abcde.restoreWeights((Serializer)this.config, "weights_abcde", new float[]{0.4f, 0.6f});
        container.setLayout((LayoutManager)new BorderLayout());
        container.add((Component)this.abcde, (Object)"Center");
    }

    public void onClose() {
        this.graphView.saveConfiguration(this.config, "graphView");
        this.algoTextView.saveConfiguration(this.config, "algoTextView");
        this.cycleView.saveConfiguration(this.config, "cycleView");
        this.setView.saveConfiguration(this.config, "setView");
        this.legendView.saveConfiguration(this.config, "legendView");
        if (this.ab != null) {
            this.ab.storeWeights((Serializer)this.config, "weights_ab");
        }
        if (this.de != null) {
            this.de.storeWeights((Serializer)this.config, "weights_de");
        }
        if (this.cde != null) {
            this.cde.storeWeights((Serializer)this.config, "weights_cde");
        }
        if (this.abcde != null) {
            this.abcde.storeWeights((Serializer)this.config, "weights_abcde");
        }
        this.graphView.reset();
        this.cycleView.reset();
        this.setView.reset();
    }

    public boolean hasCustomization() {
        return true;
    }

    public void loadCustomization(PropertiesListModel plm) {
        plm.add((Property)new ColorProperty("algoTextHighlightForeground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTFOREGROUND", (String)this.langID, (String)"Foreground color of the current step in the algorithm"), this.algoTextView.getHighlightForeground()));
        plm.add((Property)new ColorProperty("algoTextHighlightBackground", LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_ALGOTEXTHIGHLIGHTBACKGROUND", (String)this.langID, (String)"Background color of the current step in the algorithm"), this.algoTextView.getHighlightBackground()));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_STARTVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_STARTVERTEX", (String)this.langID, (String)"Background color of the starting vertex v<sub>s</sub>"), this.colorStartVertex));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_SETV_APOSTROPHE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_SETV_APOSTROPHE", (String)this.langID, (String)"Background color of the vertices of set V'"), this.colorSetV_Apostrophe));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_CYCLER, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_CYCLER", (String)this.langID, (String)"Color of the Hamiltonian cycle r"), this.colorCycleR));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_V_AKT, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_V_AKT", (String)this.langID, (String)"Background color of the vertex v<sub>akt</sub>"), this.colorV_Akt));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_V_APOSTROPHE, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_V_APOSTROPHE", (String)this.langID, (String)"Background color of the vertex v'"), this.colorV_Apostrophe));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_CURREDGEMINWEIGHT, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_CURREDGEMINWEIGHT", (String)this.langID, (String)"Color of the edge with a currently minimum weight searching for a vertex v'"), this.colorCurrEdgeMinWeight));
        plm.add((Property)new ColorProperty(CFGKEY_COLOR_MODIFIED, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_COLOR_MODIFICATIONS", (String)this.langID, (String)"Color of modifications to objects"), this.colorModified));
        NumericProperty lwStartVertex = new NumericProperty(CFGKEY_LINEWIDTH_STARTVERTEX, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_STARTVERTEX", (String)this.langID, (String)"Line with of the starting vertex v<sub>s</sub>"), (Number)this.lineWidthStartVertex, true);
        lwStartVertex.setMinimum(1);
        lwStartVertex.setMaximum(5);
        plm.add((Property)lwStartVertex);
        NumericProperty lwCycleR = new NumericProperty(CFGKEY_LINEWIDTH_CYCLER, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_CYCLER", (String)this.langID, (String)"Line with of the Hamiltonian cycle r"), (Number)this.lineWidthCycleR, true);
        lwCycleR.setMinimum(1);
        lwCycleR.setMaximum(5);
        plm.add((Property)lwCycleR);
        NumericProperty lwV_Akt = new NumericProperty(CFGKEY_LINEWIDTH_V_AKT, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_V_AKT", (String)this.langID, (String)"Line with of the vertex v<sub>akt</sub>"), (Number)this.lineWidthV_Akt, true);
        lwV_Akt.setMinimum(1);
        lwV_Akt.setMaximum(5);
        plm.add((Property)lwV_Akt);
        NumericProperty lwCurrEdgeMinDist = new NumericProperty(CFGKEY_LINEWIDTH_CURREDGEMINWEIGHT, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"CUSTOMIZE_LINEWIDTH_CURREDGEMINDIST", (String)this.langID, (String)"Line with of the edge with the currently minimum weight"), (Number)this.lineWidthCurrEdgeMinWeight, true);
        lwCurrEdgeMinDist.setMinimum(1);
        lwCurrEdgeMinDist.setMaximum(5);
        plm.add((Property)lwCurrEdgeMinDist);
    }

    public void applyCustomization(PropertiesListModel plm) {
        this.algoTextView.setHighlightForeground(plm.getColorProperty("algoTextHighlightForeground").getValue());
        this.algoTextView.setHighlightBackground(plm.getColorProperty("algoTextHighlightBackground").getValue());
        this.colorStartVertex = this.config.addColor(CFGKEY_COLOR_STARTVERTEX, plm.getColorProperty(CFGKEY_COLOR_STARTVERTEX).getValue());
        this.colorSetV_Apostrophe = this.config.addColor(CFGKEY_COLOR_SETV_APOSTROPHE, plm.getColorProperty(CFGKEY_COLOR_SETV_APOSTROPHE).getValue());
        this.colorCycleR = this.config.addColor(CFGKEY_COLOR_CYCLER, plm.getColorProperty(CFGKEY_COLOR_CYCLER).getValue());
        this.colorV_Akt = this.config.addColor(CFGKEY_COLOR_V_AKT, plm.getColorProperty(CFGKEY_COLOR_V_AKT).getValue());
        this.colorV_Apostrophe = this.config.addColor(CFGKEY_COLOR_V_APOSTROPHE, plm.getColorProperty(CFGKEY_COLOR_V_APOSTROPHE).getValue());
        this.colorCurrEdgeMinWeight = this.config.addColor(CFGKEY_COLOR_CURREDGEMINWEIGHT, plm.getColorProperty(CFGKEY_COLOR_CURREDGEMINWEIGHT).getValue());
        this.colorModified = this.config.addColor(CFGKEY_COLOR_MODIFIED, plm.getColorProperty(CFGKEY_COLOR_MODIFIED).getValue());
        this.lineWidthStartVertex = this.config.addInt(CFGKEY_LINEWIDTH_STARTVERTEX, plm.getNumericProperty(CFGKEY_LINEWIDTH_STARTVERTEX).getValue().intValue());
        this.lineWidthCycleR = this.config.addInt(CFGKEY_LINEWIDTH_CYCLER, plm.getNumericProperty(CFGKEY_LINEWIDTH_CYCLER).getValue().intValue());
        this.lineWidthV_Akt = this.config.addInt(CFGKEY_LINEWIDTH_V_AKT, plm.getNumericProperty(CFGKEY_LINEWIDTH_V_AKT).getValue().intValue());
        this.lineWidthCurrEdgeMinWeight = this.config.addInt(CFGKEY_LINEWIDTH_CURREDGEMINWEIGHT, plm.getNumericProperty(CFGKEY_LINEWIDTH_CURREDGEMINWEIGHT).getValue().intValue());
        this.createLegend();
    }

    public ToolBarExtension[] getToolBarExtensions() {
        return new ToolBarExtension[]{this.matrixToGraph, this.completeExt, this.circleLayoutExt};
    }

    public void save(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.save(file);
            } else if (this.pngFileFilter.accept(file)) {
                this.graphView.saveAsPNG(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE", (String)this.langID, (String)"File could not be saved!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_SAVEFILE_TITLE", (String)this.langID, (String)"Save File"), MessageIcon.ERROR);
        }
    }

    public void open(File file) {
        try {
            if (this.vgfFileFilter.accept(file)) {
                this.graphView.load(file);
            }
        }
        catch (IOException e) {
            this.host.showMessage((AlgorithmPlugin)this, String.valueOf(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE", (String)this.langID, (String)"File could not be opened!")) + "\n\n" + e.getMessage(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_ERROR_OPENFILE_TITLE", (String)this.langID, (String)"Open File"), MessageIcon.ERROR);
        }
    }

    public FileNameExtensionFilter[] getSaveFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter, this.pngFileFilter};
    }

    public FileNameExtensionFilter[] getOpenFileFilters() {
        return new FileNameExtensionFilter[]{this.vgfFileFilter};
    }

    public void beforeStart(RTEvent e) {
        if (this.graphView.getGraph().getOrder() <= 2) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INSUFFICIENTVERTEXCOUNT", (String)this.langID, (String)"The created graph does not comply with the assumptions!\nThe vertex count is insufficient."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_INSUFFICIENTVERTEXCOUNT_TITLE", (String)this.langID, (String)"Invalid graph"), MessageIcon.INFO);
            e.doit = false;
        } else if (this.graphView.getSelectedVertexCount() != 1) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_SELECTSTARTVERTEX", (String)this.langID, (String)"Please select the starting vertex in the graph!"), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_SELECTSTARTVERTEX_TITLE", (String)this.langID, (String)"Select starting vertex"), MessageIcon.INFO);
            e.doit = false;
        } else if (this.containsGraphNegativeWeights()) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NEGATIVEWEIGHTS", (String)this.langID, (String)"The created graph contains edges with a negative weight!\nThe Nearest neighbor algorithm can only be applied to non-negative weighted graphs."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NEGATIVEWEIGHTS_TITLE", (String)this.langID, (String)"Negative weights"), MessageIcon.INFO);
            e.doit = false;
        } else if (!GraphUtils.isComplete((Graph)this.graphView.getGraph())) {
            this.host.showMessage((AlgorithmPlugin)this, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NOTCOMPLETE", (String)this.langID, (String)"The created graph is not complete!\nThe Nearest neighbor algorithm can only be applied to complete graphs."), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"MSG_INFO_NOTCOMPLETE_TITLE", (String)this.langID, (String)"No complete graph"), MessageIcon.INFO);
            e.doit = false;
        }
        if (e.doit) {
            Vertex startVertex = this.graphView.getSelectedVertex(0).getVertex();
            this.graphView.deselectAll();
            this.graphView.setEditable(false);
            this.rte.setStartVertex(startVertex);
            this.cycleView.reset();
            this.setView.reset();
        }
    }

    public void beforeResume(RTEvent e) {
    }

    public void beforePause(RTEvent e) {
    }

    public void onStop() {
        this.graphView.setEditable(true);
    }

    public void onRunning() {
    }

    public void onPause() {
    }

    private AlgorithmText loadAlgorithmText() {
        AlgorithmText text = new AlgorithmText();
        AlgorithmExercise<String> step1_5_8 = new AlgorithmExercise<String>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP1_5_8", (String)this.langID, (String)"What is the current Hamiltonian cycle <i>r</i>?"), 1.0f){

            protected String[] requestSolution() {
                SolveExerciseDialog.SolutionEntry entry = new SolveExerciseDialog.SolutionEntry("r=", (Component)new JTextField());
                if (!SolveExercisePane.showDialog((PluginHost)NearestNeighborAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entry}, (LanguageFile)NearestNeighborAlgorithmPlugin.this.langFile, (String)NearestNeighborAlgorithmPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)NearestNeighborAlgorithmPlugin.this.langFile, (String)"EXERCISE_HINT_CYCLEINPUT", (String)NearestNeighborAlgorithmPlugin.this.langID, (String)"Use a comma as the delimiter!<br>Enter the Hamiltonian cycle in the following form: v<sub>s</sub>, v<sub>i</sub>, v<sub>j</sub>, ..."))) {
                    return null;
                }
                Path p = GraphUtils.toPath((String)((JTextField)entry.getComponent()).getText(), (Graph)NearestNeighborAlgorithmPlugin.this.graphView.getGraph());
                if (p == null) {
                    NearestNeighborAlgorithmPlugin.this.host.showMessage((AlgorithmPlugin)NearestNeighborAlgorithmPlugin.this, LanguageFile.getLabel((LanguageFile)NearestNeighborAlgorithmPlugin.this.langFile, (String)"MSG_INFO_INVALIDCYCLEINPUT", (String)NearestNeighborAlgorithmPlugin.this.langID, (String)"Your input is incorrect!\nPlease enter the Hamiltonian cycle in the specified form and only use vertex captions that are existing."), LanguageFile.getLabel((LanguageFile)NearestNeighborAlgorithmPlugin.this.langFile, (String)"MSG_INFO_INVALIDCYCLEINPUT_TITLE", (String)NearestNeighborAlgorithmPlugin.this.langID, (String)"Invalid input"), MessageIcon.INFO);
                    return null;
                }
                return new String[]{((JTextField)entry.getComponent()).getText()};
            }

            protected String getResultAsString(String result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                if (result.startsWith("(") && result.endsWith(")")) {
                    return "r=" + result;
                }
                return "r=(" + result + ")";
            }

            protected boolean examine(String[] results, AlgorithmState state) {
                PathByID r = state.getPath("r", NearestNeighborAlgorithmPlugin.this.graphView.getGraph());
                Path p = GraphUtils.toPath((String)results[0], (Graph)NearestNeighborAlgorithmPlugin.this.graphView.getGraph());
                return r.equals(p.cast());
            }
        };
        AlgorithmExercise step2_6 = new AlgorithmExercise<Set<?>>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP2_6", (String)this.langID, (String)"What is <i>V'</i>?"), 1.0f){

            protected Set<?>[] requestSolution() {
                SolveExerciseDialog.SolutionEntry entryV_Apo = new SolveExerciseDialog.SolutionEntry("V'=", (Component)new JTextField());
                if (!SolveExercisePane.showDialog((PluginHost)NearestNeighborAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryV_Apo}, (LanguageFile)NearestNeighborAlgorithmPlugin.this.langFile, (String)NearestNeighborAlgorithmPlugin.this.langID, (String)LanguageFile.getLabel((LanguageFile)NearestNeighborAlgorithmPlugin.this.langFile, (String)"EXERCISE_HINT_SETINPUT", (String)NearestNeighborAlgorithmPlugin.this.langID, (String)"Use a comma as the delimiter!"))) {
                    return null;
                }
                Set.StringElementParser parser = new Set.StringElementParser();
                Set V_Apo = Set.parse((String)((JTextField)entryV_Apo.getComponent()).getText(), (ElementParser)parser);
                return new Set[]{V_Apo};
            }

            protected String getResultAsString(Set<?> result, int index) {
                if (result == null) {
                    return super.getResultAsString(result, index);
                }
                return "V'=" + super.getResultAsString(result, index);
            }

            protected boolean examine(Set<?>[] results, AlgorithmState state) {
                Set V_Apo = NearestNeighborAlgorithmPlugin.this.toIDs(results[0]);
                return this.doAutoExamine(state, new String[]{"V_Apo"}, new Set[]{V_Apo});
            }
        };
        AlgorithmParagraph initParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_INITIALIZATION", (String)this.langID, (String)"1. Initialization:"), 1);
        AlgorithmParagraph itParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_ITERATION", (String)this.langID, (String)"2. Iteration:"), 2);
        AlgorithmParagraph expParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_EXPANSION", (String)this.langID, (String)"3. Expansion:"), 3);
        AlgorithmParagraph stopParagraph = new AlgorithmParagraph(text, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_PARAGRAPH_STOP", (String)this.langID, (String)"4. Stop:"), 4);
        AlgorithmStep step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP1_INITR", (String)this.langID, (String)"Let _latex{$r := (v_s)$} and\n"), 1);
        step.setExercise((AlgorithmExercise)step1_5_8);
        step = new AlgorithmStep(initParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP2_INITV_APOSTROPHE", (String)this.langID, (String)"_latex{$V' = V \\setminus \\{v_s\\}$}.\n\n"), 2);
        step.setExercise(step2_6);
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP3_ITERATION", (String)this.langID, (String)"Let _latex{$v_{akt}$} be the last vertex in _latex{$r$} "), 3);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Integer>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP3", (String)this.langID, (String)"Select <i>v<sub>akt</sub></i> in the graph."), 1.0f, (View)this.graphView){

            protected void beforeRequestSolution(AlgorithmState state) {
                NearestNeighborAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.VERTICES_ONLY);
                NearestNeighborAlgorithmPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                NearestNeighborAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.BOTH);
                NearestNeighborAlgorithmPlugin.this.graphView.setShowCursorToolAlways(false);
                NearestNeighborAlgorithmPlugin.this.graphView.deselectAll();
            }

            protected Integer[] requestSolution() {
                if (NearestNeighborAlgorithmPlugin.this.graphView.getSelectedVertexCount() != 1) {
                    return null;
                }
                return new Integer[]{NearestNeighborAlgorithmPlugin.this.graphView.getSelectedVertex(0).getVertex().getID()};
            }

            protected String getResultAsString(Integer result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return NearestNeighborAlgorithmPlugin.this.graphView.getVisualVertexByID(result.intValue()).getVertex().getCaption();
            }

            protected boolean examine(Integer[] results, AlgorithmState state) {
                return this.doAutoExamine(state, new String[]{"v_akt"}, results);
            }
        });
        step = new AlgorithmStep(itParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP4_ITERATION", (String)this.langID, (String)"and _latex{$v' \\in \\; \\underset{v \\in V'}{argmin} \\; c(v_{akt},v)$}.\n\n"), 4);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Integer>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP4", (String)this.langID, (String)"Select <i>v'</i> in the graph."), 1.0f, (View)this.graphView){

            protected void beforeRequestSolution(AlgorithmState state) {
                NearestNeighborAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.VERTICES_ONLY);
                NearestNeighborAlgorithmPlugin.this.graphView.setShowCursorToolAlways(true);
            }

            protected void afterRequestSolution(boolean omitted) {
                NearestNeighborAlgorithmPlugin.this.graphView.setSelectionType(GraphView.SelectionType.BOTH);
                NearestNeighborAlgorithmPlugin.this.graphView.setShowCursorToolAlways(false);
                NearestNeighborAlgorithmPlugin.this.graphView.deselectAll();
            }

            protected Integer[] requestSolution() {
                if (NearestNeighborAlgorithmPlugin.this.graphView.getSelectedVertexCount() != 1) {
                    return null;
                }
                return new Integer[]{NearestNeighborAlgorithmPlugin.this.graphView.getSelectedVertex(0).getVertex().getID()};
            }

            protected String getResultAsString(Integer result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return NearestNeighborAlgorithmPlugin.this.graphView.getVisualVertexByID(result.intValue()).getVertex().getCaption();
            }

            protected boolean getApplySolutionToAlgorithm() {
                return true;
            }

            protected void applySolutionToAlgorithm(AlgorithmState state, Integer[] solutions) {
                state.addInt("v_Apo", solutions[0].intValue());
            }

            protected boolean examine(Integer[] results, AlgorithmState state) {
                Edge e;
                Graph graph = NearestNeighborAlgorithmPlugin.this.graphView.getGraph();
                Vertex vertex_akt = graph.getVertexByID(state.getInt("v_akt"));
                Vertex vertex_apo = graph.getVertexByID(results[0].intValue());
                Set V_Apo = state.getSet("V_Apo");
                float minWeight = Float.MAX_VALUE;
                int i = 0;
                while (i < vertex_akt.getOutgoingEdgeCount()) {
                    e = vertex_akt.getOutgoingEdge(i);
                    Vertex v_apostrophe = e.getSuccessor(vertex_akt);
                    if (V_Apo.contains((Object)v_apostrophe.getID()) && e.getWeight() < minWeight) {
                        minWeight = e.getWeight();
                    }
                    ++i;
                }
                e = graph.getEdge(vertex_akt, vertex_apo);
                return e != null && V_Apo.contains((Object)vertex_apo.getID()) && e.getWeight() == minWeight;
            }
        });
        step = new AlgorithmStep(expParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP5_EXPANSIONR", (String)this.langID, (String)"Add _latex{$v'$} to _latex{$r$}.\n"), 5);
        step.setExercise((AlgorithmExercise)step1_5_8);
        step = new AlgorithmStep(expParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP6_EXPANSIONV_APOSTROPHE", (String)this.langID, (String)"Set _latex{$V' = V' \\setminus \\{v'\\}$}.\n"), 6);
        step.setExercise(step2_6);
        step = new AlgorithmStep(expParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP7_EXPANSION", (String)this.langID, (String)"If _latex{$V' \\neq \\emptyset$} then go to 2.\n\n"), 7);
        step.setExercise((AlgorithmExercise)new AlgorithmExercise<Boolean>(LanguageFile.getLabel((LanguageFile)this.langFile, (String)"EXERCISE_STEP7", (String)this.langID, (String)"Into what step will the algorithm pass?"), 1.0f){
            private final String labelIteration;
            private final String labelStop;
            {
                this.labelIteration = LanguageFile.getLabel((LanguageFile)NearestNeighborAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP7_ITERATION", (String)NearestNeighborAlgorithmPlugin.this.langID, (String)"2. Iteration");
                this.labelStop = LanguageFile.getLabel((LanguageFile)NearestNeighborAlgorithmPlugin.this.langFile, (String)"EXERCISE_STEP7_STOP", (String)NearestNeighborAlgorithmPlugin.this.langID, (String)"4. Stop");
            }

            protected Boolean[] requestSolution() {
                ButtonGroup group = new ButtonGroup();
                JRadioButton rdobtn1 = new JRadioButton(this.labelIteration);
                JRadioButton rdobtn2 = new JRadioButton(this.labelStop);
                group.add(rdobtn1);
                group.add(rdobtn2);
                SolveExerciseDialog.SolutionEntry entryIt = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn1);
                SolveExerciseDialog.SolutionEntry entryStop = new SolveExerciseDialog.SolutionEntry("", (Component)rdobtn2);
                if (!SolveExercisePane.showDialog((PluginHost)NearestNeighborAlgorithmPlugin.this.host, (AlgorithmExercise)this, (SolveExerciseDialog.SolutionEntry[])new SolveExerciseDialog.SolutionEntry[]{entryIt, entryStop}, (LanguageFile)NearestNeighborAlgorithmPlugin.this.langFile, (String)NearestNeighborAlgorithmPlugin.this.langID)) {
                    return null;
                }
                return new Boolean[]{rdobtn1.isSelected()};
            }

            protected String getResultAsString(Boolean result, int index) {
                if (result == null) {
                    return super.getResultAsString((Object)result, index);
                }
                return result == Boolean.TRUE ? this.labelIteration : this.labelStop;
            }

            protected boolean examine(Boolean[] results, AlgorithmState state) {
                Set V_Apo = state.getSet("V_Apo");
                return results[0] == !V_Apo.isEmpty();
            }
        });
        step = new AlgorithmStep(stopParagraph, LanguageFile.getLabel((LanguageFile)this.langFile, (String)"ALGOTEXT_STEP8_STOP", (String)this.langID, (String)"Add _latex{$v_s$} to _latex{$r$} so that a cycle develops."), 8);
        step.setExercise((AlgorithmExercise)step1_5_8);
        return text;
    }

    private void createLegend() {
        this.legendView.removeAll();
        this.legendView.add(new LegendItem("item1", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_STARTVERTEX", (String)this.langID, (String)"The starting vertex v<sub>s</sub>"), LegendItem.createCircleIcon((Color)this.colorStartVertex, (Color)Color.black, (int)this.lineWidthStartVertex)));
        this.legendView.add(new LegendItem("item2", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_SETV_APOSTROPHE", (String)this.langID, (String)"The vertices of the set V'"), LegendItem.createCircleIcon((Color)this.colorSetV_Apostrophe, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item3", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CYCLER", (String)this.langID, (String)"The Hamiltonian cycle r"), LegendItem.createLineIcon((Color)this.colorCycleR, (int)this.lineWidthCycleR, (int)4)));
        this.legendView.add(new LegendItem("item4", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_V_AKT", (String)this.langID, (String)"The vertex v<sub>akt</sub>"), LegendItem.createCircleIcon((Color)this.colorV_Akt, (Color)Color.black, (int)this.lineWidthV_Akt)));
        this.legendView.add(new LegendItem("item5", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_V_APOSTROPHE", (String)this.langID, (String)"The vertex v'"), LegendItem.createCircleIcon((Color)this.colorV_Apostrophe, (Color)Color.black, (int)1)));
        this.legendView.add(new LegendItem("item6", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_CURREDGEMINWEIGHT", (String)this.langID, (String)"The current edge with the minimum weight searching for a vertex v'"), LegendItem.createLineIcon((Color)this.colorCurrEdgeMinWeight, (int)this.lineWidthCurrEdgeMinWeight, (int)4)));
        this.legendView.add(new LegendItem("item7", this.graphView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_GRAPH_EDGESMINWEIGHT", (String)this.langID, (String)"The edges that are investigated searching for a vertex v'"), LegendItem.createLineIcon((Color)this.colorCurrEdgeMinWeight, (int)1, (int)4)));
        this.legendView.add(new LegendItem("item8", this.cycleView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_CYCLE_MODIFICATION", (String)this.langID, (String)"The Hamiltonian cycle r becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
        this.legendView.add(new LegendItem("item9", this.setView.getTitle(), LanguageFile.getLabel((LanguageFile)this.langFile, (String)"LEGEND_SET_MODIFICATION", (String)this.langID, (String)"The set V' becomes modified"), LegendItem.createRectangleIcon((Color)this.colorModified, (Color)this.colorModified, (int)0)));
    }

    private Set<Integer> toIDs(Set<?> set) {
        Graph graph = this.graphView.getGraph();
        Set res = new Set(set.size());
        for (Object caption : set) {
            Vertex v = graph.getVertexByCaption(caption.toString());
            if (v == null) {
                res.add((Object)-1);
                continue;
            }
            res.add((Object)v.getID());
        }
        return res;
    }

    private boolean containsGraphNegativeWeights() {
        Graph graph = this.graphView.getGraph();
        int i = 0;
        while (i < graph.getSize()) {
            if (graph.getEdge(i).getWeight() < 0.0f) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class NearestNeighborRTE
    extends AlgorithmRTE {
        private Vertex v_s;
        private Path<Vertex> r;
        private Set<Integer> V_Apo;
        private int v_akt;
        private int v_Apo;
        private int userChoice_v_Apo;

        public NearestNeighborRTE() {
            super((AlgorithmPlugin)NearestNeighborAlgorithmPlugin.this, NearestNeighborAlgorithmPlugin.this.algoText);
            this.v_s = null;
            this.userChoice_v_Apo = 0;
        }

        public void setStartVertex(Vertex v) {
            this.v_s = v;
            this.visualizeVertices();
        }

        protected int executeStep(int stepID, AlgorithmStateAttachment asa) throws Exception {
            Graph graph = NearestNeighborAlgorithmPlugin.this.graphView.getGraph();
            int nextStep = -1;
            switch (stepID) {
                case 1: {
                    this.r = new Path(graph);
                    this.r.add(this.v_s);
                    this.sleep(250L);
                    NearestNeighborAlgorithmPlugin.this.cycleView.setBackground(NearestNeighborAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeCycleAsText();
                    this.visualizeCycle();
                    this.visualizeVertices();
                    this.sleep(250L);
                    NearestNeighborAlgorithmPlugin.this.cycleView.setBackground(Color.white);
                    this.sleep(250L);
                    nextStep = 2;
                    break;
                }
                case 2: {
                    this.V_Apo = graph.getVertexByIDSet();
                    this.V_Apo.remove((Object)this.v_s.getID());
                    this.sleep(250L);
                    NearestNeighborAlgorithmPlugin.this.setView.setBackground(NearestNeighborAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeSetAsText();
                    this.visualizeVertices();
                    this.sleep(250L);
                    NearestNeighborAlgorithmPlugin.this.setView.setBackground(Color.white);
                    this.sleep(250L);
                    nextStep = 3;
                    break;
                }
                case 3: {
                    this.v_akt = this.r.get(this.r.length()).getID();
                    this.sleep(500L);
                    this.visualizeVertices();
                    this.sleep(750L);
                    nextStep = 4;
                    break;
                }
                case 4: {
                    Vertex vertex_akt = graph.getVertexByID(this.v_akt);
                    Edge minWeightEdge = null;
                    GraphView.VisualEdge ve = null;
                    if (this.userChoice_v_Apo > 0) {
                        this.v_Apo = this.userChoice_v_Apo;
                    } else {
                        this.v_Apo = 0;
                        float minWeight = Float.MAX_VALUE;
                        int i = 0;
                        while (i < vertex_akt.getOutgoingEdgeCount()) {
                            Edge e = vertex_akt.getOutgoingEdge(i);
                            Vertex v_apostrophe = e.getSuccessor(vertex_akt);
                            if (this.V_Apo.contains((Object)v_apostrophe.getID())) {
                                ve = NearestNeighborAlgorithmPlugin.this.graphView.getVisualEdge(e);
                                ve.setColor(NearestNeighborAlgorithmPlugin.this.colorCurrEdgeMinWeight);
                                ve.setLineWidth(1);
                                if (e.getWeight() < minWeight) {
                                    minWeight = e.getWeight();
                                    minWeightEdge = e;
                                    this.v_Apo = v_apostrophe.getID();
                                }
                            }
                            ++i;
                        }
                    }
                    this.userChoice_v_Apo = 0;
                    NearestNeighborAlgorithmPlugin.this.graphView.repaint();
                    this.sleep(500L);
                    GraphView.VisualEdge visualEdge = ve = minWeightEdge != null ? NearestNeighborAlgorithmPlugin.this.graphView.getVisualEdge(minWeightEdge) : null;
                    if (ve != null) {
                        ve.setColor(NearestNeighborAlgorithmPlugin.this.colorCurrEdgeMinWeight);
                        ve.setLineWidth(NearestNeighborAlgorithmPlugin.this.lineWidthCurrEdgeMinWeight);
                        NearestNeighborAlgorithmPlugin.this.graphView.repaint();
                        this.sleep(1000L);
                    }
                    this.visualizeCycle();
                    this.visualizeVertices();
                    this.sleep(1000L);
                    if (this.v_Apo < 1) {
                        nextStep = -1;
                        break;
                    }
                    nextStep = 5;
                    break;
                }
                case 5: {
                    this.r.add(graph.getVertexByID(this.v_Apo));
                    this.sleep(250L);
                    NearestNeighborAlgorithmPlugin.this.cycleView.setBackground(NearestNeighborAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeCycleAsText();
                    this.visualizeCycle();
                    this.sleep(250L);
                    NearestNeighborAlgorithmPlugin.this.cycleView.setBackground(Color.white);
                    this.sleep(250L);
                    nextStep = 6;
                    break;
                }
                case 6: {
                    this.V_Apo.remove((Object)this.v_Apo);
                    this.sleep(250L);
                    NearestNeighborAlgorithmPlugin.this.setView.setBackground(NearestNeighborAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeSetAsText();
                    this.sleep(250L);
                    NearestNeighborAlgorithmPlugin.this.setView.setBackground(Color.white);
                    this.sleep(250L);
                    nextStep = 7;
                    break;
                }
                case 7: {
                    this.sleep(750L);
                    if (!this.V_Apo.isEmpty()) {
                        nextStep = 3;
                        break;
                    }
                    nextStep = 8;
                    break;
                }
                case 8: {
                    this.r.add(this.v_s);
                    this.v_akt = 0;
                    this.v_Apo = 0;
                    this.sleep(250L);
                    NearestNeighborAlgorithmPlugin.this.cycleView.setBackground(NearestNeighborAlgorithmPlugin.this.colorModified);
                    this.sleep(250L);
                    this.visualizeCycleAsText();
                    this.visualizeCycle();
                    this.visualizeVertices();
                    this.sleep(250L);
                    NearestNeighborAlgorithmPlugin.this.cycleView.setBackground(Color.white);
                    this.sleep(250L);
                    nextStep = -1;
                }
            }
            return nextStep;
        }

        protected void storeState(AlgorithmState state) {
            state.addPath("r", this.r != null ? this.r.cast() : null);
            state.addSet("V_Apo", this.V_Apo);
            state.addInt("v_akt", this.v_akt);
            state.addInt("v_Apo", this.v_Apo);
        }

        protected void restoreState(AlgorithmState state) {
            PathByID tmpR = state.getPath("r", NearestNeighborAlgorithmPlugin.this.graphView.getGraph());
            this.r = tmpR != null ? tmpR.cast() : null;
            this.V_Apo = state.getSet("V_Apo");
            this.v_akt = state.getInt("v_akt");
            this.v_Apo = state.getInt("v_Apo");
        }

        protected void createInitialState(AlgorithmState state) {
            PathByID tmpR = state.addPath("r", null);
            this.r = tmpR != null ? tmpR.cast() : null;
            this.V_Apo = state.addSet("V_Apo", new Set());
            this.v_akt = state.addInt("v_akt", 0);
            this.v_Apo = state.addInt("v_Apo", 0);
        }

        protected void rollBackStep(int stepID, int nextStepID) {
            switch (stepID) {
                case 1: 
                case 8: {
                    this.visualizeCycle();
                    this.visualizeCycleAsText();
                    this.visualizeVertices();
                    break;
                }
                case 2: {
                    this.visualizeVertices();
                    this.visualizeSetAsText();
                    break;
                }
                case 3: 
                case 4: {
                    this.visualizeVertices();
                    break;
                }
                case 5: {
                    this.visualizeCycle();
                    this.visualizeCycleAsText();
                    break;
                }
                case 6: {
                    this.visualizeSetAsText();
                }
            }
        }

        protected void adoptState(int stepID, AlgorithmState state) {
            if (stepID == 4) {
                this.userChoice_v_Apo = state.getInt("v_Apo", 0);
            }
        }

        protected View[] getViews() {
            return new View[]{NearestNeighborAlgorithmPlugin.this.graphView, NearestNeighborAlgorithmPlugin.this.cycleView, NearestNeighborAlgorithmPlugin.this.setView};
        }

        private void visualizeVertices() {
            int i = 0;
            while (i < NearestNeighborAlgorithmPlugin.this.graphView.getVisualVertexCount()) {
                GraphView.VisualVertex vv = NearestNeighborAlgorithmPlugin.this.graphView.getVisualVertex(i);
                if (vv.getVertex().getID() == this.v_akt) {
                    vv.setBackground(NearestNeighborAlgorithmPlugin.this.colorV_Akt);
                    vv.setEdgeWidth(NearestNeighborAlgorithmPlugin.this.lineWidthV_Akt);
                } else if (vv.getVertex().getID() == this.v_s.getID()) {
                    vv.setBackground(NearestNeighborAlgorithmPlugin.this.colorStartVertex);
                    vv.setEdgeWidth(NearestNeighborAlgorithmPlugin.this.lineWidthStartVertex);
                } else if (vv.getVertex().getID() == this.v_Apo) {
                    vv.setBackground(NearestNeighborAlgorithmPlugin.this.colorV_Apostrophe);
                    vv.setEdgeWidth(1);
                } else if (this.V_Apo.contains((Object)vv.getVertex().getID())) {
                    vv.setBackground(NearestNeighborAlgorithmPlugin.this.colorSetV_Apostrophe);
                    vv.setEdgeWidth(1);
                } else {
                    vv.setBackground(GraphView.DEF_VERTEXBACKGROUND);
                    vv.setEdgeWidth(1);
                }
                ++i;
            }
            NearestNeighborAlgorithmPlugin.this.graphView.repaint();
        }

        private void visualizeCycle() {
            if (this.r == null) {
                return;
            }
            int i = 0;
            while (i < NearestNeighborAlgorithmPlugin.this.graphView.getVisualEdgeCount()) {
                GraphView.VisualEdge ve = NearestNeighborAlgorithmPlugin.this.graphView.getVisualEdge(i);
                if (this.r.contains(ve.getEdge())) {
                    ve.setColor(NearestNeighborAlgorithmPlugin.this.colorCycleR);
                    ve.setLineWidth(NearestNeighborAlgorithmPlugin.this.lineWidthCycleR);
                } else {
                    ve.setColor(GraphView.DEF_EDGECOLOR);
                    ve.setLineWidth(1);
                }
                ++i;
            }
            NearestNeighborAlgorithmPlugin.this.graphView.repaint();
        }

        private void visualizeCycleAsText() {
            NearestNeighborAlgorithmPlugin.this.cycleView.setText(this.r != null ? "r=" + this.r.toString() : "");
        }

        private void visualizeSetAsText() {
            NearestNeighborAlgorithmPlugin.this.setView.setText(this.V_Apo != null ? "V'=" + this.toCaptions(this.V_Apo) : "");
        }

        private Set<String> toCaptions(Set<Integer> set) {
            Graph graph = NearestNeighborAlgorithmPlugin.this.graphView.getGraph();
            Set res = new Set(set.size());
            for (Integer id : set) {
                res.add((Object)graph.getVertexByID(id.intValue()).getCaption());
            }
            return res;
        }
    }
}

